/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items.geburah;

import com.finderfeed.fdbosses.init.BossConfigs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public class DivineGearComponent {
    public static final Codec<DivineGearComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("charge").forGetter(DivineGearComponent::getCharge), (App)Codec.INT.fieldOf("cooldown").forGetter(DivineGearComponent::getCooldown)).apply((Applicative)instance, DivineGearComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DivineGearComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DivineGearComponent::getCharge, (StreamCodec)ByteBufCodecs.INT, DivineGearComponent::getCooldown, DivineGearComponent::new);
    private int charge;
    private int cooldown;

    public DivineGearComponent() {
        this.charge = BossConfigs.BOSS_CONFIG.get().itemConfig.divineGearCharges;
    }

    public DivineGearComponent(int charge, int cooldown) {
        this.setCharge(charge);
        this.cooldown = cooldown;
    }

    public DivineGearComponent(DivineGearComponent copy) {
        this.charge = copy.charge;
        this.cooldown = copy.cooldown;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = Mth.clamp((int)charge, (int)0, (int)BossConfigs.BOSS_CONFIG.get().itemConfig.divineGearCharges);
    }

    public void setCooldown() {
        this.cooldown = BossConfigs.BOSS_CONFIG.get().itemConfig.divineGearChargeReplenishTime;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DivineGearComponent that = (DivineGearComponent)o;
        return this.charge == that.charge && this.cooldown == that.cooldown;
    }

    public int hashCode() {
        return Objects.hash(this.charge, this.cooldown);
    }
}

