/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items.geburah;

import com.finderfeed.fdbosses.content.items.geburah.DivineGear;
import com.finderfeed.fdbosses.content.items.geburah.DivineGearComponent;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDataComponents;
import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.AnimatedItem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationHandler;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.animated_item.AnimatedItemStackContext;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DivineGearItem
extends Item
implements AnimatedItem {
    public DivineGearItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (ctx.getHand() == InteractionHand.MAIN_HAND) {
                Direction direction = ctx.getClickedFace();
                ItemStack item = ctx.getItemInHand();
                DivineGearComponent data = DivineGearItem.getComponent(item);
                int charges = data.getCharge();
                if (charges > 0 || player.isCreative()) {
                    BlockPos pos = ctx.getClickedPos();
                    Pair<BlockPos, Direction> posAndDir = DivineGearItem.getPosAndDirection(ctx.getLevel(), pos, direction);
                    pos = (BlockPos)posAndDir.first;
                    direction = (Direction)posAndDir.second;
                    if (DivineGearItem.canPlaceOn(ctx.getLevel(), pos, direction)) {
                        Vec3 place = DivineGearItem.getSpawnPlace(pos, direction);
                        DivineGear.summon(player, place);
                        if (!player.isCreative()) {
                            data.setCooldown();
                            data.setCharge(charges - 1);
                        }
                        item.set(BossDataComponents.DIVINE_GEAR_COMPONENT.get(), (Object)new DivineGearComponent(data));
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(ctx);
    }

    public static Pair<BlockPos, Direction> getPosAndDirection(Level level, BlockPos clickedPos, Direction direction) {
        BlockState state = level.getBlockState(clickedPos);
        if (state.getCollisionShape((BlockGetter)level, clickedPos).isEmpty()) {
            for (Direction dir : Direction.values()) {
                BlockPos offs = clickedPos.offset(dir.getNormal());
                if (!level.getBlockState(offs).getCollisionShape((BlockGetter)level, offs).isEmpty()) continue;
                return new Pair((Object)clickedPos.offset(dir.getOpposite().getNormal()), (Object)dir);
            }
            return new Pair((Object)clickedPos.below(), (Object)direction);
        }
        return new Pair((Object)clickedPos, (Object)direction);
    }

    public static Vec3 getSpawnPlace(BlockPos pos, Direction direction) {
        Vec3 place;
        if (direction == Direction.UP) {
            place = pos.getCenter().add(0.0, 0.5, 0.0);
        } else if (Direction.Plane.HORIZONTAL.test(direction)) {
            double x = direction.getStepX();
            double z = direction.getStepZ();
            place = pos.getCenter().add(x * 2.0, -1.5, z * 2.0);
        } else {
            place = pos.getCenter().add(0.0, -3.5, 0.0);
        }
        return place;
    }

    public static boolean canPlaceOn(Level level, BlockPos pos, Direction direction) {
        BlockPos centerPos = pos.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
        Vec3 center = centerPos.getCenter();
        AABB checkAABB = new AABB(center.x - 1.5, center.y - 1.5, center.z - 1.5, center.x + 1.5, center.y + 1.5, center.z + 1.5).inflate(0.2);
        return level.getBlockState(pos.offset(direction.getNormal())).getCollisionShape((BlockGetter)level, pos).isEmpty() && level.getBlockState(centerPos).getCollisionShape((BlockGetter)level, pos).isEmpty() && level.getEntitiesOfClass(DivineGear.class, checkAABB).isEmpty();
    }

    public static DivineGearComponent getComponent(ItemStack itemStack) {
        if (!itemStack.has(BossDataComponents.DIVINE_GEAR_COMPONENT)) {
            itemStack.set(BossDataComponents.DIVINE_GEAR_COMPONENT, (Object)new DivineGearComponent());
        }
        return (DivineGearComponent)itemStack.get(BossDataComponents.DIVINE_GEAR_COMPONENT);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        super.inventoryTick(stack, level, entity, p_41407_, p_41408_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            DivineGearComponent data = DivineGearItem.getComponent(stack);
            int charges = data.getCharge();
            if (charges < BossConfigs.BOSS_CONFIG.get().itemConfig.divineGearCharges) {
                int cooldown = data.getCooldown();
                if (cooldown > 0) {
                    data.setCooldown(data.getCooldown() - 1);
                } else {
                    data.setCharge(charges + 1);
                    data.setCooldown();
                }
                stack.set(BossDataComponents.DIVINE_GEAR_COMPONENT, (Object)new DivineGearComponent(data));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void animatedItemTick(AnimatedItemStackContext ctx) {
        FDItemAnimationSystem animSystem = FDItemAnimationHandler.getItemAnimationSystem((AnimatedItemStackContext)ctx);
        if (animSystem != null) {
            animSystem.startAnimation("IDLE", AnimationTicker.builder(BossAnims.DIVINE_GEAR_ITEM_IDLE).build());
        }
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> components, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, components, p_41424_);
        components.add((Component)Component.translatable((String)"fdbosses.word.divine_gear_description").withStyle(ChatFormatting.GOLD));
    }
}

