/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items.malkuth;

import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.items.malkuth.MalkuthFistChain;
import com.finderfeed.fdbosses.content.items.malkuth.MalkuthFistDataComponent;
import com.finderfeed.fdbosses.init.BossDataComponents;
import com.finderfeed.fdbosses.init.BossItems;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdbosses.packets.SlamParticlesPacket;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.network.PacketDistributor;

public class MalkuthFist
extends Item {
    public MalkuthFist(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            ItemStack item = player.getItemInHand(hand);
            if (!item.has(BossDataComponents.MALKUTH_FIST_COMPONENT)) {
                item.set(BossDataComponents.MALKUTH_FIST_COMPONENT, (Object)new MalkuthFistDataComponent());
            }
            if (hand == InteractionHand.MAIN_HAND) {
                if (this.usesAsChain(player)) {
                    MalkuthFistChain.summon(player, false);
                    player.startUsingItem(hand);
                    return InteractionResultHolder.consume((Object)item);
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(player.getOnPos(), player.position().add(0.0, (double)0.1f, 0.0), new Vec3(1.0, 0.0, 0.0)).maxAngle((float)Math.PI * 2).maxSpeed(0.3f).collectRadius(2).maxParticleLifetime(30).count(20).maxVerticalSpeedEdges(0.15f).maxVerticalSpeedCenter(0.15f));
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)new ChunkPos(player.getOnPos()), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                BallParticleOptions ballParticleOptions = BallParticleOptions.builder().size(7.0f).scalingOptions(1, 0, 1).color(1.0f, 0.6f, 0.2f).brightness(2).build();
                ((ServerLevel)level).sendParticles((ParticleOptions)ballParticleOptions, player.getX(), player.getY(), player.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)level), (FDShakeData)FDShakeData.builder().amplitude(1.0f).frequency(10.0f).outTime(10).build(), (Vec3)player.position(), (double)20.0);
                int stripesCount = 6;
                for (int i = 0; i < stripesCount; ++i) {
                    FDColor endColor;
                    FDColor startColor;
                    if (i % 2 == 0) {
                        startColor = new FDColor(1.0f, 0.8f, 0.2f, 1.0f);
                        endColor = new FDColor(1.0f, 0.2f, 0.1f, 1.0f);
                    } else {
                        startColor = new FDColor(0.2f, 0.8f, 1.0f, 1.0f);
                        endColor = new FDColor(0.1f, 0.2f, 1.0f, 1.0f);
                    }
                    StripeParticleOptions options = StripeParticleOptions.createHorizontalCircling(startColor, endColor, new Vec3(0.0, 1.0, 0.0), (float)i / (float)stripesCount * (float)Math.PI * 2.0f, 0.1f, 5, 20, 0.0f, 2.0f, 0.5f, 0.75f, true, false);
                    ((ServerLevel)level).sendParticles((ParticleOptions)options, player.getX(), player.getY(), player.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                Vec3 lookAngle = player.getLookAngle().multiply(1.0, 0.0, 1.0);
                if (!lookAngle.equals((Object)Vec3.ZERO)) {
                    lookAngle = lookAngle.normalize();
                }
                Vec3 speed = new Vec3(lookAngle.x * (double)0.1f, 1.5, lookAngle.z * (double)0.1f);
                FDLibCalls.setServerPlayerSpeed((ServerPlayer)((ServerPlayer)player), (Vec3)speed);
                player.setIgnoreFallDamageFromCurrentImpulse(true);
                player.currentImpulseImpactPos = player.position();
                player.getCooldowns().addCooldown(BossItems.MALKUTH_FIST.get(), 5);
                return InteractionResultHolder.consume((Object)item);
            }
            MalkuthFistChain.summon(player, true);
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)item);
        }
        return super.use(level, player, hand);
    }

    public boolean usesAsChain(Player player) {
        Vec3 lookAngle = player.getLookAngle();
        double dot = lookAngle.dot(new Vec3(0.0, 1.0, 0.0));
        if (player.onGround() && dot < -0.6) {
            ClipContext clipContext = new ClipContext(player.getEyePosition(), player.getEyePosition().add(lookAngle.scale(3.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
            BlockHitResult res = player.level().clip(clipContext);
            if (res.getType() != HitResult.Type.MISS) {
                return false;
            }
        }
        return true;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 72000;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean p_41408_) {
        super.inventoryTick(stack, level, entity, slot, p_41408_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!stack.has(BossDataComponents.MALKUTH_FIST_COMPONENT)) {
                stack.set(BossDataComponents.MALKUTH_FIST_COMPONENT, (Object)new MalkuthFistDataComponent());
            }
            MalkuthFistDataComponent data = (MalkuthFistDataComponent)stack.get(BossDataComponents.MALKUTH_FIST_COMPONENT);
            ItemCooldowns cooldowns = serverPlayer.getCooldowns();
            if (data.canSkipCooldown()) {
                if (cooldowns.isOnCooldown(stack.getItem())) {
                    if (slot != 40) {
                        data.setCanSkipCooldown(false);
                        stack.set(BossDataComponents.MALKUTH_FIST_COMPONENT, (Object)new MalkuthFistDataComponent(data));
                        cooldowns.removeCooldown(stack.getItem());
                    }
                } else {
                    data.setCanSkipCooldown(false);
                    stack.set(BossDataComponents.MALKUTH_FIST_COMPONENT, (Object)new MalkuthFistDataComponent(data));
                }
            }
            if (!cooldowns.isOnCooldown(BossItems.MALKUTH_FIST.get()) && slot == 40 && data.getEntityHookCooldown() > 0) {
                cooldowns.addCooldown(BossItems.MALKUTH_FIST.get(), data.getEntityHookCooldown());
            }
            if (data.getEntityHookCooldown() > 0) {
                data.setEntityHookCooldown(data.getEntityHookCooldown() - 1);
                stack.set(BossDataComponents.MALKUTH_FIST_COMPONENT.get(), (Object)new MalkuthFistDataComponent(data));
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        MalkuthFistDataComponent data;
        if (!entity.level().isClientSide && (data = (MalkuthFistDataComponent)stack.get(BossDataComponents.MALKUTH_FIST_COMPONENT)) != null) {
            data.setCanSkipCooldown(false);
            stack.set(BossDataComponents.MALKUTH_FIST_COMPONENT, (Object)new MalkuthFistDataComponent(data));
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> components, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, components, p_41424_);
        components.add((Component)Component.translatable((String)"fdbosses.word.malkuth_fist_description").withStyle(ChatFormatting.GOLD));
    }
}

