/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items.malkuth;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.FDBossesServerScheduler;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_crush.MalkuthCrushAttack;
import com.finderfeed.fdbosses.content.items.malkuth.MalkuthFistDataComponent;
import com.finderfeed.fdbosses.content.items.malkuth.PlayerForceAttackEntityPacket;
import com.finderfeed.fdbosses.content.util.Undismountable;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDataComponents;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossItems;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDTargetFinder;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class MalkuthFistChain
extends FDEntity
implements Undismountable {
    public static final EntityDataAccessor<Boolean> IS_HOOK = SynchedEntityData.defineId(MalkuthFistChain.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.defineId(MalkuthFistChain.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> HOOKED_TO = SynchedEntityData.defineId(MalkuthFistChain.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID ownerPlayer;
    private UUID hookFlyingTo;
    private Vec3 currentPlayerHookPos = null;
    private int pullingPlayerTickerTime = -1;
    private int pullingPlayerTicker = -1;
    private Vec3 vectorBetween;
    private Direction cachedDirection;
    public Vec3 cachedDeltaMovement;

    public static void summon(Player owner, boolean isHook) {
        MalkuthFistChain malkuthFistChain = new MalkuthFistChain(BossEntities.MALKUTH_FIST_CHAIN.get(), owner.level());
        malkuthFistChain.setPos(owner.getEyePosition());
        malkuthFistChain.getEntityData().set(IS_HOOK, (Object)isHook);
        malkuthFistChain.ownerPlayer = owner.getUUID();
        malkuthFistChain.setDeltaMovement(owner.getLookAngle().scale(3.0));
        owner.level().addFreshEntity((Entity)malkuthFistChain);
    }

    public MalkuthFistChain(EntityType<?> type, Level level) {
        super(type, level);
        this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.MALKUTH_FIST_FLYING).build());
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            LivingEntity hookedTo;
            if (this.ownerPlayer == null) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
                this.onStopChaining();
                return;
            }
            this.checkOwnerValidity();
            Player owner = this.getOwner();
            if (owner != null) {
                this.getEntityData().set(OWNER_ID, (Object)owner.getId());
            }
            if ((hookedTo = this.getHookedTo()) != null) {
                this.getEntityData().set(HOOKED_TO, (Object)hookedTo.getId());
            }
        }
        if (this.isHook()) {
            this.tickHook();
        } else {
            this.tickPullToBlocks();
        }
        LivingEntity hookedTo = this.getHookedTo();
        if (hookedTo == null) {
            this.setPos(this.position().add(this.getDeltaMovement()));
        } else {
            Vec3 pos = this.getHookedToPos(hookedTo);
            this.setPos(pos.x, pos.y, pos.z);
        }
        this.tickPullingTime();
    }

    public Vec3 getHookedToPos(LivingEntity hookedTo) {
        return hookedTo.getBoundingBox().getCenter();
    }

    public LivingEntity getHookedTo() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hookFlyingTo != null && (entity = serverLevel.getEntity(this.hookFlyingTo)) instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        } else {
            Entity entity = this.level().getEntity(((Integer)this.getEntityData().get(HOOKED_TO)).intValue());
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public void setDeltaMovement(Vec3 vec) {
        super.setDeltaMovement(vec);
        if (!vec.equals((Object)Vec3.ZERO)) {
            this.cachedDeltaMovement = vec;
        }
    }

    public void tickPullToBlocks() {
        if (!this.level().isClientSide) {
            Vec3 deltaMovement = this.getDeltaMovement();
            if (!deltaMovement.equals((Object)Vec3.ZERO)) {
                if (this.tickCount > 2) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_CHAIN_PULL.get(), SoundSource.HOSTILE, 4.0f, 0.85f);
                }
                Vec3 start = this.position();
                Vec3 end = start.add(deltaMovement.scale(2.0));
                ClipContext clipContext = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
                BlockHitResult res = this.level().clip(clipContext);
                if (res.getType() != HitResult.Type.MISS) {
                    Vec3 location = res.getLocation();
                    this.teleportTo(location.x, location.y, location.z);
                    this.setDeltaMovement(Vec3.ZERO);
                    this.cachedDirection = res.getDirection();
                    this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.MALKUTH_FIST_GRAB).build());
                }
            } else {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_CHAIN_PULL.get(), SoundSource.HOSTILE, 4.0f, 0.9f);
                this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.MALKUTH_FIST_GRAB).build());
                Player owner = this.getOwner();
                if (owner != null) {
                    if (owner.getVehicle() != this) {
                        if (!owner.startRiding((Entity)this, true)) {
                            this.setRemoved(Entity.RemovalReason.DISCARDED);
                            this.onStopChaining();
                        }
                    } else if (this.pullingPlayerTickerTime != -1 && this.pullingPlayerTicker > this.pullingPlayerTickerTime + 1) {
                        owner.stopRiding();
                        int cooldownIKnowYouAreLookingHereToChangeThisField = BossConfigs.BOSS_CONFIG.get().itemConfig.iceFireGauntletCooldown;
                        owner.getCooldowns().addCooldown(BossItems.MALKUTH_FIST.get(), cooldownIKnowYouAreLookingHereToChangeThisField);
                        this.setRemoved(Entity.RemovalReason.DISCARDED);
                        this.onStopChaining();
                        Direction direction = this.cachedDirection != null ? this.cachedDirection : Direction.UP;
                        BossUtil.malkuthPlayerFireballExplosionParticles((ServerLevel)this.level(), this.position(), MalkuthAttackType.FIRE);
                        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(50.0f).amplitude(1.5f).inTime(0).stayTime(0).outTime(10).build(), (Vec3)this.position(), (double)40.0);
                        MalkuthCrushAttack.summon(this.level(), this.position().add((double)((float)direction.getStepX() * 0.1f), (double)((float)direction.getStepY() * 0.1f), (double)((float)direction.getStepZ() * 0.1f)), 0.0f, direction, null);
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_FIREBALL_EXPLOSION.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
                        this.level().playSound(null, this.position().x, this.position().y, this.position().z, BossSounds.ROCK_IMPACT.get(), SoundSource.PLAYERS, 3.0f, 0.8f);
                        this.level().playSound(null, this.position().x, this.position().y, this.position().z, BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.PLAYERS, 3.0f, 0.8f);
                        if (this.cachedDirection != null) {
                            Vec3 n = new Vec3((double)this.cachedDirection.getStepX(), (double)this.cachedDirection.getStepY(), (double)this.cachedDirection.getStepZ());
                            double offs = n.dot(new Vec3(0.0, -1.0, 0.0));
                            Vec3 tppos = this.position().add(n.scale(offs += 1.0));
                            owner.teleportTo(tppos.x, tppos.y, tppos.z);
                        }
                        float damage = BossConfigs.BOSS_CONFIG.get().itemConfig.iceFireGauntletCrushDamage;
                        for (LivingEntity entity : FDTargetFinder.getEntitiesInSphere(LivingEntity.class, (Level)this.level(), (Vec3)this.position(), (float)3.0f)) {
                            if (entity == owner) continue;
                            entity.setRemainingFireTicks(100);
                            entity.hurt(this.level().damageSources().playerAttack(owner), damage);
                            Vec3 between = entity.position().subtract(this.position());
                            Vec3 speed = between.normalize().scale(0.5).add(0.0, 0.25, 0.0);
                            if (entity instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)entity;
                                FDLibCalls.setServerPlayerSpeed((ServerPlayer)serverPlayer, (Vec3)speed);
                                serverPlayer.hasImpulse = true;
                                continue;
                            }
                            entity.setDeltaMovement(speed);
                        }
                    }
                }
            }
        }
    }

    public void tickHook() {
        if (!this.level().isClientSide) {
            if (this.hookFlyingTo == null) {
                Entity entity;
                if (this.tickCount > 2) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_CHAIN_PULL.get(), SoundSource.HOSTILE, 4.0f, 0.85f);
                }
                Vec3 deltaMovement = this.getDeltaMovement();
                Vec3 start = this.position().add(deltaMovement.reverse());
                Vec3 end = start.add(deltaMovement.scale(2.0));
                List entities = FDHelpers.traceEntities((Level)this.level(), (Vec3)start, (Vec3)end, (double)0.15f, livingEntity -> livingEntity instanceof LivingEntity && livingEntity != this.getOwner());
                if (!entities.isEmpty() && (entity = (Entity)entities.get(0)) != null) {
                    this.hookFlyingTo = entity.getUUID();
                    this.getEntityData().set(HOOKED_TO, (Object)entity.getId());
                } else {
                    ClipContext clipContext = new ClipContext(this.position(), end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
                    BlockHitResult res = this.level().clip(clipContext);
                    if (res.getType() != HitResult.Type.MISS) {
                        this.setRemoved(Entity.RemovalReason.DISCARDED);
                        this.onStopChaining();
                    }
                }
            } else {
                this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.MALKUTH_FIST_GRAB).build());
                LivingEntity entity = this.getEntityOnHook();
                Player owner = this.getOwner();
                if (owner != null && entity != null && !entity.isDeadOrDying()) {
                    this.setDeltaMovement(Vec3.ZERO);
                    if (owner.getVehicle() == null) {
                        if (!owner.startRiding((Entity)this, true)) {
                            this.setRemoved(Entity.RemovalReason.DISCARDED);
                            this.onStopChaining();
                        }
                    } else if (owner.getVehicle() == this) {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_CHAIN_PULL.get(), SoundSource.HOSTILE, 4.0f, 0.9f);
                        if (this.pullingPlayerTicker <= this.pullingPlayerTickerTime / 2) {
                            this.vectorBetween = entity.position().subtract(owner.position());
                        }
                        if (this.pullingPlayerTickerTime != -1 && this.pullingPlayerTicker > this.pullingPlayerTickerTime + 1) {
                            owner.stopRiding();
                            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)owner), (CustomPacketPayload)new PlayerForceAttackEntityPacket(entity), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            BallParticleOptions ballParticleOptions = BallParticleOptions.builder().size(5.0f).scalingOptions(1, 0, 2).color(1.0f, 0.6f, 0.2f).brightness(2).build();
                            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ballParticleOptions, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                            BallParticleOptions ballParticleOptions2 = BallParticleOptions.builder().size(0.5f).friction(0.9f).scalingOptions(0, 0, 10).color(1.0f, 0.6f, 0.2f).brightness(2).build();
                            BallParticleOptions ballParticleOptions3 = BallParticleOptions.builder().size(0.5f).friction(0.9f).scalingOptions(0, 0, 10).color(0.2f, 0.6f, 1.0f).brightness(2).build();
                            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ballParticleOptions2, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 20, 0.1, 0.1, 0.1, 0.25);
                            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ballParticleOptions3, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 20, 0.1, 0.1, 0.1, 0.25);
                            FDBossesServerScheduler.addDelayedAction(2, server -> {
                                if (this.vectorBetween != null) {
                                    Vec3 between = this.vectorBetween;
                                    Vec3 movement = between.multiply(-1.0, 0.0, -1.0).normalize().add(0.0, 1.0, 0.0).scale(1.25);
                                    FDLibCalls.setServerPlayerSpeed((ServerPlayer)((ServerPlayer)owner), (Vec3)movement);
                                    owner.hasImpulse = true;
                                    owner.setIgnoreFallDamageFromCurrentImpulse(true);
                                    owner.currentImpulseImpactPos = owner.position();
                                }
                            });
                            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
                            int cooldown = BossConfigs.BOSS_CONFIG.get().itemConfig.iceFireGauntletCooldown;
                            ItemStack item = owner.getUseItem();
                            if (owner.getUseItem().is(BossItems.MALKUTH_FIST.get())) {
                                MalkuthFistDataComponent data = (MalkuthFistDataComponent)item.get(BossDataComponents.MALKUTH_FIST_COMPONENT);
                                data.setCanSkipCooldown(true);
                                data.setEntityHookCooldown(cooldown);
                                item.set(BossDataComponents.MALKUTH_FIST_COMPONENT, (Object)new MalkuthFistDataComponent(data));
                            }
                            owner.getCooldowns().addCooldown(BossItems.MALKUTH_FIST.get(), cooldown);
                            this.setRemoved(Entity.RemovalReason.DISCARDED);
                            this.onStopChaining();
                        }
                    } else {
                        this.setRemoved(Entity.RemovalReason.DISCARDED);
                        this.onStopChaining();
                    }
                } else {
                    this.setRemoved(Entity.RemovalReason.DISCARDED);
                    this.onStopChaining();
                }
            }
        }
    }

    private LivingEntity getEntityOnHook() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hookFlyingTo != null && (entity = serverLevel.getEntity(this.hookFlyingTo)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
            return null;
        }
        return null;
    }

    private void checkOwnerValidity() {
        double checkDistance;
        Player owner = this.getOwner();
        double d = checkDistance = this.getHookedTo() != null || this.getDeltaMovement().equals((Object)Vec3.ZERO) ? 40.0 : 30.0;
        if (owner == null || (double)this.distanceTo((Entity)owner) > checkDistance || !owner.getUseItem().is(BossItems.MALKUTH_FIST.get())) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
            this.onStopChaining();
        }
    }

    public boolean isHook() {
        return (Boolean)this.getEntityData().get(IS_HOOK);
    }

    public Player getOwner() {
        if (!this.level().isClientSide) {
            if (this.ownerPlayer != null) {
                return ((ServerLevel)this.level()).getPlayerByUUID(this.ownerPlayer);
            }
            return null;
        }
        Entity entity = this.level().getEntity(((Integer)this.getEntityData().get(OWNER_ID)).intValue());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    private void onStopChaining() {
        Player owner = this.getOwner();
        if (owner != null && owner.getUseItem().is(BossItems.MALKUTH_FIST.get())) {
            owner.stopUsingItem();
        }
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        Entity vehicle;
        if (this.currentPlayerHookPos == null) {
            this.currentPlayerHookPos = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            double distance = this.currentPlayerHookPos.distanceTo(this.position());
            this.pullingPlayerTickerTime = (int)Math.ceil(distance / 2.0);
            if (this.pullingPlayerTickerTime <= 0) {
                this.pullingPlayerTickerTime = 1;
            }
            this.pullingPlayerTicker = 0;
        }
        Vec3 thisPos = (vehicle = this.getVehicle()) != null ? this.position().add(0.0, (double)(-vehicle.getBbHeight() / 2.0f), 0.0) : this.position();
        float p = Mth.clamp((float)((float)this.pullingPlayerTicker / (float)this.pullingPlayerTickerTime), (float)0.0f, (float)1.0f);
        Vec3 interpolated = FDMathUtil.interpolateVectors((Vec3)this.currentPlayerHookPos, (Vec3)thisPos, (float)FDEasings.easeIn((float)p));
        return interpolated;
    }

    private void tickPullingTime() {
        if (this.pullingPlayerTickerTime != -1) {
            ++this.pullingPlayerTicker;
        }
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        float bbHeight = entity.getBbHeight();
        return new Vec3(0.0, (double)(bbHeight / 2.0f), 0.0);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(IS_HOOK, (Object)true);
        builder.define(OWNER_ID, (Object)-1);
        builder.define(HOOKED_TO, (Object)-1);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("ownerPlayer")) {
            this.ownerPlayer = tag.getUUID("ownerPlayer");
        }
        if (tag.contains("hookFlyingTo")) {
            this.hookFlyingTo = tag.getUUID("hookFlyingTo");
        }
        this.getEntityData().set(IS_HOOK, (Object)tag.getBoolean("isHook"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.ownerPlayer != null) {
            tag.putUUID("ownerPlayer", this.ownerPlayer);
        }
        if (this.hookFlyingTo != null) {
            tag.putUUID("hookFlyingTo", this.hookFlyingTo);
        }
        tag.putBoolean("isHook", ((Boolean)this.getEntityData().get(IS_HOOK)).booleanValue());
    }

    @EventBusSubscriber(modid="fdbosses")
    public static class Events {
        @SubscribeEvent
        public static void hurtEvent(LivingIncomingDamageEvent event) {
            ServerPlayer serverPlayer;
            Entity entity;
            LivingEntity entity2 = event.getEntity();
            if (entity2 instanceof ServerPlayer && (entity = (serverPlayer = (ServerPlayer)entity2).getVehicle()) instanceof MalkuthFistChain) {
                MalkuthFistChain malkuthFistChain = (MalkuthFistChain)entity;
                Entity source = event.getSource().getEntity();
                if (source != null) {
                    AABB sourceBB = source.getBoundingBox().inflate(2.0);
                    if (sourceBB.intersects(serverPlayer.getBoundingBox())) {
                        event.setCanceled(true);
                        event.setInvulnerabilityTicks(20);
                    }
                } else if (event.getSource().is(DamageTypes.IN_WALL)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

