/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items.malkuth;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.items.malkuth.MalkuthFistChain;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDFreeEntityRenderer;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class MalkuthFistChainRenderer
implements FDFreeEntityRenderer<MalkuthFistChain> {
    public static final ResourceLocation TEXTURE = FDBosses.location("textures/entities/malkuth/malkuth_fist_chain_segment.png");

    public void render(MalkuthFistChain malkuthFistChain, float yaw, float pticks, PoseStack matrices, MultiBufferSource multiBufferSource, int i) {
        int ownerId = (Integer)malkuthFistChain.getEntityData().get(MalkuthFistChain.OWNER_ID);
        Entity entity = malkuthFistChain.level().getEntity(ownerId);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Vec3 playerPos = player.getPosition(pticks).add(0.0, (double)(player.getBbHeight() / 2.0f) + 0.25, 0.0);
        Vec3 thisPos = malkuthFistChain.getPosition(pticks);
        Vec3 between = playerPos.subtract(thisPos);
        float length = (float)between.length();
        matrices.pushPose();
        VertexConsumer vertex = multiBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        FDRenderUtil.applyMovementMatrixRotations((PoseStack)matrices, (Vec3)between);
        Matrix4f mat = matrices.last().pose();
        float segmentWidth = 0.05f;
        float ratio = 3.5f;
        vertex.addVertex(mat, -segmentWidth, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(mat, -segmentWidth, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, ratio * length).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(mat, segmentWidth, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, ratio * length).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(mat, segmentWidth, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(mat, 0.0f, 0.0f, -segmentWidth).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 1.0f, 0.0f, 0.0f);
        vertex.addVertex(mat, 0.0f, length, -segmentWidth).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, ratio * length).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 1.0f, 0.0f, 0.0f);
        vertex.addVertex(mat, 0.0f, length, segmentWidth).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, ratio * length).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 1.0f, 0.0f, 0.0f);
        vertex.addVertex(mat, 0.0f, 0.0f, segmentWidth).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setLight(i).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(matrices.last(), 1.0f, 0.0f, 0.0f);
        matrices.popPose();
    }
}

