/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.structures;

import com.finderfeed.fdbosses.init.BossStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class GeburahArenaStructure
extends Structure {
    public static final MapCodec<GeburahArenaStructure> CODEC = RecordCodecBuilder.mapCodec(p -> p.group((App)GeburahArenaStructure.settingsCodec((RecordCodecBuilder.Instance)p), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool)).apply((Applicative)p, GeburahArenaStructure::new));
    private final Holder<StructureTemplatePool> startPool;

    public GeburahArenaStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool) {
        super(settings);
        this.startPool = startPool;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext ctx) {
        BlockPos pos = this.getLowestYIn5by5BoxOffset7Blocks(ctx, Rotation.NONE);
        if (pos.getY() != -1) {
            return Optional.empty();
        }
        BlockPos blockpos = new BlockPos(pos.getX(), 140, pos.getZ());
        return JigsawPlacement.addPieces((Structure.GenerationContext)ctx, this.startPool, Optional.empty(), (int)20, (BlockPos)blockpos, (boolean)false, Optional.empty(), (int)200, (PoolAliasLookup)PoolAliasLookup.create(new ArrayList(), (BlockPos)blockpos, (long)ctx.seed()), (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.IGNORE_WATERLOGGING);
    }

    public StructureType<?> type() {
        return BossStructures.GEBURAH_ARENA.get();
    }
}

