/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.init;

import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.FDLib;
import com.finderfeed.fdlib.init.FDDefaultTagDeserializers;
import com.finderfeed.fdlib.nbt.FDTagDeserializers;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.finderfeed.fdlib.systems.config.ReflectiveJsonConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

@EventBusSubscriber(modid="fdlib", bus=EventBusSubscriber.Bus.MOD)
public class FDModEvents {
    @SubscribeEvent
    public static void commonSetupEvent(FMLCommonSetupEvent event) {
        for (JsonConfig config : FDRegistries.CONFIGS) {
            if (!(config instanceof ReflectiveJsonConfig)) continue;
            ReflectiveJsonConfig c = (ReflectiveJsonConfig)config;
            c.memorizeDefaultValues(c.getClass(), c);
        }
        event.enqueueWork(() -> {
            FDModEvents.loadAnimations();
            FDModEvents.loadModels();
            FDTagDeserializers.registerDeserializer(Vec3.class, FDDefaultTagDeserializers.VEC3);
        });
    }

    public static void loadAnimations() {
        FDLib.LOGGER.info("Loading FD animations...");
        for (Map.Entry entry : FDRegistries.ANIMATIONS.entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Animation value = (Animation)entry.getValue();
            ResourceLocation animationName = key.location();
            ResourceLocation location = value.getFileLocation();
            if (location == null) {
                throw new RuntimeException("The animation file location is not specified! Use Animation constructor with ResourceLocation which points to a file containing the animation!");
            }
            ResourceLocation actualLocation = ResourceLocation.tryBuild((String)location.getNamespace(), (String)("bedrock/animations/" + location.getPath()));
            FDLib.LOGGER.info("Loading animation: " + String.valueOf(animationName));
            JsonElement json = FDHelpers.readJsonFileFromAssets(actualLocation);
            JsonObject object = json.getAsJsonObject();
            JsonObject animations = object.getAsJsonObject("animations");
            String path = animationName.getPath();
            if (!animations.has(path)) {
                throw new RuntimeException("Animation file " + String.valueOf(location) + " doesn't contain animation " + String.valueOf(animationName));
            }
            value.load(animationName, animations.getAsJsonObject(path));
        }
        FDLib.LOGGER.info("FD Animations loaded!");
    }

    public static void loadModels() {
        FDLib.LOGGER.info("Loading FD models...");
        for (Map.Entry entry : FDRegistries.MODELS.entrySet()) {
            FDModelInfo value = (FDModelInfo)entry.getValue();
            ResourceLocation location = value.getModelName();
            ResourceLocation actualLocation = ResourceLocation.tryBuild((String)location.getNamespace(), (String)("bedrock/models/" + location.getPath()));
            FDLib.LOGGER.info("Loading model: " + String.valueOf(location));
            JsonElement json = FDHelpers.readJsonFileFromAssets(actualLocation, ".geo.json");
            value.load(json.getAsJsonObject());
        }
        FDLib.LOGGER.info("FD Models loaded!");
    }
}

