/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.AnimatedItem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.animated_item.AnimatedItemStackContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="fdlib")
public class FDItemAnimationHandler {
    public static AnimatedItemStackContext currentRenderedContext = null;
    private static final HashMap<AnimatedItemStackContext, AnimatedItemContainer> ANIMATED_ITEMS = new HashMap();

    @SubscribeEvent
    public static void tickItems(ClientTickEvent.Pre event) {
        FDItemAnimationHandler.tickAnimatedItems();
    }

    public static FDItemAnimationSystem getItemAnimationSystem(AnimatedItemStackContext itemStack) {
        if (ANIMATED_ITEMS.containsKey(itemStack)) {
            AnimatedItemContainer animatedItem = ANIMATED_ITEMS.get(itemStack);
            return animatedItem.animationSystem;
        }
        return null;
    }

    public static void tickAnimatedItems() {
        Iterator<Map.Entry<AnimatedItemStackContext, AnimatedItemContainer>> iterator = ANIMATED_ITEMS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AnimatedItemStackContext, AnimatedItemContainer> item = iterator.next();
            AnimatedItemContainer animatedItem = item.getValue();
            animatedItem.tick();
            if (!animatedItem.shouldBeRemoved()) continue;
            iterator.remove();
        }
    }

    public static void tellIAmCurrentlyRendering(AnimatedItemStackContext ctx, boolean setCurrentRenderingContext) {
        if (ANIMATED_ITEMS.containsKey(ctx)) {
            AnimatedItemContainer item = ANIMATED_ITEMS.get(ctx);
            item.tellThatIAmAlive();
        } else {
            ANIMATED_ITEMS.put(ctx, new AnimatedItemContainer(ctx));
        }
        if (setCurrentRenderingContext) {
            currentRenderedContext = ctx;
        }
    }

    private static class AnimatedItemContainer {
        public FDItemAnimationSystem animationSystem;
        public AnimatedItemStackContext itemStack;
        public int age;

        public AnimatedItemContainer(AnimatedItemStackContext itemStack) {
            this.itemStack = itemStack;
            this.animationSystem = new FDItemAnimationSystem();
        }

        public void tick() {
            Item item = this.itemStack.getItemStack().getItem();
            if (item instanceof AnimatedItem) {
                AnimatedItem animatedItemTickListener = (AnimatedItem)item;
                animatedItemTickListener.animatedItemTick(this.itemStack);
            }
            this.animationSystem.tick();
            ++this.age;
        }

        public boolean shouldBeRemoved() {
            return this.age > 200 || this.itemStack.getItemStack().isEmpty();
        }

        public void tellThatIAmAlive() {
            this.age = 0;
        }
    }
}

