/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.models;

import com.finderfeed.fdlib.systems.bedrock.models.FDCube;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelPartDefinition;
import com.finderfeed.fdlib.systems.bedrock.models.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FDModelInfo {
    private ResourceLocation modelName;
    private float cubeScale;
    public List<FDModelPartDefinition> partDefinitionList = new ArrayList<FDModelPartDefinition>();

    public FDModelInfo(ResourceLocation location, float cubeScale) {
        this.modelName = location;
        this.cubeScale = cubeScale;
    }

    public void load(JsonObject model) {
        this.parseModel(model, this.cubeScale);
    }

    public ResourceLocation getModelName() {
        return this.modelName;
    }

    public float getCubeScale() {
        return this.cubeScale;
    }

    private void parseModel(JsonObject bmodel, float cubeScale) {
        this.partDefinitionList.clear();
        JsonObject jmodel = bmodel.getAsJsonArray("minecraft:geometry").get(0).getAsJsonObject();
        JsonObject description = jmodel.getAsJsonObject("description");
        int texWidth = description.get("texture_width").getAsInt();
        int texHeight = description.get("texture_height").getAsInt();
        JsonArray parts = jmodel.getAsJsonArray("bones");
        HashMap<String, Vector3f> pivotOffsets = new HashMap<String, Vector3f>();
        for (JsonElement epart : parts) {
            JsonObject part = epart.getAsJsonObject();
            String name = JsonHelper.getString(part, "name");
            String parent = JsonHelper.getString(part, "parent");
            Vector3f pivot = JsonHelper.parseVector3f(part, "pivot").mul(-1.0f, 1.0f, 1.0f, new Vector3f());
            Vector3f rotation = JsonHelper.parseVector3f(part, "rotation").mul(-1.0f, -1.0f, 1.0f, new Vector3f());
            List<Object> cubes = part.has("cubes") ? this.parseCubes(part.getAsJsonArray("cubes"), pivot, texWidth, texHeight, cubeScale) : new ArrayList();
            Vector3f v = (Vector3f)pivotOffsets.get(parent);
            if (v == null) {
                v = new Vector3f();
            }
            pivotOffsets.put(name, new Vector3f((Vector3fc)pivot));
            pivot.sub((Vector3fc)v);
            FDModelPartDefinition definition = new FDModelPartDefinition(cubes, name, parent, rotation, pivot);
            this.partDefinitionList.add(definition);
        }
    }

    private List<FDCube> parseCubes(JsonArray array, Vector3f bonePivot, int texWidth, int texHeight, float cubeScale) {
        ArrayList<FDCube> cubes = new ArrayList<FDCube>();
        for (JsonElement element : array) {
            cubes.add(FDCube.fromJson(element.getAsJsonObject(), bonePivot, texWidth, texHeight, cubeScale));
        }
        return cubes;
    }

    public record ModelSyncInstance(ResourceLocation location, List<FDModelPartDefinition> definitions) {
        public static final StreamCodec<FriendlyByteBuf, ModelSyncInstance> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, inst -> inst.location.toString(), (StreamCodec)FDModelPartDefinition.CODEC.apply(ByteBufCodecs.list()), inst -> inst.definitions, (str, defs) -> new ModelSyncInstance(ResourceLocation.parse((String)str), (List<FDModelPartDefinition>)defs));
    }
}

