/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.default_components.misc;

import com.finderfeed.fdlib.systems.screen.FDScreen;
import com.finderfeed.fdlib.systems.screen.FDScreenComponent;
import com.finderfeed.fdlib.systems.screen.default_components.misc.FDScrollableComponent;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class FDVerticalComponentContainer
extends FDScrollableComponent {
    public static final float SCROLLER_WIDTH = 4.0f;
    public float maxScroll = 0.0f;
    public float distBetweenChildren = 0.0f;
    public int scrollerTicker = 0;
    public static final int MAX_TIME = 20;

    public FDVerticalComponentContainer(FDScreen screen, String uniqueId, float x, float y, float height) {
        super(screen, uniqueId, x, y, 0.0f, height);
    }

    @Override
    public void renderComponent(GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        FDRenderUtil.Scissor.pushScissors(x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public void postRenderComponent(GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        float max = this.getMaxScrollY();
        if (max != 0.0f) {
            PoseStack matrices = graphics.pose();
            matrices.pushPose();
            matrices.translate(0.0f, 0.0f, 100.0f);
            float a = 0.25f + 0.5f * (1.0f - (float)Math.pow(1.0f - (float)this.scrollerTicker / 20.0f, 4.0));
            FDRenderUtil.renderScrollBar(graphics.pose(), x + this.getWidth() - 4.0f, y, 4.0f, this.getHeight(), this.scrollY, max, 0.15f, 0.15f, 0.15f, a, 0.5f, 0.5f, 0.5f, a);
            matrices.popPose();
        }
        FDRenderUtil.Scissor.popScissors();
    }

    public void replaceChildren() {
        float accumulatedH = -this.scrollY;
        for (FDScreenComponent component : this.getChildren()) {
            component.setY(accumulatedH);
            accumulatedH += component.getHeight() + this.distBetweenChildren;
        }
    }

    public void recalculateMaxScroll() {
        float h = 0.0f;
        for (FDScreenComponent component : this.getChildren()) {
            h += component.getHeight() + this.distBetweenChildren;
        }
        this.maxScroll = h = Mth.clamp((float)(h - this.getHeight()), (float)0.0f, (float)2.1474836E9f);
    }

    public float calculateWidth() {
        float m = 0.0f;
        for (FDScreenComponent component : this.getChildren()) {
            m = Math.max(component.getWidth(), m);
        }
        return m;
    }

    @Override
    public void onChildAdded(FDScreenComponent component) {
        this.recalculateMaxScroll();
        if (component.getWidth() > this.getWidth()) {
            this.setWidth(component.getWidth());
        }
        this.replaceChildren();
    }

    @Override
    public void onChildRemoved(FDScreenComponent component) {
        this.recalculateMaxScroll();
        this.setWidth(this.calculateWidth());
        this.replaceChildren();
    }

    @Override
    public void onChildWidthChanged(FDScreenComponent child, float previous, float current) {
        super.onChildWidthChanged(child, previous, current);
        this.setWidth(this.calculateWidth());
    }

    @Override
    public void onChildHeightChanged(FDScreenComponent child, float previous, float current) {
        super.onChildHeightChanged(child, previous, current);
        this.recalculateMaxScroll();
        this.scrollY = 0.0f;
        this.scrollX = 0.0f;
    }

    @Override
    public void tick() {
        super.tick();
        this.scrollerTicker = Mth.clamp((int)(this.scrollerTicker - 1), (int)0, (int)20);
    }

    @Override
    public void setHeight(float height) {
        super.setHeight(height);
        this.recalculateMaxScroll();
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(width);
    }

    @Override
    public void onVerticalScroll(float delta) {
        this.replaceChildren();
        this.scrollerTicker = 20;
    }

    @Override
    public boolean lockScrollWhenAtMaximum() {
        return true;
    }

    @Override
    public float getScrollSpeed() {
        return 10.0f;
    }

    @Override
    public float getMaxScrollX() {
        return 0.0f;
    }

    @Override
    public float getMaxScrollY() {
        return this.maxScroll;
    }
}

