/*
 * Decompiled with CFR 0.152.
 */
package sp;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import sp.SPConfig;

@Mod(modid="smartparticles", name="Smart Particles", version="12.02.7", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class SPMod {
    public static final String MODID = "smartparticles";
    public static final String NAME = "Smart Particles";
    public static final String VERSION = "12.02.7";
    private static final String[] FX_LAYERS_NAMES = new String[]{"fxLayers", "field_78876_b"};
    private static Field fieldPosX;
    private static Field fieldPosY;
    private static Field fieldPosZ;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        if (client.func_147113_T() || client.field_71439_g == null || client.field_71452_i == null) {
            return;
        }
        this.performCulling(client);
    }

    private void performCulling(Minecraft client) {
        int n;
        ArrayDeque[][] fxLayers;
        int limit = Math.max(0, SPConfig.particleLimit);
        boolean smartCulling = SPConfig.smartCameraCulling;
        try {
            fxLayers = (ArrayDeque[][])ReflectionHelper.getPrivateValue(ParticleManager.class, (Object)client.field_71452_i, (String[])FX_LAYERS_NAMES);
        }
        catch (Exception e) {
            return;
        }
        if (!smartCulling) {
            int total = 0;
            ArrayDeque[][] arrayDequeArray = fxLayers;
            int n2 = arrayDequeArray.length;
            for (int i = 0; i < n2; ++i) {
                ArrayDeque[] layer;
                for (ArrayDeque queue : layer = arrayDequeArray[i]) {
                    total += queue.size();
                }
            }
            if (total <= limit) {
                return;
            }
        }
        EntityPlayerSP player = client.field_71439_g;
        Vec3d camPos = player.func_174824_e(1.0f);
        Vec3d camDir = player.func_70676_i(1.0f);
        double fov = client.field_71474_y.field_74334_X;
        double frustumThreshold = Math.cos(Math.toRadians(fov / 2.0 + 30.0));
        double frustumPenalty = 1.0E10;
        double px = player.field_70165_t;
        double py = player.field_70163_u;
        double pz = player.field_70161_v;
        Particle[] heapParticles = new Particle[limit];
        double[] heapScores = new double[limit];
        int heapSize = 0;
        ArrayDeque[][] arrayDequeArray = fxLayers;
        int n3 = arrayDequeArray.length;
        for (n = 0; n < n3; ++n) {
            ArrayDeque[] layer;
            for (ArrayDeque queue : layer = arrayDequeArray[n]) {
                for (Particle p : queue) {
                    try {
                        double distSq;
                        double eDistSq;
                        double pX = fieldPosX.getDouble(p);
                        double pY = fieldPosY.getDouble(p);
                        double pZ = fieldPosZ.getDouble(p);
                        double ex = pX - camPos.field_72450_a;
                        double ey = pY - camPos.field_72448_b;
                        double ez = pZ - camPos.field_72449_c;
                        double dot = ex * camDir.field_72450_a + ey * camDir.field_72448_b + ez * camDir.field_72449_c;
                        boolean inFrustum = false;
                        if (dot > 0.0 && dot * dot > frustumThreshold * frustumThreshold * (eDistSq = ex * ex + ey * ey + ez * ez)) {
                            inFrustum = true;
                        }
                        if (smartCulling && !inFrustum) continue;
                        double dx = pX - px;
                        double dy = pY - py;
                        double dz = pZ - pz;
                        double score = distSq = dx * dx + dy * dy + dz * dz;
                        if (!smartCulling && !inFrustum) {
                            score += frustumPenalty;
                        }
                        if (heapSize < limit) {
                            heapParticles[heapSize] = p;
                            heapScores[heapSize] = score;
                            SPMod.heapSiftUp(heapParticles, heapScores, heapSize);
                            ++heapSize;
                            continue;
                        }
                        if (!(score < heapScores[0])) continue;
                        heapParticles[0] = p;
                        heapScores[0] = score;
                        SPMod.heapSiftDown(heapParticles, heapScores, heapSize, 0);
                    }
                    catch (IllegalAccessException pX) {}
                }
            }
        }
        Set keep = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < heapSize; ++i) {
            keep.add(heapParticles[i]);
        }
        ArrayDeque[][] arrayDequeArray2 = fxLayers;
        n = arrayDequeArray2.length;
        for (int i = 0; i < n; ++i) {
            ArrayDeque[] layer;
            for (ArrayDeque queue : layer = arrayDequeArray2[i]) {
                Iterator it = queue.iterator();
                while (it.hasNext()) {
                    Particle p = (Particle)it.next();
                    if (keep.contains(p)) continue;
                    it.remove();
                    p.func_187112_i();
                }
            }
        }
    }

    private static void heapSiftUp(Particle[] ps, double[] ds, int idx) {
        while (idx > 0) {
            int parent = idx - 1 >>> 1;
            if (ds[parent] >= ds[idx]) {
                return;
            }
            SPMod.swap(ps, ds, parent, idx);
            idx = parent;
        }
    }

    private static void heapSiftDown(Particle[] ps, double[] ds, int size, int idx) {
        int left;
        while ((left = (idx << 1) + 1) < size) {
            int right = left + 1;
            int largest = left;
            if (right < size && ds[right] > ds[left]) {
                largest = right;
            }
            if (ds[idx] >= ds[largest]) {
                return;
            }
            SPMod.swap(ps, ds, idx, largest);
            idx = largest;
        }
        return;
    }

    private static void swap(Particle[] ps, double[] ds, int a, int b) {
        Particle tp = ps[a];
        ps[a] = ps[b];
        ps[b] = tp;
        double td = ds[a];
        ds[a] = ds[b];
        ds[b] = td;
    }

    static {
        try {
            fieldPosX = ReflectionHelper.findField(Particle.class, (String[])new String[]{"posX", "field_187126_f"});
            fieldPosY = ReflectionHelper.findField(Particle.class, (String[])new String[]{"posY", "field_187127_g"});
            fieldPosZ = ReflectionHelper.findField(Particle.class, (String[])new String[]{"posZ", "field_187128_h"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

