/*
 * Decompiled with CFR 0.152.
 */
package sp;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.Vec3;
import sp.SPConfig;

@Mod(modid="smartparticles", name="Smart Particles", version="1.7.10-1.2", guiFactory="sp.SPGuiFactory")
public class SPMod {
    public static final String MODID = "smartparticles";
    public static final String NAME = "Smart Particles";
    public static final String VERSION = "1.7.10-1.2";
    private static final String[] FX_LAYERS_NAMES = new String[]{"field_78876_b", "fxLayers", "b"};
    private static boolean hasLoggedError = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        SPConfig.init(event.getSuggestedConfigurationFile());
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MODID)) {
            SPConfig.syncConfig();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft client = Minecraft.func_71410_x();
        if (client.func_147113_T() || client.field_71439_g == null || client.field_71452_i == null) {
            return;
        }
        this.performCulling(client);
    }

    private void performCulling(Minecraft client) {
        List[] fxLayers;
        int limit = Math.max(0, SPConfig.particleLimit);
        boolean smartCulling = SPConfig.smartCameraCulling;
        try {
            fxLayers = (List[])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)client.field_71452_i, (String[])FX_LAYERS_NAMES);
        }
        catch (Exception e) {
            if (!hasLoggedError) {
                System.out.println("[SmartParticles] CRITICAL ERROR: Could not access particle list.");
                e.printStackTrace();
                hasLoggedError = true;
            }
            return;
        }
        if (limit == 0 && !smartCulling) {
            for (List layer : fxLayers) {
                if (layer.isEmpty()) continue;
                layer.clear();
            }
            return;
        }
        if (!smartCulling) {
            int total = 0;
            for (List layer : fxLayers) {
                total += layer.size();
            }
            if (total <= limit) {
                return;
            }
        }
        EntityClientPlayerMP player = client.field_71439_g;
        Vec3 camPos = Vec3.func_72443_a((double)(player.field_70169_q + (player.field_70165_t - player.field_70169_q)), (double)(player.field_70167_r + (player.field_70163_u - player.field_70167_r) + (double)player.func_70047_e()), (double)(player.field_70166_s + (player.field_70161_v - player.field_70166_s)));
        Vec3 camDir = player.func_70676_i(1.0f);
        double fov = client.field_71474_y.field_74334_X;
        double frustumThreshold = Math.cos(Math.toRadians(fov / 2.0 + 30.0));
        double frustumPenalty = 1.0E10;
        double px = player.field_70165_t;
        double py = player.field_70163_u;
        double pz = player.field_70161_v;
        int safeLimit = Math.max(1, limit);
        EntityFX[] heapParticles = new EntityFX[safeLimit];
        double[] heapScores = new double[safeLimit];
        int heapSize = 0;
        for (List layer : fxLayers) {
            for (int i = 0; i < layer.size(); ++i) {
                double distSq;
                double eDistSq;
                EntityFX p = (EntityFX)layer.get(i);
                if (p == null) continue;
                double pX = p.field_70165_t;
                double pY = p.field_70163_u;
                double pZ = p.field_70161_v;
                double ex = pX - camPos.field_72450_a;
                double ey = pY - camPos.field_72448_b;
                double ez = pZ - camPos.field_72449_c;
                double dot = ex * camDir.field_72450_a + ey * camDir.field_72448_b + ez * camDir.field_72449_c;
                boolean inFrustum = false;
                if (dot > 0.0 && dot * dot > frustumThreshold * frustumThreshold * (eDistSq = ex * ex + ey * ey + ez * ez)) {
                    inFrustum = true;
                }
                if (smartCulling && !inFrustum) continue;
                double dx = pX - px;
                double dy = pY - py;
                double dz = pZ - pz;
                double score = distSq = dx * dx + dy * dy + dz * dz;
                if (!smartCulling && !inFrustum) {
                    score += frustumPenalty;
                }
                if (heapSize < safeLimit) {
                    heapParticles[heapSize] = p;
                    heapScores[heapSize] = score;
                    SPMod.heapSiftUp(heapParticles, heapScores, heapSize);
                    ++heapSize;
                    continue;
                }
                if (!(score < heapScores[0])) continue;
                heapParticles[0] = p;
                heapScores[0] = score;
                SPMod.heapSiftDown(heapParticles, heapScores, heapSize, 0);
            }
        }
        Set keep = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < heapSize; ++i) {
            keep.add(heapParticles[i]);
        }
        for (List layer : fxLayers) {
            Iterator it = layer.iterator();
            while (it.hasNext()) {
                EntityFX p = (EntityFX)it.next();
                if (keep.contains(p)) continue;
                it.remove();
                p.func_70106_y();
            }
        }
    }

    private static void heapSiftUp(EntityFX[] ps, double[] ds, int idx) {
        while (idx > 0) {
            int parent = idx - 1 >>> 1;
            if (ds[parent] >= ds[idx]) {
                return;
            }
            SPMod.swap(ps, ds, parent, idx);
            idx = parent;
        }
    }

    private static void heapSiftDown(EntityFX[] ps, double[] ds, int size, int idx) {
        int left;
        while ((left = (idx << 1) + 1) < size) {
            int right = left + 1;
            int largest = left;
            if (right < size && ds[right] > ds[left]) {
                largest = right;
            }
            if (ds[idx] >= ds[largest]) {
                return;
            }
            SPMod.swap(ps, ds, idx, largest);
            idx = largest;
        }
        return;
    }

    private static void swap(EntityFX[] ps, double[] ds, int a, int b) {
        EntityFX tp = ps[a];
        ps[a] = ps[b];
        ps[b] = tp;
        double td = ds[a];
        ds[a] = ds[b];
        ds[b] = td;
    }
}

