/*
 * Decompiled with CFR 0.152.
 */
package com.beetmacol.mc.rails_revamped.impl;

import com.beetmacol.mc.rails_revamped.api.RailsRevamped;
import com.beetmacol.mc.rails_revamped.impl.Stuff;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.class_10131;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1695;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1808;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import net.minecraft.class_9334;

public class CopperMinecart
extends class_1695
implements RailsRevamped.CopperMinecart {
    private static final long WEATHERING_TICK_IGNORE = -2L;
    private static final long WEATHERING_TICK_UNSET = -1L;
    private static final int WEATHERING_TICK_FROM = 72000;
    private static final int WEATHERING_TICK_TO = 216000;
    private long next_weathering_tick = -1L;
    private static final class_2940<class_5955.class_5811> DATA_WEATHER_STATE = class_2945.method_12791(CopperMinecart.class, (class_2941)class_2943.field_61079);

    public CopperMinecart(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    class_1808 getCopperMinecartItem() {
        return Objects.requireNonNull((class_1808)Stuff.COPPER_MINECART_ITEMS.get((Object)Pair.of((Object)this.getWeatherState(), (Object)this.isWaxed())));
    }

    protected class_1792 method_7557() {
        return this.getCopperMinecartItem();
    }

    public class_1799 method_31480() {
        return this.getCopperMinecartItem().method_7854();
    }

    protected void method_5693(class_2945.class_9222 data) {
        super.method_5693(data);
        data.method_56912(DATA_WEATHER_STATE, (Object)class_5955.class_5811.field_28704);
    }

    protected void method_5652(class_11372 output) {
        super.method_5652(output);
        output.method_71466("next_weather_age", this.next_weathering_tick);
        output.method_71468("weather_state", class_5955.class_5811.field_46493, (Object)this.getWeatherState());
    }

    protected void method_5749(class_11368 input) {
        super.method_5749(input);
        this.next_weathering_tick = input.method_71425("next_weather_age", -1L);
        this.setWeatherState(input.method_71426("weather_state", class_5955.class_5811.field_46493).orElse(class_5955.class_5811.field_28704));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_73183().method_8608()) {
            this.updateWeathering(this.method_73183().method_8409(), this.method_73183().method_75260());
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        boolean scrape_wax;
        class_1937 level = this.method_73183();
        if (level.method_8608()) {
            return super.method_5688(player, hand);
        }
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_20414) && !this.isWaxed()) {
            level.method_8444((class_1297)this, 3003, this.method_24515(), 0);
            this.next_weathering_tick = -2L;
            this.usePlayerItem(player, hand, stack);
            return class_1269.field_52422;
        }
        if (stack.method_31573(class_3489.field_42612) && ((scrape_wax = this.isWaxed()) || this.getWeatherState() != class_5955.class_5811.field_28704)) {
            level.method_43129(null, (class_1297)this, class_3417.field_29541, this.method_5634(), 1.0f, 1.0f);
            level.method_8444((class_1297)this, scrape_wax ? 3004 : 3005, this.method_24515(), 0);
            this.next_weathering_tick = -1L;
            if (!scrape_wax) {
                this.field_6011.method_49743(DATA_WEATHER_STATE, (Object)this.getWeatherState().method_72644(), true);
            }
            stack.method_7970(1, (class_1309)player, hand.method_73186());
            return class_1269.field_52422;
        }
        return super.method_5688(player, hand);
    }

    protected void usePlayerItem(class_1657 player, class_1268 hand, class_1799 itemStack) {
        int beforeUseCount = itemStack.method_7947();
        class_10131 useRemainder = (class_10131)itemStack.method_58694(class_9334.field_53965);
        itemStack.method_57008(1, (class_1309)player);
        if (useRemainder != null) {
            class_1799 newHandStack = useRemainder.method_62863(itemStack, beforeUseCount, player.method_56992(), arg_0 -> ((class_1657)player).method_64399(arg_0));
            player.method_6122(hand, newHandStack);
        }
    }

    private static float getCopperSlowdown(class_5955.class_5811 state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case class_5955.class_5811.field_28704 -> 1.0f;
            case class_5955.class_5811.field_28705 -> 0.985f;
            case class_5955.class_5811.field_28706 -> 0.97f;
            case class_5955.class_5811.field_28707 -> 0.94f;
        };
    }

    protected class_243 method_7525(class_243 movement) {
        return super.method_7525(movement).method_1021((double)CopperMinecart.getCopperSlowdown(this.getWeatherState()));
    }

    @Override
    public class_1688 asAbstractMinecart() {
        return this;
    }

    @Override
    public class_5955.class_5811 getWeatherState() {
        return (class_5955.class_5811)this.field_6011.method_12789(DATA_WEATHER_STATE);
    }

    @Override
    public void setWeatherState(class_5955.class_5811 state) {
        this.field_6011.method_12778(DATA_WEATHER_STATE, (Object)state);
    }

    @Override
    public boolean isWaxed() {
        return this.next_weathering_tick == -2L;
    }

    @Override
    public void markWaxed() {
        this.next_weathering_tick = -2L;
    }

    private void randomizeWeatheringTick(class_5819 random, long game_time) {
        this.next_weathering_tick = game_time + (long)random.method_39332(72000, 216000);
    }

    private void updateWeathering(class_5819 random, long game_time) {
        if (this.next_weathering_tick == -2L) {
            return;
        }
        if (this.next_weathering_tick == -1L) {
            this.randomizeWeatheringTick(random, game_time);
        }
        class_5955.class_5811 state = this.getWeatherState();
        if (game_time < this.next_weathering_tick || state == class_5955.class_5811.field_28707) {
            return;
        }
        state = state.method_72643();
        this.setWeatherState(state);
        if (state.equals((Object)class_5955.class_5811.field_28707)) {
            this.next_weathering_tick = 0L;
        } else {
            this.randomizeWeatheringTick(random, game_time);
        }
    }
}

