/*
 * Decompiled with CFR 0.152.
 */
package com.beetmacol.mc.rails_revamped.impl;

import com.beetmacol.mc.rails_revamped.api.RailsRevamped;
import com.beetmacol.mc.rails_revamped.impl.RailMechanics;
import com.beetmacol.mc.rails_revamped.impl.Stuff;
import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class InterruptionRailBlock
extends class_2241 {
    public static final MapCodec<InterruptionRailBlock> CODEC = InterruptionRailBlock.method_54094(InterruptionRailBlock::new);
    public static final class_2754<class_2768> SHAPE = class_2741.field_12542;
    public static final class_2754<RailMechanics.DirectionSign> DIRECTION = class_2754.method_11850((String)"direction", RailMechanics.DirectionSign.class);
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 OCCUPIED = class_2741.field_12528;

    protected InterruptionRailBlock(class_4970.class_2251 settings) {
        super(true, settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(SHAPE, (Comparable)class_2768.field_12665)).method_11657(DIRECTION, (Comparable)((Object)RailMechanics.DirectionSign.NEGATIVE))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_27096, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2241> method_53969() {
        return CODEC;
    }

    public class_2769<class_2768> method_9474() {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE, DIRECTION, POWERED, OCCUPIED, field_27096});
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (rotation == class_2470.field_11464 || rotation == class_2470.field_11465) {
            state = (class_2680)state.method_11657(DIRECTION, (Comparable)((Object)((RailMechanics.DirectionSign)((Object)state.method_11654(DIRECTION))).negate()));
        }
        state = (class_2680)state.method_11657(SHAPE, (Comparable)this.method_71014((class_2768)state.method_11654(SHAPE), rotation));
        return state;
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror.method_26380().method_26387(RailMechanics.shapeToAxis((class_2768)state.method_11654(SHAPE)))) {
            state = (class_2680)state.method_11657(DIRECTION, (Comparable)((Object)((RailMechanics.DirectionSign)((Object)state.method_11654(DIRECTION))).negate()));
        }
        state = (class_2680)state.method_11657(SHAPE, (Comparable)this.method_71013((class_2768)state.method_11654(SHAPE), mirror));
        return state;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = super.method_9605(ctx);
        if (ctx.method_8036() != null) {
            class_2350.class_2351 axis = RailMechanics.shapeToAxis((class_2768)state.method_11654(SHAPE));
            class_2350 direction = class_2350.method_32801((class_1297)ctx.method_8036(), (class_2350.class_2351)axis);
            state = (class_2680)state.method_11657(DIRECTION, (Comparable)((Object)(direction.method_62675().method_30558(axis) < 0 ? RailMechanics.DirectionSign.NEGATIVE : RailMechanics.DirectionSign.POSITIVE)));
        }
        return state;
    }

    protected void method_9477(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighbor) {
        boolean already_powered = (Boolean)state.method_11654((class_2769)POWERED);
        boolean receiving_power = level.method_49803(pos);
        if (receiving_power != already_powered) {
            this.runInChain(state, level, pos, (other_pos, other_state) -> this.checkPowered((class_2680)other_state, level, (class_2338)other_pos, receiving_power), false);
        }
    }

    protected void checkPowered(class_2680 state, class_1937 level, class_2338 pos, boolean source_receiving_power) {
        if ((Boolean)state.method_11654((class_2769)POWERED) == source_receiving_power) {
            return;
        }
        MutableBoolean is_powered = new MutableBoolean(false);
        this.runInChain(state, level, pos, (other_pos, other_state) -> {
            if (level.method_49803(other_pos)) {
                is_powered.setValue(true);
            }
        }, false);
        if (is_powered.get() == state.method_11654((class_2769)POWERED)) {
            return;
        }
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)((Boolean)is_powered.get())), 3);
        if (((Boolean)is_powered.get()).booleanValue()) {
            this.undockAny(level, pos, false);
        }
    }

    protected void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 old_state, boolean movedByPiston) {
        super.method_9615(state, level, pos, old_state, movedByPiston);
        this.updateChainAnalogOutput(state, level, pos, false);
    }

    protected void method_66388(class_2680 state, class_3218 level, class_2338 pos, boolean movedByPiston) {
        super.method_66388(state, level, pos, movedByPiston);
        this.updateChainAnalogOutput(state, (class_1937)level, pos, true);
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 level, class_2338 pos, class_2350 direction) {
        MutableInt result = new MutableInt(0);
        this.runInChain(state, level, pos, (other_pos, other_state) -> {
            if (!((Boolean)other_state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
                return;
            }
            result.add(1);
        }, false);
        return result.intValue();
    }

    public boolean isDockable(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)OCCUPIED) == false && (Boolean)state.method_11654((class_2769)POWERED) == false;
    }

    public boolean tryDock(class_1937 level, class_2338 pos, class_1688 minecart, boolean silent) {
        class_2680 state = level.method_8320(pos);
        assert (state.method_26204() == this);
        if (!this.isDockable(state)) {
            return false;
        }
        RailsRevamped.MinecartDocking docking = new RailsRevamped.MinecartDocking(pos, minecart.method_18798());
        minecart.method_18799(class_243.field_1353);
        RailsRevamped.API.setDocking(minecart, docking);
        state = (class_2680)state.method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(true));
        level.method_8652(pos, state, 3);
        minecart.method_33574(pos.method_61082().method_1031(0.0, 0.1, 0.0));
        this.updateChainAnalogOutput(state, level, pos, false);
        if (!silent) {
            level.method_8396(null, pos, Stuff.SOUND_DOCK, class_3419.field_15245, 1.4f, 1.0f);
        }
        return true;
    }

    public boolean tryUndock(class_1937 level, class_2338 pos, class_1688 minecart, boolean silent) {
        class_2680 state = level.method_8320(pos);
        assert (state.method_26204() == this);
        if (!((Boolean)state.method_11654((class_2769)OCCUPIED)).booleanValue()) {
            return false;
        }
        RailsRevamped.MinecartDocking docking = RailsRevamped.API.getDocking(minecart);
        if (docking == null || !pos.equals((Object)docking.pos())) {
            return false;
        }
        RailsRevamped.API.setDocking(minecart, null);
        state = (class_2680)state.method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false));
        class_243 movement = docking.motion();
        class_2350.class_2351 axis = RailMechanics.shapeToAxis((class_2768)state.method_11654(SHAPE));
        if (Math.signum(movement.method_18043(axis)) != ((RailMechanics.DirectionSign)((Object)state.method_11654(DIRECTION))).sign()) {
            movement = movement.method_38499(axis, -movement.method_18043(axis));
        }
        minecart.method_18799(movement);
        level.method_8652(pos, state, 260);
        this.updateChainAnalogOutput(state, level, pos, false);
        if (!silent) {
            level.method_8396(null, pos, Stuff.SOUND_UNDOCK, class_3419.field_15245, 1.4f, 1.0f);
        }
        return true;
    }

    public boolean undockAny(class_1937 level, class_2338 pos, boolean silent) {
        for (class_1688 minecart : level.method_18467(class_1688.class, new class_238(pos))) {
            if (!this.tryUndock(level, pos, minecart, silent)) continue;
            return true;
        }
        if (!silent) {
            level.method_8396(null, pos, Stuff.SOUND_UNDOCK_FAIL, class_3419.field_15245, 0.8f, 1.0f);
        }
        return false;
    }

    private void updateChainAnalogOutput(class_2680 state, class_1937 level, class_2338 pos, boolean skip_self) {
        this.runInChain(state, level, pos, (other_pos, other_state) -> level.method_8455(other_pos, (class_2248)this), skip_self);
    }

    public void runInChain(class_2680 start_state, class_1937 level, class_2338 start_pos, BiConsumer<class_2338, class_2680> callback, boolean skip_start) {
        class_2338 behind;
        int i;
        class_2680 state = start_state;
        class_2338 pos = start_pos;
        for (i = 0; i < 15 && (behind = this.getBehind(state, level, pos)) != null; ++i) {
            pos = behind;
            state = level.method_8320(pos);
        }
        for (i = 0; i < 15; ++i) {
            if (!skip_start || pos != start_pos) {
                callback.accept(pos, state);
            }
            if ((pos = this.getAhead(state, level, pos)) == null) break;
            state = level.method_8320(pos);
        }
    }

    @Nullable
    private class_2338 getAheadOrBehind(class_2680 state, class_1937 level, class_2338 pos, boolean behind) {
        assert (state.method_26204() == this);
        class_2350 direction = this.getDirection(state);
        class_2350 chain_direction = !behind ? direction : direction.method_10153();
        return RailMechanics.nextRailInChain(this, SHAPE, level, state, pos, chain_direction, other_state -> this.getDirection((class_2680)other_state) == direction);
    }

    @Nullable
    public class_2338 getAhead(class_2680 state, class_1937 level, class_2338 pos) {
        return this.getAheadOrBehind(state, level, pos, false);
    }

    @Nullable
    public class_2338 getBehind(class_2680 state, class_1937 level, class_2338 pos) {
        return this.getAheadOrBehind(state, level, pos, true);
    }

    public class_2350 getDirection(class_2680 state) {
        assert (state.method_26204() == this);
        return RailMechanics.shapeToDirection((class_2768)state.method_11654(SHAPE), (RailMechanics.DirectionSign)((Object)state.method_11654(DIRECTION)));
    }
}

