/*
 * Decompiled with CFR 0.152.
 */
package com.beetmacol.mc.rails_revamped.impl;

import com.beetmacol.mc.rails_revamped.impl.RailMechanics;
import com.beetmacol.mc.rails_revamped.impl.Stuff;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class PoweredRailPower {
    public static final class_2758 POWER = class_2741.field_12511;
    public static final class_2746 POWER_HOST = class_2746.method_11825((String)"own_power");
    public static final int POWER_RANGE = 8;

    public static boolean doApplyEnhancements(class_2442 block) {
        return block.method_63499().equals("block.minecraft.powered_rail");
    }

    public static boolean doModifyStates(class_2442 block, class_3218 level) {
        return PoweredRailPower.doApplyEnhancements(block) && (Boolean)level.method_64395().method_76185(Stuff.RULE_POWERED_RAIL_STRENGTH) != false;
    }

    public static boolean doReplacePhysics(class_2680 state) {
        return PoweredRailPower.doApplyEnhancements((class_2442)state.method_26204()) && ((Integer)state.method_11654((class_2769)POWER) > 0 || (Boolean)state.method_11654((class_2769)class_2442.field_11364) == false);
    }

    public static void appendProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWER_HOST, POWER});
    }

    public static class_2680 withDefaultState(class_2680 state) {
        return (class_2680)((class_2680)state.method_11657((class_2769)POWER_HOST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0));
    }

    public static boolean isDefaultState(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)POWER_HOST) == false && (Integer)state.method_11654((class_2769)POWER) == 0;
    }

    private static int getOwnPower(class_1937 level, class_2338 pos) {
        return level.method_49804(pos);
    }

    private static int findChainPower(class_1937 level, class_2338 pos, RailMechanics.DirectionSign direction_sign, int power, class_2241 block) {
        class_2680 next;
        class_2768 next_shape;
        class_2768 shape;
        class_2350 direction;
        class_2680 current;
        for (int dist = 0; dist < 8 && (pos = RailMechanics.nextRailInChain(block, (class_2754<class_2768>)class_2442.field_11365, level, current = level.method_8320(pos), pos, direction = RailMechanics.shapeToDirection(shape = (class_2768)current.method_11654((class_2769)class_2442.field_11365), direction_sign), state -> true)) != null && RailMechanics.shapeToAxis(next_shape = (class_2768)(next = level.method_8320(pos)).method_11654((class_2769)class_2442.field_11365)) == RailMechanics.shapeToAxis(shape) && (Integer)next.method_11654((class_2769)POWER) >= power; ++dist) {
            if (!((Boolean)next.method_11654((class_2769)POWER_HOST)).booleanValue()) continue;
            power = Math.max(power, PoweredRailPower.getOwnPower(level, pos));
        }
        return power;
    }

    public static boolean updatePower(class_1937 level, class_2338 pos, class_2680 state) {
        boolean is_power_host;
        class_2241 block = (class_2241)state.method_26204();
        int own_power = PoweredRailPower.getOwnPower(level, pos);
        int power = Math.max(PoweredRailPower.findChainPower(level, pos, RailMechanics.DirectionSign.NEGATIVE, own_power, block), PoweredRailPower.findChainPower(level, pos, RailMechanics.DirectionSign.POSITIVE, own_power, block));
        boolean bl = is_power_host = own_power > 0;
        if (is_power_host != (Boolean)state.method_11654((class_2769)POWER_HOST) || power != (Integer)state.method_11654((class_2769)POWER)) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)POWER_HOST, (Comparable)Boolean.valueOf(is_power_host))).method_11657((class_2769)POWER, (Comparable)Integer.valueOf(power));
            level.method_8652(pos, state, 3);
            level.method_8408(pos.method_10074(), (class_2248)block);
            if (((class_2768)state.method_11654((class_2769)class_2442.field_11365)).method_11897()) {
                level.method_8408(pos.method_10084(), (class_2248)block);
            }
        }
        return power > 0;
    }

    public static double getTargetSpeed(class_2680 state, double max_speed) {
        int power = (Integer)state.method_11654((class_2769)POWER);
        return max_speed * (double)power / 15.0;
    }

    public static boolean shouldBoostOrHalt(class_2680 state, double current_speed_sq, double max_speed, boolean halting_not_boosting) {
        double target = PoweredRailPower.getTargetSpeed(state, max_speed);
        return Double.compare(current_speed_sq, target * target) * (halting_not_boosting ? 1 : -1) > 0;
    }

    public static class_243 executeBoostOrHalt(class_2680 state, class_243 wanted, double max_speed, boolean halting_not_boosting) {
        double target = PoweredRailPower.getTargetSpeed(state, max_speed);
        if (PoweredRailPower.shouldBoostOrHalt(state, wanted.method_1027(), max_speed, halting_not_boosting)) {
            return wanted;
        }
        return wanted.method_1029().method_1021(target);
    }
}

