/*
 * Decompiled with CFR 0.152.
 */
package com.beetmacol.mc.rails_revamped.impl;

import com.beetmacol.mc.rails_revamped.api.RailsRevamped;
import com.beetmacol.mc.rails_revamped.impl.InterruptionRailBlock;
import com.beetmacol.mc.rails_revamped.impl.Stuff;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.class_12279;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class RailMechanics {
    public static class_2350.class_2351 shapeToAxis(class_2768 shape) {
        return switch (shape) {
            case class_2768.field_12665, class_2768.field_12670, class_2768.field_12668 -> class_2350.class_2351.field_11051;
            case class_2768.field_12674, class_2768.field_12667, class_2768.field_12666 -> class_2350.class_2351.field_11048;
            default -> throw new IllegalStateException("Expected straight rail shape; got " + shape.method_35309());
        };
    }

    public static class_2350 shapeToDirection(class_2768 shape, DirectionSign sign) {
        class_2350.class_2351 axis = RailMechanics.shapeToAxis(shape);
        return switch (sign.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> axis.method_64923();
            case 1 -> axis.method_64922();
        };
    }

    @Nullable
    public static class_2350 slopeDirection(class_2768 shape) {
        return switch (shape) {
            case class_2768.field_12667 -> class_2350.field_11034;
            case class_2768.field_12666 -> class_2350.field_11039;
            case class_2768.field_12670 -> class_2350.field_11043;
            case class_2768.field_12668 -> class_2350.field_11035;
            default -> null;
        };
    }

    public static class_2768 nonAscending(class_2768 shape) {
        return switch (shape) {
            case class_2768.field_12667, class_2768.field_12666 -> class_2768.field_12674;
            case class_2768.field_12670, class_2768.field_12668 -> class_2768.field_12665;
            default -> shape;
        };
    }

    public static class_2768 changeShapeForClick(class_3218 level, class_243 click, class_2768 old_shape, boolean straight) {
        class_2768 shape = old_shape;
        if (old_shape == class_2768.field_12670 || old_shape == class_2768.field_12668) {
            shape = class_2768.field_12665;
        } else if (old_shape == class_2768.field_12667 || old_shape == class_2768.field_12666) {
            shape = class_2768.field_12674;
        } else if (!straight && Math.abs(click.field_1352) < 0.5 && Math.abs(click.field_1350) < 0.5 && shape != Stuff.INTERSECTION_SHAPE && ((Boolean)level.method_64395().method_76185(Stuff.RULE_RAIL_INTERSECTIONS)).booleanValue()) {
            shape = Stuff.INTERSECTION_SHAPE;
        } else if (!straight && Math.abs(click.field_1352) > 0.5 && Math.abs(click.field_1350) > 0.5) {
            if (click.field_1352 < 0.0 && click.field_1350 < 0.0) {
                shape = class_2768.field_12672;
            } else if (click.field_1352 < 0.0 && click.field_1350 > 0.0) {
                shape = class_2768.field_12671;
            } else if (click.field_1352 > 0.0 && click.field_1350 < 0.0) {
                shape = class_2768.field_12663;
            } else if (click.field_1352 > 0.0 && click.field_1350 > 0.0) {
                shape = class_2768.field_12664;
            }
        } else if (Math.abs(click.field_1350) > Math.abs(click.field_1352)) {
            shape = class_2768.field_12665;
            if (old_shape == shape) {
                if (click.field_1350 > 0.0) {
                    shape = class_2768.field_12668;
                } else if (click.field_1350 < 0.0) {
                    shape = class_2768.field_12670;
                }
            }
        } else if (Math.abs(click.field_1350) < Math.abs(click.field_1352) && old_shape == (shape = class_2768.field_12674)) {
            if (click.field_1352 > 0.0) {
                shape = class_2768.field_12667;
            } else if (click.field_1352 < 0.0) {
                shape = class_2768.field_12666;
            }
        }
        return shape;
    }

    public static DirectionSign changeDirectionSignForClick(class_243 click, class_2768 shape) {
        return click.method_18043(RailMechanics.shapeToAxis(shape)) < 0.0 ? DirectionSign.NEGATIVE : DirectionSign.POSITIVE;
    }

    public static boolean tryChangeRailShape(class_3218 level, class_2338 pos, class_2680 state, class_3965 hit, class_2769<class_2768> shape_property, @Nullable class_2769<DirectionSign> direction_property, boolean straight, RailShapeCheck check) {
        class_2768 old_shape;
        if (!((Boolean)level.method_64395().method_76185(Stuff.RULE_EDITABLE_RAIL_SHAPE)).booleanValue()) {
            return false;
        }
        class_243 click = hit.method_17784().method_1020(pos.method_61082()).method_1021(2.0);
        class_2768 shape = RailMechanics.changeShapeForClick(level, click, old_shape = (class_2768)state.method_11654(shape_property), straight);
        if (check.shouldBeRemoved(pos, (class_1937)level, shape)) {
            shape = old_shape;
        }
        boolean sign_changed = false;
        if (state.method_26204() instanceof InterruptionRailBlock && (shape == class_2768.field_12665 || shape == class_2768.field_12674)) {
            DirectionSign old_sign = (DirectionSign)((Object)state.method_11654(InterruptionRailBlock.DIRECTION));
            DirectionSign sign = RailMechanics.changeDirectionSignForClick(click, shape);
            if (sign != old_sign) {
                state = (class_2680)state.method_11657(InterruptionRailBlock.DIRECTION, (Comparable)((Object)sign));
                sign_changed = true;
            }
        }
        if (shape == old_shape && !sign_changed) {
            return false;
        }
        state = (class_2680)state.method_11657(shape_property, (Comparable)shape);
        level.method_8501(pos, state);
        return true;
    }

    public static Pair<class_2382, class_2382> railExits(class_2768 shape, class_1688 minecart) {
        if (shape == Stuff.INTERSECTION_SHAPE) {
            shape = minecart.method_5735().method_10166() == class_2350.class_2351.field_11051 ? class_2768.field_12674 : class_2768.field_12665;
        }
        return class_1688.method_22864((class_2768)shape);
    }

    public static boolean doStabilizeSpeed(class_3218 level, class_1688 minecart) {
        class_12279<Boolean> rule = RailsRevamped.API.getMiencartStableSpeedGameRule(minecart);
        return rule != null && (Boolean)level.method_64395().method_76185(rule) != false;
    }

    public static boolean stepAlongInterruptionRail(class_1937 level, class_2338 rail_pos, class_2680 rail_state, InterruptionRailBlock rail_block, class_1688 minecart, class_243 position, class_243 velocity, double movement) {
        class_2680 rail_ahead_state;
        class_2338 rail_ahead_pos;
        class_2350 rail_direction = rail_block.getDirection(rail_state);
        class_2350.class_2351 axis = rail_direction.method_10166();
        class_243 destination = rail_pos.method_61082();
        if (Math.signum(velocity.method_18043(axis)) != Math.signum(destination.method_18043(axis) - position.method_18043(axis))) {
            return false;
        }
        if (class_2350.method_58251((class_243)velocity) == rail_direction && (rail_ahead_pos = rail_block.getAhead(rail_state, level, rail_pos)) != null && rail_block.isDockable(rail_ahead_state = level.method_8320(rail_ahead_pos))) {
            return false;
        }
        if (!destination.method_24802((class_2374)position.method_38499(class_2350.class_2351.field_11052, Math.floor(destination.field_1351)), movement)) {
            return false;
        }
        return rail_block.tryDock(level, rail_pos, minecart, false);
    }

    private static boolean checkIfChains(class_2241 block, class_2754<class_2768> shape_property, class_1937 level, class_2338 pos, Predicate<class_2680> additional_check, Predicate<@Nullable class_2350> slope_direction_check) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() != block || !additional_check.test(state)) {
            return false;
        }
        return slope_direction_check.test(RailMechanics.slopeDirection((class_2768)state.method_11654(shape_property)));
    }

    @Nullable
    public static class_2338 nextRailInChain(class_2241 block, class_2754<class_2768> shape_property, class_1937 level, class_2680 state, class_2338 pos, class_2350 direction, Predicate<class_2680> additional_check) {
        class_2768 shape = (class_2768)state.method_11654(shape_property);
        @Nullable class_2350 slope = RailMechanics.slopeDirection(shape);
        if (slope == null || slope == direction.method_10153()) {
            if (RailMechanics.checkIfChains(block, shape_property, level, pos = pos.method_10093(direction), additional_check, other_slope -> other_slope != direction.method_10153())) {
                return pos;
            }
            if (RailMechanics.checkIfChains(block, shape_property, level, pos = pos.method_10074(), additional_check, other_slope -> other_slope == direction.method_10153())) {
                return pos;
            }
            return null;
        }
        if (slope == direction) {
            if (RailMechanics.checkIfChains(block, shape_property, level, pos = pos.method_10093(direction).method_10084(), additional_check, other_slope -> other_slope != direction.method_10153())) {
                return pos;
            }
            return null;
        }
        throw new IllegalStateException("Got interrupted rail direction on different axis than its slope direction");
    }

    public static enum DirectionSign implements class_3542
    {
        NEGATIVE,
        POSITIVE;


        public String method_15434() {
            return this.name().toLowerCase();
        }

        public DirectionSign negate() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> POSITIVE;
                case 1 -> NEGATIVE;
            };
        }

        double sign() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> -1.0;
                case 1 -> 1.0;
            };
        }
    }

    public static interface RailShapeCheck {
        public boolean shouldBeRemoved(class_2338 var1, class_1937 var2, class_2768 var3);
    }
}

