/*
 * Decompiled with CFR 0.152.
 */
package com.beetmacol.mc.rails_revamped.mixin;

import com.beetmacol.mc.rails_revamped.api.RailsRevamped;
import com.beetmacol.mc.rails_revamped.impl.CopperMinecart;
import com.beetmacol.mc.rails_revamped.impl.InterruptionRailBlock;
import com.beetmacol.mc.rails_revamped.impl.Main;
import com.beetmacol.mc.rails_revamped.impl.Stuff;
import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5955;
import net.minecraft.class_8836;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1688.class})
public abstract class AbstractMinecartMixin
extends class_8836 {
    @Shadow
    public abstract class_2338 method_62825();

    public AbstractMinecartMixin(class_1299<?> entity_type, class_1937 world) {
        super(entity_type, world);
    }

    @Inject(method={"method_7523"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1688;method_64275(DDD)V")})
    private static void createMinecart_copperVariant(class_1937 level, double x, double y, double z, class_1299<?> type, class_3730 reason, class_1799 stack, @Nullable class_1657 player, CallbackInfoReturnable<?> ci, @Local class_1688 entity) {
        if (!type.equals(Stuff.COPPER_MINECART)) {
            return;
        }
        if (!(entity instanceof CopperMinecart)) {
            return;
        }
        CopperMinecart minecart = (CopperMinecart)entity;
        Pair info = (Pair)Stuff.COPPER_MINECART_ITEMS.inverse().get((Object)stack.method_7909());
        if (info == null) {
            Main.LOGGER.warn("copper minecart spawned from unrecognized item");
            return;
        }
        minecart.setWeatherState((class_5955.class_5811)info.getFirst());
        if (((Boolean)info.getSecond()).booleanValue()) {
            minecart.markWaxed();
        }
    }

    @Unique
    boolean validateDock() {
        class_1688 self = (class_1688)this;
        RailsRevamped.MinecartDocking docking = RailsRevamped.API.getDocking(self);
        if (docking == null) {
            return false;
        }
        class_2680 state = this.method_73183().method_8320(docking.pos());
        if (state.method_27852((class_2248)Stuff.INTERRUPTION_RAIL) && ((Boolean)state.method_11654((class_2769)InterruptionRailBlock.OCCUPIED)).booleanValue()) {
            return true;
        }
        RailsRevamped.API.setDocking(self, null);
        return false;
    }

    @Inject(method={"method_66327"}, at={@At(value="RETURN")}, cancellable=true)
    private static void exitsLambda_intersectionPlaceholder(CallbackInfoReturnable<ImmutableMap<class_2768, Pair<class_2382, class_2382>>> cir) {
        ImmutableMap orig = (ImmutableMap)cir.getReturnValue();
        Pair placeholder = Objects.requireNonNull((Pair)orig.get((Object)class_2768.field_12665));
        cir.setReturnValue((Object)new ImmutableMap.Builder().putAll((Map)orig).put((Object)Stuff.INTERSECTION_SHAPE, (Object)placeholder).build());
    }

    @Inject(method={"method_22864"}, at={@At(value="HEAD")})
    private static void exits_intersectionWarning(class_2768 shape, CallbackInfoReturnable<Pair<class_2382, class_2382>> cir) {
        if (shape != Stuff.INTERSECTION_SHAPE) {
            return;
        }
        Main.LOGGER.warn("Adjacent rails queried for intersection (possibly non-vanilla call); placeholder (north-south) will be returned, possibly causing wrong behavior on the intersection rail");
    }

    @Inject(method={"method_5810"}, at={@At(value="HEAD")}, cancellable=true)
    private void isPushable_preventPushingDocked(CallbackInfoReturnable<Boolean> cir) {
        RailsRevamped.MinecartDocking docking = RailsRevamped.API.getDocking((class_1688)this);
        if (docking == null) {
            return;
        }
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"method_5784"}, at={@At(value="HEAD")}, cancellable=true)
    private void move_preventMovingDocked(class_1313 moverType, class_243 delta, CallbackInfo ci) {
        RailsRevamped.MinecartDocking docking = RailsRevamped.API.getDocking((class_1688)this);
        if (docking == null) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"method_61565"}, at={@At(value="TAIL")})
    private void setOnRails_undock(boolean on_rails, CallbackInfo ci) {
        if (!this.validateDock() || on_rails) {
            return;
        }
        class_2338 pos = this.method_62825();
        class_2248 class_22482 = this.method_73183().method_8320(pos).method_26204();
        if (!(class_22482 instanceof InterruptionRailBlock)) {
            return;
        }
        InterruptionRailBlock block = (InterruptionRailBlock)class_22482;
        if (!block.tryUndock(this.method_73183(), pos, (class_1688)this, true)) {
            Main.LOGGER.warn("Unexpectedly failed to undock minecart from interruption rail at {}", (Object)pos.method_23854());
        }
    }

    @Inject(method={"method_7513"}, at={@At(value="HEAD")}, cancellable=true)
    private void moveAlongTrack_keepDocked(class_3218 level, CallbackInfo ci) {
        if (this.validateDock()) {
            ci.cancel();
        }
    }
}

