/*
 * Decompiled with CFR 0.152.
 */
package fenny.minepersist.mixin;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class ServerPlayerGameModeMixin {
    @Unique
    private static final Logger MP_LOG = LogUtils.getLogger();
    @Unique
    private static final int MP_TTL_TICKS = 20;
    @Shadow
    protected ServerLevel f_9244_;
    @Shadow
    @Final
    protected ServerPlayer f_9245_;
    @Shadow
    private boolean f_9249_;
    @Shadow
    private int f_9250_;
    @Shadow
    private BlockPos f_9251_;
    @Shadow
    private int f_9252_;
    @Shadow
    private int f_9256_;
    @Unique
    private BlockPos mp_savedPos;
    @Unique
    private BlockState mp_savedState;
    @Unique
    private float mp_savedProgress;
    @Unique
    private int mp_savedAtTick = -999999;
    @Unique
    private int mp_overrideStartTick = Integer.MIN_VALUE;

    @Inject(method={"handleBlockBreakAction"}, at={@At(value="HEAD")})
    private void mp_onHandleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction direction, int worldHeight, int sequence, CallbackInfo ci) {
        if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK || action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            this.mp_captureProgressIfSameTarget(pos);
            return;
        }
        if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            this.mp_prepareRestore(pos);
        }
    }

    @Unique
    private void mp_captureProgressIfSameTarget(BlockPos pos) {
        if (!this.f_9249_) {
            return;
        }
        if (this.f_9251_ == null || !this.f_9251_.equals((Object)pos)) {
            return;
        }
        float approx = this.f_9256_ < 0 ? 0.0f : (float)this.f_9256_ / 10.0f;
        approx = Mth.m_14036_((float)approx, (float)0.0f, (float)1.0f);
        BlockState state = this.f_9244_.m_8055_(pos);
        this.mp_savedPos = pos.m_7949_();
        this.mp_savedState = state;
        this.mp_savedProgress = approx;
        this.mp_savedAtTick = this.f_9252_;
    }

    @Unique
    private void mp_prepareRestore(BlockPos pos) {
        int newStart;
        if (this.mp_savedPos == null) {
            return;
        }
        if (!this.mp_savedPos.equals((Object)pos)) {
            return;
        }
        int age = this.f_9252_ - this.mp_savedAtTick;
        if (age < 0 || age > 20) {
            return;
        }
        BlockState now = this.f_9244_.m_8055_(pos);
        if (!now.equals(this.mp_savedState)) {
            return;
        }
        float speedNow = now.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9244_, pos);
        if (speedNow <= 0.0f) {
            return;
        }
        float elapsed = this.mp_savedProgress / speedNow - 1.0f;
        int elapsedTicks = Math.max(0, Mth.m_14143_((float)elapsed));
        this.mp_overrideStartTick = newStart = this.f_9252_ - elapsedTicks;
        this.f_9256_ = -1;
    }

    @Redirect(method={"handleBlockBreakAction"}, at=@At(value="FIELD", target="Lnet/minecraft/server/level/ServerPlayerGameMode;destroyProgressStart:I", opcode=181))
    private void mp_redirectSetDestroyProgressStart(ServerPlayerGameMode instance, int value) {
        if (this.mp_overrideStartTick != Integer.MIN_VALUE) {
            this.f_9250_ = this.mp_overrideStartTick;
            this.mp_overrideStartTick = Integer.MIN_VALUE;
        } else {
            this.f_9250_ = value;
        }
    }
}

