/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.block.Other;

import com.jerotes.jerotesvillage.block.Other.TabletPressMachine;
import com.jerotes.jerotesvillage.init.JerotesVillageBlockEntities;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.recipes.TabletPressingRecipe;
import com.jerotes.jerotesvillage.world.inventory.TabletPressMachineMenu;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TabletPressMachineEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final int INGREDIENT_SLOT = 3;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2};
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    private final RecipeManager.CachedCheck<Container, ? extends TabletPressingRecipe> quickCheck;
    int makeTime;
    private boolean[] lastPotionCount;
    private Item ingredient;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int n) {
            if (n == 0) {
                return TabletPressMachineEntity.this.makeTime;
            }
            return 0;
        }

        public void m_8050_(int n, int n2) {
            if (n == 0) {
                TabletPressMachineEntity.this.makeTime = n2;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public TabletPressMachineEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)JerotesVillageBlockEntities.TABLET_PRESS_MACHINE.get(), blockPos, blockState);
        this.recipesUsed = new Object2IntOpenHashMap();
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)JerotesVillageRecipeType.TABLET_PRESSING.get()));
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.jerotesvillage.villager_block_physician");
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TabletPressMachineEntity tabletPressMachine) {
        boolean flag = TabletPressMachineEntity.isMakeable(level, tabletPressMachine.items);
        boolean flag1 = tabletPressMachine.makeTime > 0;
        ItemStack itemstack1 = (ItemStack)tabletPressMachine.items.get(3);
        if (flag1) {
            --tabletPressMachine.makeTime;
            boolean flag2 = tabletPressMachine.makeTime == 0;
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)tabletPressMachine.quickCheck.m_213657_((Container)tabletPressMachine, level).orElse(null) : null;
            if (flag2 && flag) {
                tabletPressMachine.m_40156_(recipeholder);
                TabletPressMachineEntity.doMake(level, blockPos, tabletPressMachine.items);
                TabletPressMachineEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            } else if (!flag || !itemstack1.m_150930_(tabletPressMachine.ingredient)) {
                tabletPressMachine.makeTime = 0;
                TabletPressMachineEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        } else if (flag) {
            tabletPressMachine.makeTime = 600;
            tabletPressMachine.ingredient = itemstack1.m_41720_();
            TabletPressMachineEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        boolean[] aboolean = tabletPressMachine.getPotionBits();
        if (!Arrays.equals(aboolean, tabletPressMachine.lastPotionCount)) {
            tabletPressMachine.lastPotionCount = aboolean;
            BlockState blockstate = blockState;
            if (!(blockState.m_60734_() instanceof TabletPressMachine)) {
                return;
            }
        }
    }

    private boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    @Nullable
    private static TabletPressingRecipe findMatchingRecipe(Level level, ItemStack base, ItemStack addition) {
        return level.m_7465_().m_44013_((RecipeType)JerotesVillageRecipeType.TABLET_PRESSING.get()).stream().map(RecipeHolder::f_291008_).filter(recipe -> TabletPressMachineEntity.matchesIngredients(recipe.getBase(), base) && TabletPressMachineEntity.matchesIngredients(recipe.getAddition(), addition)).findFirst().orElse(null);
    }

    private static boolean matchesIngredients(NonNullList<Ingredient> ingredients, ItemStack itemStack) {
        return ingredients.stream().anyMatch(ingredient -> ingredient.test(itemStack));
    }

    private static boolean isMakeable(Level level, NonNullList<ItemStack> items) {
        ItemStack ingredientStack = (ItemStack)items.get(3);
        if (ingredientStack.m_41619_()) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            TabletPressingRecipe recipe;
            ItemStack baseStack = (ItemStack)items.get(i);
            if (baseStack.m_41619_() || (recipe = TabletPressMachineEntity.findMatchingRecipe(level, baseStack, ingredientStack)) == null) continue;
            return true;
        }
        return false;
    }

    private static void doMake(Level level, BlockPos blockPos, NonNullList<ItemStack> items) {
        ItemStack ingredientStack = (ItemStack)items.get(3);
        for (int i = 0; i < 3; ++i) {
            ItemStack baseStack = (ItemStack)items.get(i);
            if (baseStack.m_41619_()) continue;
            TabletPressingRecipe recipe = TabletPressMachineEntity.findMatchingRecipe(level, baseStack, ingredientStack);
            if (recipe != null) {
                ItemStack result = recipe.getResult().m_41777_();
                baseStack.m_41774_(1);
                if (baseStack.m_41619_()) {
                    items.set(i, (Object)result);
                } else {
                    ItemEntity drop = level.m_8055_(blockPos).m_61143_((Property)TabletPressMachine.FACING) == Direction.NORTH ? new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() - 0.5, result) : (level.m_8055_(blockPos).m_61143_((Property)TabletPressMachine.FACING) == Direction.SOUTH ? new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 1.5, result) : (level.m_8055_(blockPos).m_61143_((Property)TabletPressMachine.FACING) == Direction.WEST ? new ItemEntity(level, (double)blockPos.m_123341_() - 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, result) : new ItemEntity(level, (double)blockPos.m_123341_() + 1.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, result)));
                    if (level.m_8055_(blockPos).m_61143_((Property)TabletPressMachine.FACING) == Direction.NORTH) {
                        drop.m_20343_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() - 0.5);
                    } else if (level.m_8055_(blockPos).m_61143_((Property)TabletPressMachine.FACING) == Direction.SOUTH) {
                        drop.m_20343_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 1.5);
                    } else if (level.m_8055_(blockPos).m_61143_((Property)TabletPressMachine.FACING) == Direction.WEST) {
                        drop.m_20343_((double)blockPos.m_123341_() - 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                    } else {
                        drop.m_20343_((double)blockPos.m_123341_() + 1.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                    }
                    drop.m_20334_(0.0, 0.0, 0.0);
                    level.m_7967_((Entity)drop);
                }
                ingredientStack.m_41774_(1);
                items.set(3, (Object)(ingredientStack.m_41619_() ? ItemStack.f_41583_ : ingredientStack));
            }
            level.m_5594_(null, blockPos, JerotesVillageSounds.TABLET_PRESS_MACHINE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        this.makeTime = compoundTag.m_128448_("MakeTime");
        CompoundTag compoundtag = compoundTag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128376_("MakeTime", (short)this.makeTime);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), p_187450_.intValue()));
        compoundTag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public ItemStack m_8020_(int n) {
        return n >= 0 && n < this.items.size() ? (ItemStack)this.items.get(n) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int n, int n2) {
        return ContainerHelper.m_18969_(this.items, (int)n, (int)n2);
    }

    public ItemStack m_8016_(int n) {
        return ContainerHelper.m_18966_(this.items, (int)n);
    }

    public void m_6836_(int n, ItemStack itemStack) {
        if (n >= 0 && n < this.items.size()) {
            this.items.set(n, (Object)itemStack);
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7013_(int n, ItemStack itemStack) {
        return true;
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return direction == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int n, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(n, itemStack);
    }

    public boolean m_7157_(int n, ItemStack itemStack, Direction direction) {
        return n < 3;
    }

    public void m_6211_() {
        this.items.clear();
    }

    protected AbstractContainerMenu m_6555_(int n, Inventory inventory) {
        return new TabletPressMachineMenu(n, inventory, (Container)this, this.dataAccess);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.f_58859_) {
            return switch (facing) {
                case Direction.UP -> this.handlers[0].cast();
                case Direction.DOWN -> this.handlers[1].cast();
                default -> this.handlers[2].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    public void m_40156_(RecipeHolder<?> recipeHolder) {
        if (recipeHolder != null) {
            ResourceLocation resourcelocation = recipeHolder.f_291676_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> m_40158_() {
        return null;
    }

    public void m_5809_(StackedContents stackedContents) {
        for (ItemStack itemstack : this.items) {
            stackedContents.m_36491_(itemstack);
        }
    }
}

