/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.block.ResurrectSediment;

import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Boss.SedimentLordEntity;
import com.jerotes.jerotesvillage.entity.Monster.Resurrecter.ResurrecterEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ResurrecterCoffin
extends Block {
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61410_;

    public ResurrecterCoffin() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283772_).m_60918_(SoundType.f_56743_).m_60913_(6.0f, 9.0f).m_60999_().m_60977_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }

    public int getLevel(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)LEVEL);
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        super.m_213898_(blockState, level, pos, randomSource);
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        super.m_213897_(blockState, level, pos, randomSource);
        level.m_186460_(pos, (Block)this, 1);
        BlockState blockState1 = level.m_8055_(pos.m_7494_());
        if (!blockState1.m_60796_((BlockGetter)level, pos)) {
            List listPlayer = level.m_45976_(Player.class, AABB.m_165882_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (double)12.0, (double)12.0, (double)12.0));
            for (Player players : listPlayer) {
                if (players == null || players.m_6144_() || players.m_20145_() || players.m_150110_().f_35937_) continue;
                this.spawnInfestationTrue(level, blockState, pos);
                return;
            }
            List listResurrect = level.m_45976_(ResurrecterEntity.class, AABB.m_165882_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (double)12.0, (double)12.0, (double)12.0));
            listResurrect.removeIf(entity -> entity.angryTick < 500);
            if (!listResurrect.isEmpty()) {
                this.spawnInfestationTrue(level, blockState, pos);
                return;
            }
            List listLord = level.m_45976_(SedimentLordEntity.class, AABB.m_165882_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (double)32.0, (double)32.0, (double)32.0));
            listLord.removeIf(entity -> entity.angryTick < 500);
            if (!listLord.isEmpty()) {
                this.spawnInfestationTrue(level, blockState, pos);
            }
        }
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 1);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        super.m_6861_(blockState, level, blockPos, block, blockPos2, bl);
        level.m_186460_(blockPos, (Block)this, 1);
    }

    private boolean spawnInfestation(ServerLevel serverLevel, BlockState blockState, BlockPos blockPos) {
        int level = this.getLevel(blockState);
        if (level > 10) {
            level = 10;
        } else if (level < 0) {
            level = 0;
        }
        int max = level;
        int min = 10 - level;
        double guardTen = OtherMainConfig.ResurrectCoffinSedimentGuardWeightAfterTenResurrections;
        double guardZero = OtherMainConfig.ResurrectCoffinSedimentGuardWeight;
        double guard = ((double)max * guardTen + (double)min * guardZero) / 10.0;
        double soulStabilizerTen = OtherMainConfig.ResurrectCoffinSedimentSoulStabilizerWeightAfterTenResurrections;
        double soulStabilizerZero = OtherMainConfig.ResurrectCoffinSedimentSoulStabilizerWeight;
        double soulStabilizer = ((double)max * soulStabilizerTen + (double)min * soulStabilizerZero) / 10.0;
        double heavyGuardTen = OtherMainConfig.ResurrectCoffinHeavyArmoredSedimentGuardWeightAfterTenResurrections;
        double heavyGuardZero = OtherMainConfig.ResurrectCoffinHeavyArmoredSedimentGuardWeight;
        double heavyGuard = ((double)max * heavyGuardTen + (double)min * heavyGuardZero) / 10.0;
        double maxDouble = guard + soulStabilizer + heavyGuard;
        ResurrecterEntity resurrecter = (double)serverLevel.f_46441_.m_188501_() < heavyGuard / maxDouble ? (ResurrecterEntity)((EntityType)JerotesVillageEntityType.HEAVY_ARMORED_SEDIMENT_GUARD.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), MobSpawnType.MOB_SUMMONED) : ((double)serverLevel.f_46441_.m_188501_() > 1.0 - soulStabilizer / maxDouble ? (ResurrecterEntity)((EntityType)JerotesVillageEntityType.SEDIMENT_SOUL_STABILIZER.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), MobSpawnType.MOB_SUMMONED) : (ResurrecterEntity)((EntityType)JerotesVillageEntityType.SEDIMENT_GUARD.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), MobSpawnType.MOB_SUMMONED));
        if (resurrecter != null) {
            List list = serverLevel.m_45976_(ResurrecterEntity.class, resurrecter.m_20191_().m_82377_(32.0, 32.0, 32.0));
            for (ResurrecterEntity resurrecters : list) {
                if (resurrecters == null || resurrecter.m_20270_((Entity)resurrecters) > 64.0f) continue;
                resurrecters.angryTick = 3600;
            }
            resurrecter.m_7678_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
            serverLevel.m_7967_((Entity)resurrecter);
            resurrecter.m_21373_();
            serverLevel.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
            return true;
        }
        return false;
    }

    private void spawnInfestationTrue(ServerLevel serverLevel, BlockState blockState, BlockPos blockPos) {
        boolean bl = this.spawnInfestation(serverLevel, blockState, blockPos);
        if (bl) {
            int level = this.getLevel(blockState);
            if (this.getLevel(blockState) < 10) {
                level = this.getLevel(blockState) + 1;
            }
            serverLevel.m_7731_(blockPos, (BlockState)((Block)JerotesVillageBlocks.RESURRECTER_EMPTY_COFFIN.get()).m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level)), 2);
        }
    }

    public void m_213646_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean bl) {
        super.m_213646_(blockState, serverLevel, blockPos, itemStack, bl);
        this.spawnInfestation(serverLevel, blockState, blockPos);
    }
}

