/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client;

import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SkyRenderer {
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("jerotesvillage", "textures/environment/second_round_world_sun.png");
    private static final ResourceLocation MOON_LOCATION = new ResourceLocation("jerotesvillage", "textures/environment/second_round_world_moon.png");
    private static final ResourceLocation RED_MOON_LOCATION = new ResourceLocation("jerotesvillage", "textures/environment/red_second_round_world_moon.png");
    private static VertexBuffer starBuffer;
    private static VertexBuffer darkBuffer;
    private static VertexBuffer skyBuffer;

    public static boolean renderSky(ClientLevel level, PoseStack stack, Matrix4f matrix, float partialTicks, Camera camera, Runnable runnable) {
        LivingEntity livingEntity;
        Matrix4f matrix4f;
        Minecraft minecraft = Minecraft.m_91087_();
        LevelRenderer levelRenderer = minecraft.f_91060_;
        runnable.run();
        Vec3 vec3 = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), partialTicks);
        float f = (float)vec3.f_82479_;
        float f1 = (float)vec3.f_82480_;
        float f2 = (float)vec3.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        float[] arrf = level.m_104583_().m_7518_(level.m_46942_(f), f);
        if (arrf != null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.m_85836_();
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float f3 = Mth.m_14031_((float)level.m_46490_(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            stack.m_252781_(Axis.f_252403_.m_252977_(f3));
            stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float f4 = arrf[0];
            float f5 = arrf[1];
            float f6 = arrf[2];
            matrix4f = stack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, arrf[3]).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * arrf[3]).m_85950_(arrf[0], arrf[1], arrf[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            stack.m_85849_();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        stack.m_85836_();
        float f10 = 1.0f - level.m_46722_(partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f10);
        stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        stack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(f) * 360.0f));
        Matrix4f matrix4f1 = stack.m_85850_().m_252922_();
        float f11 = 30.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -f11, 100.0f, -f11).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f11, 100.0f, -f11).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f11, 100.0f, f11).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -f11, 100.0f, f11).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        f11 = 20.0f;
        matrix4f = camera.m_90592_();
        if (matrix4f instanceof LivingEntity && (livingEntity = (LivingEntity)matrix4f).m_21023_((MobEffect)JerotesVillageMobEffects.WICKED_RIDICULE_NIGHT.get())) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RED_MOON_LOCATION);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
        }
        int n2 = level.m_46941_();
        int n3 = n2 % 4;
        int n = n2 / 4 % 2;
        float f12 = (float)(n3 + 0) / 4.0f;
        float f14 = (float)(n + 0) / 2.0f;
        float f15 = (float)(n3 + 1) / 4.0f;
        float f16 = (float)(n + 1) / 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -f11, -100.0f, f11).m_7421_(f15, f16).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f11, -100.0f, f11).m_7421_(f12, f16).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f11, -100.0f, -f11).m_7421_(f12, f14).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -f11, -100.0f, -f11).m_7421_(f15, f14).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        float f13 = level.m_104811_(f) * f2;
        if (f13 > 0.0f) {
            RenderSystem.setShaderColor((float)f13, (float)f13, (float)f13, (float)f13);
            FogRenderer.m_109017_();
            starBuffer.m_85921_();
            starBuffer.m_253207_(stack.m_85850_().m_252922_(), matrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            runnable.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        stack.m_85849_();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d0 = minecraft.f_91074_.m_20299_((float)partialTicks).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (d0 < 0.0) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 12.0f, 0.0f);
            darkBuffer.m_85921_();
            darkBuffer.m_253207_(stack.m_85850_().m_252922_(), matrix, shaderinstance);
            VertexBuffer.m_85931_();
            stack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        return true;
    }

    public static void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (starBuffer != null) {
            starBuffer.close();
        }
        starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = SkyRenderer.drawStars(bufferbuilder);
        starBuffer.m_85921_();
        starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    public static void createDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        if (darkBuffer != null) {
            darkBuffer.close();
        }
        darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer renderedBuffer = SkyRenderer.buildSkyDisc(bufferBuilder, -16.0f);
        darkBuffer.m_85921_();
        darkBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }

    public static void createLightSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        if (skyBuffer != null) {
            skyBuffer.close();
        }
        skyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer renderedBuffer = SkyRenderer.buildSkyDisc(bufferBuilder, 16.0f);
        skyBuffer.m_85921_();
        skyBuffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
    }

    private static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder bufferBuilder, float f) {
        float f2 = Math.signum(f) * 512.0f;
        float f3 = 512.0f;
        RenderSystem.setShader(GameRenderer::m_172808_);
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_(0.0, (double)f, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilder.m_5483_((double)(f2 * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)f, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return bufferBuilder.m_231175_();
    }

    private static BufferBuilder.RenderedBuffer drawStars(BufferBuilder bufferBuilder) {
        RandomSource randomSource = RandomSource.m_216335_((long)10842L);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d = randomSource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomSource.m_188501_() * 2.0f - 1.0f;
            double d3 = randomSource.m_188501_() * 2.0f - 1.0f;
            double d4 = 0.15f + randomSource.m_188501_() * 0.1f;
            double d5 = d * d + d2 * d2 + d3 * d3;
            if (!(d5 < 1.0) || !(d5 > 0.01)) continue;
            d5 = 1.0 / Math.sqrt(d5);
            double d6 = (d *= d5) * 100.0;
            double d7 = (d2 *= d5) * 100.0;
            double d8 = (d3 *= d5) * 100.0;
            double d9 = Math.atan2(d, d3);
            double d10 = Math.sin(d9);
            double d11 = Math.cos(d9);
            double d12 = Math.atan2(Math.sqrt(d * d + d3 * d3), d2);
            double d13 = Math.sin(d12);
            double d14 = Math.cos(d12);
            double d15 = randomSource.m_188500_() * Math.PI * 2.0;
            double d16 = Math.sin(d15);
            double d17 = Math.cos(d15);
            for (int j = 0; j < 4; ++j) {
                double d18;
                double d19 = 0.0;
                double d20 = (double)((j & 2) - 1) * d4;
                double d21 = (double)((j + 1 & 2) - 1) * d4;
                double d22 = 0.0;
                double d23 = d20 * d17 - d21 * d16;
                double d24 = d18 = d21 * d17 + d20 * d16;
                double d25 = d23 * d13 + 0.0 * d14;
                double d26 = 0.0 * d13 - d23 * d14;
                double d27 = d26 * d10 - d24 * d11;
                double d28 = d25;
                double d29 = d24 * d10 + d26 * d11;
                bufferBuilder.m_5483_(d6 + d27, d7 + d28, d8 + d29).m_5752_();
            }
        }
        return bufferBuilder.m_231175_();
    }
}

