/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.layer;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class ExplorerArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;
    private final TextureAtlas armorTrimAtlas;
    private final ItemStack itemStackHead;
    private final ItemStack itemStackChest;
    private final ItemStack itemStackLegs;
    private final ItemStack itemStackFeet;

    public ExplorerArmorLayer(RenderLayerParent<T, M> renderLayerParent, A a, A a2, ModelManager modelManager, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4) {
        super(renderLayerParent, a, a2, modelManager);
        this.innerModel = a;
        this.outerModel = a2;
        this.armorTrimAtlas = modelManager.m_119428_(Sheets.f_265912_);
        this.itemStackHead = itemStack;
        this.itemStackChest = itemStack2;
        this.itemStackLegs = itemStack3;
        this.itemStackFeet = itemStack4;
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource multiBufferSource, int n, T t, float f, float f2, float f3, float f4, float f5, float f6) {
        if (t.m_21023_((MobEffect)JerotesMobEffects.CLOAKING.get()) && t.m_6144_()) {
            return;
        }
        this.m_117118_(poseStack, multiBufferSource, t, EquipmentSlot.CHEST, n, this.m_117078_(EquipmentSlot.CHEST));
        this.m_117118_(poseStack, multiBufferSource, t, EquipmentSlot.LEGS, n, this.m_117078_(EquipmentSlot.LEGS));
        this.m_117118_(poseStack, multiBufferSource, t, EquipmentSlot.FEET, n, this.m_117078_(EquipmentSlot.FEET));
        this.m_117118_(poseStack, multiBufferSource, t, EquipmentSlot.HEAD, n, this.m_117078_(EquipmentSlot.HEAD));
    }

    private A m_117078_(EquipmentSlot p_117079_) {
        return this.m_117128_(p_117079_) ? this.innerModel : this.outerModel;
    }

    private void m_117118_(PoseStack poseStack, MultiBufferSource multiBufferSource, T t, EquipmentSlot equipmentSlot, int n, A a) {
        ArmorItem armoritem;
        ItemStack itemstack = t.m_6844_(equipmentSlot);
        Item item = itemstack.m_41720_();
        if (item == this.itemStackHead.m_41720_()) {
            return;
        }
        if (item == this.itemStackChest.m_41720_()) {
            return;
        }
        if (item == this.itemStackLegs.m_41720_()) {
            return;
        }
        if (item == this.itemStackFeet.m_41720_()) {
            return;
        }
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).m_40402_() == equipmentSlot) {
            ((HumanoidModel)this.m_117386_()).m_102872_(a);
            this.m_117125_(a, equipmentSlot);
            Model model = this.getArmorModelHook(t, itemstack, equipmentSlot, a);
            boolean flag = this.m_117128_(equipmentSlot);
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(poseStack, multiBufferSource, n, armoritem, model, flag, f, f1, f2, this.getArmorResource((Entity)t, itemstack, equipmentSlot, null));
                this.renderModel(poseStack, multiBufferSource, n, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)t, itemstack, equipmentSlot, "overlay"));
            } else {
                this.renderModel(poseStack, multiBufferSource, n, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)t, itemstack, equipmentSlot, null));
            }
            ArmorTrim.m_266285_((RegistryAccess)t.m_9236_().m_9598_(), (ItemStack)itemstack, (boolean)true).ifPresent(p_289638_ -> this.renderTrim(armoritem.m_40401_(), poseStack, multiBufferSource, n, (ArmorTrim)p_289638_, model, flag));
            if (itemstack.m_41790_()) {
                this.renderGlint(poseStack, multiBufferSource, n, model);
            }
        }
    }

    protected void m_117125_(A a, EquipmentSlot equipmentSlot) {
        a.m_8009_(false);
        switch (equipmentSlot) {
            case HEAD: {
                ((HumanoidModel)a).f_102808_.f_104207_ = true;
                ((HumanoidModel)a).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)a).f_102810_.f_104207_ = true;
                ((HumanoidModel)a).f_102811_.f_104207_ = true;
                ((HumanoidModel)a).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)a).f_102810_.f_104207_ = true;
                ((HumanoidModel)a).f_102813_.f_104207_ = true;
                ((HumanoidModel)a).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)a).f_102813_.f_104207_ = true;
                ((HumanoidModel)a).f_102814_.f_104207_ = true;
            }
        }
    }

    private void m_289609_(PoseStack p_289664_, MultiBufferSource p_289689_, int p_289681_, ArmorItem p_289650_, A p_289658_, boolean p_289668_, float p_289678_, float p_289674_, float p_289693_, @Nullable String p_289682_) {
        this.renderModel(p_289664_, p_289689_, p_289681_, p_289650_, (Model)p_289658_, p_289668_, p_289678_, p_289674_, p_289693_, this.m_117080_(p_289650_, p_289668_, p_289682_));
    }

    private void renderModel(PoseStack p_289664_, MultiBufferSource p_289689_, int p_289681_, ArmorItem p_289650_, Model p_289658_, boolean p_289668_, float p_289678_, float p_289674_, float p_289693_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = p_289689_.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        p_289658_.m_7695_(p_289664_, vertexconsumer, p_289681_, OverlayTexture.f_118083_, p_289678_, p_289674_, p_289693_, 1.0f);
    }

    private void m_289604_(ArmorMaterial p_289690_, PoseStack p_289687_, MultiBufferSource p_289643_, int p_289683_, ArmorTrim p_289692_, A p_289663_, boolean p_289651_) {
        this.m_289604_(p_289690_, p_289687_, p_289643_, p_289683_, p_289692_, p_289663_, p_289651_);
    }

    private void renderTrim(ArmorMaterial p_289690_, PoseStack p_289687_, MultiBufferSource p_289643_, int p_289683_, ArmorTrim p_289692_, Model p_289663_, boolean p_289651_) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(p_289651_ ? p_289692_.m_267774_(p_289690_) : p_289692_.m_267606_(p_289690_));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(p_289643_.m_6299_(Sheets.m_266442_((boolean)((TrimPattern)p_289692_.m_266429_().m_203334_()).f_290976_())));
        p_289663_.m_7695_(p_289687_, vertexconsumer, p_289683_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void m_289597_(PoseStack p_289673_, MultiBufferSource p_289654_, int p_289649_, A p_289659_) {
        this.m_289597_(p_289673_, p_289654_, p_289649_, p_289659_);
    }

    private void renderGlint(PoseStack p_289673_, MultiBufferSource p_289654_, int p_289649_, Model p_289659_) {
        p_289659_.m_7695_(p_289673_, p_289654_.m_6299_(RenderType.m_110484_()), p_289649_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private boolean m_117128_(EquipmentSlot p_117129_) {
        return p_117129_ == EquipmentSlot.LEGS;
    }

    @Deprecated
    private ResourceLocation m_117080_(ArmorItem p_117081_, boolean p_117082_, @Nullable String p_117083_) {
        String s = "textures/models/armor/" + p_117081_.m_40401_().m_6082_() + "_layer_" + (p_117082_ ? 2 : 1) + (String)(p_117083_ == null ? "" : "_" + p_117083_) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        return ForgeHooksClient.getArmorModel(entity, (ItemStack)itemStack, (EquipmentSlot)slot, model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.m_117128_(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

