/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.layer;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.item.ItemModelArmor;
import com.jerotes.jerotesvillage.client.model.Modelfrost_yeti;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class SnowyApeArmorLayer<T extends LivingEntity, M extends Modelfrost_yeti<T>, A extends Modelfrost_yeti<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;

    public SnowyApeArmorLayer(RenderLayerParent<T, M> renderLayerParent, A a, A a2, ModelManager modelManager) {
        super(renderLayerParent);
        this.innerModel = a;
        this.outerModel = a2;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int n, T t, float f, float f2, float f3, float f4, float f5, float f6) {
        if (t.m_21023_((MobEffect)JerotesMobEffects.CLOAKING.get()) && t.m_6144_()) {
            return;
        }
        ((Modelfrost_yeti)((Object)this.innerModel)).m_6973_(t, f, f2, f4, f5, f6);
        ((Modelfrost_yeti)((Object)this.outerModel)).m_6973_(t, f, f2, f4, f5, f6);
        this.renderArmorPiece(poseStack, multiBufferSource, t, EquipmentSlot.HEAD, n, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T t, EquipmentSlot equipmentSlot, int n, A a) {
        ArmorItem armoritem;
        ItemStack itemstack = t.m_6844_(equipmentSlot);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).m_40402_() == equipmentSlot) {
            ((Modelfrost_yeti)this.m_117386_()).m_102872_((HumanoidModel)a);
            this.setPartVisibility(a, equipmentSlot);
            Model model = this.getArmorModelHook(t, itemstack, equipmentSlot, a);
            boolean flag = this.usesInnerModel(equipmentSlot);
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(poseStack, multiBufferSource, n, armoritem, model, flag, f, f1, f2, this.getArmorResource((Entity)t, itemstack, equipmentSlot, null));
                this.renderModel(poseStack, multiBufferSource, n, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)t, itemstack, equipmentSlot, "overlay"));
            } else {
                this.renderModel(poseStack, multiBufferSource, n, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)t, itemstack, equipmentSlot, null));
            }
            if (itemstack.m_41790_()) {
                this.renderGlint(poseStack, multiBufferSource, n, model);
            }
        }
    }

    protected void setPartVisibility(A a, EquipmentSlot equipmentSlot) {
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource multiBufferSource, int n, ArmorItem armorItem, A a, boolean bl, float f, float f2, float f3, @Nullable String string) {
        this.renderModel(poseStack, multiBufferSource, n, armorItem, (Model)a, bl, f, f2, f3, this.getArmorLocation(armorItem, bl, string));
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource multiBufferSource, int n, ArmorItem armorItem, Model a, boolean bl, float f, float f2, float f3, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        a.m_7695_(poseStack, vertexconsumer, n, OverlayTexture.f_118083_, f, f2, f3, 1.0f);
    }

    private void renderGlint(PoseStack poseStack, MultiBufferSource multiBufferSource, int n, A model) {
        this.renderGlint(poseStack, multiBufferSource, n, model);
    }

    private void renderGlint(PoseStack poseStack, MultiBufferSource multiBufferSource, int n, Model model) {
        model.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110484_()), n, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private A getArmorModel(EquipmentSlot equipmentSlot) {
        return this.usesInnerModel(equipmentSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS;
    }

    @Deprecated
    private ResourceLocation getArmorLocation(ArmorItem armorItem, boolean bl, @Nullable String string) {
        String s = "textures/models/armor/" + armorItem.m_40401_().m_6082_() + "_layer_" + (bl ? 2 : 1) + (String)(string == null ? "" : "_" + string) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack itemStack, EquipmentSlot slot, @Nullable String type) {
        if (!Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString().contains("minecraft:") && !Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString().contains("jerotesvillage:") || itemStack.m_41720_() instanceof ItemModelArmor) {
            if (this.usesInnerModel(slot)) {
                return new ResourceLocation("minecraft:textures/models/armor/iron_layer_2.png");
            }
            return new ResourceLocation("minecraft:textures/models/armor/iron_layer_1.png");
        }
        ArmorItem item = (ArmorItem)itemStack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)itemStack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

