/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.particle;

import com.jerotes.jerotesvillage.init.JerotesVillageParticleRenderTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TimeStealingParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private float baseScale;
    private float distortionProgress;

    protected TimeStealingParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.m_108339_(sprites);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107230_ = 0.9f;
        this.baseScale = 0.75f;
        this.f_107225_ = 80;
        this.f_107219_ = false;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        float progress = (float)this.f_107224_ / (float)this.f_107225_;
        float easeOut = 1.0f - (float)Math.pow(1.0f - progress, 4.0);
        this.f_107663_ = this.baseScale * (1.0f + easeOut * 2.0f);
        this.f_107230_ = 0.9f * (1.0f - progress);
        this.distortionProgress = easeOut;
    }

    public ParticleRenderType m_7556_() {
        return JerotesVillageParticleRenderTypes.CUSTOM_TRANSLUCENT_SHOCKWAVE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new TimeStealingParticle(level, x, y, z, this.sprites);
        }
    }
}

