/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.jerotes.jerotesvillage.entity.Other.ABaseBoatType;
import com.jerotes.jerotesvillage.entity.Other.ABaseChestBoatEntity;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ABaseChestBoatRenderer
extends BoatRenderer {
    private final Map<ABaseBoatType, Pair<ResourceLocation, ListModel<Boat>>> modBoatResources = (Map)Stream.of(ABaseBoatType.values()).collect(ImmutableMap.toImmutableMap(boatType -> boatType, boatType -> Pair.of((Object)new ResourceLocation("jerotesvillage", this.getTextureLocation((ABaseBoatType)((Object)boatType), isChestBoot)), this.createModBoatModel(renderContext, (ABaseBoatType)((Object)boatType), isChestBoot))));

    public ABaseChestBoatRenderer(EntityRendererProvider.Context renderContext, boolean isChestBoot) {
        super(renderContext, isChestBoot);
    }

    public ABaseChestBoatRenderer(EntityRendererProvider.Context renderContext) {
        this(renderContext, true);
    }

    private String getTextureLocation(ABaseBoatType boatType, boolean isChestBoat) {
        return isChestBoat ? "textures/entity/chest_boat/" + boatType.getName() + ".png" : "textures/entity/boat/" + boatType.getName() + ".png";
    }

    private ListModel<Boat> createModBoatModel(EntityRendererProvider.Context renderContext, ABaseBoatType modBoatTypes, boolean isChestBoat) {
        Boat.Type defaultType = Boat.Type.OAK;
        ModelLayerLocation modellayerlocation = ModelLayers.m_233550_((Boat.Type)defaultType);
        ModelPart modelpart = renderContext.m_174023_(modellayerlocation);
        return new ChestBoatModel(renderContext.m_174023_(ModelLayers.m_233550_((Boat.Type)defaultType)));
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        ABaseChestBoatEntity moddedBoat = (ABaseChestBoatEntity)boat;
        return this.modBoatResources.get((Object)moddedBoat.getModBoatType());
    }
}

