/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.renderer;

import com.jerotes.jerotesvillage.client.layer.EyeDiscLayer;
import com.jerotes.jerotesvillage.client.model.Modeleye_disc;
import com.jerotes.jerotesvillage.entity.Monster.EyeDiscEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class EyeDiscRenderer
extends MobRenderer<EyeDiscEntity, Modeleye_disc<EyeDiscEntity>> {
    private static final ResourceLocation LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/eye_disc.png");
    private static final ResourceLocation SHOOT_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/eye_disc_shoot.png");
    private static final ResourceLocation BLIND_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/eye_disc_blind.png");
    private static final ResourceLocation EYE_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/eye_disc_glow.png");

    public EyeDiscRenderer(EntityRendererProvider.Context context) {
        super(context, new Modeleye_disc(context.m_174023_(Modeleye_disc.LAYER_LOCATION)), 0.0f);
        this.m_115326_(new EyeDiscLayer(this, new Modeleye_disc(context.m_174023_(Modeleye_disc.LAYER_LOCATION))));
    }

    protected void scale(EyeDiscEntity entity, PoseStack poseStack, float f) {
        float xMax = 1.75f;
        float yMax = 1.75f;
        float zMax = 1.75f;
        float xMin = 0.75f;
        float yMin = 0.75f;
        float zMin = 0.75f;
        int maxTick = 40;
        int tickX = entity.f_19797_ % maxTick;
        int tickY = (entity.f_19797_ + maxTick / 4) % maxTick;
        int tickZ = (entity.f_19797_ + maxTick / 8) % maxTick;
        float x = 1.25f;
        float y = 1.25f;
        float z = 1.25f;
        if (!entity.isBlind() && entity.getShootTick() > 0) {
            x = (float)tickX > (float)maxTick / 2.0f ? xMin + (float)tickX * ((xMax - xMin) / (float)maxTick) : xMax - (float)tickX * ((xMax - xMin) / (float)maxTick);
            y = (float)tickY > (float)maxTick / 2.0f ? yMin + (float)tickY * ((yMax - yMin) / (float)maxTick) : yMax - (float)tickY * ((yMax - yMin) / (float)maxTick);
            z = (float)tickZ > (float)maxTick / 2.0f ? zMin + (float)tickZ * ((zMax - zMin) / (float)maxTick) : zMax - (float)tickZ * ((zMax - zMin) / (float)maxTick);
        }
        poseStack.m_85841_(x, y, z);
        super.m_7546_((LivingEntity)entity, poseStack, f);
    }

    public void render(EyeDiscEntity entity, float f, float f2, PoseStack poseStack, MultiBufferSource multiBufferSource, int n) {
        if (!entity.isBlind() && entity.getShootTick() > 0) {
            int spellLevel = entity.getSpellLevelOf();
            for (int i = 0; i < spellLevel; ++i) {
                poseStack.m_85836_();
                poseStack.m_252880_((float)spellLevel * 0.5f * (entity.m_217043_().m_188501_() - 0.5f), (float)spellLevel * 0.5f * (entity.m_217043_().m_188501_() - 0.5f), (float)spellLevel * 0.5f * (entity.m_217043_().m_188501_() - 0.5f));
                super.m_7392_((Mob)entity, f, f2, poseStack, multiBufferSource, n);
                poseStack.m_85849_();
            }
            super.m_7392_((Mob)entity, f, f2, poseStack, multiBufferSource, n);
        } else {
            super.m_7392_((Mob)entity, f, f2, poseStack, multiBufferSource, n);
        }
    }

    protected int getBlockLightLevel(EyeDiscEntity entity, BlockPos blockPos) {
        if (!entity.isBlind() && entity.getShootTick() > 0) {
            return 12;
        }
        return super.m_6086_((Entity)entity, blockPos);
    }

    public ResourceLocation getTextureLocation(EyeDiscEntity entity) {
        if (entity.isBlind()) {
            return BLIND_LOCATION;
        }
        if (entity.getShootTick() > 0) {
            return SHOOT_LOCATION;
        }
        return LOCATION;
    }
}

