/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.client.renderer;

import com.jerotes.jerotes.client.layer.TameLayer;
import com.jerotes.jerotesvillage.client.model.Modelmalialosaur;
import com.jerotes.jerotesvillage.entity.Animal.MalialosaurEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class MalialosaurRenderer
extends MobRenderer<MalialosaurEntity, Modelmalialosaur<MalialosaurEntity>> {
    private static final ResourceLocation LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/malialosaur.png");
    private static final ResourceLocation TAME_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/malialosaur_tame.png");
    private static final ResourceLocation SADDLE_LOCATION = new ResourceLocation("jerotesvillage", "textures/entity/malialosaur_saddle.png");

    public MalialosaurRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelmalialosaur(context.m_174023_(Modelmalialosaur.LAYER_LOCATION)), 1.3f);
        this.m_115326_((RenderLayer)new TameLayer((RenderLayerParent)this, new Modelmalialosaur(context.m_174023_(Modelmalialosaur.LAYER_LOCATION)), TAME_LOCATION));
        this.m_115326_((RenderLayer)new SaddleLayer((RenderLayerParent)this, new Modelmalialosaur(context.m_174023_(Modelmalialosaur.LAYER_LOCATION)), SADDLE_LOCATION));
    }

    protected void scale(MalialosaurEntity t, PoseStack poseStack, float f) {
        if (t.getChangeTick() > 0) {
            float xMax = 1.5f;
            float yMax = 1.5f;
            float zMax = 1.5f;
            float xMin = 0.25f;
            float yMin = 0.25f;
            float zMin = 0.25f;
            int maxTick = 20;
            int tickX = t.f_19797_ % maxTick;
            int tickY = (t.f_19797_ + maxTick / 4) % maxTick;
            int tickZ = (t.f_19797_ + maxTick / 8) % maxTick;
            float x = (float)tickX > (float)maxTick / 2.0f ? xMin + (float)tickX * ((xMax - xMin) / (float)maxTick) : xMax - (float)tickX * ((xMax - xMin) / (float)maxTick);
            float y = (float)tickY > (float)maxTick / 2.0f ? yMin + (float)tickY * ((yMax - yMin) / (float)maxTick) : yMax - (float)tickY * ((yMax - yMin) / (float)maxTick);
            float z = (float)tickZ > (float)maxTick / 2.0f ? zMin + (float)tickZ * ((zMax - zMin) / (float)maxTick) : zMax - (float)tickZ * ((zMax - zMin) / (float)maxTick);
            poseStack.m_85841_(x, y, z);
        }
        super.m_7546_((LivingEntity)t, poseStack, f);
    }

    protected float getWhiteOverlayProgress(MalialosaurEntity t, float f) {
        if (t.getChangeTick() > 0) {
            float xMax = 1.0f;
            float yMax = 1.0f;
            float zMax = 1.0f;
            float xMin = 0.0f;
            float yMin = 0.0f;
            float zMin = 0.0f;
            int maxTick = 10;
            int tickX = t.f_19797_ % maxTick;
            int tickY = (t.f_19797_ + maxTick / 4) % maxTick;
            int tickZ = (t.f_19797_ + maxTick / 8) % maxTick;
            float x = (float)tickX > (float)maxTick / 2.0f ? xMin + (float)tickX * ((xMax - xMin) / (float)maxTick) : xMax - (float)tickX * ((xMax - xMin) / (float)maxTick);
            float y = (float)tickY > (float)maxTick / 2.0f ? yMin + (float)tickY * ((yMax - yMin) / (float)maxTick) : yMax - (float)tickY * ((yMax - yMin) / (float)maxTick);
            float z = (float)tickZ > (float)maxTick / 2.0f ? zMin + (float)tickZ * ((zMax - zMin) / (float)maxTick) : zMax - (float)tickZ * ((zMax - zMin) / (float)maxTick);
            return Mth.m_14036_((float)x, (float)y, (float)z);
        }
        return super.m_6931_((LivingEntity)t, f);
    }

    public ResourceLocation getTextureLocation(MalialosaurEntity entity) {
        return LOCATION;
    }

    protected void setupRotations(MalialosaurEntity entity, PoseStack poseStack, float f, float f2, float f3) {
        super.m_7523_((LivingEntity)entity, poseStack, f, f2, f3);
        float pitch = entity.m_146909_() * (float)entity.getWaterAnim() / 40.0f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-pitch));
    }
}

