/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.compat.jei;

import com.jerotes.jerotesvillage.compat.jei.categories.HagReplacementRecipeCategory;
import com.jerotes.jerotesvillage.compat.jei.categories.TabletPressingRecipeCategory;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeType;
import com.jerotes.jerotesvillage.recipes.HagReplacementRecipe;
import com.jerotes.jerotesvillage.recipes.TabletPressingRecipe;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("jerotesvillage", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new TabletPressingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new HagReplacementRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List<TabletPressingRecipe> tabletPressingRecipes = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)JerotesVillageRecipeType.TABLET_PRESSING.get()).stream().map(RecipeHolder::f_291008_).toList();
        registration.addRecipes(TabletPressingRecipeCategory.TABLET_PRESSING, tabletPressingRecipes);
        List<HagReplacementRecipe> hagReplacementRecipes = manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)JerotesVillageRecipeType.HAG_REPLACEMENT.get()).stream().map(RecipeHolder::f_291008_).toList();
        registration.addRecipes(HagReplacementRecipeCategory.HAG_REPLACEMENT, hagReplacementRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)JerotesVillageBlocks.VILLAGER_BLOCK_PHYSICIAN.get()), new RecipeType[]{TabletPressingRecipeCategory.TABLET_PRESSING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)JerotesVillageBlocks.NEW_HAGS_CAULDRON.get()), new RecipeType[]{HagReplacementRecipeCategory.HAG_REPLACEMENT});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

