/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ArmorEntity;
import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantBodyRotationControl;
import com.jerotes.jerotesvillage.control.GiantLookControl;
import com.jerotes.jerotesvillage.control.GiantMoveControl;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.BrightLandBeastEntity;
import com.jerotes.jerotesvillage.entity.in.StopLook;
import com.jerotes.jerotesvillage.goal.BrightLandBeastFloatGoal;
import com.jerotes.jerotesvillage.goal.BrightLandBeastMeleeAttackGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowParentGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeTemptGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.navigation.BrightLandBeastPathNavigation;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ArchnosedHornbeastEntity
extends BaseTamableAnimalEntity
implements NeutralMob,
StopLook,
PlayerRideableJumping,
BreakShieldEntity,
Saddleable,
ArmorEntity,
ContainerListener,
HasCustomInventoryScreen {
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState attack4AnimationState = new AnimationState();
    public AnimationState attack5AnimationState = new AnimationState();
    public AnimationState attack6AnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState quakeStartAnimationState = new AnimationState();
    public AnimationState quakeAnimationState = new AnimationState();
    public AnimationState quakeUseAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("2ed991e3-f1bd-439a-b3fb-0b2791549b50");
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_RUSH = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> QUAKE_TICK = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> QUAKE_USE_TICK = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RUSH_ANIM = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("jerotes", "animal_foods/grass_foods")));
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(ArchnosedHornbeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    public double trampleTick;
    public int sitTick = 0;
    private int walkSound;
    public double blockDestroyTick;
    @Nullable
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;

    public SimpleContainer inventory() {
        return this.inventory;
    }

    public boolean isWearingArmor() {
        return false;
    }

    public boolean isWarBeastArmor() {
        return false;
    }

    public boolean isGiantBeastArmor() {
        return false;
    }

    public ArchnosedHornbeastEntity(EntityType<? extends ArchnosedHornbeastEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(2.6f);
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.f_21342_ = new GiantMoveControl((Mob)this);
        this.f_21365_ = new GiantLookControl((Mob)this, 1);
        this.createInventory();
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_5757_(Container p_30548_) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
    }

    public SoundEvent m_246265_() {
        return JerotesSounds.USE_SADDLE;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 400.0);
        builder = builder.m_22268_(Attributes.f_22281_, 28.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.26);
        builder = builder.m_22268_(Attributes.f_22282_, 3.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BrightLandBeastFloatGoal(this));
        if (!(this instanceof BrightLandBeastEntity)) {
            this.f_21345_.m_25352_(1, (Goal)new BrightLandBeastMeleeAttackGoal(this, 1.1, true));
        } else {
            this.f_21345_.m_25352_(1, (Goal)new BrightLandBeastMeleeAttackGoal(this, 1.0, true));
        }
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new JerotesAnimalChangeTemptGoal(this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new JerotesAnimalChangeFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ArchnosedHornbeastEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.ARCHNOSED_HORNBEAST_AMBIENT;
    }

    public int m_8100_() {
        return 400;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.ARCHNOSED_HORNBEAST_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.ARCHNOSED_HORNBEAST_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        if (this.walkSound == 1) {
            if (this.m_5912_()) {
                this.playRushSound();
            } else {
                this.playWalkSound();
            }
            this.trampUse();
            this.walkSound = 0;
        } else {
            this.walkSound = 1;
        }
    }

    public void playRushSound() {
        this.m_5496_(JerotesVillageSounds.ARCHNOSED_HORNBEAST_RUSH, 1.0f, 1.0f);
    }

    public void playWalkSound() {
        this.m_5496_(JerotesVillageSounds.ARCHNOSED_HORNBEAST_WALK, 1.0f, 1.0f);
    }

    public void trampUse() {
        if (this.m_5448_() == null && !this.m_20160_()) {
            return;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(2.5, 2.5, 2.5));
        list.removeIf(livingEntity -> livingEntity == this || livingEntity.m_20186_() >= this.m_20188_() || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)livingEntity));
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity shock : list) {
            ArchnosedHornbeastEntity archnosedHornbeast;
            if (shock == null || this.m_20280_((Entity)shock) > Double.MAX_VALUE || shock.m_20186_() >= this.m_20188_() || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)shock) || this.m_269323_() != null && AttackFind.FindCanNotAttack((LivingEntity)this.m_269323_(), (Entity)shock) || shock instanceof ArchnosedHornbeastEntity && (archnosedHornbeast = (ArchnosedHornbeastEntity)shock).m_5448_() != this && this.m_5448_() != archnosedHornbeast || !shock.m_20096_() || !Main.mobSizeSmall((Entity)shock) && !Main.mobSizeMedium((Entity)shock)) continue;
            if (shock.m_21223_() <= this.m_21223_() / 10.0f) {
                shock.m_6469_(this.m_269291_().m_269364_((LivingEntity)this), 4.0f);
                continue;
            }
            AttackFind.attackBegin((LivingEntity)this, (Entity)shock);
            AttackFind.attackAfter((LivingEntity)this, (Entity)shock, (float)0.0f, (float)0.2f, (boolean)true, (float)4.0f);
        }
    }

    public int m_6062_() {
        return 6000;
    }

    @Nullable
    public ArchnosedHornbeastEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        ArchnosedHornbeastEntity archnosedHornbeast = (ArchnosedHornbeastEntity)((EntityType)JerotesVillageEntityType.ARCHNOSED_HORNBEAST.get()).m_20615_((Level)serverLevel);
        if (archnosedHornbeast != null && (uUID = this.m_21805_()) != null) {
            archnosedHornbeast.m_21816_(uUID);
            archnosedHornbeast.m_7105_(true);
        }
        return archnosedHornbeast;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float scale = 1.0f;
        if (this instanceof BrightLandBeastEntity) {
            scale = 1.25f;
        }
        float height = 5.8f * scale;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return this.m_21824_() || this.m_6162_() || super.m_6573_(player);
    }

    public boolean m_213824_() {
        return true;
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.500000277905201E-7;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GiantBodyRotationControl((Mob)this);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -288000 : 0);
    }

    protected PathNavigation m_6037_(Level level) {
        if (this instanceof BrightLandBeastEntity) {
            return new BrightLandBeastPathNavigation((Mob)this, level);
        }
        return super.m_6037_(level);
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                if (this.m_21515_() && this.m_20069_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    this.m_19920_(this.m_6113_(), new Vec3((double)strafe, 0.0, (double)forward));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.6));
                    if (this.m_5448_() == null) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                    }
                } else {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
                }
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        if (this.m_21515_() && (this.m_20069_() || this.m_20077_() && this instanceof BrightLandBeastEntity)) {
            this.m_19920_(this.m_6113_(), dir);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.6));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(dir);
        }
        if (this.getQuakeUseTick() > 10) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.m_292590_(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.m_6049_((Entity)this), vec3.f_82481_);
    }

    public float m_6049_(Entity entity) {
        return this.m_292595_(entity) * this.m_6134_();
    }

    protected float m_292595_(Entity entity) {
        float scale = 1.0f;
        if (this instanceof BrightLandBeastEntity) {
            scale = 1.25f;
        }
        if (!this.m_6254_()) {
            return -0.1f * scale;
        }
        return 0.2f * scale;
    }

    public Vec3 m_292590_(Entity entity) {
        return new Vec3(this.m_292594_(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    protected Vector3f m_292594_(Entity entity, EntityDimensions entityDimensions, float f) {
        float fTick;
        if (!this.m_6254_()) {
            float scale = 1.0f;
            if (this instanceof BrightLandBeastEntity) {
                scale = 1.25f;
            }
            float f4 = 0.0f;
            float f2 = 2.0f;
            float f3 = 0.0f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    float fTick2 = 110 - this.getQuakeUseTick();
                    f4 += 2.5f * (fTick2 / 15.0f);
                    f2 -= 2.5f * (fTick2 / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    float fTick3 = 20 - this.getQuakeUseTick();
                    f4 += 2.5f - 2.5f * (fTick3 / 10.0f);
                    f2 -= 2.5f - 2.5f * (fTick3 / 10.0f);
                } else {
                    f4 += 2.5f;
                    f2 -= 2.5f;
                }
            }
            return new Vector3f(f3 * scale, entityDimensions.f_20378_ + f4 * scale, f2 * scale);
        }
        float scale = 1.0f;
        if (this instanceof BrightLandBeastEntity) {
            scale = 1.25f;
        }
        float f2 = this.getSinglePassengerXOffset();
        float f3 = 0.0f;
        float f4 = 0.0f;
        int i = this.m_20197_().indexOf(entity);
        if (i == 0) {
            f2 = 2.0f;
            f3 = 0.0f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 2.5f * (fTick / 15.0f);
                    f2 -= 2.5f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 2.5f - 2.5f * (fTick / 10.0f);
                    f2 -= 2.5f - 2.5f * (fTick / 10.0f);
                } else {
                    f4 += 2.5f;
                    f2 -= 2.5f;
                }
            }
        }
        if (i == 1) {
            f2 = 1.5f;
            f3 = -1.25f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 1.875f * (fTick / 15.0f);
                    f2 -= 2.5f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 1.875f - 1.875f * (fTick / 10.0f);
                    f2 -= 2.5f - 2.5f * (fTick / 10.0f);
                } else {
                    f4 += 1.875f;
                    f2 -= 2.5f;
                }
            }
        }
        if (i == 2) {
            f2 = 1.5f;
            f3 = 1.25f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 1.875f * (fTick / 15.0f);
                    f2 -= 2.5f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 1.875f - 1.875f * (fTick / 10.0f);
                    f2 -= 2.5f - 2.5f * (fTick / 10.0f);
                } else {
                    f4 += 1.875f;
                    f2 -= 2.5f;
                }
            }
        }
        if (i == 3) {
            f2 = 0.0f;
            f3 = -1.25f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 2.0f * (fTick / 15.0f);
                    f2 -= 1.8f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 2.0f - 2.0f * (fTick / 10.0f);
                    f2 -= 1.8f - 1.8f * (fTick / 10.0f);
                } else {
                    f4 += 2.0f;
                    f2 -= 1.8f;
                }
            }
        }
        if (i == 4) {
            f2 = 0.0f;
            f3 = 1.25f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 2.0f * (fTick / 15.0f);
                    f2 -= 1.8f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 2.0f - 2.0f * (fTick / 10.0f);
                    f2 -= 1.8f - 1.8f * (fTick / 10.0f);
                } else {
                    f4 += 2.0f;
                    f2 -= 1.8f;
                }
            }
        }
        if (i == 5) {
            f2 = -1.25f;
            f3 = -1.25f;
            f4 = -0.1f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 0.8f * (fTick / 15.0f);
                    f2 -= 1.6f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 0.8f - 0.8f * (fTick / 10.0f);
                    f2 -= 1.6f - 1.6f * (fTick / 10.0f);
                } else {
                    f4 += 0.8f;
                    f2 -= 1.6f;
                }
            }
        }
        if (i == 6) {
            f2 = -1.25f;
            f3 = 1.25f;
            f4 = -0.1f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 0.8f * (fTick / 15.0f);
                    f2 -= 1.6f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 0.8f - 0.8f * (fTick / 10.0f);
                    f2 -= 1.6f - 1.6f * (fTick / 10.0f);
                } else {
                    f4 += 0.8f;
                    f2 -= 1.6f;
                }
            }
        }
        if (i == 7) {
            f2 = -2.5f;
            f3 = -1.25f;
            f4 = -0.1f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 0.1f * (fTick / 15.0f);
                    f2 -= 1.2f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 0.1f - 0.1f * (fTick / 10.0f);
                    f2 -= 1.2f - 1.2f * (fTick / 10.0f);
                } else {
                    f4 += 0.3f;
                    f2 -= 1.2f;
                }
            }
        }
        if (i == 8) {
            f2 = -2.5f;
            f3 = 1.25f;
            f4 = -0.1f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 0.1f * (fTick / 15.0f);
                    f2 -= 1.2f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 0.1f - 0.1f * (fTick / 10.0f);
                    f2 -= 1.2f - 1.2f * (fTick / 10.0f);
                } else {
                    f4 += 0.1f;
                    f2 -= 1.4f;
                }
            }
        }
        if (i == 9) {
            f2 = -1.75f;
            f4 = -0.1f;
            if (this.getQuakeUseTick() > 10) {
                if (this.getQuakeUseTick() <= 110 && this.getQuakeUseTick() > 95) {
                    fTick = 110 - this.getQuakeUseTick();
                    f4 += 0.0f * (fTick / 15.0f);
                    f2 -= 1.8f * (fTick / 15.0f);
                } else if (this.getQuakeUseTick() <= 20) {
                    fTick = 20 - this.getQuakeUseTick();
                    f4 += 0.0f - 0.0f * (fTick / 10.0f);
                    f2 -= 1.8f - 1.8f * (fTick / 10.0f);
                } else {
                    f4 += 0.0f;
                    f2 -= 1.8f;
                }
            }
        }
        return new Vector3f(f3 * scale, entityDimensions.f_20378_ + f4 * scale, f2 * scale);
    }

    public void m_147240_(double d, double d2, double d3) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(0.0, 0.0, 0.0);
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public int m_21529_() {
        return 5;
    }

    public void m_21391_(Entity entity, float f, float f2) {
        if (!this.stopLookTime()) {
            super.m_21391_(entity, f, f2);
        }
    }

    public void m_146926_(float f) {
        if (!this.stopLookTime()) {
            super.m_146926_(f);
        }
    }

    public void m_146922_(float f) {
        if (!this.stopLookTime()) {
            super.m_146922_(f);
        }
    }

    public void m_5618_(float f) {
        if (!this.stopLookTime()) {
            super.m_5618_(f);
        }
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity;
        float scale = 1.0f;
        if (this instanceof BrightLandBeastEntity) {
            scale = 1.25f;
        }
        if ((entity = this.m_20202_()) != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(2.0 * (double)scale, 2.0 * (double)scale, 2.0 * (double)scale);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    protected void playChestEquipsSound() {
        this.m_5496_(JerotesSounds.USE_CHEST, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public int getShieldBreakStrength() {
        int scale = 1;
        if (this instanceof BrightLandBeastEntity) {
            scale = 12;
        }
        return 100 * scale;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    protected int getMaxPassengers() {
        if (!this.m_6254_()) {
            return 1;
        }
        return 10;
    }

    public boolean hasChest() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ID_CHEST);
    }

    public void setChest(boolean p_30505_) {
        this.m_20088_().m_135381_(DATA_ID_CHEST, (Object)p_30505_);
    }

    public boolean isRush() {
        return (Boolean)this.m_20088_().m_135370_(IS_RUSH);
    }

    public void setRush(boolean bl) {
        this.m_20088_().m_135381_(IS_RUSH, (Object)bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        if (bl) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Rush Movement Speed bonus", 0.05, AttributeModifier.Operation.ADDITION));
        }
    }

    public int getRushAnim() {
        return (Integer)this.m_20088_().m_135370_(RUSH_ANIM);
    }

    public void setRushAnim(int n) {
        this.m_20088_().m_135381_(RUSH_ANIM, (Object)n);
    }

    public int getInventorySize() {
        return 51;
    }

    public int getInventoryColumns() {
        return 10;
    }

    protected void setFlag(int n, boolean n2) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (n2) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | n)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~n)));
        }
    }

    protected boolean getFlag(int n) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & n) != 0;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public boolean isArmor(ItemStack itemStack) {
        return false;
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (!(this instanceof BrightLandBeastEntity)) {
            if (bl) {
                this.m_21051_(Attributes.f_22276_).m_22100_(440.0);
                this.m_21153_(440.0f);
                this.m_21051_(Attributes.f_22281_).m_22100_(30.0);
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(400.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(28.0);
            }
        }
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "attack4")) {
            return 4;
        }
        if (Objects.equals(animation, "attack5")) {
            return 5;
        }
        if (Objects.equals(animation, "attack6")) {
            return 6;
        }
        if (Objects.equals(animation, "quake")) {
            return 7;
        }
        if (Objects.equals(animation, "quakeStart")) {
            return 8;
        }
        if (Objects.equals(animation, "quakeUse")) {
            return 9;
        }
        if (Objects.equals(animation, "dead")) {
            return 10;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.attack4AnimationState);
        list.add(this.attack5AnimationState);
        list.add(this.attack6AnimationState);
        list.add(this.quakeAnimationState);
        list.add(this.quakeStartAnimationState);
        list.add(this.quakeUseAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setQuakeTick(int n) {
        this.m_20088_().m_135381_(QUAKE_TICK, (Object)n);
    }

    public int getQuakeTick() {
        return (Integer)this.m_20088_().m_135370_(QUAKE_TICK);
    }

    public void setQuakeUseTick(int n) {
        this.m_20088_().m_135381_(QUAKE_USE_TICK, (Object)n);
    }

    public int getQuakeUseTick() {
        return (Integer)this.m_20088_().m_135370_(QUAKE_USE_TICK);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("QuakeUseTick", this.getQuakeUseTick());
        compoundTag.m_128405_("QuakeTick", this.getQuakeTick());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128347_("TrampleTick", this.trampleTick);
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128405_("SitTick", this.sitTick);
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("ChestedHorse", this.hasChest());
        compoundTag.m_128379_("IsRush", this.isRush());
        if (this.hasChest()) {
            ListTag $$1 = new ListTag();
            for (int $$2 = 2; $$2 < this.inventory.m_6643_(); ++$$2) {
                ItemStack $$3 = this.inventory.m_8020_($$2);
                if ($$3.m_41619_()) continue;
                CompoundTag $$4 = new CompoundTag();
                $$4.m_128344_("Slot", (byte)$$2);
                $$3.m_41739_($$4);
                $$1.add((Object)$$4);
            }
            compoundTag.m_128365_("Items", (Tag)$$1);
        }
        compoundTag.m_128405_("RushAnim", this.getRushAnim());
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemStack;
        ItemStack itemstack;
        super.m_7378_(compoundTag);
        this.setQuakeUseTick(compoundTag.m_128451_("QuakeUseTick"));
        this.setQuakeTick(compoundTag.m_128451_("QuakeTick"));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.trampleTick = compoundTag.m_128459_("TrampleTick");
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack);
        }
        this.setChest(compoundTag.m_128471_("ChestedHorse"));
        this.setRush(compoundTag.m_128471_("IsRush"));
        this.createInventory();
        if (this.hasChest()) {
            ListTag $$1 = compoundTag.m_128437_("Items", 10);
            for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
                CompoundTag $$3 = $$1.m_128728_($$2);
                int $$4 = $$3.m_128445_("Slot") & 0xFF;
                if ($$4 < 2 || $$4 >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_($$4, ItemStack.m_41712_((CompoundTag)$$3));
            }
        }
        this.updateContainerEquipment();
        this.setRushAnim(compoundTag.m_128451_("RushAnim"));
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(QUAKE_TICK, (Object)600);
        this.m_20088_().m_135372_(QUAKE_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(DATA_ID_FLAGS, (Object)0);
        this.m_20088_().m_135372_(DATA_ID_CHEST, (Object)false);
        this.m_20088_().m_135372_(IS_RUSH, (Object)false);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(RUSH_ANIM, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.attack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack4AnimationState);
                    break;
                }
                case 5: {
                    this.attack5AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack5AnimationState);
                    break;
                }
                case 6: {
                    this.attack6AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack6AnimationState);
                    break;
                }
                case 7: {
                    this.quakeAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.quakeAnimationState);
                    break;
                }
                case 8: {
                    this.quakeStartAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.quakeStartAnimationState);
                    break;
                }
                case 9: {
                    this.quakeUseAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.quakeUseAnimationState);
                    break;
                }
                case 10: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public void m_8107_() {
        double blockDestroyTickUse;
        int attack;
        float f;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && !this.stopLookTime() && this.getAttackTick() <= 0) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) > this.m_20205_() * 5.0f) {
            if (!this.m_9236_().m_5776_()) {
                this.setRush(true);
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setRush(false);
        }
        if (this.m_5912_() && this.isRush()) {
            if (!this.m_9236_().m_5776_()) {
                this.setRushAnim(Math.min(this.getRushAnim() + 1, 40));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setRushAnim(Math.max(this.getRushAnim() - 1, 0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.f_267362_.m_267780_() && this.m_20096_() && this.m_21223_() > this.m_21233_() / 4.0f && !this.m_6162_() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        if (this.m_21825_()) {
            this.idleAnimationState.m_216973_();
        } else {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_21825_() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.m_21825_() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setQuakeTick(Math.max(0, this.getQuakeTick() - 1));
            this.setQuakeUseTick(Math.max(0, this.getQuakeUseTick() - 1));
        }
        if (this.getQuakeUseTick() <= 90 && this.getQuakeUseTick() > 20 && !this.quakeAnimationState.m_216984_() && !this.m_9236_().m_5776_()) {
            this.setAnimTick(80);
            this.setAnimationState("quake");
        }
        if (this.getQuakeUseTick() == 20 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("quakeUse");
        }
        if (this.getQuakeUseTick() == 10) {
            this.earthQuake();
            if (!this.m_9236_().m_5776_()) {
                this.setAttackTick(0);
            }
        }
        if (this.getAttackTick() == 10 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.getAttackTick() > 15 && this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.getAttackTick() > 0) {
            this.m_21573_().m_26573_();
        }
        int n = attack = this instanceof BrightLandBeastEntity ? -((int)(OtherMainConfig.BrightLandBeastMeleeAttackCooldown * 20.0)) : -20;
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(attack, this.getAttackTick() - 1));
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        float breakLevel = this instanceof BrightLandBeastEntity ? 20.0f : 5.0f;
        double d = blockDestroyTickUse = this instanceof BrightLandBeastEntity ? OtherMainConfig.BrightLandBeastBreakBlockCooldown * 20.0 : 60.0;
        if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)breakLevel);
            if (blockDestroy) {
                this.blockDestroyTick = blockDestroyTickUse;
            }
            if (!this.m_9236_().f_46443_ && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
    }

    public void m_7888_(int i) {
    }

    public int m_245614_() {
        return this.getQuakeTick();
    }

    public boolean m_7132_() {
        return this.getQuakeTick() <= 0 && this.getQuakeUseTick() <= 0 && this.getAttackTick() <= -20;
    }

    public void m_7199_(int i) {
        if (i > 80 && this.getQuakeTick() <= 0 && this.getQuakeUseTick() <= 0 && this.getAttackTick() <= -20 && !this.m_9236_().m_5776_()) {
            this.setQuakeUseTick(110);
            this.setQuakeTick(640);
            this.setAnimTick(20);
            this.setAnimationState("quakeStart");
            this.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 100, 3), (Entity)this);
        }
    }

    public void m_8012_() {
    }

    public boolean earthQuake() {
        float damage = 20.0f + this.m_21223_() / 20.0f;
        OtherSpellFind.EarthQuake((LivingEntity)this, (int)damage, 14);
        if (!this.m_20067_() && this.m_6084_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.ARCHNOSED_HORNBEAST_QUAKE, this.m_5720_(), 10.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
        }
        this.setQuakeTick((int)(OtherMainConfig.BrightLandBeastQuakeCooldown * 20.0));
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(12.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                if (!this.hasChest() && itemStack.m_150930_(Items.f_42009_)) {
                    this.equipChest(player, itemStack);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (!this.m_6898_(itemStack) && this.m_6254_() && this.m_20197_().size() < this.getMaxPassengers() && !player.m_36341_() && !this.m_21827_()) {
                    if (!this.m_9236_().f_46443_) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            int pose = this.getChangeType() + 1;
            if (pose > 4) {
                pose = 1;
            }
            this.setChangeType(pose, player);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack) || this.m_21660_() || this instanceof BrightLandBeastEntity) {
            return super.m_6071_(player, interactionHand);
        }
        if (!this.m_21023_((MobEffect)JerotesMobEffects.ANESTHETIZED_HOLD.get())) {
            return InteractionResult.PASS;
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(64) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    private void equipChest(Player player, ItemStack itemStack) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.createInventory();
    }

    @Override
    public boolean stopLookTime() {
        return this.getQuakeUseTick() <= 20 && this.getQuakeUseTick() > 0 || this.getAttackTick() > 0;
    }

    public boolean m_7327_(Entity entity) {
        int attack;
        int n = attack = this instanceof BrightLandBeastEntity ? -((int)(OtherMainConfig.BrightLandBeastMeleeAttackCooldown * 20.0)) : -10;
        if (this.getQuakeUseTick() <= 0 && this.getAttackTick() <= attack) {
            if (!this.m_9236_().m_5776_()) {
                int attackRandom = this.m_217043_().m_188503_(30);
                if (attackRandom > 25) {
                    this.setAttackTick(25);
                    this.setAttackUse(1);
                    this.setAnimTick(25);
                    this.setAnimationState("attack1");
                } else if (attackRandom > 20) {
                    this.setAttackTick(25);
                    this.setAttackUse(1);
                    this.setAnimTick(25);
                    this.setAnimationState("attack2");
                } else if (attackRandom > 15) {
                    this.setAttackTick(25);
                    this.setAttackUse(2);
                    this.setAnimTick(25);
                    this.setAnimationState("attack3");
                } else if (attackRandom > 10) {
                    this.setAttackTick(25);
                    this.setAttackUse(2);
                    this.setAnimTick(30);
                    this.setAnimationState("attack4");
                } else if (attackRandom > 5) {
                    this.setAttackTick(25);
                    this.setAttackUse(3);
                    this.setAnimTick(30);
                    this.setAnimationState("attack5");
                } else {
                    this.setAttackTick(35);
                    this.setAttackUse(4);
                    this.setAnimTick(35);
                    this.setAnimationState("attack6");
                }
            }
            return true;
        }
        return false;
    }

    public boolean trueHurt() {
        Object shake2;
        Object hurt2;
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.ARCHNOSED_HORNBEAST_ATTACK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        float damageBase = 1.0f;
        float knockbackBase = 1.0f;
        if (this.getAttackUse() == 1) {
            knockbackBase = 1.25f;
        }
        if (this.getAttackUse() == 2) {
            damageBase = 1.25f;
        }
        if (this.getAttackUse() == 3) {
            damageBase = 1.5f;
            knockbackBase = 1.25f;
        }
        if (this.getAttackUse() == 4) {
            damageBase = 1.5f;
            knockbackBase = 1.05f;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(1.25));
        for (Object hurt2 : list) {
            ArchnosedHornbeastEntity archnosedHornbeast;
            if (hurt2 == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt2) || !this.m_142582_((Entity)hurt2) || !Main.canSee((Entity)hurt2, (Entity)this) && !this.m_292684_().m_82381_(hurt2.m_20191_()) && this.getAttackUse() != 2 && this.getAttackUse() != 4 || hurt2 instanceof ArchnosedHornbeastEntity && (archnosedHornbeast = (ArchnosedHornbeastEntity)hurt2).m_5448_() != this && this.m_5448_() != archnosedHornbeast) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt2);
            boolean bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt2, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
            if (!bl2) continue;
            if ((Main.mobSizeSmall((Entity)hurt2) || Main.mobSizeMedium((Entity)hurt2) || Main.mobSizeLarge((Entity)hurt2)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt2.m_6095_())) {
                double d = 0.0;
                if (hurt2.m_21051_(Attributes.f_22278_) != null) {
                    d = Math.max(hurt2.m_21133_(Attributes.f_22278_), 1.0);
                }
                double d3 = Math.max(0.0, 1.0 - d) + 0.5;
                hurt2.m_6853_(false);
                hurt2.m_20256_(hurt2.m_20184_().m_82520_(-((this.m_20185_() - hurt2.m_20185_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20186_() - hurt2.m_20186_()) * d3) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20189_() - hurt2.m_20189_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f))));
            }
            if (this.getAttackUse() != 2 || this.getAttackUse() != 4 || !Main.mobSizeSmall((Entity)hurt2) && !Main.mobSizeMedium((Entity)hurt2) || EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt2.m_6095_())) continue;
            hurt2.m_6853_(false);
            hurt2.m_20256_(hurt2.m_20184_().m_82520_(0.0, (double)((7.0f - this.m_20270_((Entity)hurt2)) / 8.0f), 0.0));
        }
        if (this.getAttackUse() == 2 || this.getAttackUse() == 4) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
            for (Object shake2 : listShake) {
                if (shake2 == null || shake2 == this || this.m_20280_((Entity)shake2) > Double.MAX_VALUE || shake2.m_9236_().m_5776_()) continue;
                shake2.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        Main.sweepAttack((Entity)this);
        hurt2 = this.m_9236_();
        if (hurt2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)hurt2;
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), (double)(Main.mobWidth((Entity)this) / 2.0f + 5.0f), (double)0.0, (double)(Main.mobWidth((Entity)this) / 2.0f + 5.0f));
            shake2 = BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_)).iterator();
            while (shake2.hasNext()) {
                BlockPos blockPos = (BlockPos)shake2.next();
                if (!Main.canSee((Vec3)blockPos.m_252807_(), (Entity)this) && this.getAttackUse() != 2 && this.getAttackUse() != 4 || !Main.canSeeAngle((Entity)this, (Vec3)blockPos.m_252807_(), (double)40.0) && this.getAttackUse() != 2 && this.getAttackUse() != 4 && this.getAttackUse() != 3) continue;
                Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
        SimpleParticleType particleOptions = ParticleTypes.f_123777_;
        if (this.getAttackUse() == 4 && (shake2 = this.m_9236_()) instanceof ServerLevel) {
            double offsetZ;
            double offsetX;
            double radius;
            double angle;
            int i;
            ServerLevel serverLevel = (ServerLevel)shake2;
            double d = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            for (i = 0; i < 160; ++i) {
                angle = Math.PI * 2 * (double)i / 160.0;
                radius = 8.0;
                offsetX = Math.cos(angle) * radius;
                offsetZ = Math.sin(angle) * radius;
                serverLevel.m_8767_((ParticleOptions)particleOptions, this.m_20185_() + offsetX + d, this.m_20186_() + (double)0.2f, this.m_20189_() + offsetZ + d2, 0, offsetX * 0.02, -0.04, offsetZ * 0.02, 1.0);
            }
            for (i = 0; i < 100; ++i) {
                angle = Math.PI * 2 * (double)i / 100.0;
                radius = 5.0;
                offsetX = Math.cos(angle) * radius;
                offsetZ = Math.sin(angle) * radius;
                serverLevel.m_8767_((ParticleOptions)particleOptions, this.m_20185_() + offsetX + d, this.m_20186_() + (double)0.2f, this.m_20189_() + offsetZ + d2, 0, offsetX * 0.05, -0.02, offsetZ * 0.05, 1.0);
            }
        }
        return true;
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - (this instanceof BrightLandBeastEntity ? 40 : 20);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        return super.m_6469_(damageSource, amount);
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36384_(true);
        }
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19620_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.hasChest()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            this.setChest(false);
        }
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return ArchnosedHornbeastEntity.this.inventory.m_8020_(p_149503_);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                ArchnosedHornbeastEntity.this.inventory.m_6836_(p_149503_, p_149528_);
                ArchnosedHornbeastEntity.this.updateContainerEquipment();
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int p_149479_) {
        return p_149479_ == 499 ? new SlotAccess(){

            public ItemStack m_142196_() {
                return ArchnosedHornbeastEntity.this.hasChest() ? new ItemStack((ItemLike)Items.f_42009_) : ItemStack.f_41583_;
            }

            public boolean m_142104_(ItemStack p_149485_) {
                if (p_149485_.m_41619_()) {
                    if (ArchnosedHornbeastEntity.this.hasChest()) {
                        ArchnosedHornbeastEntity.this.setChest(false);
                        ArchnosedHornbeastEntity.this.createInventory();
                    }
                    return true;
                }
                if (p_149485_.m_150930_(Items.f_42009_)) {
                    if (!ArchnosedHornbeastEntity.this.hasChest()) {
                        ArchnosedHornbeastEntity.this.setChest(true);
                        ArchnosedHornbeastEntity.this.createInventory();
                    }
                    return true;
                }
                return false;
            }
        } : this.getSlots(p_149479_);
    }

    public SlotAccess getSlots(int p_149514_) {
        int j;
        int i = p_149514_ - this.getAddNumber();
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = p_149514_ - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(p_149514_);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    public boolean canWearArmor() {
        return false;
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openSuchInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        BrightLandBeastEntity brightLandBeast;
        ArchnosedHornbeastEntity archnosedHornbeastEntity = this;
        if (archnosedHornbeastEntity instanceof BrightLandBeastEntity && (brightLandBeast = (BrightLandBeastEntity)archnosedHornbeastEntity).getQuakeTick() > 0) {
            return 0.0f;
        }
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public void m_6153_() {
        super.m_6153_();
        if (this.f_20919_ > 0 && !this.m_9236_().m_5776_()) {
            this.setQuakeUseTick(0);
        }
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }
}

