/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.CatchEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesFollowParentGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BrownVenomousSlugEntity
extends Animal
implements JerotesEntity,
CatchEntity {
    private static final EntityDataAccessor<Integer> POISON_TICK = SynchedEntityData.m_135353_(BrownVenomousSlugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_CATCH = SynchedEntityData.m_135353_(BrownVenomousSlugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("jerotesvillage", "green_humanoid_cane")));

    public BrownVenomousSlugEntity(EntityType<? extends BrownVenomousSlugEntity> type, Level world) {
        super(type, world);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new JerotesFollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.06);
        builder = builder.m_22268_(Attributes.f_22276_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 12.0);
        return builder;
    }

    protected void m_7324_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.getPoisonTick() > 0 && !living.m_7307_(entity) && this.m_6779_(living) && this.m_6549_(living.m_6095_())) {
                if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    if (!living.m_9236_().f_46443_) {
                        living.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.WILDERNESS_GIANT_POISON.get(), 140, 1));
                    }
                } else if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL && !living.m_9236_().f_46443_) {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 140, 1));
                }
            }
        }
        super.m_7324_(entity);
    }

    public ItemStack getCatchItemStack() {
        return new ItemStack((ItemLike)JerotesVillageItems.CAPTURED_BROWN_VENOMOUS_SLUG.get());
    }

    public SoundEvent getPickupSound() {
        return JerotesVillageSounds.BROWN_VENOMOUS_SLUG_AMBIENT;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromCatch();
    }

    public boolean m_6785_(double d) {
        return !this.fromCatch() && !this.m_8077_() && super.m_6785_(d);
    }

    public int getPoisonTick() {
        return (Integer)this.m_20088_().m_135370_(POISON_TICK);
    }

    public void setPoisonTick(int n) {
        this.m_20088_().m_135381_(POISON_TICK, (Object)n);
    }

    public boolean fromCatch() {
        return (Boolean)this.f_19804_.m_135370_(FROM_CATCH);
    }

    public void setFromCatch(boolean bl) {
        this.f_19804_.m_135381_(FROM_CATCH, (Object)bl);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("FromCatch", this.fromCatch());
        compoundTag.m_128405_("PoisonTick", this.getPoisonTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setFromCatch(compoundTag.m_128471_("FromCatch"));
        if (compoundTag.m_128441_("PoisonTick")) {
            this.setPoisonTick(compoundTag.m_128451_("PoisonTick"));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(POISON_TICK, (Object)0);
        this.m_20088_().m_135372_(FROM_CATCH, (Object)false);
    }

    public void saveToCatchTag(ItemStack itemStack) {
        CatchEntity.saveDefaultDataToCatchTag((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        this.m_7380_(compoundTag);
        itemStack.m_41739_(compoundTag);
    }

    public void loadFromCatchTag(CompoundTag compoundTag) {
        CatchEntity.loadDefaultDataFromCatchTag((Mob)this, (CompoundTag)compoundTag);
        this.m_7378_(compoundTag);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return CatchEntity.catchMobPickup((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setPoisonTick(Math.max(0, this.getPoisonTick() - 1));
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setPoisonTick(160);
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.WILDERNESS_GIANT_POISON.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.BROWN_VENOMOUS_SLUG_AMBIENT, 0.15f, 0.5f);
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.BROWN_VENOMOUS_SLUG_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.BROWN_VENOMOUS_SLUG_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.BROWN_VENOMOUS_SLUG_AMBIENT;
    }

    protected float m_6121_() {
        return 0.05f;
    }

    @Nullable
    public BrownVenomousSlugEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (BrownVenomousSlugEntity)((EntityType)JerotesVillageEntityType.BROWN_VENOMOUS_SLUG.get()).m_20615_((Level)serverLevel);
    }
}

