/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.CatchEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesAnimalMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesFollowParentGoal;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class DownySpiderEntity
extends Animal
implements JerotesEntity,
CatchEntity {
    private static final EntityDataAccessor<Boolean> DATA_COLOR_A_ID = SynchedEntityData.m_135353_(DownySpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_COLOR_B_ID = SynchedEntityData.m_135353_(DownySpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_CATCH = SynchedEntityData.m_135353_(DownySpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(DownySpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(DownySpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState climbAnimationState = new AnimationState();
    public int webTime = this.f_19796_.m_188503_(6000) + 6000;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("jerotes", "animal_foods/fruit_foods")));
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(DownySpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public DownySpiderEntity(EntityType<? extends DownySpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalMeleeAttackGoal((Animal)this, 1.3, true));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new JerotesFollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Silverfish.class, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, false));
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.26);
        builder = builder.m_22268_(Attributes.f_22276_, 4.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        return builder;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 0.2f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6121_() {
        return 0.1f;
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - 10;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12434_;
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
        if (!blockState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(blockState, vec3);
        } else {
            this.m_183634_();
        }
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean bl) {
        byte by = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)by);
    }

    public ItemStack getCatchItemStack() {
        return new ItemStack((ItemLike)JerotesVillageItems.CAPTURED_DOWNY_SPIDER.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.f_12432_;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromCatch();
    }

    public boolean m_6785_(double d) {
        return !this.fromCatch() && !this.m_8077_() && super.m_6785_(d);
    }

    public boolean fromCatch() {
        return (Boolean)this.f_19804_.m_135370_(FROM_CATCH);
    }

    public void setFromCatch(boolean bl) {
        this.f_19804_.m_135381_(FROM_CATCH, (Object)bl);
    }

    public boolean isColorA() {
        return (Boolean)this.m_20088_().m_135370_(DATA_COLOR_A_ID);
    }

    public boolean isColorB() {
        return (Boolean)this.m_20088_().m_135370_(DATA_COLOR_B_ID);
    }

    public void setColorA(boolean bl) {
        this.m_20088_().m_135381_(DATA_COLOR_A_ID, (Object)bl);
    }

    public void setColorB(boolean bl) {
        this.m_20088_().m_135381_(DATA_COLOR_B_ID, (Object)bl);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128379_("FromCatch", this.fromCatch());
        compoundTag.m_128379_("IsColorA", this.isColorA());
        compoundTag.m_128379_("IsColorB", this.isColorB());
        compoundTag.m_128405_("WebTime", this.webTime);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setFromCatch(compoundTag.m_128471_("FromCatch"));
        if (compoundTag.m_128441_("IsColorA")) {
            this.setColorA(compoundTag.m_128471_("IsColorA"));
        }
        if (compoundTag.m_128441_("IsColorB")) {
            this.setColorB(compoundTag.m_128471_("IsColorB"));
        }
        if (compoundTag.m_128441_("WebTime")) {
            this.webTime = compoundTag.m_128451_("WebTime");
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(FROM_CATCH, (Object)false);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_COLOR_A_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_COLOR_B_ID, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void saveToCatchTag(ItemStack itemStack) {
        CatchEntity.saveDefaultDataToCatchTag((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        this.m_7380_(compoundTag);
        itemStack.m_41739_(compoundTag);
    }

    public void loadFromCatchTag(CompoundTag compoundTag) {
        CatchEntity.loadDefaultDataFromCatchTag((Mob)this, (CompoundTag)compoundTag);
        this.m_7378_(compoundTag);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return CatchEntity.catchMobPickup((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(7);
            this.setAnimationState("attack");
        }
        if ((bl = super.m_7327_(entity)) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!livingEntity.m_9236_().f_46443_) {
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 20, 0), (Entity)this);
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 20, 0), (Entity)this);
            }
        }
        return bl;
    }

    @Nullable
    public DownySpiderEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        DownySpiderEntity downySpider = (DownySpiderEntity)((EntityType)JerotesVillageEntityType.DOWNY_SPIDER.get()).m_20615_((Level)serverLevel);
        if (downySpider != null && ageableMob instanceof DownySpiderEntity) {
            DownySpiderEntity downySpider2 = (DownySpiderEntity)ageableMob;
            if (this.f_19796_.m_188499_()) {
                downySpider.setColorA(this.isColorA());
                downySpider.setColorB(this.isColorB());
            } else {
                downySpider.setColorA(downySpider2.isColorA());
                downySpider.setColorB(downySpider2.isColorB());
            }
        } else if (downySpider != null) {
            downySpider.setColorA(this.isColorA());
            downySpider.setColorB(this.isColorB());
        }
        return downySpider;
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        for (int i = 0; i < Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)4); ++i) {
            DownySpiderEntity ageableMob = this.getBreedOffspring(serverLevel, (AgeableMob)animal);
            if (ageableMob == null) {
                return;
            }
            ageableMob.m_6863_(true);
            ageableMob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            this.m_277117_(serverLevel, animal, (AgeableMob)ageableMob);
            serverLevel.m_47205_((Entity)ageableMob);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.isClimbing()) {
            this.climbAnimationState.m_216977_(this.f_19797_);
        } else {
            this.climbAnimationState.m_216973_();
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_() && --this.webTime <= 0) {
            this.m_5496_(SoundEvents.f_12432_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            if ((double)this.f_19796_.m_188501_() > 0.99) {
                this.m_19998_((ItemLike)JerotesVillageItems.HIGH_STRENGTH_STRING.get());
            } else if ((double)this.f_19796_.m_188501_() > 0.9) {
                this.m_19998_((ItemLike)Items.f_41863_);
            } else {
                this.m_19998_((ItemLike)Items.f_42401_);
            }
            this.m_146850_(GameEvent.f_157810_);
            this.webTime = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.FISHING_NET_CONFINEMET.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomSourceSkin = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION && mobSpawnType != MobSpawnType.BREEDING) {
            if (randomSourceSkin.m_188501_() < 0.25f) {
                this.setColorA(true);
            }
            if (randomSourceSkin.m_188501_() < 0.3f) {
                this.setColorB(true);
            }
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }
}

