/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.CatchEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesFollowParentGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotesvillage.control.BabyCanNotFlyMoveControl;
import com.jerotes.jerotesvillage.goal.FollowDustMothGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DustMothEntity
extends Animal
implements JerotesEntity,
CatchEntity {
    private static final EntityDataAccessor<Boolean> DATA_COLOR_A_ID = SynchedEntityData.m_135353_(DustMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_COLOR_B_ID = SynchedEntityData.m_135353_(DustMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_CATCH = SynchedEntityData.m_135353_(DustMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> QUEEN = SynchedEntityData.m_135353_(DustMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PUPA = SynchedEntityData.m_135353_(DustMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DUST_COOLDOWN = SynchedEntityData.m_135353_(DustMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState dustAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.f_13143_);
    private static final Ingredient FOOD_ITEMS_OTHER = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_151016_)});

    public DustMothEntity(EntityType<? extends DustMothEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new BabyCanNotFlyMoveControl((Mob)this, 10, true);
        this.m_252801_();
    }

    public boolean isJerotesFlyingMob() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS_OTHER, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowDustMothGoal(this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new JerotesFollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22280_, 1.8);
        builder = builder.m_22268_(Attributes.f_22279_, 0.1);
        builder = builder.m_22268_(Attributes.f_22276_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        return builder;
    }

    protected float m_6121_() {
        return 0.1f;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack) || FOOD_ITEMS_OTHER.test(itemStack);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.DUST_MOTH_HURT;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.DUST_MOTH_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.DUST_MOTH_DEATH;
    }

    public ItemStack getCatchItemStack() {
        return new ItemStack((ItemLike)JerotesVillageItems.CAPTURED_DUST_MOTH.get());
    }

    protected Component m_5677_() {
        if (this.isQueen()) {
            return Component.m_237115_((String)"entity.jerotesvillage.dust_moth.queen");
        }
        return Component.m_237115_((String)this.m_6095_().m_20675_());
    }

    public SoundEvent getPickupSound() {
        return JerotesVillageSounds.DUST_MOTH_AMBIENT;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromCatch();
    }

    public boolean m_6785_(double d) {
        return !this.fromCatch() && !this.m_8077_() && super.m_6785_(d);
    }

    protected void m_30232_() {
        super.m_30232_();
    }

    @NotNull
    public PathNavigation m_21573_() {
        Entity entity = this.m_275832_();
        if (entity instanceof Mob) {
            return super.m_21573_();
        }
        if (this.m_6162_()) {
            return new GroundPathNavigation((Mob)this, this.m_9236_());
        }
        return super.m_21573_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        int size = this.m_6162_() ? 2 : 1;
        return super.m_6972_(pose).m_20388_(1.0f * (float)size);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        if (this.isQueen()) {
            float height = 0.225f;
            if (this.m_6162_()) {
                return height / 2.0f;
            }
            return height;
        }
        float height = 0.15f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    protected PathNavigation m_6037_(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public boolean fromCatch() {
        return (Boolean)this.f_19804_.m_135370_(FROM_CATCH);
    }

    public void setFromCatch(boolean bl) {
        this.f_19804_.m_135381_(FROM_CATCH, (Object)bl);
    }

    public boolean isColorA() {
        return (Boolean)this.m_20088_().m_135370_(DATA_COLOR_A_ID);
    }

    public boolean isColorB() {
        return (Boolean)this.m_20088_().m_135370_(DATA_COLOR_B_ID);
    }

    public void setColorA(boolean bl) {
        this.m_20088_().m_135381_(DATA_COLOR_A_ID, (Object)bl);
    }

    public void setColorB(boolean bl) {
        this.m_20088_().m_135381_(DATA_COLOR_B_ID, (Object)bl);
    }

    public boolean isQueen() {
        return (Boolean)this.m_20088_().m_135370_(QUEEN);
    }

    public void setQueen(boolean bl) {
        this.m_20088_().m_135381_(QUEEN, (Object)bl);
        this.m_20090_();
        this.m_6210_();
    }

    public boolean isPupa() {
        return (Boolean)this.m_20088_().m_135370_(PUPA);
    }

    public void setPupa(boolean bl) {
        this.m_20088_().m_135381_(PUPA, (Object)bl);
        this.m_20090_();
        this.m_6210_();
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double d2 = this.m_20186_();
        double d3 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, d2, d3);
    }

    public int getDustCooldown() {
        return (Integer)this.m_20088_().m_135370_(DUST_COOLDOWN);
    }

    public void setDustCooldown(int n) {
        this.m_20088_().m_135381_(DUST_COOLDOWN, (Object)n);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("FromCatch", this.fromCatch());
        compoundTag.m_128379_("IsColorA", this.isColorA());
        compoundTag.m_128379_("IsColorB", this.isColorB());
        compoundTag.m_128379_("IsQueen", this.isQueen());
        compoundTag.m_128379_("IsPupa", this.isPupa());
        compoundTag.m_128405_("DustCooldown", this.getDustCooldown());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setFromCatch(compoundTag.m_128471_("FromCatch"));
        if (compoundTag.m_128441_("IsColorA")) {
            this.setColorA(compoundTag.m_128471_("IsColorA"));
        }
        if (compoundTag.m_128441_("IsColorB")) {
            this.setColorB(compoundTag.m_128471_("IsColorB"));
        }
        if (compoundTag.m_128441_("IsQueen")) {
            this.setQueen(compoundTag.m_128471_("IsQueen"));
        }
        if (compoundTag.m_128441_("IsPupa")) {
            this.setPupa(compoundTag.m_128471_("IsPupa"));
        }
        if (compoundTag.m_128441_("DustCooldown")) {
            this.setDustCooldown(compoundTag.m_128451_("DustCooldown"));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FROM_CATCH, (Object)false);
        this.m_20088_().m_135372_(QUEEN, (Object)false);
        this.m_20088_().m_135372_(PUPA, (Object)false);
        this.m_20088_().m_135372_(DATA_COLOR_A_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_COLOR_B_ID, (Object)false);
        this.m_20088_().m_135372_(DUST_COOLDOWN, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (QUEEN.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (PUPA.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    public void saveToCatchTag(ItemStack itemStack) {
        CatchEntity.saveDefaultDataToCatchTag((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        this.m_7380_(compoundTag);
        itemStack.m_41739_(compoundTag);
    }

    public void loadFromCatchTag(CompoundTag compoundTag) {
        CatchEntity.loadDefaultDataFromCatchTag((Mob)this, (CompoundTag)compoundTag);
        this.m_7378_(compoundTag);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return CatchEntity.catchMobPickup((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isPupa()) {
            this.m_6862_(false);
            if (!this.m_9236_().m_5776_()) {
                this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
                this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_6162_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setDustCooldown(Math.max(0, this.getDustCooldown() - 1));
        }
        if ((this.m_20070_() || this.m_20072_()) && this.getDustCooldown() < 1600 && !this.m_9236_().m_5776_()) {
            this.setDustCooldown(this.getDustCooldown() + 100);
        }
        if (this.m_6162_() && this.m_146764_() > -2400) {
            if (!this.isPupa() && !this.m_9236_().m_5776_()) {
                this.setPupa(true);
                if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.m_20000_((ItemLike)Items.f_42401_, 1);
                    if (this.isQueen()) {
                        this.m_20000_((ItemLike)JerotesVillageItems.HIGH_STRENGTH_STRING.get(), 1);
                    }
                }
            }
        } else if (this.isPupa() && !this.m_9236_().m_5776_()) {
            this.setPupa(false);
        }
    }

    @Nullable
    public DustMothEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        DustMothEntity dustMoth = (DustMothEntity)((EntityType)JerotesVillageEntityType.DUST_MOTH.get()).m_20615_((Level)serverLevel);
        if (dustMoth != null && ageableMob instanceof DustMothEntity) {
            DustMothEntity dustMoth2 = (DustMothEntity)ageableMob;
            if (this.f_19796_.m_188499_()) {
                dustMoth.setColorA(this.isColorA());
                dustMoth.setColorB(this.isColorB());
            } else {
                dustMoth.setColorA(dustMoth2.isColorA());
                dustMoth.setColorB(dustMoth2.isColorB());
            }
            if (this.isQueen()) {
                dustMoth.setQueen(this.isQueen());
            } else if (dustMoth2.isQueen()) {
                dustMoth.setQueen(dustMoth2.isQueen());
            } else {
                dustMoth.setQueen(false);
            }
        } else if (dustMoth != null) {
            dustMoth.setColorA(this.isColorA());
            dustMoth.setColorB(this.isColorB());
            dustMoth.setQueen(this.isQueen());
        }
        return dustMoth;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.PRURITUS.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        if (amount > 0.0f && damageSource.m_7639_() != null && damageSource.m_7639_() != this) {
            this.cloud();
            if (this.isQueen()) {
                List list = this.m_9236_().m_45976_(DustMothEntity.class, this.m_20191_().m_82377_(3.0, 3.0, 3.0));
                for (DustMothEntity find : list) {
                    if (find == null || find.m_5647_() != null && find.m_5647_() != this.m_5647_()) continue;
                    find.cloud();
                }
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean cloud() {
        if (this.getDustCooldown() > 0 || this.m_6162_() || !this.m_6084_()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setDustCooldown(1600);
        }
        this.dustAnimationState.m_216977_(this.f_19797_);
        int scale = this.isQueen() ? 2 : 1;
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaEffectCloud.m_19718_((LivingEntity)this);
        areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123796_);
        areaEffectCloud.m_19712_((float)scale / 2.0f);
        areaEffectCloud.m_19734_(60 * scale);
        areaEffectCloud.m_19738_((2.0f - areaEffectCloud.m_19743_()) / (float)areaEffectCloud.m_19748_());
        areaEffectCloud.m_19716_(new MobEffectInstance((MobEffect)JerotesMobEffects.PRURITUS.get(), 240 * scale, scale - 1));
        this.m_5496_(JerotesVillageSounds.DUST_MOTH_CLOUD, 1.0f, 1.0f);
        this.m_9236_().m_7967_((Entity)areaEffectCloud);
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomSourceSkin = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION && mobSpawnType != MobSpawnType.BREEDING) {
            if (randomSourceSkin.m_188501_() < 0.25f) {
                this.setColorA(true);
            }
            if (randomSourceSkin.m_188501_() < 0.3f) {
                this.setColorB(true);
            }
            if (randomSourceSkin.m_188501_() < 0.05f) {
                this.setQueen(true);
            }
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }
}

