/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal.Fish.BenthicFish;

import com.jerotes.jerotesvillage.entity.Animal.Fish.BenthicFish.BaseBenthicFishEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class BrightGrassCarpEntity
extends BaseBenthicFishEntity {
    public AnimationState idleAnimationState = new AnimationState();
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("00cc11c5-1b8e-4474-ac0e-9dd70f715fc1");
    private static final EntityDataAccessor<Boolean> WALKER = SynchedEntityData.m_135353_(BrightGrassCarpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean isLandNavigatorType = false;
    public boolean isRainAbout = false;

    public BrightGrassCarpEntity(EntityType<? extends BrightGrassCarpEntity> entityType, Level level) {
        super(entityType, level);
        this.m_252801_();
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)JerotesVillageItems.BRIGHT_GRASS_CARP_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.BRIGHT_GRASS_CARP_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.BRIGHT_GRASS_CARP_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.BRIGHT_GRASS_CARP_HURT;
    }

    protected SoundEvent m_5699_() {
        return JerotesVillageSounds.BRIGHT_GRASS_CARP_FLOP;
    }

    protected SoundEvent m_5501_() {
        return JerotesVillageSounds.BRIGHT_GRASS_CARP_SWIM;
    }

    public static AttributeSupplier.Builder m_27495_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.7);
        builder = builder.m_22268_(Attributes.f_22276_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    public EntityDimensions m_6972_(Pose pose) {
        int size = this.isWalker() ? 3 : 1;
        return super.m_6972_(pose).m_20390_(1.0f, (float)size);
    }

    protected void m_6229_(int n) {
        if (!this.isWalker()) {
            super.m_6229_(n);
        } else {
            this.m_20301_(300);
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        if (this.isWalker()) {
            return 0.8f;
        }
        return super.m_6431_(pose, entityDimensions);
    }

    public boolean isWalker() {
        return (Boolean)this.m_20088_().m_135370_(WALKER);
    }

    public void setWalker(boolean bl) {
        this.m_20088_().m_135381_(WALKER, (Object)bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        if (bl) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Walker Movement Speed bonus", -0.5, AttributeModifier.Operation.ADDITION));
        }
        this.m_20090_();
        this.m_6210_();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsWalker", this.isWalker());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setWalker(compoundTag.m_128471_("IsWalker"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(WALKER, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (WALKER.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    @Override
    public void m_8107_() {
        BlockState blockState;
        super.m_8107_();
        boolean rain = this.m_9236_().m_46758_(this.m_20097_());
        if (rain && !this.isRainAbout) {
            this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
            this.isRainAbout = true;
        }
        if (!rain && this.isRainAbout) {
            this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
            this.isRainAbout = false;
        }
        if (this.isWalker()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.m_20069_() && this.isLandNavigatorType) {
            this.f_21342_ = new FishMoveControl((AbstractFish)this);
            this.f_21344_ = new WaterBoundPathNavigation((Mob)this, this.m_9236_());
            this.setWalker(false);
            this.isLandNavigatorType = false;
        }
        if (!this.m_20069_() && rain && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.setWalker(true);
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && rain && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n = 0; n < 18; ++n) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
    }

    private static class FishMoveControl
    extends MoveControl {
        private final AbstractFish fish;

        FishMoveControl(AbstractFish p_27501_) {
            super((Mob)p_27501_);
            this.fish = p_27501_;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13131_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float $$0 = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)$$0));
                double $$1 = this.f_24975_ - this.fish.m_20185_();
                double $$2 = this.f_24976_ - this.fish.m_20186_();
                double $$3 = this.f_24977_ - this.fish.m_20189_();
                if ($$2 != 0.0) {
                    double $$4 = Math.sqrt($$1 * $$1 + $$2 * $$2 + $$3 * $$3);
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * ($$2 / $$4) * 0.1, 0.0));
                }
                if ($$1 != 0.0 || $$3 != 0.0) {
                    float $$5 = (float)(Mth.m_14136_((double)$$3, (double)$$1) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), $$5, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }
}

