/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.google.common.annotations.VisibleForTesting;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;

public class HarmoniousSlimeEntity
extends Animal
implements NeutralMob,
JerotesEntity {
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(HarmoniousSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;
    public int eat;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public HarmoniousSlimeEntity(EntityType<? extends HarmoniousSlimeEntity> entityType, Level level) {
        super(entityType, level);
        this.m_252801_();
        this.f_21342_ = new SlimeMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SlimeFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 0.9, Ingredient.m_204132_((TagKey)ItemTags.f_13149_), false));
        this.f_21345_.m_25352_(5, (Goal)new SlimeKeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, true));
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ID_SIZE, (Object)1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 4.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        return builder;
    }

    public boolean m_6162_() {
        return false;
    }

    @VisibleForTesting
    public void setSize(int n, boolean bl) {
        int n2 = Mth.m_14045_((int)n, (int)1, (int)127);
        this.f_19804_.m_135381_(ID_SIZE, (Object)n2);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(n2 * n2));
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.2f + 0.1f * (float)n2));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)n2);
        if (bl) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = 0;
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Size", this.getSize() - 1);
        compoundTag.m_128379_("wasOnGround", this.wasOnGround);
        compoundTag.m_128405_("Eat", this.eat);
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.setSize(compoundTag.m_128451_("Size") + 1, false);
        super.m_7378_(compoundTag);
        this.wasOnGround = compoundTag.m_128471_("wasOnGround");
        this.eat = compoundTag.m_128451_("Eat");
    }

    public boolean isTiny() {
        return this.getSize() <= 1;
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_276452_;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(2.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
    }

    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.m_8119_();
        if (this.m_20096_() && !this.wasOnGround) {
            int n = this.getSize();
            for (int i = 0; i < n * 8; ++i) {
                float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f2 = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                float f3 = Mth.m_14031_((float)f) * (float)n * 0.5f * f2;
                float f4 = Mth.m_14089_((float)f) * (float)n * 0.5f * f2;
                this.m_9236_().m_7106_(this.getParticleType(), this.m_20185_() + (double)f3, this.m_20186_(), this.m_20189_() + (double)f4, 0.0, 0.0, 0.0);
            }
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.targetSquish = -0.5f;
        } else if (!this.m_20096_() && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.m_20096_();
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double d2 = this.m_20186_();
        double d3 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, d2, d3);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ID_SIZE.equals(entityDataAccessor)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.f_19796_.m_188503_(20) == 1) {
                this.m_5841_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public EntityType<? extends HarmoniousSlimeEntity> m_6095_() {
        return super.m_6095_();
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        int n = this.getSize();
        if (!this.m_9236_().f_46443_ && n > 1 && this.m_21224_()) {
            Component component = this.m_7770_();
            boolean bl = this.m_21525_();
            float f = (float)n / 4.0f;
            int n2 = n / 2;
            int n3 = 2 + this.f_19796_.m_188503_(3);
            for (int i = 0; i < n3; ++i) {
                Level level;
                float f2 = ((float)(i % 2) - 0.5f) * f;
                float f3 = ((float)(i / 2) - 0.5f) * f;
                HarmoniousSlimeEntity slime = (HarmoniousSlimeEntity)this.m_6095_().m_20615_(this.m_9236_());
                if (slime == null) continue;
                if (this.m_21532_()) {
                    slime.m_21530_();
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    PlayerTeam teams = this.m_5647_();
                    if (teams != null) {
                        serverLevel.m_6188_().m_6546_(slime.m_20149_(), teams);
                    }
                    if (this.m_5448_() != null) {
                        slime.m_6710_(this.m_5448_());
                    }
                }
                slime.m_6593_(component);
                slime.m_21557_(bl);
                slime.m_20331_(this.m_20147_());
                slime.setSize(n2, true);
                slime.m_7678_(this.m_20185_() + (double)f2, this.m_20186_() + 0.5, this.m_20189_() + (double)f3, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)slime);
            }
        }
        super.m_142687_(removalReason);
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (entity == this.m_5448_() && this.isDealsDamage()) {
            this.dealDamage((LivingEntity)entity);
        }
    }

    protected void dealDamage(LivingEntity livingEntity) {
        if (this.m_6084_()) {
            int n = this.getSize();
            if (this.m_20280_((Entity)livingEntity) < 0.6 * (double)n * (0.6 * (double)n) && this.m_142582_((Entity)livingEntity)) {
                AttackFind.attackBegin((LivingEntity)this, (Entity)livingEntity);
                boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)livingEntity, (float)1.0f, (float)0.0f, (boolean)false, (float)0.0f);
                if (bl) {
                    this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
            }
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.625f * entityDimensions.f_20378_;
    }

    protected boolean isDealsDamage() {
        return !this.isTiny() && this.m_21515_();
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.isTiny()) {
            return SoundEvents.f_12468_;
        }
        return SoundEvents.f_12386_;
    }

    protected SoundEvent m_5592_() {
        if (this.isTiny()) {
            return SoundEvents.f_12467_;
        }
        return SoundEvents.f_12385_;
    }

    protected SoundEvent getSquishSound() {
        if (this.isTiny()) {
            return SoundEvents.f_12470_;
        }
        return SoundEvents.f_12388_;
    }

    protected float m_6121_() {
        return 0.4f * (float)this.getSize();
    }

    public int m_8132_() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return this.getSize() > 0;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        int n = randomSource.m_188503_(3);
        if (n < 2 && randomSource.m_188501_() < 0.5f * difficultyInstance.m_19057_()) {
            ++n;
        }
        int n2 = 1 << n;
        this.setSize(n2, true);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
    }

    protected SoundEvent getJumpSound() {
        return this.isTiny() ? SoundEvents.f_12469_ : SoundEvents.f_12387_;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(0.255f * (float)this.getSize());
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)JerotesVillageEntityType.HARMONIOUS_SLIME.get()).m_20615_((Level)serverLevel);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_204117_(ItemTags.f_13149_)) {
            player.m_5496_(SoundEvents.f_12392_, 1.0f, 1.0f);
            ItemStack itemStack2 = new ItemStack((ItemLike)JerotesVillageItems.PINK_SLIME_BALL.get(), 1);
            if (!player.m_150109_().m_36054_(itemStack2)) {
                player.m_36176_(itemStack2, false);
            }
            this.m_5634_(3.0f);
            float f = (float)this.m_20186_();
            Vec3 vec3 = this.m_20184_();
            for (int i = 0; i < 10; ++i) {
                float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                float f3 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)f2, (double)(f + 2.0f), this.m_20189_() + (double)f3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6898_(itemStack)) {
            ++this.eat;
            if (this.getSize() * this.getSize() * this.getSize() <= this.eat) {
                this.eat = 0;
                this.setSize(this.getSize() + 1, true);
            }
            player.m_5496_(SoundEvents.f_12392_, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:slimeballs")));
    }

    static class SlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final HarmoniousSlimeEntity slime;
        private boolean isAggressive;

        public SlimeMoveControl(HarmoniousSlimeEntity slime) {
            super((Mob)slime);
            this.slime = slime;
            this.yRot = 180.0f * slime.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float f, boolean bl) {
            this.yRot = f;
            this.isAggressive = bl;
        }

        public void setWantedMovement(double d) {
            this.f_24978_ = d;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
                return;
            }
            this.f_24981_ = MoveControl.Operation.WAIT;
            if (this.f_24974_.m_20096_()) {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.slime.getJumpDelay();
                    if (this.isAggressive) {
                        this.jumpDelay /= 3;
                    }
                    this.slime.m_21569_().m_24901_();
                    if (this.slime.doPlayJumpSound()) {
                        this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), this.slime.getSoundPitch());
                    }
                } else {
                    this.slime.f_20900_ = 0.0f;
                    this.slime.f_20902_ = 0.0f;
                    this.f_24974_.m_7910_(0.0f);
                }
            } else {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            }
        }
    }

    static class SlimeFloatGoal
    extends Goal {
        private final HarmoniousSlimeEntity slime;

        public SlimeFloatGoal(HarmoniousSlimeEntity slime) {
            this.slime = slime;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slime.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl moveControl;
            if (this.slime.m_217043_().m_188501_() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            if ((moveControl = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)moveControl;
                slimeMoveControl.setWantedMovement(1.2);
            }
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final HarmoniousSlimeEntity slime;
        private int growTiredTimer;

        public SlimeAttackGoal(HarmoniousSlimeEntity slime) {
            this.slime = slime;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.slime.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingEntity) || !this.slime.m_6549_(livingEntity.m_6095_())) {
                return false;
            }
            return this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = SlimeAttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.slime.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingEntity) || !this.slime.m_6549_(livingEntity.m_6095_())) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl moveControl;
            LivingEntity livingEntity = this.slime.m_5448_();
            if (livingEntity != null) {
                this.slime.m_21391_((Entity)livingEntity, 10.0f, 10.0f);
            }
            if ((moveControl = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)moveControl;
                slimeMoveControl.setDirection(this.slime.m_146908_(), this.slime.isDealsDamage());
            }
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final HarmoniousSlimeEntity slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(HarmoniousSlimeEntity slime) {
            this.slime = slime;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.m_20096_() || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8037_() {
            MoveControl moveControl;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.slime.m_217043_().m_188503_(60));
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            if ((moveControl = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)moveControl;
                slimeMoveControl.setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final HarmoniousSlimeEntity slime;

        public SlimeKeepOnJumpingGoal(HarmoniousSlimeEntity slime) {
            this.slime = slime;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            MoveControl moveControl = this.slime.m_21566_();
            if (moveControl instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)moveControl;
                slimeMoveControl.setWantedMovement(1.0);
            }
        }
    }
}

