/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ChangePoseAbout;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.TameMobEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesChangeFollowMobOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeFollowOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeHelpMobOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeOwnerHurtByTargetGoal;
import com.jerotes.jerotes.goal.JerotesChangeOwnerHurtTargetGoal;
import com.jerotes.jerotes.goal.JerotesChangeSitWhenOrderedToGoal;
import com.jerotes.jerotes.goal.JerotesFollowParentGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesTameMobNonTameRandomTargetGoal;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.entity.Animal.RuinsMouseEntity;
import com.jerotes.jerotesvillage.entity.in.HasHomePosEntity;
import com.jerotes.jerotesvillage.goal.BaseTamableAnimalGoHomeGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageBiomes;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.StrollThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.ForgeEventFactory;

public class RustleFoxEntity
extends Fox
implements JerotesEntity,
TameMobEntity,
OwnableEntity,
ChangePoseAbout,
HasHomePosEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState jumpAnimationState = new AnimationState();
    public AnimationState wantAttackAnimationState = new AnimationState();
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> IS_WANDER = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FOX_TYPE = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = p_309166_ -> !p_309166_.m_32063_() && p_309166_.m_6084_();
    public static final Predicate<LivingEntity> PREY_SELECTOR = entity -> entity instanceof Chicken || entity instanceof Rabbit || entity instanceof RuinsMouseEntity;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID_OTHER = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID_ID = SynchedEntityData.m_135353_(RustleFoxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private boolean orderedToSit;
    float crouchAmount;
    float crouchAmountO;
    private int crouchTick;
    private int sitTick = 0;

    public RustleFoxEntity(EntityType<? extends Fox> entityType, Level level) {
        super(entityType, level);
        this.reassessTameGoals();
        this.m_21530_();
    }

    public static AttributeSupplier.Builder m_28553_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 14.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FoxFloatGoal());
        this.f_21345_.m_25352_(0, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(1, (Goal)new FaceplantGoal());
        this.f_21345_.m_25352_(2, (Goal)new FoxPanicGoal(2.2));
        this.f_21345_.m_25352_(3, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.6, 1.4, wolf -> !((Wolf)wolf).m_21824_() && !this.m_28567_() && this.m_5448_() != wolf));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 8.0f, 1.6, 1.4, bear -> !this.m_28567_() && this.m_5448_() != bear));
        this.f_21345_.m_25352_(5, (Goal)new StalkPreyGoal());
        this.f_21345_.m_25352_(6, (Goal)new FoxPounceGoal());
        this.f_21345_.m_25352_(6, (Goal)new SeekShelterGoal(1.25));
        this.f_21345_.m_25352_(7, (Goal)new FoxMeleeAttackGoal(1.2, true));
        this.f_21345_.m_25352_(7, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(8, (Goal)new FoxFollowParentGoal(this, 1.25){

            @Override
            public boolean m_8036_() {
                if (RustleFoxEntity.this.isWander()) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                if (RustleFoxEntity.this.isWander()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(9, (Goal)new FoxStrollThroughVillageGoal(32, 200));
        this.f_21345_.m_25352_(10, (Goal)new FoxEatBerriesGoal(1.2, 12, 1));
        this.f_21345_.m_25352_(10, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new FoxSearchForItemsGoal());
        this.f_21345_.m_25352_(12, (Goal)new FoxLookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.f_21345_.m_25352_(13, (Goal)new PerchAndSearchGoal());
        this.f_21345_.m_25352_(1, (Goal)new JerotesChangeSitWhenOrderedToGoal((ChangePoseAbout)this));
        this.f_21345_.m_25352_(3, (Goal)new BaseTamableAnimalGoHomeGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new JerotesChangeFollowOwnerGoal((ChangePoseAbout)this, 1.3, 5.0f, 1.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new JerotesChangeFollowMobOwnerGoal((ChangePoseAbout)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new JerotesChangeHelpMobOwnerGoal((ChangePoseAbout)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesChangeOwnerHurtByTargetGoal((ChangePoseAbout)this));
        this.f_21346_.m_25352_(2, (Goal)new JerotesChangeOwnerHurtTargetGoal((ChangePoseAbout)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new JerotesTameMobNonTameRandomTargetGoal((TameMobEntity)this, Animal.class, false, PREY_SELECTOR));
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        if (randomSource.m_188501_() < 0.2f) {
            float f = randomSource.m_188501_();
            ItemStack itemStack = f < 0.05f ? new ItemStack((ItemLike)JerotesVillageItems.MEROR_TOKEN_M.get()) : (f < 0.2f ? new ItemStack((ItemLike)JerotesVillageItems.IRISHTAIL_CHICKEN_EGG.get()) : (f < 0.4f ? (randomSource.m_188499_() ? new ItemStack((ItemLike)Items.f_42648_) : new ItemStack((ItemLike)Items.f_42649_)) : (f < 0.6f ? new ItemStack((ItemLike)Items.f_42405_) : (f < 0.8f ? new ItemStack((ItemLike)Items.f_42454_) : new ItemStack((ItemLike)Items.f_42402_)))));
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
        }
    }

    protected void reassessTameGoals() {
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
    }

    public int getFoxType() {
        return (Integer)this.m_20088_().m_135370_(FOX_TYPE);
    }

    public void setFoxType(int n) {
        this.m_20088_().m_135381_(FOX_TYPE, (Object)n);
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0 || this.m_28555_();
    }

    public boolean isOwnedBy(LivingEntity livingEntity) {
        return livingEntity == this.m_269323_();
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID_ID)).orElse(null);
    }

    public void setTame(boolean bl) {
        byte bl1 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 | 4)));
            this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 & 0xFFFFFFFB)));
            this.m_21051_(Attributes.f_22281_).m_22100_(3.0);
        }
        this.reassessTameGoals();
    }

    public PlayerTeam m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.m_269323_()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public void setOrderedToSit(boolean bl) {
        this.orderedToSit = bl;
    }

    public void setInSittingPose(boolean bl) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void setHomePos(BlockPos blockPos) {
        this.f_19804_.m_135381_(HOME_POS, (Object)blockPos);
    }

    @Override
    public BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    @Override
    public boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    @Override
    public void setGoingHome(boolean bl) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)bl);
    }

    @Nullable
    public LivingEntity m_269323_() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : RustleFoxEntity.getLivingEntityByUUID(this.m_9236_(), uuid);
        }
        int id = this.getOwnerId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getOwnerId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerId(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public static LivingEntity getLivingEntityByUUID(Level level, UUID uuid) {
        return RustleFoxEntity.getLivingEntityByUUID(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUUID(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public boolean isWander() {
        return (Boolean)this.m_20088_().m_135370_(IS_WANDER);
    }

    public void setWander(boolean bl) {
        this.m_20088_().m_135381_(IS_WANDER, (Object)bl);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsWander", this.isWander());
        compoundTag.m_128379_("IsGoingHome", this.isGoingHome());
        compoundTag.m_128405_("HomePosX", this.getHomePos().m_123341_());
        compoundTag.m_128405_("HomePosY", this.getHomePos().m_123342_());
        compoundTag.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        if (this.m_21805_() != null) {
            compoundTag.m_128362_("Owner", this.m_21805_());
        }
        compoundTag.m_128379_("Sitting", this.orderedToSit);
        compoundTag.m_128405_("FoxType", this.getFoxType());
        compoundTag.m_128405_("crouchTick", this.crouchTick);
        compoundTag.m_128405_("SitTick", this.sitTick);
    }

    public void m_7378_(CompoundTag compoundTag) {
        UUID uuid;
        super.m_7378_(compoundTag);
        this.setWander(compoundTag.m_128471_("IsWander"));
        this.setGoingHome(compoundTag.m_128471_("IsGoingHome"));
        int n = compoundTag.m_128451_("HomePosX");
        int n2 = compoundTag.m_128451_("HomePosY");
        int n3 = compoundTag.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(n, n2, n3));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String string = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
        this.orderedToSit = compoundTag.m_128471_("Sitting");
        this.setFoxType(compoundTag.m_128451_("FoxType"));
        this.crouchTick = compoundTag.m_128451_("CrouchTick");
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.setInSittingPose(this.orderedToSit);
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.getChangeType() != 3;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_WANDER, (Object)false);
        this.m_20088_().m_135372_(DATA_OWNER_ID, (Object)-1);
        this.m_20088_().m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.m_20088_().m_135372_(GOING_HOME, (Object)false);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_FLAGS_ID_OTHER, (Object)0);
        this.m_20088_().m_135372_(DATA_OWNER_UUID_ID, Optional.empty());
        this.m_20088_().m_135372_(FOX_TYPE, (Object)1);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Nullable
    public RustleFoxEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        RustleFoxEntity fox = (RustleFoxEntity)((EntityType)JerotesVillageEntityType.RUSTLE_FOX.get()).m_20615_((Level)serverLevel);
        if (fox != null && (uUID = this.m_21805_()) != null) {
            fox.setOwnerUUID(uUID);
            fox.setTame(true);
            if (ageableMob instanceof RustleFoxEntity) {
                RustleFoxEntity fox2 = (RustleFoxEntity)ageableMob;
                if (this.f_19796_.m_188499_()) {
                    fox.setFoxType(this.getFoxType());
                } else {
                    fox.setFoxType(fox2.getFoxType());
                }
            } else {
                fox.setFoxType(this.getFoxType());
            }
        } else if (fox != null) {
            if (ageableMob instanceof RustleFoxEntity) {
                RustleFoxEntity fox2 = (RustleFoxEntity)ageableMob;
                if (this.f_19796_.m_188499_()) {
                    fox.setFoxType(this.getFoxType());
                } else {
                    fox.setFoxType(fox2.getFoxType());
                }
            } else {
                fox.setFoxType(this.getFoxType());
            }
        }
        return fox;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_269323_() != null && this.getOwnerId() == -1) {
            this.setOwnerId(this.m_269323_().m_19879_());
        }
        if (this.isWander() && this.isInSittingPose() && !this.m_9236_().f_46443_) {
            this.setInSittingPose(false);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (!this.isInSittingPose()) {
            this.sitAnimationState.m_216973_();
        }
        if (this.isInSittingPose() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.isInSittingPose() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if (this.crouchTick > 0) {
            --this.crouchTick;
        }
        if (this.m_5803_()) {
            this.sleepAnimationState.m_216977_(this.f_19797_);
        } else {
            this.sleepAnimationState.m_216973_();
        }
        if (this.m_28557_() || this.m_28556_()) {
            this.jumpAnimationState.m_216977_(this.f_19797_);
        } else {
            this.jumpAnimationState.m_216973_();
            if (this.m_6047_()) {
                if (this.crouchTick <= 0 && this.f_20919_ == 0) {
                    this.wantAttackAnimationState.m_216977_(this.f_19797_);
                    this.crouchTick = 40;
                }
            } else {
                this.wantAttackAnimationState.m_216973_();
            }
        }
        if (this.isTame() && this.m_28555_()) {
            this.m_28610_(false);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.crouchAmountO = this.crouchAmount;
        if (this.m_6047_()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
    }

    public boolean m_28558_() {
        return this.crouchAmount == 3.0f;
    }

    public float m_28624_(float p_28625_) {
        return Mth.m_14179_((float)p_28625_, (float)this.crouchAmountO, (float)this.crouchAmount);
    }

    public boolean m_7327_(Entity entity) {
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(10);
            this.setAnimationState("attack");
        }
        return super.m_7327_(entity);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        boolean bl = super.m_6469_(damageSource, amount);
        if (bl && !this.m_9236_().m_5776_() && this.getChangeType() == 1) {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setChangeType(2, player);
            } else {
                this.setChangeType(2);
            }
        }
        return bl;
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.isOwnedBy((LivingEntity)player) || this.isTame() || this.m_6898_(itemStack) && !this.isTame();
            boolean bl3 = bl2 = this.isTame() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.isTame()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(5.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.isOwnedBy((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack)) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(6) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.tame(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    public int getChangeType() {
        return (this.isOrderedToSit() ? 1 : 2) + (this.isWander() ? 2 : 0);
    }

    public void setChangeType(int n) {
        n = Mth.m_14045_((int)n, (int)1, (int)4);
        switch (n) {
            case 1: {
                this.setOrderedToSit(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 2: {
                this.setOrderedToSit(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 3: {
                this.setOrderedToSit(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                    this.setHomePos(this.m_20183_());
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 4: {
                this.setOrderedToSit(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
        }
    }

    public void setChangeType(int n, Player player) {
        this.setChangeType(n);
        if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_213846_((Component)Component.m_237110_((String)("talk.jerotes.pose_" + n), (Object[])new Object[]{this.m_5446_()}).m_130940_(ChatFormatting.WHITE));
        }
    }

    protected void spawnTamingParticles(boolean bl) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!bl) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected void spawnHealParticles() {
        SimpleParticleType particleoptions = ParticleTypes.f_123748_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_7822_(byte by) {
        if (by == 7) {
            this.spawnTamingParticles(true);
        } else if (by == 6) {
            this.spawnTamingParticles(false);
        } else if (by == 11) {
            this.spawnHealParticles();
        } else {
            super.m_7822_(by);
        }
    }

    public boolean m_7307_(Entity entity) {
        if (this.isTame()) {
            LivingEntity livingentity = this.m_269323_();
            if (entity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        return !this.isOwnedBy(livingEntity) && super.m_6779_(livingEntity);
    }

    public boolean wantsToAttack(LivingEntity livingEntity, LivingEntity livingEntity2) {
        return AttackFind.wantsToAttack((Mob)this, (LivingEntity)livingEntity, (LivingEntity)livingEntity2);
    }

    public void m_6667_(DamageSource damageSource) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(damageSource);
        if (this.f_20890_ && !this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(deathMessage);
        }
    }

    boolean m_28570_() {
        return !this.m_5803_() && !this.m_28555_() && !this.m_28556_();
    }

    void m_28569_() {
        this.m_28616_(false);
        this.m_28614_(false);
        this.m_28610_(false);
        this.m_28626_(false);
        this.m_28622_(false);
        this.m_28618_(false);
    }

    void m_28626_(boolean p_28627_) {
        this.m_28532_(32, p_28627_);
    }

    void m_28622_(boolean p_28623_) {
        this.m_28532_(128, p_28623_);
    }

    void m_28618_(boolean p_28619_) {
        this.m_28532_(64, p_28619_);
    }

    private void m_28532_(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID_OTHER, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID_OTHER) | p_28533_)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID_OTHER, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID_OTHER) & ~p_28533_)));
        }
    }

    boolean m_28567_() {
        return this.m_28608_(128);
    }

    private boolean m_28608_(int p_28609_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID_OTHER) & p_28609_) != 0;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setHomePos(this.m_20183_());
        if (mobSpawnType != MobSpawnType.CONVERSION && mobSpawnType != MobSpawnType.BREEDING) {
            if (serverLevelAccessor.m_204166_(this.m_20183_()).m_203565_(JerotesVillageBiomes.DAMAGED_RUINS)) {
                this.setFoxType(2);
            } else if (serverLevelAccessor.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_263748_)) {
                this.setFoxType(3);
            } else if (serverLevelAccessor.m_204166_(this.m_20183_()).m_203565_(JerotesVillageBiomes.WILDERNESS_WOODLAND)) {
                this.setFoxType(1);
            } else {
                float f = serverLevelAccessor.m_213780_().m_188501_();
                if (f < 0.75f) {
                    this.setFoxType(1);
                } else if (f < 0.9f) {
                    this.setFoxType(2);
                } else {
                    this.setFoxType(3);
                }
            }
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    class FoxFloatGoal
    extends FloatGoal {
        public FoxFloatGoal() {
            super((Mob)RustleFoxEntity.this);
        }

        public void m_8056_() {
            super.m_8056_();
            RustleFoxEntity.this.m_28569_();
        }

        public boolean m_8036_() {
            return RustleFoxEntity.this.m_20069_() && RustleFoxEntity.this.m_204036_(FluidTags.f_13131_) > 0.25 || RustleFoxEntity.this.m_20077_();
        }
    }

    class FaceplantGoal
    extends Goal {
        int countdown;

        public FaceplantGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RustleFoxEntity.this.m_28556_();
        }

        public boolean m_8045_() {
            return this.m_8036_() && this.countdown > 0;
        }

        public void m_8056_() {
            this.countdown = this.m_183277_(40);
        }

        public void m_8041_() {
            RustleFoxEntity.this.m_28618_(false);
        }

        public void m_8037_() {
            --this.countdown;
        }
    }

    class FoxPanicGoal
    extends PanicGoal {
        public FoxPanicGoal(double p_28734_) {
            super((PathfinderMob)RustleFoxEntity.this, p_28734_);
        }

        public boolean m_202729_() {
            return !RustleFoxEntity.this.m_28567_() && super.m_202729_() && !RustleFoxEntity.this.isTame();
        }
    }

    class StalkPreyGoal
    extends Goal {
        public StalkPreyGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            Mob mob;
            if (RustleFoxEntity.this.m_5803_()) {
                return false;
            }
            LivingEntity livingentity = RustleFoxEntity.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && (PREY_SELECTOR.test(livingentity) || livingentity instanceof Mob && (mob = (Mob)livingentity).m_5448_() != RustleFoxEntity.this) && RustleFoxEntity.this.m_20280_((Entity)livingentity) > 36.0 && !RustleFoxEntity.this.m_6047_() && !RustleFoxEntity.this.m_28559_() && !RustleFoxEntity.this.f_20899_;
        }

        public void m_8056_() {
            RustleFoxEntity.this.m_28610_(false);
            RustleFoxEntity.this.m_28618_(false);
        }

        public void m_8041_() {
            LivingEntity livingentity = RustleFoxEntity.this.m_5448_();
            if (livingentity != null && Fox.m_28471_((Fox)RustleFoxEntity.this, (LivingEntity)livingentity)) {
                RustleFoxEntity.this.m_28616_(true);
                RustleFoxEntity.this.m_28614_(true);
                RustleFoxEntity.this.m_21573_().m_26573_();
                RustleFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, (float)RustleFoxEntity.this.m_8085_(), (float)RustleFoxEntity.this.m_8132_());
            } else {
                RustleFoxEntity.this.m_28616_(false);
                RustleFoxEntity.this.m_28614_(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = RustleFoxEntity.this.m_5448_();
            if (livingentity != null) {
                RustleFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, (float)RustleFoxEntity.this.m_8085_(), (float)RustleFoxEntity.this.m_8132_());
                if (RustleFoxEntity.this.m_20280_((Entity)livingentity) <= 36.0) {
                    RustleFoxEntity.this.m_28616_(true);
                    RustleFoxEntity.this.m_28614_(true);
                    RustleFoxEntity.this.m_21573_().m_26573_();
                } else {
                    RustleFoxEntity.this.m_21573_().m_5624_((Entity)livingentity, 1.5);
                }
            }
        }
    }

    public class FoxPounceGoal
    extends JumpGoal {
        public boolean m_8036_() {
            if (!RustleFoxEntity.this.m_28558_()) {
                return false;
            }
            LivingEntity livingentity = RustleFoxEntity.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (livingentity.m_6374_() != livingentity.m_6350_()) {
                    return false;
                }
                boolean flag = Fox.m_28471_((Fox)RustleFoxEntity.this, (LivingEntity)livingentity);
                if (!flag) {
                    RustleFoxEntity.this.m_21573_().m_6570_((Entity)livingentity, 0);
                    RustleFoxEntity.this.m_28614_(false);
                    RustleFoxEntity.this.m_28616_(false);
                }
                return flag;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = RustleFoxEntity.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = RustleFoxEntity.this.m_20184_().f_82480_;
                return !(d0 * d0 < (double)0.05f && Math.abs(RustleFoxEntity.this.m_146909_()) < 15.0f && RustleFoxEntity.this.m_20096_() || RustleFoxEntity.this.m_28556_());
            }
            return false;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            RustleFoxEntity.this.m_6862_(true);
            RustleFoxEntity.this.m_28612_(true);
            RustleFoxEntity.this.m_28616_(false);
            LivingEntity livingentity = RustleFoxEntity.this.m_5448_();
            if (livingentity != null) {
                RustleFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
                Vec3 vec3 = new Vec3(livingentity.m_20185_() - RustleFoxEntity.this.m_20185_(), livingentity.m_20186_() - RustleFoxEntity.this.m_20186_(), livingentity.m_20189_() - RustleFoxEntity.this.m_20189_()).m_82541_();
                RustleFoxEntity.this.m_20256_(RustleFoxEntity.this.m_20184_().m_82520_(vec3.f_82479_ * 0.8, 0.9, vec3.f_82481_ * 0.8));
            }
            RustleFoxEntity.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            RustleFoxEntity.this.m_28614_(false);
            RustleFoxEntity.this.crouchAmount = 0.0f;
            RustleFoxEntity.this.crouchAmountO = 0.0f;
            RustleFoxEntity.this.m_28616_(false);
            RustleFoxEntity.this.m_28612_(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = RustleFoxEntity.this.m_5448_();
            if (livingentity != null) {
                RustleFoxEntity.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
            }
            if (!RustleFoxEntity.this.m_28556_()) {
                Vec3 vec3 = RustleFoxEntity.this.m_20184_();
                if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && RustleFoxEntity.this.m_146909_() != 0.0f) {
                    RustleFoxEntity.this.m_146926_(Mth.m_14189_((float)0.2f, (float)RustleFoxEntity.this.m_146909_(), (float)0.0f));
                } else {
                    double d0 = vec3.m_165924_();
                    double d1 = Math.signum(-vec3.f_82480_) * Math.acos(d0 / vec3.m_82553_()) * 57.2957763671875;
                    RustleFoxEntity.this.m_146926_((float)d1);
                }
            }
            if (livingentity != null && RustleFoxEntity.this.m_20270_((Entity)livingentity) <= 2.0f) {
                RustleFoxEntity.this.m_7327_((Entity)livingentity);
            } else if (RustleFoxEntity.this.m_146909_() > 0.0f && RustleFoxEntity.this.m_20096_() && (float)RustleFoxEntity.this.m_20184_().f_82480_ != 0.0f && RustleFoxEntity.this.m_9236_().m_8055_(RustleFoxEntity.this.m_20183_()).m_60713_(Blocks.f_50125_)) {
                RustleFoxEntity.this.m_146926_(60.0f);
                RustleFoxEntity.this.m_6710_(null);
                RustleFoxEntity.this.m_28618_(true);
            }
        }
    }

    class SeekShelterGoal
    extends FleeSunGoal {
        private int interval;

        public SeekShelterGoal(double p_28777_) {
            super((PathfinderMob)RustleFoxEntity.this, p_28777_);
            this.interval = SeekShelterGoal.m_186073_((int)100);
        }

        public boolean m_8036_() {
            if (!RustleFoxEntity.this.m_5803_() && this.f_25214_.m_5448_() == null) {
                if (RustleFoxEntity.this.m_9236_().m_46470_() && RustleFoxEntity.this.m_9236_().m_45527_(this.f_25214_.m_20183_())) {
                    return this.m_25226_();
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPos blockpos = this.f_25214_.m_20183_();
                return RustleFoxEntity.this.m_9236_().m_46461_() && RustleFoxEntity.this.m_9236_().m_45527_(blockpos) && !((ServerLevel)RustleFoxEntity.this.m_9236_()).m_8802_(blockpos) && this.m_25226_();
            }
            return false;
        }

        public void m_8056_() {
            RustleFoxEntity.this.m_28569_();
            super.m_8056_();
        }
    }

    class FoxMeleeAttackGoal
    extends JerotesMeleeAttackGoal {
        public FoxMeleeAttackGoal(double p_28720_, boolean p_28721_) {
            super((PathfinderMob)RustleFoxEntity.this, p_28720_, p_28721_);
        }

        protected void checkAndPerformAttack(LivingEntity p_28724_) {
            if (this.canPerformAttack(p_28724_)) {
                this.resetAttackCooldown();
                this.mob.m_7327_((Entity)p_28724_);
                RustleFoxEntity.this.m_5496_(SoundEvents.f_11945_, 1.0f, 1.0f);
            }
        }

        public void m_8056_() {
            RustleFoxEntity.this.m_28616_(false);
            super.m_8056_();
        }

        public boolean m_8036_() {
            return !RustleFoxEntity.this.m_28555_() && !RustleFoxEntity.this.m_5803_() && !RustleFoxEntity.this.m_6047_() && !RustleFoxEntity.this.m_28556_() && super.m_8036_();
        }
    }

    class SleepGoal
    extends FoxBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = RustleFoxEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (RustleFoxEntity.this.isTame()) {
                return false;
            }
            if (RustleFoxEntity.this.f_20900_ == 0.0f && RustleFoxEntity.this.f_20901_ == 0.0f && RustleFoxEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || RustleFoxEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            if (RustleFoxEntity.this.isTame()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (RustleFoxEntity.this.isTame()) {
                return false;
            }
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return RustleFoxEntity.this.m_9236_().m_46461_() && this.hasShelter() && !this.alertable() && !RustleFoxEntity.this.f_146808_;
        }

        public void m_8041_() {
            this.countdown = RustleFoxEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            RustleFoxEntity.this.m_28569_();
        }

        public void m_8056_() {
            RustleFoxEntity.this.m_28610_(false);
            RustleFoxEntity.this.m_28614_(false);
            RustleFoxEntity.this.m_28616_(false);
            RustleFoxEntity.this.m_6862_(false);
            RustleFoxEntity.this.m_28626_(true);
            RustleFoxEntity.this.m_21573_().m_26573_();
            RustleFoxEntity.this.m_21566_().m_6849_(RustleFoxEntity.this.m_20185_(), RustleFoxEntity.this.m_20186_(), RustleFoxEntity.this.m_20189_(), 0.0);
        }
    }

    class FoxStrollThroughVillageGoal
    extends StrollThroughVillageGoal {
        public FoxStrollThroughVillageGoal(int p_28754_, int p_28755_) {
            super((PathfinderMob)RustleFoxEntity.this, p_28755_);
        }

        public void m_8056_() {
            RustleFoxEntity.this.m_28569_();
            super.m_8056_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.canFoxMove();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !RustleFoxEntity.this.m_5803_() && !RustleFoxEntity.this.m_28555_() && !RustleFoxEntity.this.m_28567_() && RustleFoxEntity.this.m_5448_() == null;
        }
    }

    public class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public FoxEatBerriesGoal(double p_28675_, int p_28676_, int p_28677_) {
            super((PathfinderMob)RustleFoxEntity.this, p_28675_, p_28676_, p_28677_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader p_28680_, BlockPos p_28681_) {
            BlockState blockstate = p_28680_.m_8055_(p_28681_);
            return blockstate.m_60713_(Blocks.f_50685_) && (Integer)blockstate.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 2 || CaveVines.m_152951_((BlockState)blockstate);
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.m_25625_() && RustleFoxEntity.this.f_19796_.m_188501_() < 0.05f) {
                RustleFoxEntity.this.m_5496_(SoundEvents.f_11951_, 1.0f, 1.0f);
            }
            super.m_8037_();
        }

        protected void onReachedTarget() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)RustleFoxEntity.this.m_9236_(), (Entity)RustleFoxEntity.this)) {
                BlockState blockstate = RustleFoxEntity.this.m_9236_().m_8055_(this.f_25602_);
                if (blockstate.m_60713_(Blocks.f_50685_)) {
                    this.pickSweetBerries(blockstate);
                } else if (CaveVines.m_152951_((BlockState)blockstate)) {
                    this.pickGlowBerry(blockstate);
                }
            }
        }

        private void pickGlowBerry(BlockState p_148927_) {
            CaveVines.m_269473_((Entity)RustleFoxEntity.this, (BlockState)p_148927_, (Level)RustleFoxEntity.this.m_9236_(), (BlockPos)this.f_25602_);
        }

        private void pickSweetBerries(BlockState p_148929_) {
            int i = (Integer)p_148929_.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));
            int j = 1 + RustleFoxEntity.this.m_9236_().f_46441_.m_188503_(2) + (i == 3 ? 1 : 0);
            ItemStack itemstack = RustleFoxEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_()) {
                RustleFoxEntity.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42780_));
                --j;
            }
            if (j > 0) {
                Block.m_49840_((Level)RustleFoxEntity.this.m_9236_(), (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, j));
            }
            RustleFoxEntity.this.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
            RustleFoxEntity.this.m_9236_().m_7731_(this.f_25602_, (BlockState)p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
            RustleFoxEntity.this.m_9236_().m_220407_(GameEvent.f_157792_, this.f_25602_, GameEvent.Context.m_223717_((Entity)RustleFoxEntity.this));
        }

        public boolean m_8036_() {
            return !RustleFoxEntity.this.m_5803_() && super.m_8036_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            RustleFoxEntity.this.m_28610_(false);
            super.m_8056_();
        }
    }

    class FoxSearchForItemsGoal
    extends Goal {
        public FoxSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!RustleFoxEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (RustleFoxEntity.this.m_5448_() == null && RustleFoxEntity.this.m_21188_() == null) {
                if (!RustleFoxEntity.this.m_28570_()) {
                    return false;
                }
                if (RustleFoxEntity.this.m_217043_().m_188503_(FoxSearchForItemsGoal.m_186073_((int)10)) != 0) {
                    return false;
                }
                List list = RustleFoxEntity.this.m_9236_().m_6443_(ItemEntity.class, RustleFoxEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && RustleFoxEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = RustleFoxEntity.this.m_9236_().m_6443_(ItemEntity.class, RustleFoxEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = RustleFoxEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                RustleFoxEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = RustleFoxEntity.this.m_9236_().m_6443_(ItemEntity.class, RustleFoxEntity.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                RustleFoxEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    class FoxLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public FoxLookAtPlayerGoal(Mob p_28707_, Class<? extends LivingEntity> p_28708_, float p_28709_) {
            super(p_28707_, p_28708_, p_28709_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !RustleFoxEntity.this.m_28556_() && !RustleFoxEntity.this.m_28559_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !RustleFoxEntity.this.m_28556_() && !RustleFoxEntity.this.m_28559_();
        }
    }

    class PerchAndSearchGoal
    extends FoxBehaviorGoal {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public PerchAndSearchGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (RustleFoxEntity.this.isTame()) {
                return false;
            }
            return RustleFoxEntity.this.m_21188_() == null && RustleFoxEntity.this.m_217043_().m_188501_() < 0.02f && !RustleFoxEntity.this.m_5803_() && RustleFoxEntity.this.m_5448_() == null && RustleFoxEntity.this.m_21573_().m_26571_() && !this.alertable() && !RustleFoxEntity.this.m_28557_() && !RustleFoxEntity.this.m_6047_();
        }

        public boolean m_8045_() {
            if (RustleFoxEntity.this.isTame()) {
                return false;
            }
            return this.looksRemaining > 0;
        }

        public void m_8056_() {
            this.resetLook();
            this.looksRemaining = 2 + RustleFoxEntity.this.m_217043_().m_188503_(3);
            RustleFoxEntity.this.m_28610_(true);
            RustleFoxEntity.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            RustleFoxEntity.this.m_28610_(false);
        }

        public void m_8037_() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            RustleFoxEntity.this.m_21563_().m_24950_(RustleFoxEntity.this.m_20185_() + this.relX, RustleFoxEntity.this.m_20188_(), RustleFoxEntity.this.m_20189_() + this.relZ, (float)RustleFoxEntity.this.m_8085_(), (float)RustleFoxEntity.this.m_8132_());
        }

        private void resetLook() {
            double d0 = Math.PI * 2 * RustleFoxEntity.this.m_217043_().m_188500_();
            this.relX = Math.cos(d0);
            this.relZ = Math.sin(d0);
            this.lookTime = this.m_183277_(80 + RustleFoxEntity.this.m_217043_().m_188503_(20));
        }
    }

    abstract class FoxBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting;

        FoxBehaviorGoal() {
            TargetingConditions var10001 = TargetingConditions.m_148352_().m_26883_(12.0).m_148355_();
            RustleFoxEntity var10004 = RustleFoxEntity.this;
            Objects.requireNonNull(var10004);
            this.alertableTargeting = var10001.m_26888_((Predicate)new Fox.FoxAlertableEntitiesSelector((Fox)var10004));
        }

        protected boolean hasShelter() {
            BlockPos blockpos = BlockPos.m_274561_((double)RustleFoxEntity.this.m_20185_(), (double)RustleFoxEntity.this.m_20191_().f_82292_, (double)RustleFoxEntity.this.m_20189_());
            return !RustleFoxEntity.this.m_9236_().m_45527_(blockpos) && RustleFoxEntity.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !RustleFoxEntity.this.m_9236_().m_45971_(LivingEntity.class, this.alertableTargeting, (LivingEntity)RustleFoxEntity.this, RustleFoxEntity.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    class FoxFollowParentGoal
    extends JerotesFollowParentGoal {
        private final RustleFoxEntity fox;

        public FoxFollowParentGoal(RustleFoxEntity p_28696_, double p_28697_) {
            super((Animal)p_28696_, p_28697_);
            this.fox = p_28696_;
        }

        public boolean m_8036_() {
            return !this.fox.m_28567_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.fox.m_28567_() && super.m_8045_();
        }

        public void m_8056_() {
            this.fox.m_28569_();
            super.m_8056_();
        }
    }
}

