/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ArmorEntity;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtByTargetGoal;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtTargetGoal;
import com.jerotes.jerotes.goal.JerotesHelpMobOwnerGoal;
import com.jerotes.jerotes.goal.JerotesLeapAtTargetAndLookGoal;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowParentGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeTemptGoal;
import com.jerotes.jerotesvillage.goal.ThornyTortoiseBreedGoal;
import com.jerotes.jerotesvillage.goal.ThornyTortoiseMeleeAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.joml.Vector3f;

public class ThornyTortoiseEntity
extends BaseTamableAnimalEntity
implements NeutralMob,
Saddleable,
ArmorEntity,
ContainerListener,
HasCustomInventoryScreen {
    public AnimationState hideAnimationState = new AnimationState();
    public AnimationState unHideAnimationState = new AnimationState();
    public AnimationState inHideAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("jerotes", "animal_foods/sea_grass_foods")));
    private static final EntityDataAccessor<Boolean> IS_WITHIN = SynchedEntityData.m_135353_(ThornyTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(ThornyTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(ThornyTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(ThornyTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    public boolean isLandNavigatorType = true;
    private int sitTick = 0;
    @Nullable
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public SimpleContainer inventory() {
        return this.inventory;
    }

    public ThornyTortoiseEntity(EntityType<? extends ThornyTortoiseEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.1f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.createInventory();
    }

    public boolean isWearingArmor() {
        return false;
    }

    public boolean isWarBeastArmor() {
        return false;
    }

    public boolean isGiantBeastArmor() {
        return false;
    }

    public int getInventorySize() {
        return 2;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_5757_(Container p_30548_) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
    }

    public SoundEvent m_246265_() {
        return JerotesSounds.USE_SADDLE;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new ThornyTortoiseMeleeAttackGoal(this, 1.25, true));
        this.f_21345_.m_25352_(1, (Goal)new JerotesLeapAtTargetAndLookGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(2, (Goal)new ThornyTortoiseBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new JerotesAnimalChangeTemptGoal(this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new JerotesAnimalChangeFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpMobOwnerGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalOwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new JerotesAnimalOwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ThornyTortoiseEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.18);
        builder = builder.m_22268_(Attributes.f_22276_, 60.0);
        builder = builder.m_22268_(Attributes.f_22284_, 20.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.75);
        return builder;
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.m_21051_(Attributes.f_22276_).m_22100_(75.0);
            this.m_21153_(75.0f);
            this.m_21051_(Attributes.f_22284_).m_22100_(24.0);
            this.m_21051_(Attributes.f_22277_).m_22100_(48.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(60.0);
            this.m_21051_(Attributes.f_22284_).m_22100_(20.0);
            this.m_21051_(Attributes.f_22277_).m_22100_(20.0);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_20069_() && this.m_20096_() && !this.m_6162_()) {
            return JerotesVillageSounds.THORNY_TORTOISE_AMBIENT;
        }
        return super.m_7515_();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.THORNY_TORTOISE_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.THORNY_TORTOISE_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.THORNY_TORTOISE_WALK, 0.15f, 1.0f);
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(10);
            this.setAnimationState("attack");
        }
        if ((bl = super.m_7327_(entity)) && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.THORNY_TORTOISE_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.25f : 1.0f;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    @Nullable
    public ThornyTortoiseEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        ThornyTortoiseEntity thornyTortoise = (ThornyTortoiseEntity)((EntityType)JerotesVillageEntityType.THORNY_TORTOISE.get()).m_20615_((Level)serverLevel);
        if (thornyTortoise != null && (uUID = this.m_21805_()) != null) {
            thornyTortoise.m_21816_(uUID);
            thornyTortoise.m_7105_(true);
        }
        return thornyTortoise;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)Items.f_42355_, 3);
        }
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -72000 : 0);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 1.8f;
        if (this.m_6162_()) {
            return height / 4.0f;
        }
        return height;
    }

    public boolean m_6094_() {
        return !this.m_20160_() && !this.isWithin();
    }

    public boolean m_5829_() {
        return this.isWithin() && this.m_6084_() || super.m_5829_();
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.m_292590_(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.m_6049_((Entity)this), vec3.f_82481_);
    }

    public float m_6049_(Entity entity) {
        return this.m_292595_(entity) * this.m_6134_();
    }

    protected float m_292595_(Entity entity) {
        return -0.5f;
    }

    public Vec3 m_292590_(Entity entity) {
        return new Vec3(this.m_292594_(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f m_292594_(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public boolean m_6063_() {
        return false;
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    @Override
    public void m_8107_() {
        LivingEntity n2;
        ServerLevel serverLevel;
        Level level;
        BlockState blockState;
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_20069_() && this.isLandNavigatorType) {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.2f, true);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = false;
        }
        if (!this.m_20069_() && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n2 = 0; n2 < 18; ++n2) {
                level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.setWithin(this.m_21223_() < this.m_21233_() / 8.0f && !this.m_6060_() || this.m_21825_());
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.isWithin()) {
            if (this.f_19796_.m_188503_(600) == 1 && this.f_20919_ == 0) {
                this.m_5634_(3.0f);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 20, 4, false, false), (Entity)this);
                this.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 20, 2, false, false), (Entity)this);
            }
        }
        if (this.isWithin() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.isWithin() && this.sitTick > 0) {
            this.unHideAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.inHideAnimationState.m_216973_();
            this.hideAnimationState.m_216973_();
        }
        if (this.sitTick == 40) {
            this.hideAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.hideAnimationState.m_216973_();
            this.inHideAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if ((n2 = this.m_6688_()) instanceof Player) {
            Player player = (Player)n2;
            if (!this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && this.m_20069_() && this.f_19862_) {
                for (int n3 = 0; n3 < 18; ++n3) {
                    level = this.m_9236_();
                    if (!(level instanceof ServerLevel)) continue;
                    serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
                }
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
            }
            if ((this.f_19790_ != this.m_20185_() || this.f_19792_ != this.m_20189_()) && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                double d = Math.abs(this.m_20185_() - this.f_19790_);
                double d2 = Math.abs(this.m_20189_() - this.f_19792_);
                if ((d >= 0.003 || d2 >= 0.003) && this.m_20184_().f_82480_ < (double)0.6f && this.m_20184_().f_82480_ > (double)-0.6f) {
                    float headXRot = player.m_146909_();
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(headXRot / 2.0f * -0.0035f), 0.0));
                }
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (this.isWithin() && (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268469_))) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (this.isWithin()) {
            boolean bl;
            LivingEntity livingEntity;
            Entity entity;
            if (amount <= 40.0f && damagesource.m_276093_(DamageTypes.f_268739_)) {
                return false;
            }
            if (!damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                amount /= 4.0f;
            }
            if ((entity = damagesource.m_7639_()) instanceof LivingEntity && !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)(livingEntity = (LivingEntity)entity)) && this.m_20270_((Entity)livingEntity) < 8.0f) {
                float damages = Math.min(40.0f, amount / 3.0f);
                damages = Math.max(2.0f, damages);
                if (EntityAndItemFind.isMeleeDamage((DamageSource)damagesource)) {
                    DamageSource damageSource = this.m_9236_().m_269111_().m_269333_((LivingEntity)this);
                    entity.m_6469_(damageSource, damages);
                }
            }
            if ((bl = super.m_6469_(damagesource, amount / 4.0f)) && this.m_21223_() < this.m_21233_() / 3.0f && this.getChangeType() == 1) {
                LivingEntity livingEntity2 = this.m_269323_();
                if (livingEntity2 instanceof Player) {
                    Player player = (Player)livingEntity2;
                    this.setChangeType(2, player);
                } else {
                    this.setChangeType(2);
                }
            }
            return bl;
        }
        boolean bl = super.m_6469_(damagesource, amount);
        if (bl && this.m_21223_() < this.m_21233_() / 3.0f && this.getChangeType() == 1) {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setChangeType(2, player);
            } else {
                this.setChangeType(2);
            }
        }
        return bl;
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(5.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                if (!(this.m_6898_(itemStack) || !this.m_6254_() || this.m_20160_() || player.m_36341_() || this.m_21827_())) {
                    if (!this.m_9236_().f_46443_) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack) || this.m_21660_()) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(64) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    public boolean isWithin() {
        return (Boolean)this.m_20088_().m_135370_(IS_WITHIN);
    }

    public void setWithin(boolean bl) {
        this.m_20088_().m_135381_(IS_WITHIN, (Object)bl);
    }

    protected void setFlag(int n, boolean n2) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (n2) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | n)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~n)));
        }
    }

    protected boolean getFlag(int n) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & n) != 0;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public boolean isArmor(ItemStack itemStack) {
        return false;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128379_("Within", this.isWithin());
        compoundTag.m_128405_("SitTick", this.sitTick);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemStack;
        ItemStack itemstack;
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setWithin(compoundTag.m_128471_("Within"));
        this.sitTick = compoundTag.m_128451_("SitTick");
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack);
        }
        this.m_147285_(this.m_9236_(), compoundTag);
        this.updateContainerEquipment();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(DATA_ID_FLAGS, (Object)0);
        this.m_20088_().m_135372_(IS_WITHIN, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return ThornyTortoiseEntity.this.inventory.m_8020_(p_149503_);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                ThornyTortoiseEntity.this.inventory.m_6836_(p_149503_, p_149528_);
                ThornyTortoiseEntity.this.updateContainerEquipment();
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int p_149514_) {
        int j;
        int i = p_149514_ - this.getAddNumber();
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = p_149514_ - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(p_149514_);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    public boolean canWearArmor() {
        return false;
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openSuchInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.isWithin()) {
            player.m_8127_();
        }
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                if (this.m_6109_() && this.m_20069_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    this.m_19920_(this.m_6113_(), new Vec3((double)strafe, 0.0, (double)forward));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.8));
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                } else {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    float forward = passenger.f_20902_;
                    strafe = passenger.f_20900_ / 2.0f;
                    super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
                }
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), dir);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(dir);
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

