/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.CanBeIllagerFactionEntity;
import com.jerotes.jerotes.entity.ChangePoseAbout;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesIllagerFactionEntityHelpIllagerGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.entity.in.HasHomePosEntity;
import com.jerotes.jerotesvillage.goal.BaseTamableAnimalGoHomeGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowMobOwnerGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowOwnerGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeHelpMobOwnerGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeOwnerHurtByTargetGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeOwnerHurtTargetGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeSitWhenOrderedToGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageBiomes;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class WildernessWolfEntity
extends Wolf
implements JerotesEntity,
CanBeIllagerFactionEntity,
ChangePoseAbout,
HasHomePosEntity {
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(WildernessWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(WildernessWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> IS_WANDER = SynchedEntityData.m_135353_(WildernessWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(WildernessWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ILLAGER_FACTION = SynchedEntityData.m_135353_(WildernessWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SNOW = SynchedEntityData.m_135353_(WildernessWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public WildernessWolfEntity(EntityType<? extends WildernessWolfEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21530_();
        this.m_252801_();
    }

    public static AttributeSupplier.Builder m_30425_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WolfPanicGoal(1.5));
        this.f_21345_.m_25352_(2, (Goal)new JerotesAnimalChangeSitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(3, new WolfAvoidEntityGoal<Llama>(this, Llama.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new BaseTamableAnimalGoHomeGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new JerotesAnimalChangeFollowOwnerGoal(this, 1.3, 5.0f, 1.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new JerotesAnimalChangeFollowMobOwnerGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new BegGoal((Wolf)this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesIllagerFactionEntityHelpIllagerGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalChangeHelpMobOwnerGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalChangeOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new JerotesAnimalChangeOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((WildernessWolfEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Nullable
    public WildernessWolfEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        WildernessWolfEntity wolf = (WildernessWolfEntity)((EntityType)JerotesVillageEntityType.WILDERNESS_WOLF.get()).m_20615_((Level)serverLevel);
        if (wolf != null && (uUID = this.m_21805_()) != null) {
            wolf.m_21816_(uUID);
            wolf.m_7105_(true);
            if (ageableMob instanceof WildernessWolfEntity) {
                WildernessWolfEntity wildernessWolf = (WildernessWolfEntity)ageableMob;
                if (this.f_19796_.m_188499_()) {
                    wolf.setSnow(this.isSnow());
                } else {
                    wolf.setSnow(wildernessWolf.isSnow());
                }
            } else {
                wolf.setSnow(this.isSnow());
            }
        } else if (wolf != null) {
            if (ageableMob instanceof WildernessWolfEntity) {
                WildernessWolfEntity wildernessWolf = (WildernessWolfEntity)ageableMob;
                if (this.f_19796_.m_188499_()) {
                    wolf.setSnow(this.isSnow());
                } else {
                    wolf.setSnow(wildernessWolf.isSnow());
                }
            } else {
                wolf.setSnow(this.isSnow());
            }
        }
        return wolf;
    }

    public boolean isIllagerFaction() {
        return (Boolean)this.m_20088_().m_135370_(IS_ILLAGER_FACTION);
    }

    public void setIllagerFaction(boolean bl) {
        this.m_20088_().m_135381_(IS_ILLAGER_FACTION, (Object)bl);
    }

    public boolean isSnow() {
        return (Boolean)this.m_20088_().m_135370_(IS_SNOW);
    }

    public void setSnow(boolean bl) {
        this.m_20088_().m_135381_(IS_SNOW, (Object)bl);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        float scale = 1.0f;
        if (this.isSnow()) {
            scale = 0.85f;
        }
        return super.m_6972_(pose).m_20388_(scale);
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.setIllagerFaction(false);
            this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(7.0);
            this.m_21153_(40.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(5.0);
        }
    }

    @Override
    public void setHomePos(BlockPos blockPos) {
        this.f_19804_.m_135381_(HOME_POS, (Object)blockPos);
    }

    @Override
    public BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    @Override
    public boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    @Override
    public void setGoingHome(boolean bl) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)bl);
    }

    @Nullable
    public LivingEntity m_269323_() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : WildernessWolfEntity.getLivingEntityByUUID(this.m_9236_(), uuid);
        }
        int id = this.getOwnerId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getOwnerId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerId(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public static LivingEntity getLivingEntityByUUID(Level level, UUID uuid) {
        return WildernessWolfEntity.getLivingEntityByUUID(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUUID(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public boolean isWander() {
        return (Boolean)this.m_20088_().m_135370_(IS_WANDER);
    }

    public void setWander(boolean bl) {
        this.m_20088_().m_135381_(IS_WANDER, (Object)bl);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsWander", this.isWander());
        compoundTag.m_128379_("IsGoingHome", this.isGoingHome());
        compoundTag.m_128405_("HomePosX", this.getHomePos().m_123341_());
        compoundTag.m_128405_("HomePosY", this.getHomePos().m_123342_());
        compoundTag.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        compoundTag.m_128379_("IsIllagerFaction", this.isIllagerFaction());
        compoundTag.m_128379_("IsSnow", this.isSnow());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setIllagerFaction(compoundTag.m_128471_("IsIllagerFaction"));
        this.setSnow(compoundTag.m_128471_("IsSnow"));
        this.setWander(compoundTag.m_128471_("IsWander"));
        this.setGoingHome(compoundTag.m_128471_("IsGoingHome"));
        int n = compoundTag.m_128451_("HomePosX");
        int n2 = compoundTag.m_128451_("HomePosY");
        int n3 = compoundTag.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(n, n2, n3));
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.getChangeType() != 3;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_ILLAGER_FACTION, (Object)false);
        this.m_20088_().m_135372_(IS_SNOW, (Object)false);
        this.m_20088_().m_135372_(IS_WANDER, (Object)false);
        this.m_20088_().m_135372_(DATA_OWNER_ID, (Object)-1);
        this.m_20088_().m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.m_20088_().m_135372_(GOING_HOME, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (IS_ILLAGER_FACTION.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (IS_SNOW.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.m_269323_() != null && this.getOwnerId() == -1) {
            this.setOwnerId(this.m_269323_().m_19879_());
        }
        if (this.isWander() && this.m_21825_() && !this.m_9236_().f_46443_) {
            this.m_21837_(false);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            InteractionResult interactionResult;
            if (!player.m_6144_() && this.m_6898_(itemStack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(itemStack.getFoodProperties((LivingEntity)this).m_38744_());
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    return InteractionResult.SUCCESS;
                }
                return super.m_6071_(player, interactionHand);
            }
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (this.m_21830_((LivingEntity)player)) {
                    DyeColor dyecolor = dyeItem.m_41089_();
                    if (dyecolor != this.m_30428_()) {
                        this.m_30397_(dyecolor);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
            }
            if ((interactionResult = super.m_6071_(player, interactionHand)).m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!itemStack.m_150930_(Items.f_42500_) || this.m_21660_()) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(6) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    public int getChangeType() {
        return (this.m_21827_() ? 1 : 2) + (this.isWander() ? 2 : 0);
    }

    public void setChangeType(int n) {
        n = Mth.m_14045_((int)n, (int)1, (int)4);
        switch (n) {
            case 1: {
                this.m_21839_(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 2: {
                this.m_21839_(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 3: {
                this.m_21839_(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                    this.setHomePos(this.m_20183_());
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 4: {
                this.m_21839_(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
        }
    }

    public void setChangeType(int n, Player player) {
        this.setChangeType(n);
        if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_213846_((Component)Component.m_237110_((String)("talk.jerotes.pose_" + n), (Object[])new Object[]{this.m_5446_()}).m_130940_(ChatFormatting.WHITE));
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean bl;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        Entity entity = damageSource.m_7639_();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        if ((bl = super.m_6469_(damageSource, amount)) && !this.m_9236_().m_5776_() && this.getChangeType() == 1) {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setChangeType(2, player);
            } else {
                this.setChangeType(2);
            }
        }
        return bl;
    }

    public boolean m_7757_(LivingEntity livingEntity, LivingEntity livingEntity2) {
        return AttackFind.wantsToAttack((Mob)this, (LivingEntity)livingEntity, (LivingEntity)livingEntity2);
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        if (this.isIllagerFaction() && livingEntity instanceof AbstractIllager && (this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_())) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setHomePos(this.m_20183_());
        if (mobSpawnType != MobSpawnType.CONVERSION && mobSpawnType != MobSpawnType.BREEDING) {
            if (serverLevelAccessor.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_263748_)) {
                this.setSnow(true);
            } else if (serverLevelAccessor.m_204166_(this.m_20183_()).m_203565_(JerotesVillageBiomes.WILDERNESS_WOODLAND)) {
                this.setSnow(false);
            } else {
                this.setSnow(serverLevelAccessor.m_213780_().m_188501_() > 0.9f);
            }
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    class WolfPanicGoal
    extends PanicGoal {
        public WolfPanicGoal(double p_203124_) {
            super((PathfinderMob)WildernessWolfEntity.this, p_203124_);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_();
        }
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Wolf wolf;

        public WolfAvoidEntityGoal(Wolf p_30454_, Class<T> p_30455_, float p_30456_, double p_30457_, double p_30458_) {
            super((PathfinderMob)p_30454_, p_30455_, p_30456_, p_30457_, p_30458_);
            this.wolf = p_30454_;
        }

        public boolean m_8036_() {
            if (super.m_8036_() && this.f_25016_ instanceof Llama) {
                return !this.wolf.m_21824_() && this.avoidLlama((Llama)this.f_25016_);
            }
            return false;
        }

        private boolean avoidLlama(Llama p_30461_) {
            return p_30461_.m_30823_() >= WildernessWolfEntity.this.f_19796_.m_188503_(5);
        }

        public void m_8056_() {
            WildernessWolfEntity.this.m_6710_(null);
            super.m_8056_();
        }

        public void m_8037_() {
            WildernessWolfEntity.this.m_6710_(null);
            super.m_8037_();
        }
    }
}

