/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ChangePoseAbout;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.in.HasHomePosEntity;
import com.jerotes.jerotesvillage.goal.BaseTamableAnimalGoHomeGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowMobOwnerGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowOwnerGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeHelpMobOwnerGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeOwnerHurtByTargetGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeOwnerHurtTargetGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeSitWhenOrderedToGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageBuiltInLootTable;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.world.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class WonderlandLiCatEntity
extends Cat
implements JerotesEntity,
NeutralMob,
ChangePoseAbout,
HasHomePosEntity {
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(WonderlandLiCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(WonderlandLiCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> IS_WANDER = SynchedEntityData.m_135353_(WonderlandLiCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(WonderlandLiCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CAT_COLOR = SynchedEntityData.m_135353_(WonderlandLiCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CAT_WILD = SynchedEntityData.m_135353_(WonderlandLiCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public WonderlandLiCatEntity(EntityType<? extends WonderlandLiCatEntity> entityType, Level level) {
        super(entityType, level);
        this.m_252801_();
        this.m_21530_();
    }

    public static AttributeSupplier.Builder m_28168_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        return builder;
    }

    public void MobInventoryAddTooltip(List<Component> tooltip, LivingEntity livingEntity) {
        tooltip.add((Component)Component.m_237110_((String)"message.jerotesvillage.mob_wild", (Object[])new Object[]{this.getCatWild()}).m_130940_(ChatFormatting.AQUA));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            public boolean m_8036_() {
                if (WonderlandLiCatEntity.this.getCatWild() >= 5 && !WonderlandLiCatEntity.this.m_6162_() || WonderlandLiCatEntity.this.getCatWild() >= 10) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (WonderlandLiCatEntity.this.getCatWild() >= 5 && !WonderlandLiCatEntity.this.m_6162_() || WonderlandLiCatEntity.this.getCatWild() >= 10) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new JerotesAnimalChangeSitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BaseTamableAnimalGoHomeGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new JerotesAnimalChangeFollowOwnerGoal(this, 1.3, 5.0f, 1.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new JerotesAnimalChangeFollowMobOwnerGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new CatRelaxOnOwnerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new CatTemptGoal(this, 0.6, true));
        this.f_21345_.m_25352_(5, (Goal)new CatLieOnBedGoal((Cat)this, 1.1, 8));
        this.f_21345_.m_25352_(7, (Goal)new CatSitOnBlockGoal((Cat)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(9, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new JerotesBreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalChangeHelpMobOwnerGoal(this){

            @Override
            public boolean m_8036_() {
                if ((WonderlandLiCatEntity.this.getCatWild() < 5 || WonderlandLiCatEntity.this.m_6162_()) && WonderlandLiCatEntity.this.getCatWild() < 10) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                if ((WonderlandLiCatEntity.this.getCatWild() < 5 || WonderlandLiCatEntity.this.m_6162_()) && WonderlandLiCatEntity.this.getCatWild() < 10) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalChangeOwnerHurtByTargetGoal(this){

            @Override
            public boolean m_8036_() {
                if ((WonderlandLiCatEntity.this.getCatWild() < 5 || WonderlandLiCatEntity.this.m_6162_()) && WonderlandLiCatEntity.this.getCatWild() < 10) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                if ((WonderlandLiCatEntity.this.getCatWild() < 5 || WonderlandLiCatEntity.this.m_6162_()) && WonderlandLiCatEntity.this.getCatWild() < 10) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new JerotesAnimalChangeOwnerHurtTargetGoal(this){

            @Override
            public boolean m_8036_() {
                if ((WonderlandLiCatEntity.this.getCatWild() < 5 || WonderlandLiCatEntity.this.m_6162_()) && WonderlandLiCatEntity.this.getCatWild() < 10) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                if ((WonderlandLiCatEntity.this.getCatWild() < 5 || WonderlandLiCatEntity.this.m_6162_()) && WonderlandLiCatEntity.this.getCatWild() < 10) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((WonderlandLiCatEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public int getCatColor() {
        return (Integer)this.m_20088_().m_135370_(CAT_COLOR);
    }

    public void setCatColor(int n) {
        this.m_20088_().m_135381_(CAT_COLOR, (Object)n);
    }

    public int getCatWild() {
        return (Integer)this.m_20088_().m_135370_(CAT_WILD);
    }

    public void setCatWild(int n, boolean bl) {
        int n2 = Mth.m_14045_((int)n, (int)1, (int)OtherMainConfig.WonderlandLiCatMaxWild);
        this.m_20088_().m_135381_(CAT_WILD, (Object)n2);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)(10 + this.getCatWild()));
        if (bl) {
            this.m_21153_(10.0f + (float)this.getCatWild());
        }
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(3.0 + (double)this.getCatWild() / 4.0);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.3 + (double)this.getCatWild() * 0.0025);
        this.m_274367_(0.5f + (float)this.getCatWild() * 0.05f);
        this.m_20090_();
        this.m_6210_();
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double d2 = this.m_20186_();
        double d3 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, d2, d3);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTags.f_13156_);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_((float)(1.0 + 0.05 * (double)this.getCatWild()));
    }

    @Override
    public void setHomePos(BlockPos blockPos) {
        this.f_19804_.m_135381_(HOME_POS, (Object)blockPos);
    }

    @Override
    public BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    @Override
    public boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    @Override
    public void setGoingHome(boolean bl) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)bl);
    }

    @Nullable
    public LivingEntity m_269323_() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : WonderlandLiCatEntity.getLivingEntityByUUID(this.m_9236_(), uuid);
        }
        int id = this.getOwnerId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getOwnerId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerId(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public static LivingEntity getLivingEntityByUUID(Level level, UUID uuid) {
        return WonderlandLiCatEntity.getLivingEntityByUUID(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUUID(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public boolean isWander() {
        return (Boolean)this.m_20088_().m_135370_(IS_WANDER);
    }

    public void setWander(boolean bl) {
        this.m_20088_().m_135381_(IS_WANDER, (Object)bl);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsWander", this.isWander());
        compoundTag.m_128379_("IsGoingHome", this.isGoingHome());
        compoundTag.m_128405_("HomePosX", this.getHomePos().m_123341_());
        compoundTag.m_128405_("HomePosY", this.getHomePos().m_123342_());
        compoundTag.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        compoundTag.m_128405_("CatColor", this.getCatColor());
        compoundTag.m_128405_("CatWild", this.getCatWild());
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("CatWild")) {
            this.setCatWild(compoundTag.m_128451_("CatWild"), false);
        }
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("CatColor")) {
            this.setCatColor(compoundTag.m_128451_("CatColor"));
        }
        this.setWander(compoundTag.m_128471_("IsWander"));
        this.setGoingHome(compoundTag.m_128471_("IsGoingHome"));
        int n = compoundTag.m_128451_("HomePosX");
        int n2 = compoundTag.m_128451_("HomePosY");
        int n3 = compoundTag.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(n, n2, n3));
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.getChangeType() != 3;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_WANDER, (Object)false);
        this.m_20088_().m_135372_(DATA_OWNER_ID, (Object)-1);
        this.m_20088_().m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.m_20088_().m_135372_(GOING_HOME, (Object)false);
        this.m_20088_().m_135372_(CAT_COLOR, (Object)1);
        this.m_20088_().m_135372_(CAT_WILD, (Object)1);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (CAT_WILD.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    @Nullable
    public WonderlandLiCatEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        WonderlandLiCatEntity cat2;
        UUID uUID;
        WonderlandLiCatEntity cat = (WonderlandLiCatEntity)((EntityType)JerotesVillageEntityType.WONDERLAND_LI_CAT.get()).m_20615_((Level)serverLevel);
        if (cat != null && (uUID = this.m_21805_()) != null) {
            cat.m_21816_(uUID);
            cat.m_7105_(true);
            if (ageableMob instanceof WonderlandLiCatEntity) {
                cat2 = (WonderlandLiCatEntity)ageableMob;
                if (this.f_19796_.m_188499_()) {
                    cat.m_28464_(this.m_28554_());
                    cat.setCatColor(this.getCatColor());
                    cat.setCatWild(this.getCatWild() + Main.randomReach((RandomSource)this.m_217043_(), (int)-2, (int)2), true);
                } else {
                    cat.m_28464_(cat2.m_28554_());
                    cat.setCatColor(cat2.getCatColor());
                    cat.setCatWild(cat2.getCatWild() + Main.randomReach((RandomSource)cat2.m_217043_(), (int)-2, (int)2), true);
                }
                if (this.f_19796_.m_188499_()) {
                    cat.m_28131_(this.m_28166_());
                } else {
                    cat.m_28131_(cat2.m_28166_());
                }
            }
        }
        if (cat != null && ageableMob instanceof WonderlandLiCatEntity) {
            cat2 = (WonderlandLiCatEntity)ageableMob;
            if (this.f_19796_.m_188499_()) {
                cat.m_28464_(this.m_28554_());
                cat.setCatColor(this.getCatColor());
                cat.setCatWild(this.getCatWild() + Main.randomReach((RandomSource)this.m_217043_(), (int)-2, (int)2), true);
            } else {
                cat.m_28464_(cat2.m_28554_());
                cat.setCatColor(cat2.getCatColor());
                cat.setCatWild(cat2.getCatWild() + Main.randomReach((RandomSource)cat2.m_217043_(), (int)-2, (int)2), true);
            }
        }
        return cat;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(2.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.m_269323_() != null && this.getOwnerId() == -1) {
            this.setOwnerId(this.m_269323_().m_19879_());
        }
        if (this.isWander() && this.m_21825_() && !this.m_9236_().f_46443_) {
            this.m_21837_(false);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            InteractionResult interactionResult;
            if (!player.m_6144_() && this.m_6898_(itemStack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(itemStack.getFoodProperties((LivingEntity)this).m_38744_());
                    this.m_142075_(player, interactionHand, itemStack);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    return InteractionResult.SUCCESS;
                }
                return super.m_6071_(player, interactionHand);
            }
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (this.m_21830_((LivingEntity)player)) {
                    DyeColor dyecolor = dyeItem.m_41089_();
                    if (dyecolor != this.m_28166_()) {
                        this.m_28131_(dyecolor);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
            }
            if ((interactionResult = super.m_6071_(player, interactionHand)).m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack)) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(3) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    public int getChangeType() {
        return (this.m_21827_() ? 1 : 2) + (this.isWander() ? 2 : 0);
    }

    public void setChangeType(int n) {
        n = Mth.m_14045_((int)n, (int)1, (int)4);
        switch (n) {
            case 1: {
                this.m_21839_(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 2: {
                this.m_21839_(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 3: {
                this.m_21839_(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                    this.setHomePos(this.m_20183_());
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 4: {
                this.m_21839_(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
        }
    }

    public void setChangeType(int n, Player player) {
        this.setChangeType(n);
        if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_213846_((Component)Component.m_237110_((String)("talk.jerotes.pose_" + n), (Object[])new Object[]{this.m_5446_()}).m_130940_(ChatFormatting.WHITE));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean bl;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        Entity entity = damageSource.m_7639_();
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        if ((bl = super.m_6469_(damageSource, amount)) && !this.m_9236_().m_5776_() && this.getChangeType() == 1) {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setChangeType(2, player);
            } else {
                this.setChangeType(2);
            }
        }
        return bl;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setHomePos(this.m_20183_());
        RandomSource randomSourceSkin = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION && mobSpawnType != MobSpawnType.BREEDING) {
            this.setCatColor(Main.randomReach((RandomSource)randomSourceSkin, (int)1, (int)8));
            this.setCatWild(Main.randomReach((RandomSource)randomSourceSkin, (int)1, (int)5), true);
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    static class CatRelaxOnOwnerGoal
    extends Goal {
        private final Cat cat;
        @Nullable
        private Player ownerPlayer;
        @Nullable
        private BlockPos goalPos;
        private int onBedTicks;

        public CatRelaxOnOwnerGoal(Cat p_28203_) {
            this.cat = p_28203_;
        }

        public boolean m_8036_() {
            if (!this.cat.m_21824_()) {
                return false;
            }
            if (this.cat.m_21827_()) {
                return false;
            }
            LivingEntity livingentity = this.cat.m_269323_();
            if (livingentity instanceof Player) {
                this.ownerPlayer = (Player)livingentity;
                if (!livingentity.m_5803_()) {
                    return false;
                }
                if (this.cat.m_20280_((Entity)this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.ownerPlayer.m_20183_();
                BlockState blockstate = this.cat.m_9236_().m_8055_(blockpos);
                if (blockstate.m_204336_(BlockTags.f_13038_)) {
                    this.goalPos = blockstate.m_61145_((Property)BedBlock.f_54117_).map(p_28209_ -> blockpos.m_121945_(p_28209_.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockpos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            Cat cat;
            Iterator var1 = this.cat.m_9236_().m_45976_(Cat.class, new AABB(this.goalPos).m_82400_(2.0)).iterator();
            do {
                if (var1.hasNext()) continue;
                return false;
            } while ((cat = (Cat)var1.next()) == this.cat || !cat.m_28164_() && !cat.m_28165_());
            return true;
        }

        public boolean m_8045_() {
            return this.cat.m_21824_() && !this.cat.m_21827_() && this.ownerPlayer != null && this.ownerPlayer.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void m_8056_() {
            if (this.goalPos != null) {
                this.cat.m_21837_(false);
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
            }
        }

        public void m_8041_() {
            this.cat.m_28181_(false);
            float f = this.cat.m_9236_().m_46942_(1.0f);
            if (this.ownerPlayer.m_36318_() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.cat.m_9236_().m_213780_().m_188501_() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.cat.m_28185_(false);
            this.cat.m_21573_().m_26573_();
        }

        private void giveMorningGift() {
            RandomSource randomsource = this.cat.m_217043_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockpos$mutableblockpos.m_122190_((Vec3i)(this.cat.m_21523_() ? this.cat.m_21524_().m_20183_() : this.cat.m_20183_()));
            this.cat.m_20984_((double)(blockpos$mutableblockpos.m_123341_() + randomsource.m_188503_(11) - 5), (double)(blockpos$mutableblockpos.m_123342_() + randomsource.m_188503_(5) - 2), (double)(blockpos$mutableblockpos.m_123343_() + randomsource.m_188503_(11) - 5), false);
            blockpos$mutableblockpos.m_122190_((Vec3i)this.cat.m_20183_());
            LootTable loottable = this.cat.m_9236_().m_7654_().m_278653_().m_278676_(JerotesVillageBuiltInLootTable.LI_CAT_MORNING_GIFT);
            LootParams lootparams = new LootParams.Builder((ServerLevel)this.cat.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.cat.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.cat).m_287235_(LootContextParamSets.f_81416_);
            for (ItemStack itemstack : loottable.m_287195_(lootparams)) {
                this.cat.m_9236_().m_7967_((Entity)new ItemEntity(this.cat.m_9236_(), (double)blockpos$mutableblockpos.m_123341_() - (double)Mth.m_14031_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), (double)blockpos$mutableblockpos.m_123342_(), (double)blockpos$mutableblockpos.m_123343_() + (double)Mth.m_14089_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), itemstack));
            }
        }

        public void m_8037_() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.cat.m_21837_(false);
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
                if (this.cat.m_20280_((Entity)this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.m_183277_(16)) {
                        this.cat.m_28181_(true);
                        this.cat.m_28185_(false);
                    } else {
                        this.cat.m_21391_((Entity)this.ownerPlayer, 45.0f, 45.0f);
                        this.cat.m_28185_(true);
                    }
                } else {
                    this.cat.m_28181_(false);
                }
            }
        }
    }

    static class CatTemptGoal
    extends TemptGoal {
        @Nullable
        private Player selectedPlayer;
        private final Cat cat;

        public CatTemptGoal(Cat p_28219_, double p_28220_, boolean p_28222_) {
            super((PathfinderMob)p_28219_, p_28220_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_}), p_28222_);
            this.cat = p_28219_;
        }

        private boolean m_148138_(LivingEntity livingEntity) {
            return livingEntity.m_21205_().m_204117_(ItemTags.f_13156_) || livingEntity.m_21205_().m_204117_(ItemTags.f_13156_);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.selectedPlayer == null && this.f_25924_.m_217043_().m_188503_(this.m_183277_(600)) == 0) {
                this.selectedPlayer = this.f_25925_;
            } else if (this.f_25924_.m_217043_().m_188503_(this.m_183277_(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean m_7497_() {
            return this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.f_25925_) ? false : super.m_7497_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.cat.m_21824_();
        }
    }
}

