/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss.Biome;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.ShockEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Animal.ArchnosedHornbeastEntity;
import com.jerotes.jerotesvillage.entity.Part.BrightLandBeastPart;
import com.jerotes.jerotesvillage.entity.in.ToughEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;

public class BrightLandBeastEntity
extends ArchnosedHornbeastEntity
implements ToughEntity,
BossEntity,
ShockEntity {
    private static final EntityDataAccessor<Integer> TOUGH_TICK = SynchedEntityData.m_135353_(BrightLandBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> TOUGH_DAMAGE = SynchedEntityData.m_135353_(BrightLandBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_TOUGH = SynchedEntityData.m_135353_(BrightLandBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(BrightLandBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.RED, false);
    public final BrightLandBeastPart back;
    public final BrightLandBeastPart[] allParts;
    public int start = -101;
    private float health1 = 1.0f;

    public BrightLandBeastEntity(EntityType<? extends BrightLandBeastEntity> entityType, Level level) {
        super((EntityType<? extends ArchnosedHornbeastEntity>)entityType, level);
        this.m_274367_(3.1f);
        this.f_21364_ = 400;
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.m_21441_(BlockPathTypes.FENCE, 0.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.BrightLandBeastMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.BrightLandBeastMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.BrightLandBeastArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.BrightLandBeastMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.BrightLandBeastAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.BrightLandBeastKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
        this.back = new BrightLandBeastPart(this, "back", 7.25f, 3.0f);
        this.allParts = new BrightLandBeastPart[]{this.back};
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.BrightLandBeastMagicAttackPercentage;
        }
        return (float)OtherMainConfig.BrightLandBeastAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.BrightLandBeastDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.BrightLandBeastDamageCooldownTick * base;
    }

    public int m_213860_() {
        return 400;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.allParts != null) {
            for (BrightLandBeastPart part : this.allParts) {
                part.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.start > 0) {
            this.bossEvent.m_142711_(this.health1 / this.m_21233_());
            this.health1 += (this.m_21223_() - this.health1) / 60.0f;
        } else {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 650.0);
        builder = builder.m_22268_(Attributes.f_22281_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22282_, 4.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.BRIGHT_LAND_BEAST_AMBIENT;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.BRIGHT_LAND_BEAST_HURT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.BRIGHT_LAND_BEAST_DEATH;
    }

    @Override
    public void playRushSound() {
        this.m_5496_(JerotesVillageSounds.BRIGHT_LAND_BEAST_RUSH, 1.0f, 1.0f);
    }

    @Override
    public void playWalkSound() {
        this.m_5496_(JerotesVillageSounds.BRIGHT_LAND_BEAST_WALK, 1.0f, 1.0f);
    }

    @Override
    public void trampUse() {
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(2.5, 2.5, 2.5));
        list.removeIf(livingEntity -> livingEntity == this || livingEntity.m_20186_() >= this.m_20188_() || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)livingEntity));
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity shock : list) {
            ArchnosedHornbeastEntity archnosedHornbeast;
            if (shock == null || this.m_20280_((Entity)shock) > Double.MAX_VALUE || shock.m_20186_() >= this.m_20188_() || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)shock) || this.m_269323_() != null && AttackFind.FindCanNotAttack((LivingEntity)this.m_269323_(), (Entity)shock) || shock instanceof ArchnosedHornbeastEntity && (archnosedHornbeast = (ArchnosedHornbeastEntity)shock).m_5448_() != this && this.m_5448_() != archnosedHornbeast || !shock.m_20096_() || !Main.mobSizeSmall((Entity)shock) && !Main.mobSizeMedium((Entity)shock)) continue;
            if (shock.m_21223_() <= this.m_21223_() / 10.0f) {
                shock.m_6469_(this.m_269291_().m_269364_((LivingEntity)this), 8.0f);
                continue;
            }
            AttackFind.attackBegin((LivingEntity)this, (Entity)shock);
            AttackFind.attackAfter((LivingEntity)this, (Entity)shock, (float)0.0f, (float)0.2f, (boolean)true, (float)8.0f);
        }
    }

    protected float m_6121_() {
        return 5.0f;
    }

    @Override
    public int m_6062_() {
        return 6000;
    }

    public int m_6056_() {
        if (this.m_21223_() > 160.0f) {
            return super.m_6056_() * 64;
        }
        return super.m_6056_();
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
        this.m_183634_();
    }

    public boolean m_7337_(Entity entity) {
        if (entity instanceof BrightLandBeastPart) {
            return false;
        }
        return entity.m_5829_() && !this.m_20365_(entity) && this.m_6084_();
    }

    public boolean useShock() {
        return this.m_21223_() > this.m_21233_() / 2.0f;
    }

    @Override
    @Nullable
    public BrightLandBeastEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        BrightLandBeastEntity archnosedHornbeast = (BrightLandBeastEntity)((EntityType)JerotesVillageEntityType.BRIGHT_LAND_BEAST.get()).m_20615_((Level)serverLevel);
        if (archnosedHornbeast != null && (uUID = this.m_21805_()) != null) {
            archnosedHornbeast.m_21816_(uUID);
            archnosedHornbeast.m_7105_(true);
        }
        return archnosedHornbeast;
    }

    @Override
    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("jerotes", "aa_creative_claw")));
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_6060_() {
        if (this.isTough()) {
            return false;
        }
        return super.m_6060_();
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.BRIGHT_LAND_BEAST_MUSIC;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setToughDamage(float f) {
        this.m_20088_().m_135381_(TOUGH_DAMAGE, (Object)Float.valueOf(f));
    }

    public float getToughDamage() {
        return ((Float)this.m_20088_().m_135370_(TOUGH_DAMAGE)).floatValue();
    }

    @Override
    public boolean isTough() {
        return (Boolean)this.m_20088_().m_135370_(IS_TOUGH) != false && this.m_6084_();
    }

    public void setTough(boolean bl) {
        this.m_20088_().m_135381_(IS_TOUGH, (Object)bl);
    }

    public void setToughTick(int n) {
        this.m_20088_().m_135381_(TOUGH_TICK, (Object)n);
    }

    public int getToughTick() {
        return (Integer)this.m_20088_().m_135370_(TOUGH_TICK);
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128379_("Tough", this.isTough());
        compoundTag.m_128405_("ToughTick", this.getToughTick());
        compoundTag.m_128405_("Start", this.start);
        compoundTag.m_128350_("Health1", this.health1);
        compoundTag.m_128350_("ToughDamage", this.getToughDamage());
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.setTough(compoundTag.m_128471_("Tough"));
        this.setToughTick(compoundTag.m_128451_("ToughTick"));
        this.start = compoundTag.m_128451_("Start");
        this.health1 = compoundTag.m_128457_("Health1");
        this.setToughDamage(compoundTag.m_128457_("ToughDamage"));
        this.m_147285_(this.m_9236_(), compoundTag);
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TOUGH_DAMAGE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(IS_TOUGH, (Object)false);
        this.m_20088_().m_135372_(TOUGH_TICK, (Object)0);
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("jerotes", "aa_creative_claw")))) {
            if (!this.m_21824_()) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                return InteractionResult.SUCCESS;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)6);
            this.m_21530_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public BrightLandBeastPart[] getSubEntities() {
        return this.allParts;
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        BrightLandBeastPart[] brightLandBeastParts = this.getSubEntities();
        for (int i = 0; i < brightLandBeastParts.length; ++i) {
            brightLandBeastParts[i].m_20234_(i + 1 + clientboundAddEntityPacket.m_131496_());
        }
    }

    private void tickMultipart() {
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
        this.back.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 3.0, 0.0), 0.0f, this.f_20883_).m_82549_(center));
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    private Vec3 rotateOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.m_82496_(-xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    @Override
    public void m_8119_() {
        this.tickMultipart();
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughTick(Math.max(0, this.getToughTick() - 1));
        }
        if (this.getToughTick() > 0) {
            if (!this.isTough() && !this.m_9236_().m_5776_()) {
                this.setTough(true);
            }
        } else if (this.isTough() && !this.m_9236_().m_5776_()) {
            this.setTough(false);
        }
        if (this.isTough() && this.m_20094_() > 0) {
            this.m_20095_();
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.update();
        if (this.start > 0) {
            --this.start;
        } else if (this.start == 0) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.BRIGHT_LAND_BEAST_AMBIENT, 10.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 660, 1));
            }
            this.start = -1;
        } else if (this.start > -100) {
            --this.start;
        }
        if (this.start <= -100) {
            this.start = -101;
        }
        if (this.m_5448_() != null && this.m_269323_() == null && !this.m_21525_() && this.m_20270_((Entity)this.m_5448_()) < 24.0f && this.getQuakeUseTick() <= 0 && this.getQuakeTick() <= 0 && this.getAttackTick() <= -((int)(OtherMainConfig.BrightLandBeastMeleeAttackCooldown * 20.0)) && !this.m_9236_().m_5776_()) {
            this.setQuakeUseTick(110);
            this.setQuakeTick((int)(OtherMainConfig.BrightLandBeastQuakeCooldown * 20.0));
            this.setAnimTick(20);
            this.setAnimationState("quakeStart");
            this.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 100, 3), (Entity)this);
        }
        if (this.m_6084_() && this.m_21223_() > this.m_21233_() / 2.0f && !this.m_21525_() && this.f_19797_ % 120 == 0) {
            this.addAback();
        }
    }

    public boolean addAback() {
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
        double d = Double.MAX_VALUE;
        for (LivingEntity shock : list) {
            ArchnosedHornbeastEntity archnosedHornbeast;
            if (shock == null || shock == this || this.m_20280_((Entity)shock) > d || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)shock) || this.m_269323_() != null && AttackFind.FindCanNotAttack((LivingEntity)this.m_269323_(), (Entity)shock) || EntityAndItemFind.isAbackAwayImmune((EntityType)shock.m_6095_()) || shock.m_21223_() > this.m_21223_() / 1.5f || shock.m_21023_((MobEffect)JerotesVillageMobEffects.ABUNDANT_COURAGE.get()) || shock.m_21023_((MobEffect)JerotesVillageMobEffects.RAMPANT.get()) || shock instanceof ArchnosedHornbeastEntity && (archnosedHornbeast = (ArchnosedHornbeastEntity)shock).m_5448_() != this && this.m_5448_() != archnosedHornbeast || shock.m_9236_().m_5776_()) continue;
            shock.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.ABACK.get(), 240, 0), (Entity)this);
            shock.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 240, 0), (Entity)this);
        }
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 24; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.ABACK.get(), this.m_20208_(0.5), this.m_20187_() + (double)(this.m_20206_() / 4.0f), this.m_20262_(0.5), 0.0, 0.02, 0.0);
            }
        }
        return true;
    }

    @Override
    public boolean trueHurt() {
        Object shake2;
        Object hurt2;
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.BRIGHT_LAND_BEAST_ATTACK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        float damageBase = 1.0f;
        float knockbackBase = 1.0f;
        if (this.getAttackUse() == 1) {
            knockbackBase = 1.25f;
        }
        if (this.getAttackUse() == 2) {
            damageBase = 1.25f;
        }
        if (this.getAttackUse() == 3) {
            damageBase = 1.5f;
            knockbackBase = 1.25f;
        }
        if (this.getAttackUse() == 4) {
            damageBase = 1.5f;
            knockbackBase = 1.05f;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(5.0, 4.0, 5.0));
        for (Object hurt2 : list) {
            Level level;
            ArchnosedHornbeastEntity archnosedHornbeast;
            if (hurt2 == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt2) || !this.m_142582_((Entity)hurt2) || !Main.canSee((Entity)hurt2, (Entity)this) && !this.m_292684_().m_82381_(hurt2.m_20191_()) && this.getAttackUse() != 2 && this.getAttackUse() != 4 || hurt2 instanceof ArchnosedHornbeastEntity && (archnosedHornbeast = (ArchnosedHornbeastEntity)hurt2).m_5448_() != this && this.m_5448_() != archnosedHornbeast) continue;
            float hurtBrightLandBeast = 0.0f;
            if (JerotesVillageGameRules.JEROTES_VILLAGE_BRIGHT_LAND_BEAST_TO_GIANT_ENTITY != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_BRIGHT_LAND_BEAST_TO_GIANT_ENTITY) && (hurtBrightLandBeast = Main.mobWidth((Entity)hurt2) * 4.0f * Main.mobHeight((Entity)hurt2)) > this.m_21223_() / 4.0f) {
                hurtBrightLandBeast = this.m_21223_() / 4.0f;
            }
            float damages = (float)this.m_21133_(Attributes.f_22281_) * damageBase + hurtBrightLandBeast;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt2);
            boolean bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt2, (float)0.0f, (float)knockbackBase, (boolean)true, (float)damages);
            if (!bl2) continue;
            if ((Main.mobSizeSmall((Entity)hurt2) || Main.mobSizeMedium((Entity)hurt2) || Main.mobSizeLarge((Entity)hurt2) || this.m_20191_().m_82309_() > hurt2.m_20191_().m_82309_()) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt2.m_6095_())) {
                double d = 0.0;
                if (hurt2.m_21051_(Attributes.f_22278_) != null) {
                    d = Math.max(hurt2.m_21133_(Attributes.f_22278_), 1.0);
                }
                double d3 = Math.max(0.0, 1.0 - d) + 0.5;
                hurt2.m_6853_(false);
                hurt2.m_20256_(hurt2.m_20184_().m_82520_(-(this.m_20185_() - hurt2.m_20185_()) * 1.4 * d3 * (0.7 + (double)(knockbackBase / 3.0f)), -(this.m_20186_() - hurt2.m_20186_()) * 2.0 * d3 * (0.7 + (double)(knockbackBase / 3.0f)) + (double)(0.2f * knockbackBase), -(this.m_20189_() - hurt2.m_20189_()) * 1.4 * d3 * (0.7 + (double)(knockbackBase / 3.0f))));
            }
            if (this.getAttackUse() == 2 && this.getAttackUse() == 4 && (Main.mobSizeSmall((Entity)hurt2) || Main.mobSizeMedium((Entity)hurt2)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt2.m_6095_())) {
                hurt2.m_6853_(false);
                hurt2.m_20256_(hurt2.m_20184_().m_82520_(0.0, (double)((7.0f - this.m_20270_((Entity)hurt2)) / 4.0f), 0.0));
            }
            if (!((level = hurt2.m_9236_()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.BRIGHT_LAND_BEAST_HURT.get()), hurt2.m_20185_(), hurt2.m_20186_() + 0.1, hurt2.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.getAttackUse() == 2 || this.getAttackUse() == 4) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(24.0, 24.0, 24.0));
            for (Object shake2 : listShake) {
                if (shake2 == null || shake2 == this || this.m_20280_((Entity)shake2) > Double.MAX_VALUE || shake2.m_9236_().m_5776_()) continue;
                shake2.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 40, 0, false, false), (Entity)this);
            }
        }
        Main.sweepAttack((Entity)this);
        hurt2 = this.m_9236_();
        if (hurt2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)hurt2;
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), (double)(Main.mobWidth((Entity)this) / 2.0f + 5.0f), (double)0.0, (double)(Main.mobWidth((Entity)this) / 2.0f + 5.0f));
            shake2 = BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_)).iterator();
            while (shake2.hasNext()) {
                BlockPos blockPos = (BlockPos)shake2.next();
                if (!Main.canSee((Vec3)blockPos.m_252807_(), (Entity)this) && this.getAttackUse() != 2 && this.getAttackUse() != 4 || !Main.canSeeAngle((Entity)this, (Vec3)blockPos.m_252807_(), (double)40.0) && this.getAttackUse() != 2 && this.getAttackUse() != 4 && this.getAttackUse() != 3) continue;
                Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
        SimpleParticleType particleOptions = ParticleTypes.f_123777_;
        if (this.getAttackUse() == 4 && (shake2 = this.m_9236_()) instanceof ServerLevel) {
            double offsetZ;
            double offsetX;
            double radius;
            double angle;
            int i;
            ServerLevel serverLevel = (ServerLevel)shake2;
            double d = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            for (i = 0; i < 160; ++i) {
                angle = Math.PI * 2 * (double)i / 160.0;
                radius = 8.0;
                offsetX = Math.cos(angle) * radius;
                offsetZ = Math.sin(angle) * radius;
                serverLevel.m_8767_((ParticleOptions)particleOptions, this.m_20185_() + offsetX + d, this.m_20186_() + (double)0.2f, this.m_20189_() + offsetZ + d2, 0, offsetX * 0.02, -0.04, offsetZ * 0.02, 1.0);
            }
            for (i = 0; i < 100; ++i) {
                angle = Math.PI * 2 * (double)i / 100.0;
                radius = 5.0;
                offsetX = Math.cos(angle) * radius;
                offsetZ = Math.sin(angle) * radius;
                serverLevel.m_8767_((ParticleOptions)particleOptions, this.m_20185_() + offsetX + d, this.m_20186_() + (double)0.2f, this.m_20189_() + offsetZ + d2, 0, offsetX * 0.05, -0.02, offsetZ * 0.05, 1.0);
            }
        }
        return true;
    }

    @Override
    public boolean earthQuake() {
        float damage = (float)(OtherMainConfig.BrightLandBeastQuakeBaseDamage * 0.5 + (double)this.m_21223_() * OtherMainConfig.BrightLandBeastQuakeHealthMultipleDamage * 0.5);
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            damage = (float)(OtherMainConfig.BrightLandBeastQuakeBaseDamage + (double)this.m_21223_() * OtherMainConfig.BrightLandBeastQuakeHealthMultipleDamage);
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            damage = (float)(OtherMainConfig.BrightLandBeastQuakeBaseDamage * 1.5 + (double)this.m_21223_() * OtherMainConfig.BrightLandBeastQuakeHealthMultipleDamage * 1.5);
        }
        OtherSpellFind.EarthQuake((LivingEntity)this, (int)damage, 18);
        if (!this.m_20067_() && this.m_6084_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.BRIGHT_LAND_BEAST_QUAKE, this.m_5720_(), 100.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setQuakeTick((int)(OtherMainConfig.BrightLandBeastQuakeCooldown * 20.0));
        }
        return true;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        if (this.start > -100) {
            return true;
        }
        if (damageSource.m_276093_(DamageTypes.f_268440_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (amount <= 3.0f) {
            return false;
        }
        if (!damagesource.m_269533_(DamageTypeTags.f_268738_) && this.isTough() && (double)amount <= (double)this.getToughDamage() * OtherMainConfig.BrightLandBeastBreakHurtCooldownMultiple) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughDamage(amount);
        }
        double toughBase = OtherMainConfig.BrightLandBeastHurtCooldown * 20.0;
        float toughMultiple = 0.5f;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            toughMultiple = 1.0f;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            toughMultiple = 1.5f;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughTick((int)(toughBase * (double)toughMultiple));
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268549_)) {
            float fallDamage = amount / 2.0f;
            if (fallDamage > 80.0f) {
                fallDamage = 80.0f;
            }
            return super.m_6469_(damagesource, fallDamage);
        }
        if (damagesource.m_7640_() instanceof AbstractArrow || damagesource.m_7640_() instanceof ThrowableProjectile) {
            return super.m_6469_(damagesource, amount / 2.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean hurtByPart(BrightLandBeastPart brightLandBeastPart, DamageSource damageSource, float f) {
        return this.m_6469_(damageSource, f);
    }

    @Override
    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ABACK.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19613_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19597_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    @Override
    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(40);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (!this.m_9236_().m_5776_()) {
            this.setQuakeUseTick(0);
        }
        if (this.f_20919_ == 32) {
            this.earthQuake();
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.BRIGHT_LAND_BEAST_QUAKE, SoundSource.AMBIENT, 100.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
            }
        }
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }
}

