/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss.Biome;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.FireAbsorptionEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.NoRotationControl;
import com.jerotes.jerotesvillage.entity.Humanoid.Serpon.SerponColonialSoldierEntity;
import com.jerotes.jerotesvillage.entity.Humanoid.Serpon.SerponEntity;
import com.jerotes.jerotesvillage.entity.Other.SerponChariotEntity;
import com.jerotes.jerotesvillage.entity.Other.SerponCombatPlatformEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.goal.SerponAttackTargetPlayerGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageBiomeTypeTags;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.network.JerotesVillageLevelData;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import com.jerotes.jerotesvillage.util.Other;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;

public class SerponCombatExecuterEntity
extends SerponEntity
implements BossEntity,
FireAbsorptionEntity,
SpellUseEntity {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("d8d07b34-c419-425c-8cc6-da38d77fd547");
    private static final UUID ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("f07e31dd-a4f8-4ff6-a428-3c5ad54f93fa");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("bccc23e7-90ae-4c19-8d45-a0cd65213ea0");
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_TRUE_COME = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SUPPLEMENT = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FURY = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPELL_CHANCE = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> USE_SPELL_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WIND_ATTACK_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLAME_ATTACK_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CURSE_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> IS_CURSE_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAST_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LAST = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPECIAL_BLOCK_TICK = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECIAL_MELEE_CHANCE = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(SerponCombatExecuterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState swordAttack1AnimationState = new AnimationState();
    public AnimationState swordAttack2AnimationState = new AnimationState();
    public AnimationState swordAttack3AnimationState = new AnimationState();
    public AnimationState swordAttack4AnimationState = new AnimationState();
    public AnimationState windAttackAnimationState = new AnimationState();
    public AnimationState flameAttackAnimationState = new AnimationState();
    public AnimationState block1AnimationState = new AnimationState();
    public AnimationState block2AnimationState = new AnimationState();
    public AnimationState block3AnimationState = new AnimationState();
    public AnimationState pikeSpellAnimationState = new AnimationState();
    public AnimationState hotWindSpellAnimationState = new AnimationState();
    public AnimationState meteorSpellAnimationState = new AnimationState();
    public AnimationState pushAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.YELLOW, false);
    private double blockDestroyTick;
    public int spellLevel = OtherMainConfig.SerponCombatExecuterSpellNormalLevel;
    public double supplementTick;
    public double summonAmountMax = OtherMainConfig.SerponCombatExecuterRoundTimeMin * 20.0;
    public double summonAmountStopMax = OtherMainConfig.SerponCombatExecuterRoundTimeMax * 20.0;
    public double summonAmount = this.summonAmountMax;
    public float summonMaxHealth = 1.0f;
    public int round = 1;
    public int roundSummons;

    public SerponCombatExecuterEntity(EntityType<? extends SerponCombatExecuterEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 700;
        this.m_21553_(true);
        this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = (float)OtherMainConfig.SerponCombatExecuterDropEquipmentChance;
        this.f_21348_[EquipmentSlot.CHEST.m_20749_()] = (float)OtherMainConfig.SerponCombatExecuterDropEquipmentChance;
        this.f_21348_[EquipmentSlot.LEGS.m_20749_()] = (float)OtherMainConfig.SerponCombatExecuterDropEquipmentChance;
        this.f_21348_[EquipmentSlot.FEET.m_20749_()] = (float)OtherMainConfig.SerponCombatExecuterDropEquipmentChance;
        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = (float)OtherMainConfig.SerponCombatExecuterDropEquipmentChance;
        this.f_21347_[EquipmentSlot.OFFHAND.m_20749_()] = (float)OtherMainConfig.SerponCombatExecuterDropEquipmentChance;
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.SerponCombatExecuterMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.SerponCombatExecuterMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.SerponCombatExecuterArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.SerponCombatExecuterMovementSpeed);
            this.m_21051_(Attributes.f_22280_).m_22100_(OtherMainConfig.SerponCombatExecuterFlyingSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.SerponCombatExecuterAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.SerponCombatExecuterKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.SerponCombatExecuterMagicAttackPercentage;
        }
        return (float)OtherMainConfig.SerponCombatExecuterAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.SerponCombatExecuterDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.SerponCombatExecuterDamageCooldownTick * base;
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.canEquip(EquipmentSlot.HEAD, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.CHEST, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.LEGS, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.FEET, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.OFFHAND, (Entity)this)) {
            return false;
        }
        if (!this.m_21205_().m_41619_()) {
            return false;
        }
        return super.m_7243_(itemStack);
    }

    @Override
    protected boolean m_7808_(ItemStack newItem, ItemStack oldItem) {
        if (newItem.m_41720_() instanceof BowItem) {
            return false;
        }
        if (newItem.m_41720_() instanceof CrossbowItem) {
            return false;
        }
        if (newItem.m_41720_() instanceof ShieldItem) {
            return false;
        }
        return super.m_7808_(newItem, oldItem);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.isTrueCome()) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        } else if (this.isSupplement()) {
            this.bossEvent.m_142711_((float)this.supplementTick);
        } else {
            this.bossEvent.m_142711_(Mth.m_14036_((float)(this.getHealthOfLivingSerpon() / this.summonMaxHealth), (float)0.0f, (float)1.0f));
        }
    }

    public float getHealthOfLivingSerpon() {
        float f = (float)(this.summonAmount / this.summonAmountMax);
        List listTeam = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listTeam.removeIf(entity -> entity instanceof SerponCombatExecuterEntity || !OtherEntityFactionFind.isFactionSerponCombatTeam((LivingEntity)entity) || !(entity instanceof NeutralMob) && !(entity instanceof Enemy));
        listTeam.removeIf(entity -> (entity.m_5647_() != null || this.m_5647_() != null) && !this.m_7307_((Entity)entity));
        return f + (float)listTeam.size();
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        ItemStack head = new ItemStack((ItemLike)JerotesVillageItems.SERPON_POWERHOUSE_HELMET.get());
        ItemStack chest = new ItemStack((ItemLike)JerotesVillageItems.SERPON_POWERHOUSE_CHESTPLATE.get());
        ItemStack legs = new ItemStack((ItemLike)JerotesVillageItems.SERPON_POWERHOUSE_LEGGINGS.get());
        ItemStack feet = new ItemStack((ItemLike)JerotesVillageItems.SERPON_POWERHOUSE_BOOTS.get());
        ArmorTrim armorTrim = new ArmorTrim((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "fire_secretor_adhesive"))).get(), (Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_266063_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266063_, (ResourceLocation)new ResourceLocation("jerotesvillage", "serpent_dominater"))).get());
        ArmorTrim.m_266570_((RegistryAccess)this.m_9236_().m_9598_(), (ItemStack)head, (ArmorTrim)armorTrim);
        ArmorTrim.m_266570_((RegistryAccess)this.m_9236_().m_9598_(), (ItemStack)chest, (ArmorTrim)armorTrim);
        ArmorTrim.m_266570_((RegistryAccess)this.m_9236_().m_9598_(), (ItemStack)legs, (ArmorTrim)armorTrim);
        ArmorTrim.m_266570_((RegistryAccess)this.m_9236_().m_9598_(), (ItemStack)feet, (ArmorTrim)armorTrim);
        this.maybeWearArmor(EquipmentSlot.HEAD, head, randomSource);
        this.maybeWearArmor(EquipmentSlot.CHEST, chest, randomSource);
        this.maybeWearArmor(EquipmentSlot.LEGS, legs, randomSource);
        this.maybeWearArmor(EquipmentSlot.FEET, feet, randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        this.m_8061_(equipmentSlot, itemStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 270.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22280_, 0.5);
        builder = builder.m_22268_(Attributes.f_22282_, 0.5);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, new SerponAttackTargetPlayerGoal<Player>((Mob)this, Player.class, true));
    }

    @Override
    protected SoundEvent m_7515_() {
        if (!this.isTrueCome()) {
            return null;
        }
        return JerotesVillageSounds.SERPON_COMBAT_EXECUTER_AMBIENT;
    }

    @Override
    public int m_8100_() {
        return 200;
    }

    @Override
    protected SoundEvent m_5592_() {
        if (!this.isTrueCome()) {
            return null;
        }
        return JerotesVillageSounds.SERPON_COMBAT_EXECUTER_DEATH;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (!this.isTrueCome()) {
            return null;
        }
        return JerotesVillageSounds.SERPON_COMBAT_EXECUTER_HURT;
    }

    public float serponStrengthBase() {
        Mob mob;
        LivingEntity livingEntity;
        float base = 1.0f;
        if (this.m_9236_().m_204166_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())).m_203656_(JerotesVillageBiomeTypeTags.SERPON_FIND) && JerotesVillageLevelData.get((LevelAccessor)this.m_9236_()) != null && !JerotesVillageLevelData.get((LevelAccessor)this.m_9236_()).SerponAway) {
            base += 0.5f;
        } else if (this.m_9236_().m_204166_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())).m_203656_(BiomeTags.f_263828_)) {
            base += 0.25f;
        } else if (JerotesVillageLevelData.get((LevelAccessor)this.m_9236_()) != null && this.m_9236_().m_204166_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())).m_203656_(BiomeTags.f_263748_)) {
            base -= 0.5f;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)this.m_9236_()) != null && JerotesVillageLevelData.get((LevelAccessor)this.m_9236_()).SerponAway) {
            base -= 0.5f;
        }
        if (this.m_9236_().m_8055_(this.m_20097_().m_7494_()).m_204336_(BlockTags.f_13076_) || this.m_9236_().m_6425_(this.m_20097_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
            base += 0.25f;
        }
        List listTeam = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listTeam.removeIf(entity -> entity instanceof SerponCombatExecuterEntity || !OtherEntityFactionFind.isFactionSerponCombatTeam((LivingEntity)entity) || !(entity instanceof NeutralMob) && !(entity instanceof Enemy));
        listTeam.removeIf(entity -> (entity.m_5647_() != null || this.m_5647_() != null) && !this.m_7307_((Entity)entity));
        if (!listTeam.isEmpty()) {
            base += Math.min(1.0f, (float)listTeam.size() / 12.0f);
        }
        if (this.m_9236_().m_46461_()) {
            base += 0.25f;
        } else if (this.m_9236_().m_46462_()) {
            base += 0.25f;
        }
        if (this.m_21527_()) {
            base += 0.25f;
        }
        if (this.m_5448_() != null && (livingEntity = this.m_5448_()) instanceof Mob && this.otherIsSunBurnTick(mob = (Mob)livingEntity)) {
            base += 0.25f;
        }
        if (this.m_5448_() != null && this.m_5448_().m_21023_((MobEffect)JerotesVillageMobEffects.SERPON_CREDENTIAL.get())) {
            base -= 0.25f;
        }
        if (this.isFury()) {
            base += 0.25f;
        }
        return Math.min(Math.max(base, 0.25f), 5.0f);
    }

    protected boolean otherIsSunBurnTick(Mob mob) {
        if (this.m_9236_().m_46461_() && !this.m_9236_().f_46443_) {
            boolean flag;
            float f = this.m_213856_();
            BlockPos blockpos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20188_(), (double)this.m_20189_());
            boolean bl = flag = this.m_20071_() || this.f_146808_ || this.f_146809_;
            if (f > 0.5f && this.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !flag && this.m_9236_().m_45527_(blockpos)) {
                return true;
            }
        }
        return false;
    }

    public boolean m_21526_() {
        return false;
    }

    @Override
    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        if (!this.m_21205_().m_41619_()) {
            return aabb1.m_82377_(1.6, 1.6, 1.6);
        }
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    @Override
    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public void m_147240_(double d, double d2, double d3) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(0.0, 0.0, 0.0);
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
        this.m_183634_();
    }

    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.specialAction() && (this.getUseSpellTick() >= 0 || this.getUseSpellTick() <= -2)) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    public void m_20256_(Vec3 vec3) {
        if (!this.isTrueCome()) {
            super.m_20256_(new Vec3(0.0, 0.0, 0.0));
        } else {
            super.m_20256_(vec3);
        }
    }

    public boolean m_21254_() {
        if (this.getSpecialBlockTick() > 4) {
            return true;
        }
        if (this.isFury() && this.getUseSpellTick() > 1) {
            return true;
        }
        return super.m_21254_();
    }

    public boolean m_21275_(DamageSource damageSource) {
        if (this.isFury() && this.getSpecialBlockTick() < 0 && this.m_217043_().m_188501_() > 0.75f) {
            return true;
        }
        return super.m_21275_(damageSource);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        if (!this.isTrueCome()) {
            return new NoRotationControl((Mob)this);
        }
        return super.m_7560_();
    }

    public boolean m_142066_() {
        if (!this.isTrueCome()) {
            return false;
        }
        return super.m_142066_();
    }

    public Component m_5446_() {
        if (!this.isTrueCome()) {
            return Component.m_237115_((String)"entity.jerotesvillage.serpon_combat_team");
        }
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)this.m_7755_()).m_130938_(p_185975_ -> p_185975_.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    public boolean m_6094_() {
        if (!this.isTrueCome()) {
            return false;
        }
        return super.m_6094_();
    }

    public boolean m_6063_() {
        if (!this.isTrueCome()) {
            return false;
        }
        return super.m_6063_();
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.SERPON_COMBAT_EXECUTER_MUSIC;
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.isTrueCome();
    }

    public double FireAbsorptionPercentage() {
        return OtherMainConfig.SerponCombatExecuterFireAbsorptionPercentage;
    }

    public boolean canUseCrossbow() {
        return false;
    }

    public boolean canUseThrow() {
        return false;
    }

    public boolean canUseRangeJavelin() {
        return false;
    }

    public boolean canUseBow() {
        return false;
    }

    public void m_21391_(Entity entity, float f, float f2) {
        if (this.getIsCurseTick() <= 0) {
            super.m_21391_(entity, f, f2);
        }
    }

    public void m_146926_(float f) {
        if (this.getIsCurseTick() <= 0) {
            super.m_146926_(f);
        }
    }

    public void m_146922_(float f) {
        if (this.getIsCurseTick() <= 0) {
            super.m_146922_(f);
        }
    }

    public void m_5618_(float f) {
        if (this.getIsCurseTick() <= 0) {
            super.m_5618_(f);
        }
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    public boolean isTrueCome() {
        return (Boolean)this.m_20088_().m_135370_(IS_TRUE_COME);
    }

    public void setTrueCome(boolean bl) {
        this.m_20088_().m_135381_(IS_TRUE_COME, (Object)bl);
        this.f_19794_ = false;
        if (bl) {
            this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public boolean isSupplement() {
        return (Boolean)this.m_20088_().m_135370_(IS_SUPPLEMENT);
    }

    public void setSupplement(boolean bl) {
        this.m_20088_().m_135381_(IS_SUPPLEMENT, (Object)bl);
    }

    public boolean specialAction() {
        return !this.isTrueCome() || this.getUseSpellTick() < 0 || this.getFlameAttackTick() > 0 || this.getWindAttackTick() > 0 || this.getIsCurseTick() > 0;
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setUseSpellTick(int n) {
        this.m_20088_().m_135381_(USE_SPELL_TICK, (Object)n);
    }

    public int getUseSpellTick() {
        return (Integer)this.m_20088_().m_135370_(USE_SPELL_TICK);
    }

    public void setSpellChance(int n) {
        this.m_20088_().m_135381_(SPELL_CHANCE, (Object)n);
    }

    public int getSpellChance() {
        return (Integer)this.m_20088_().m_135370_(SPELL_CHANCE);
    }

    public void setWindAttackTick(int n) {
        this.m_20088_().m_135381_(WIND_ATTACK_TICK, (Object)n);
    }

    public int getWindAttackTick() {
        return (Integer)this.m_20088_().m_135370_(WIND_ATTACK_TICK);
    }

    public void setFlameAttackTick(int n) {
        this.m_20088_().m_135381_(FLAME_ATTACK_TICK, (Object)n);
    }

    public int getFlameAttackTick() {
        return (Integer)this.m_20088_().m_135370_(FLAME_ATTACK_TICK);
    }

    public void setCurseTick(int n) {
        this.m_20088_().m_135381_(CURSE_TICK, (Object)n);
    }

    public int getCurseTick() {
        return (Integer)this.m_20088_().m_135370_(CURSE_TICK);
    }

    public void setIsCurseTick(int n) {
        this.m_20088_().m_135381_(IS_CURSE_TICK, (Object)n);
    }

    public int getIsCurseTick() {
        return (Integer)this.m_20088_().m_135370_(IS_CURSE_TICK);
    }

    public void setLastTick(int n) {
        this.m_20088_().m_135381_(LAST_TICK, (Object)n);
    }

    public int getLastTick() {
        return (Integer)this.m_20088_().m_135370_(LAST_TICK);
    }

    public void setSpecialBlockTick(int n) {
        this.m_20088_().m_135381_(SPECIAL_BLOCK_TICK, (Object)n);
    }

    public int getSpecialBlockTick() {
        return (Integer)this.m_20088_().m_135370_(SPECIAL_BLOCK_TICK);
    }

    public void setSpecialMeleeChance(int n) {
        this.m_20088_().m_135381_(SPECIAL_MELEE_CHANCE, (Object)n);
    }

    public int getSpecialMeleeChance() {
        return (Integer)this.m_20088_().m_135370_(SPECIAL_MELEE_CHANCE);
    }

    public boolean isLast() {
        return (Boolean)this.m_20088_().m_135370_(IS_LAST);
    }

    public void setLast(boolean bl) {
        this.m_20088_().m_135381_(IS_LAST, (Object)bl);
    }

    public boolean isFury() {
        return (Boolean)this.m_20088_().m_135370_(IS_FURY);
    }

    public void setFury(boolean bl) {
        this.m_20088_().m_135381_(IS_FURY, (Object)bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22120_(ATTACK_DAMAGE_MODIFIER_UUID);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
        if (bl) {
            ItemStack head = this.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = this.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = this.m_6844_(EquipmentSlot.LEGS);
            ItemStack feet = this.m_6844_(EquipmentSlot.FEET);
            head.m_41622_(2400, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.HEAD));
            chest.m_41622_(2400, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.CHEST));
            legs.m_41622_(2400, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.LEGS));
            feet.m_41622_(2400, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.FEET));
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SERPON_COMBAT_EXECUTER_FURY, this.m_5720_(), 1.0f, 1.0f);
            }
            double d = OtherMainConfig.SerponCombatExecuterArmorFury - OtherMainConfig.SerponCombatExecuterArmor;
            double d2 = OtherMainConfig.SerponCombatExecuterMeleeDamageFury - OtherMainConfig.SerponCombatExecuterMeleeDamage;
            double d3 = OtherMainConfig.SerponCombatExecuterKnockbackResistanceFury - OtherMainConfig.SerponCombatExecuterKnockbackResistance;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Fury armor", d, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22118_(new AttributeModifier(ATTACK_DAMAGE_MODIFIER_UUID, "Fury movement speed", d2, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Fury knockback resistance", d3, AttributeModifier.Operation.ADDITION));
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "swordAttack1")) {
            return 3;
        }
        if (Objects.equals(animation, "swordAttack2")) {
            return 4;
        }
        if (Objects.equals(animation, "swordAttack3")) {
            return 5;
        }
        if (Objects.equals(animation, "swordAttack4")) {
            return 6;
        }
        if (Objects.equals(animation, "windAttack")) {
            return 7;
        }
        if (Objects.equals(animation, "flameAttack")) {
            return 8;
        }
        if (Objects.equals(animation, "block1")) {
            return 9;
        }
        if (Objects.equals(animation, "block2")) {
            return 10;
        }
        if (Objects.equals(animation, "block3")) {
            return 11;
        }
        if (Objects.equals(animation, "pikeSpell")) {
            return 12;
        }
        if (Objects.equals(animation, "hotWindSpell")) {
            return 13;
        }
        if (Objects.equals(animation, "meteorSpell")) {
            return 14;
        }
        if (Objects.equals(animation, "push")) {
            return 15;
        }
        if (Objects.equals(animation, "dead")) {
            return 16;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.swordAttack1AnimationState);
        list.add(this.swordAttack2AnimationState);
        list.add(this.swordAttack3AnimationState);
        list.add(this.swordAttack4AnimationState);
        list.add(this.windAttackAnimationState);
        list.add(this.flameAttackAnimationState);
        list.add(this.block1AnimationState);
        list.add(this.block2AnimationState);
        list.add(this.block3AnimationState);
        list.add(this.pikeSpellAnimationState);
        list.add(this.hotWindSpellAnimationState);
        list.add(this.meteorSpellAnimationState);
        list.add(this.pushAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception || state == this.pushAnimationState) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == this.pushAnimationState) continue;
            state.m_216973_();
        }
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128379_("IsTrueCome", this.isTrueCome());
        compoundTag.m_128379_("IsSupplement", this.isSupplement());
        compoundTag.m_128379_("IsFury", this.isFury());
        compoundTag.m_128379_("IsLast", this.isLast());
        compoundTag.m_128347_("SupplementTick", this.supplementTick);
        compoundTag.m_128347_("SummonAmount", this.summonAmount);
        compoundTag.m_128347_("SummonAmountMax", this.summonAmountMax);
        compoundTag.m_128347_("SummonAmountStopMax", this.summonAmountStopMax);
        compoundTag.m_128350_("SummonMaxHealth", this.summonMaxHealth);
        compoundTag.m_128405_("Round", this.round);
        compoundTag.m_128405_("RoundSummons", this.roundSummons);
        compoundTag.m_128405_("SpecialBlockTick", this.getSpecialBlockTick());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("FlameAttackTick", this.getFlameAttackTick());
        compoundTag.m_128405_("WindAttackTick", this.getWindAttackTick());
        compoundTag.m_128405_("CurseTick", this.getCurseTick());
        compoundTag.m_128405_("IsCurseTick", this.getIsCurseTick());
        compoundTag.m_128405_("LastTick", this.getLastTick());
        compoundTag.m_128405_("SpecialMeleeChance", this.getSpecialMeleeChance());
        compoundTag.m_128405_("SpellTick", this.getUseSpellTick());
        compoundTag.m_128405_("SpellChance", this.getSpellChance());
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        if (compoundTag.m_128441_("IsTrueCome")) {
            this.setTrueCome(compoundTag.m_128471_("IsTrueCome"));
        }
        if (compoundTag.m_128441_("IsSupplement")) {
            this.setSupplement(compoundTag.m_128471_("IsSupplement"));
        }
        if (compoundTag.m_128441_("IsFury")) {
            this.setFury(compoundTag.m_128471_("IsFury"));
        }
        this.setLast(compoundTag.m_128471_("IsLast"));
        this.supplementTick = compoundTag.m_128459_("SupplementTick");
        this.summonAmount = compoundTag.m_128459_("SummonAmount");
        this.summonAmountMax = compoundTag.m_128459_("SummonAmountMax");
        this.summonAmountStopMax = compoundTag.m_128459_("SummonAmountStopMax");
        this.summonMaxHealth = compoundTag.m_128457_("SummonMaxHealth");
        this.round = compoundTag.m_128451_("Round");
        this.roundSummons = compoundTag.m_128451_("RoundSummons");
        this.setSpecialBlockTick(compoundTag.m_128451_("SpecialBlockTick"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setFlameAttackTick(compoundTag.m_128451_("FlameAttackTick"));
        this.setWindAttackTick(compoundTag.m_128451_("WindAttackTick"));
        this.setCurseTick(compoundTag.m_128451_("CurseTick"));
        this.setIsCurseTick(compoundTag.m_128451_("IsCurseTick"));
        this.setLastTick(compoundTag.m_128451_("LastTick"));
        this.setSpecialMeleeChance(compoundTag.m_128451_("SpecialMeleeChance"));
        this.setUseSpellTick(compoundTag.m_128451_("SpellTick"));
        this.setSpellChance(compoundTag.m_128451_("SpellChance"));
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(IS_TRUE_COME, (Object)true);
        this.m_20088_().m_135372_(IS_SUPPLEMENT, (Object)true);
        this.m_20088_().m_135372_(IS_FURY, (Object)false);
        this.m_20088_().m_135372_(IS_LAST, (Object)false);
        this.m_20088_().m_135372_(SPELL_CHANCE, (Object)0);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(USE_SPELL_TICK, (Object)0);
        this.m_20088_().m_135372_(WIND_ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(FLAME_ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(CURSE_TICK, (Object)400);
        this.m_20088_().m_135372_(IS_CURSE_TICK, (Object)0);
        this.m_20088_().m_135372_(LAST_TICK, (Object)0);
        this.m_20088_().m_135372_(SPECIAL_BLOCK_TICK, (Object)0);
        this.m_20088_().m_135372_(SPECIAL_MELEE_CHANCE, (Object)0);
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (IS_TRUE_COME.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.swordAttack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack1AnimationState);
                    break;
                }
                case 4: {
                    this.swordAttack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack2AnimationState);
                    break;
                }
                case 5: {
                    this.swordAttack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack3AnimationState);
                    break;
                }
                case 6: {
                    this.swordAttack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack4AnimationState);
                    break;
                }
                case 7: {
                    this.windAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.windAttackAnimationState);
                    break;
                }
                case 8: {
                    this.flameAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.flameAttackAnimationState);
                    break;
                }
                case 9: {
                    this.block1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.block2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.block3AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.pikeSpellAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.pikeSpellAnimationState);
                    break;
                }
                case 13: {
                    this.hotWindSpellAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.hotWindSpellAnimationState);
                    break;
                }
                case 14: {
                    this.meteorSpellAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.meteorSpellAnimationState);
                    break;
                }
                case 15: {
                    this.pushAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 16: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (!this.isTrueCome()) {
            if (player.m_21120_(interactionHand).m_41720_() == JerotesVillageItems.SERPON_CREDENTIAL.get() && this.round < 8 && !player.m_36335_().m_41519_((Item)JerotesVillageItems.SERPON_CREDENTIAL.get())) {
                player.m_36335_().m_41524_((Item)JerotesVillageItems.SERPON_CREDENTIAL.get(), 360);
                ++this.round;
                this.supplementTick = 0.0;
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    public void m_8119_() {
        this.fly = 500;
        List listTeam = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listTeam.removeIf(entity -> entity instanceof SerponCombatExecuterEntity || !OtherEntityFactionFind.isFactionSerponCombatTeam((LivingEntity)entity) || !(entity instanceof NeutralMob) && !(entity instanceof Enemy));
        listTeam.removeIf(entity -> (entity.m_5647_() != null || this.m_5647_() != null) && !this.m_7307_((Entity)entity));
        for (Mob serpon : listTeam) {
            if (!(serpon instanceof SerponEntity)) continue;
            SerponEntity serpon1 = (SerponEntity)serpon;
            serpon1.fly = 500;
        }
        if (!this.isTrueCome() && this.m_6084_()) {
            this.f_19794_ = true;
            super.m_8119_();
            this.f_19794_ = false;
            this.m_20242_(true);
            this.m_21573_().m_26573_();
            if (!this.m_9236_().f_46443_) {
                this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
                this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
                this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 10, 10, true, false));
            }
            int time1 = (int)Math.max(this.summonAmount / 20.0, 0.0);
            int time2 = (int)((this.summonAmount + (this.summonAmountStopMax - this.summonAmountMax)) / 20.0);
            this.bossEvent.m_6456_((Component)Component.m_237115_((String)"entity.jerotesvillage.serpon_combat_team").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"entity.jerotesvillage.serpon_combat_team_round", (Object[])new Object[]{String.valueOf(this.round)})).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"entity.jerotesvillage.serpon_combat_team_time", (Object[])new Object[]{time1, time2})).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"entity.jerotesvillage.serpon_combat_team_count", (Object[])new Object[]{listTeam.size()})));
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(4.0), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 2.0), this.m_20262_(4.0), 0.0, 0.0, 0.0);
                }
            }
            if (this.supplementTick < 1.0) {
                this.supplementTick += 0.01;
                if (!this.m_9236_().m_5776_()) {
                    this.setSupplement(true);
                }
                this.summonMaxHealth = 1.0f;
                this.summonAmount = this.summonAmountMax;
                this.roundSummons = 0;
            } else if (!this.m_9236_().m_5776_()) {
                this.setSupplement(false);
            }
            if (!this.isSupplement()) {
                if (this.summonAmount > this.summonAmountMax - this.summonAmountStopMax) {
                    this.summonAmount -= 1.0;
                    if (this.summonAmount <= 0.0 && this.getHealthOfLivingSerpon() <= 0.0f) {
                        ++this.round;
                        this.supplementTick = 0.0;
                        if (!this.m_9236_().m_5776_()) {
                            this.setSupplement(true);
                        }
                    }
                } else if (this.round < 8) {
                    ++this.round;
                    this.supplementTick = 0.0;
                    if (!this.m_9236_().m_5776_()) {
                        this.setSupplement(true);
                    }
                }
            }
            if (this.round > 8 || this.round < 1) {
                if (!this.m_9236_().m_5776_()) {
                    this.setTrueCome(true);
                }
                this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
                this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int counts = 0; counts < 360; ++counts) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 4, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.round == 1) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_PIONEER.get(), 2, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_PIONEER.get(), 3, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_PIONEER.get(), 3, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_PIONEER.get(), 4, 12);
                    ++this.roundSummons;
                }
            } else if (this.round == 2) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 3, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 3, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 4, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 5, 12);
                    ++this.roundSummons;
                }
            } else if (this.round == 3) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 3, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 3, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.WAR_PYTHON.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 4, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get(), 5, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.WAR_PYTHON.get(), 2, 12);
                    ++this.roundSummons;
                }
            } else if (this.round == 4) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 2, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.WAR_PYTHON.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FLAME_WIZARD.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.WAR_PYTHON.get(), 2, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.WAR_PYTHON.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FLAME_WIZARD.get(), 1, 12);
                    ++this.roundSummons;
                }
            } else if (this.round == 5) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FLAME_WIZARD.get(), 2, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_CHARIOT.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 3, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.WAR_PYTHON.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FLAME_WIZARD.get(), 2, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get(), 3, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FLAME_WIZARD.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_CHARIOT.get(), 1, 12);
                    ++this.roundSummons;
                }
            } else if (this.round == 6) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.FLAMOAR.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_CHARIOT.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.ROYAL_WAR_PYTHON.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.FLAMOAR.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FIRE_APOSTLE.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_CHARIOT.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.ROYAL_WAR_PYTHON.get(), 3, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.FLAMOAR.get(), 3, 12);
                    ++this.roundSummons;
                }
            } else if (this.round == 7) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.ROYAL_WAR_PYTHON.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_CHARIOT.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COMBAT_PLATFORM.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.ROYAL_WAR_PYTHON.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COMBAT_PLATFORM.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FIRE_APOSTLE.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COMBAT_PLATFORM.get(), 1, 12);
                    ++this.roundSummons;
                }
            } else if (this.round == 8) {
                if (this.summonAmount < this.summonAmountMax * 0.95 && this.roundSummons == 0) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.FLAMOAR.get(), 2, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.75 && this.roundSummons == 1) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_INTRUDER.get(), 1, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COMBAT_PLATFORM.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.5 && this.roundSummons == 2) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.FLAMOAR.get(), 2, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_COMBAT_PLATFORM.get(), 1, 12);
                    ++this.roundSummons;
                }
                if (this.summonAmount < this.summonAmountMax * 0.25 && this.roundSummons == 3) {
                    this.summonEntity((EntityType)JerotesVillageEntityType.SERPON_FIRE_APOSTLE.get(), 3, 12);
                    this.summonEntity((EntityType)JerotesVillageEntityType.FLAMOAR.get(), 3, 12);
                    ++this.roundSummons;
                    this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, false, Level.ExplosionInteraction.MOB);
                    if (!this.m_9236_().m_5776_()) {
                        this.setTrueCome(true);
                    }
                    ++this.round;
                    this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
                    this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
                    Level counts = this.m_9236_();
                    if (counts instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)counts;
                        for (int counts2 = 0; counts2 < 360; ++counts2) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 4, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    if (this.m_9236_().f_46443_) {
                        for (int i = 0; i < 64; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(4.0), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 2.0), this.m_20262_(4.0), 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        } else {
            super.m_8119_();
        }
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
    }

    public void summonEntity(EntityType entityType, int count, int summonDistance) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int countss = 0; countss < Other.getRaidBossCount((LivingEntity)this); ++countss) {
                for (int i = 0; i < count; ++i) {
                    Mob mob;
                    BlockPos summonPos = Main.findSpawnPositionNearFill((LivingEntity)this, (int)summonDistance);
                    if ((double)summonPos.m_123342_() < this.m_20186_()) {
                        summonPos = this.m_20097_().m_7494_();
                    }
                    Entity serpon = entityType.m_262496_(serverLevel, BlockPos.m_274561_((double)summonPos.m_123341_(), (double)summonPos.m_123342_(), (double)summonPos.m_123343_()), MobSpawnType.MOB_SUMMONED);
                    PlayerTeam teams = this.m_5647_();
                    if (teams != null && serpon != null) {
                        serverLevel.m_6188_().m_6546_(serpon.m_20149_(), teams);
                    }
                    if (entityType != JerotesVillageEntityType.SERPON_CHARIOT.get() && entityType != JerotesVillageEntityType.SERPON_COMBAT_PLATFORM.get()) {
                        if (serpon instanceof Mob) {
                            Mob mobSerpon = (Mob)serpon;
                            for (counts = 0; counts < 12; ++counts) {
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, mobSerpon.m_20208_(0.5), mobSerpon.m_20187_(), mobSerpon.m_20262_(0.5), 4, 0.0, 0.0, 0.0, 0.0);
                            }
                            if (this.m_5448_() != null) {
                                mobSerpon.m_6710_(this.m_5448_());
                            }
                        }
                        this.summonMaxHealth += 1.0f;
                    } else if (entityType == JerotesVillageEntityType.SERPON_CHARIOT.get()) {
                        if (serpon instanceof SerponChariotEntity) {
                            SerponChariotEntity serponChariot = (SerponChariotEntity)serpon;
                            for (counts = 0; counts < 12; ++counts) {
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, serponChariot.m_20208_(0.5), serponChariot.m_20187_(), serponChariot.m_20262_(0.5), 4, 0.0, 0.0, 0.0, 0.0);
                            }
                            serponChariot.m_6710_(this.m_5448_());
                            for (i2 = 0; i2 < 3; ++i2) {
                                SerponColonialSoldierEntity serponColonialSoldier = (SerponColonialSoldierEntity)((EntityType)JerotesVillageEntityType.SERPON_COLONIAL_SOLDIER.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)summonPos.m_123341_(), (double)summonPos.m_123342_(), (double)summonPos.m_123343_()), MobSpawnType.MOB_SUMMONED);
                                if (serponColonialSoldier == null) continue;
                                if (i2 == 0) {
                                    serponColonialSoldier.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)JerotesVillageItems.SERPON_SWORD.get()));
                                } else {
                                    serponColonialSoldier.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)JerotesVillageItems.SERPON_BLOWPIPE.get()));
                                }
                                if (!this.m_9236_().f_46443_) {
                                    serponColonialSoldier.m_20329_((Entity)serponChariot);
                                }
                                if (teams == null) continue;
                                serverLevel.m_6188_().m_6546_(serponColonialSoldier.m_20149_(), teams);
                            }
                        }
                        this.summonMaxHealth += 3.0f;
                    } else if (entityType == JerotesVillageEntityType.SERPON_COMBAT_PLATFORM.get()) {
                        if (serpon instanceof SerponCombatPlatformEntity) {
                            SerponCombatPlatformEntity serponCombatPlatform = (SerponCombatPlatformEntity)serpon;
                            for (counts = 0; counts < 12; ++counts) {
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, serponCombatPlatform.m_20208_(0.5), serponCombatPlatform.m_20187_(), serponCombatPlatform.m_20262_(0.5), 4, 0.0, 0.0, 0.0, 0.0);
                            }
                            serponCombatPlatform.m_6710_(this.m_5448_());
                            for (i2 = 0; i2 < 5; ++i2) {
                                SerponEntity serpon2;
                                if (i2 == 0 || i2 == 1 || i2 == 2) {
                                    serpon2 = (SerponEntity)((EntityType)JerotesVillageEntityType.SERPON_RIOTER.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)summonPos.m_123341_(), (double)summonPos.m_123342_(), (double)summonPos.m_123343_()), MobSpawnType.MOB_SUMMONED);
                                    if (serpon2 == null) continue;
                                    if (!this.m_9236_().f_46443_) {
                                        serpon2.m_20329_((Entity)serponCombatPlatform);
                                    }
                                    if (teams == null) continue;
                                    serverLevel.m_6188_().m_6546_(serpon2.m_20149_(), teams);
                                    continue;
                                }
                                serpon2 = (SerponEntity)((EntityType)JerotesVillageEntityType.SERPON_FLAME_WIZARD.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)summonPos.m_123341_(), (double)summonPos.m_123342_(), (double)summonPos.m_123343_()), MobSpawnType.MOB_SUMMONED);
                                if (serpon2 == null) continue;
                                if (!this.m_9236_().f_46443_) {
                                    serpon2.m_20329_((Entity)serponCombatPlatform);
                                }
                                if (teams == null) continue;
                                serverLevel.m_6188_().m_6546_(serpon2.m_20149_(), teams);
                            }
                        }
                        this.summonMaxHealth += 5.0f;
                    }
                    if (!(serpon instanceof Mob) || (mob = (Mob)serpon).m_20145_()) continue;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.SERPON_PORTAL.get()), mob.m_20185_(), mob.m_20227_(0.5), mob.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
                serverLevel.m_220407_(GameEvent.f_157810_, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), GameEvent.Context.m_223717_((Entity)this));
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.update();
        if (this.isTrueCome()) {
            Level playerPos;
            double offsetZ;
            double offsetX;
            Player player;
            LivingEntity livingEntity;
            int i;
            if (this.getFlameAttackTick() > 0) {
                if (this.m_9236_().m_5776_()) {
                    for (i = 0; i < 5; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(4.0), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 2.0), this.m_20262_(4.0), 0.0, 0.0, 0.0);
                    }
                }
                for (i = 0; i < 24; ++i) {
                    double angle = Math.PI * 2 * (double)i / 24.0;
                    double radius = 5.0;
                    double offsetX2 = Math.cos(angle) * radius;
                    double offsetZ2 = Math.sin(angle) * radius;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + offsetX2, this.m_20186_(), this.m_20189_() + offsetZ2, 0.0, 0.12, 0.0);
                }
            }
            if (this.getFlameAttackTick() == 5) {
                this.FlameAttack();
            }
            if (this.getWindAttackTick() > 0 && this.m_9236_().m_5776_()) {
                for (i = 0; i < 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(4.0), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 2.0), this.m_20262_(4.0), 0.0, 0.0, 0.0);
                }
            }
            if (this.getWindAttackTick() == 5) {
                this.WindAttack();
            }
            if (this.m_5448_() != null && !this.specialAction() && this.m_20270_((Entity)this.m_5448_()) > 12.0f && Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)40) == 1) {
                this.RushAttack(true);
            }
            if (!this.m_9236_().m_5776_()) {
                this.setAttackTick(Math.max(0, this.getAttackTick() - 1));
            }
            if (this.getAttackTick() == 15 && this.m_6084_()) {
                this.trueHurt();
            }
            if (this.getAttackTick() > 18 && this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            }
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
            }
            if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
                this.setAnimationState(0);
            }
            if (this.m_6084_()) {
                this.idleAnimationState.m_216982_(this.f_19797_);
            }
            if (this.getSpellChance() == 1) {
                Vec3 playerPos2 = this.m_20182_().m_82520_(0.0, this.m_20227_(0.5) - this.m_20186_(), 0.0);
                double radius = 3.0;
                int particleCount = 40;
                for (int i2 = 0; i2 < particleCount; ++i2) {
                    double angle = this.m_217043_().m_188500_() * Math.PI * 2.0;
                    double inclination = this.m_217043_().m_188500_() * Math.PI;
                    double offsetX3 = radius * Math.sin(inclination) * Math.cos(angle);
                    double offsetY = radius * Math.cos(inclination);
                    double offsetZ3 = radius * Math.sin(inclination) * Math.sin(angle);
                    Vec3 particlePos = playerPos2.m_82520_(offsetX3, offsetY, offsetZ3);
                    Vec3 direction = playerPos2.m_82546_(particlePos).m_82541_();
                    double speed = 0.15;
                    Vec3 velocity = direction.m_82490_(speed);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                }
            }
            if (this.blockDestroyTick > 0.0) {
                this.blockDestroyTick -= 1.0;
            }
            if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
                boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)5.0f);
                if (blockDestroy) {
                    this.blockDestroyTick = 30.0;
                }
                if (!this.m_9236_().m_5776_() && !canBlockDestroy && this.m_20096_()) {
                    this.m_6135_();
                }
            }
            int spellLevel = this.getSpellLevel() - 1;
            if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                spellLevel = this.getSpellLevel();
            } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                spellLevel = this.getSpellLevel() + 1;
            }
            if (this.getUseSpellTick() < 0 && this.getUseSpellTick() > -60 && this.m_5448_() != null && !this.m_21525_()) {
                if (this.getSpellChance() == 1) {
                    if (this.getUseSpellTick() == -20 || this.getUseSpellTick() == -30 || this.getUseSpellTick() == -40 || this.getUseSpellTick() == -50) {
                        OtherSpellList.SerponSirocco(this.getSpellLevel(), (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
                    }
                } else if (this.getSpellChance() == 2) {
                    if (this.getUseSpellTick() == -20 || this.getUseSpellTick() == -30 || this.getUseSpellTick() == -40 || this.getUseSpellTick() == -50) {
                        OtherSpellFind.RainofSerponPike((LivingEntity)this, this.m_5448_(), spellLevel * 4, spellLevel * 8, 4, 12);
                        if (!this.m_20067_()) {
                            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SERPON_COMBAT_EXECUTER_PIKE, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                        }
                    }
                } else if (this.getSpellChance() == 3 && (this.getUseSpellTick() == -30 || this.getUseSpellTick() == -40)) {
                    OtherSpellList.SerpenperthMeteor(this.getSpellLevel(), (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
                }
            }
            if (this.getUseSpellTick() <= -60 && !this.m_9236_().m_5776_()) {
                this.setUseSpellTick((int)(OtherMainConfig.SerponCombatExecuterSpellCooldown * 20.0));
                this.setSpellChance(0);
            }
            if (this.getUseSpellTick() == 0 && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 64.0f && Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)120) == 1) {
                int spellChance;
                this.RushAttack(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setUseSpellTick(this.getUseSpellTick() - 1);
                }
                if ((spellChance = Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)100)) > 60) {
                    if (!this.m_9236_().m_5776_()) {
                        this.setSpellChance(1);
                        this.setAnimTick(60);
                        this.setAnimationState("hotWindSpell");
                    }
                } else if (spellChance > 20) {
                    if (!this.m_9236_().m_5776_()) {
                        this.setSpellChance(2);
                        this.setAnimTick(60);
                        this.setAnimationState("pikeSpell");
                    }
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SERPON_COMBAT_EXECUTER_PIKE, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                } else if (!this.m_9236_().m_5776_()) {
                    this.setSpellChance(3);
                    this.setAnimTick(60);
                    this.setAnimationState("meteorSpell");
                }
            }
            if (this.isTrueCome() && this.m_21223_() <= this.m_21233_() / 2.0f && this.m_6084_() && !this.isFury()) {
                if (!this.m_9236_().m_5776_()) {
                    this.setFury(true);
                }
                if ((livingEntity = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)livingEntity;
                    if (!this.m_20145_()) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.STRIPPED_FURY_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if ((livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_() && this.getCurseTick() >= 800) {
                this.m_146926_(45.0f);
                if (!this.m_9236_().m_5776_()) {
                    this.setIsCurseTick(60);
                    this.setCurseTick(0);
                }
            }
            if (this.getIsCurseTick() > 0) {
                if (!this.m_9236_().m_5776_()) {
                    this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
                    this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
                    this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
                }
                this.m_21573_().m_26573_();
                livingEntity = this.m_9236_();
                if (livingEntity instanceof ServerLevel) {
                    double radius;
                    int i3;
                    ServerLevel serverLevel = (ServerLevel)livingEntity;
                    for (i3 = 0; i3 < 4; ++i3) {
                        double angle = Math.PI * 2 * (double)(this.getIsCurseTick() + i3 * 10) / 60.0;
                        radius = 1.45;
                        offsetX = Math.cos(angle) * radius;
                        offsetZ = Math.sin(angle) * radius;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + offsetX, this.m_20227_(1.1f), this.m_20189_() + offsetZ, 0, 0.0, 0.12, 0.0, 1.0);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + offsetX * 1.25, this.m_20227_(1.1f), this.m_20189_() + offsetZ * 1.25, 0, 0.0, 0.15, 0.0, 1.0);
                    }
                    for (i3 = 0; i3 < 8; ++i3) {
                        double angle = Math.PI * 2 * (double)(this.getIsCurseTick() + i3 * 5) / 60.0;
                        radius = 4.0;
                        offsetX = Math.cos(angle) * radius;
                        offsetZ = Math.sin(angle) * radius;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + offsetX, this.m_20227_(1.1f), this.m_20189_() + offsetZ, 0, 0.0, 0.12, 0.0, 1.0);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + offsetX * 1.25, this.m_20227_(1.1f), this.m_20189_() + offsetZ * 1.25, 0, 0.0, 0.15, 0.0, 1.0);
                    }
                    playerPos = this.m_20182_().m_82520_(0.0, this.m_20227_(0.5) - this.m_20186_(), 0.0);
                    double radius2 = 3.0;
                    int particleCount = 60;
                    for (int i4 = 0; i4 < particleCount; ++i4) {
                        double angle = this.m_217043_().m_188500_() * Math.PI * 2.0;
                        double inclination = this.m_217043_().m_188500_() * Math.PI;
                        double offsetX4 = radius2 * Math.sin(inclination) * Math.cos(angle);
                        double offsetY = radius2 * Math.cos(inclination);
                        double offsetZ4 = radius2 * Math.sin(inclination) * Math.sin(angle);
                        Vec3 particlePos = playerPos.m_82520_(offsetX4, offsetY, offsetZ4);
                        Vec3 direction = playerPos.m_82546_(particlePos).m_82541_();
                        double speed = 0.15;
                        Vec3 velocity = direction.m_82490_(speed);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_, 1.0);
                    }
                }
            }
            if (this.getLastTick() > 0 && (playerPos = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)playerPos;
                for (int i5 = 0; i5 < 3; ++i5) {
                    double angle = Math.PI * 2 * (double)i5 / 3.0;
                    double radius = 0.45;
                    offsetX = Math.cos(angle) * radius;
                    offsetZ = Math.sin(angle) * radius;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + offsetX, this.m_20227_(0.65f), this.m_20189_() + offsetZ, 0, 0.0, 0.12, 0.0, 1.0);
                }
            }
            if (!this.m_9236_().m_5776_()) {
                this.setSpecialBlockTick(Math.max(0, this.getSpecialBlockTick() - 1));
                this.setFlameAttackTick(Math.max(0, this.getFlameAttackTick() - 1));
                this.setWindAttackTick(Math.max(0, this.getWindAttackTick() - 1));
                if (this.getUseSpellTick() > 0 || this.getUseSpellTick() < 0 && this.getUseSpellTick() > -60) {
                    this.setUseSpellTick(this.getUseSpellTick() - 1);
                }
                if (this.isFury()) {
                    this.setCurseTick(Math.min(800, this.getCurseTick() + 1));
                }
                this.setIsCurseTick(Math.max(0, this.getIsCurseTick() - 1));
                this.setLastTick(Math.max(0, this.getLastTick() - 1));
            }
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (!this.isTrueCome()) {
            return false;
        }
        if (!this.specialAction() && this.getAttackTick() <= 0) {
            if (this.getSpecialMeleeChance() > 0 || (double)this.m_217043_().m_188501_() >= OtherMainConfig.SerponCombatExecuterFlameSlashChance + OtherMainConfig.SerponCombatExecuterWhirlwindSlashChance) {
                if (!this.m_9236_().m_5776_()) {
                    this.setAttackTick(20);
                    if (this.getSpecialMeleeChance() > 0) {
                        this.setSpecialMeleeChance(this.getSpecialMeleeChance() - 1);
                    }
                    int attackRandom = this.m_217043_().m_188503_(40);
                    if (this.m_21205_().m_41619_()) {
                        this.setAnimTick(5);
                        if (attackRandom < 30) {
                            this.setAnimationState("attack1");
                        } else {
                            this.setAnimationState("attack2");
                        }
                    } else {
                        this.setAnimTick(10);
                        if (attackRandom > 30) {
                            this.setAnimationState("swordAttack1");
                        } else if (attackRandom > 20) {
                            this.setAnimationState("swordAttack2");
                        } else if (attackRandom > 10) {
                            this.setAnimationState("swordAttack3");
                        } else {
                            this.setAnimationState("swordAttack4");
                        }
                    }
                }
                return true;
            }
            if ((double)this.m_217043_().m_188501_() < OtherMainConfig.SerponCombatExecuterFlameSlashChance / (OtherMainConfig.SerponCombatExecuterFlameSlashChance + OtherMainConfig.SerponCombatExecuterWhirlwindSlashChance)) {
                Level level;
                if (!this.m_9236_().m_5776_()) {
                    this.setAttackTick(0);
                    this.setFlameAttackTick(15);
                    this.setSpecialMeleeChance(3);
                    this.setAnimTick(15);
                    this.setAnimationState("flameAttack");
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (!this.m_20145_()) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.FLAME_SLASH_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            } else {
                Level level;
                if (!this.m_9236_().m_5776_()) {
                    this.setAttackTick(0);
                    this.setWindAttackTick(15);
                    this.setSpecialMeleeChance(3);
                    this.setAnimTick(15);
                    this.setAnimationState("windAttack");
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (!this.m_20145_()) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.WHIRLWIND_SLASH_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.SERPON_COMBAT_EXECUTER_ATTACK, 5.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(0.5));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)Math.min(1.0f, 0.5f + this.serponStrengthBase() / 1.5f), (float)0.5f, (boolean)false, (float)0.0f);
            if (!bl) continue;
            hurt.m_20254_(16);
            double d = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 15; ++i) {
                double xs = this.m_20185_() + d + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20185_() - hurt.m_20185_()) / 2.0;
                double ys = this.m_20227_(0.5) + (double)this.m_217043_().m_188501_() - 0.5 - (this.m_20186_() - hurt.m_20186_()) / 2.0;
                double zs = this.m_20189_() + d2 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20189_() - hurt.m_20189_()) / 2.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, xs, ys, zs, 0, d, 0.0, d2, 0.0);
            }
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean FlameAttack() {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SERPON_COMBAT_EXECUTER_FLAME, this.m_5720_(), 10.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(0.75));
        for (LivingEntity attack : list) {
            Mob serpon;
            if (AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)attack) || !this.m_142582_((Entity)attack) || attack instanceof Mob && OtherEntityFactionFind.isFactionSerponCombatTeam((LivingEntity)(serpon = (Mob)attack)) && serpon.m_5448_() != this && this.m_5448_() != serpon) continue;
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268684_), (Entity)this);
            AttackFind.attackBegin((LivingEntity)this, (Entity)attack);
            boolean bl2 = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)attack, (DamageSource)damageSource, (float)(2.5f * (0.5f + this.serponStrengthBase() / 1.5f)), (float)1.0f, (boolean)false, (float)0.0f);
            if (bl2) {
                attack.m_20254_(32);
                attack.m_147240_(2.0, (double)Mth.m_14031_((float)(this.m_146908_() * 0.0175f)), (double)(-Mth.m_14089_((float)(this.m_146908_() * 0.0175f))));
            } else {
                AttackFind.attackAfter((LivingEntity)this, (Entity)attack, (float)(2.0f * this.serponStrengthBase()), (float)1.0f, (boolean)false, (float)0.0f);
            }
            Main.sweepAttack((Entity)this);
            double d = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 15; ++i) {
                    double xs = this.m_20185_() + d + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20185_() - attack.m_20185_()) / 2.0;
                    double ys = this.m_20227_(0.5) + (double)this.m_217043_().m_188501_() - 0.5 - (this.m_20186_() - attack.m_20186_()) / 2.0;
                    double zs = this.m_20189_() + d2 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20189_() - attack.m_20189_()) / 2.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, xs, ys, zs, 0, d, 0.0, d2, 0.0);
                }
            }
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(attack.m_20185_(), attack.m_20186_(), attack.m_20189_()), (double)4.0, (double)3.0, (double)4.0);
            Level level2 = this.m_9236_();
            if (!(level2 instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level2;
            if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) continue;
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockState = serverLevel.m_8055_(blockPos);
                if (!blockState.m_60795_() || serverLevel.m_8055_(blockPos.m_7495_()).m_60795_()) continue;
                serverLevel.m_7731_(blockPos, Blocks.f_50083_.m_49966_(), 2);
            }
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    public boolean WindAttack() {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SERPON_COMBAT_EXECUTER_WIND, this.m_5720_(), 10.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(0.75));
        for (LivingEntity attack : list) {
            Mob serpon;
            if (AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)attack) || !this.m_142582_((Entity)attack) || attack instanceof Mob && OtherEntityFactionFind.isFactionSerponCombatTeam((LivingEntity)(serpon = (Mob)attack)) && serpon.m_5448_() != this && this.m_5448_() != serpon) continue;
            attack.m_147240_(5.0, (double)Mth.m_14031_((float)(this.m_146908_() * 0.0175f)), (double)(-Mth.m_14089_((float)(this.m_146908_() * 0.0175f))));
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268671_), (Entity)this);
            AttackFind.attackBegin((LivingEntity)this, (Entity)attack);
            boolean bl2 = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)attack, (DamageSource)damageSource, (float)(2.25f * (0.5f + this.serponStrengthBase() / 1.5f)), (float)3.0f, (boolean)false, (float)0.0f);
            if (bl2) {
                double d = 0.0;
                if (attack.m_21051_(Attributes.f_22278_) != null) {
                    d = Math.max(attack.m_21133_(Attributes.f_22278_), 1.0);
                }
                double d2 = Math.max(0.0, 1.0 - d) + 1.0;
                if (!EntityAndItemFind.isNoSpecialKnockback((EntityType)attack.m_6095_())) {
                    attack.m_20256_(attack.m_20184_().m_82520_(-(this.m_20185_() - attack.m_20185_()) * 1.4 * (d2 + 0.3), -(this.m_20186_() - attack.m_20186_()) * 2.0 * (d2 + 0.35), -(this.m_20189_() - attack.m_20189_()) * 1.4 * (d2 + 0.3)));
                }
            } else {
                AttackFind.attackAfter((LivingEntity)this, (Entity)attack, (float)(2.0f * this.serponStrengthBase()), (float)3.0f, (boolean)false, (float)0.0f);
            }
            Main.sweepAttack((Entity)this);
            double d3 = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d4 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 15; ++i) {
                    double xs = this.m_20185_() + d3 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20185_() - attack.m_20185_()) / 2.0;
                    double ys = this.m_20227_(0.5) + (double)this.m_217043_().m_188501_() - 0.5 - (this.m_20186_() - attack.m_20186_()) / 2.0;
                    double zs = this.m_20189_() + d4 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20189_() - attack.m_20189_()) / 2.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, xs, ys, zs, 0, d3, 0.0, d4, 0.0);
                }
            }
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), (double)7.0, (double)6.0, (double)7.0);
            Level level2 = this.m_9236_();
            if (!(level2 instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level2;
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268440_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_269533_(DamageTypeTags.f_268415_) && this.isFury() || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        boolean furyUse;
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (amount < this.m_21233_() * 20.0f && amount >= this.m_21223_() && !this.isLast()) {
            if (!this.m_9236_().m_5776_()) {
                this.setLast(true);
                this.setLastTick(160);
            }
            return false;
        }
        if (amount < this.m_21233_() * 20.0f && this.getLastTick() > 0) {
            return false;
        }
        if (!this.isTrueCome()) {
            if (amount < 32000.0f) {
                if (damagesource.m_7639_() instanceof Player) {
                    this.summonAmount -= (double)amount;
                }
                return false;
            }
            return super.m_6469_(damagesource, amount);
        }
        boolean normalUse = this.m_5912_() && this.isDamageSourceBlocks(damagesource);
        boolean bl = furyUse = !damagesource.m_269533_(DamageTypeTags.f_268738_) && this.isFury();
        if (!this.m_21525_() && this.getIsCurseTick() <= 0 && !this.m_6673_(damagesource) && this.isTrueCome() && (normalUse || furyUse) && !this.m_21205_().m_41619_() && !this.specialAction() && this.m_6084_() && this.getSpecialBlockTick() <= 0) {
            int attackDamage;
            Item item;
            ItemTwoHanded itemTwoHanded;
            Item item2;
            if (!this.specialAction() && !this.m_9236_().m_5776_()) {
                int blockRandom = this.m_217043_().m_188503_(30);
                if (blockRandom > 20) {
                    this.setAnimationState("block1");
                } else if (blockRandom > 10) {
                    this.setAnimationState("block2");
                } else {
                    this.setAnimationState("block3");
                }
            }
            if (this.m_21206_().m_41619_() && (item2 = this.m_21205_().m_41720_()) instanceof ItemTwoHanded && (itemTwoHanded = (ItemTwoHanded)item2).canBlock() && (item = this.m_21205_().m_41720_()) instanceof ItemSpecialEffect) {
                ItemSpecialEffect specialEffect = (ItemSpecialEffect)item;
                specialEffect.blockUse((Entity)this, damagesource.m_7639_(), damagesource);
            }
            float chance = Math.max(1.5f - (this.serponStrengthBase() / 3.0f - 1.0f), 0.2f);
            if (this.isFury()) {
                chance = Math.max(0.35f - (this.serponStrengthBase() / 3.0f - 1.0f), 0.1f);
            }
            if ((attackDamage = (int)this.m_21133_(Attributes.f_22281_) * 10) < 2) {
                attackDamage = 2;
            }
            if ((float)Main.randomReach((RandomSource)this.m_217043_(), (int)0, (int)attackDamage) > chance * amount) {
                ItemStack hand;
                if (!this.m_9236_().m_5776_()) {
                    if (!this.isFury()) {
                        this.setSpecialBlockTick(5);
                    } else {
                        this.setSpecialBlockTick(2);
                    }
                }
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SERPON_COMBAT_EXECUTER_BLOCK, this.m_5720_(), 10.0f, 1.0f);
                }
                if (this.m_5448_() != null && this.getAttackTick() <= 0) {
                    if (this.m_292684_().m_82381_(this.m_5448_().m_20191_())) {
                        this.m_7327_((Entity)this.m_5448_());
                    } else {
                        this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                        this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                        this.RushAttack(true);
                    }
                }
                if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK) && (hand = this.m_21205_()).m_41720_() != JerotesVillageItems.GLAIVE_OF_SERPENT_DOMINATER.get()) {
                    hand.m_41622_((int)amount / 3, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
                }
                return false;
            }
        }
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource) && this.isFury()) {
            return super.m_6469_(damagesource, amount / 3.0f / this.serponStrengthBase());
        }
        return super.m_6469_(damagesource, amount / this.serponStrengthBase());
    }

    public boolean RushAttack(boolean bl) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                Vec3 vec3 = this.m_20184_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, vec3.f_82479_, vec3.f_82480_ - 0.1, vec3.f_82481_, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, vec3.f_82479_, vec3.f_82480_ - 0.1, vec3.f_82481_, 0.0);
            }
        }
        float f = this.m_146908_();
        float f2 = this.m_146909_();
        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = 0.5f + (this.serponStrengthBase() - 1.0f) * 0.15f;
        if (!bl) {
            this.m_20334_(-(f3 *= f7 / f6 * 2.0f), -(f4 *= f7 / f6 * 2.0f), -(f5 *= f7 / f6 * 2.0f));
        } else {
            this.m_20334_(f3 *= f7 / f6 * 2.0f, f4 *= f7 / f6 * 2.0f, f5 *= f7 / f6 * 2.0f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("push");
        }
        if (!this.m_20067_()) {
            this.m_9236_().m_6269_(null, (Entity)this, JerotesVillageSounds.SERPON_COMBAT_EXECUTER_DASH, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ABACK.get()) {
            return false;
        }
        if (!this.isTrueCome() && mobEffectInstance.m_19544_() != MobEffects.f_19609_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19613_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.CORROSIVE.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.GLAIVE_OF_SERPENT_DOMINATER.get());
    }

    @Override
    public void m_6153_() {
        if (this.getLastTick() > 0) {
            return;
        }
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(40);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.SERPON_PORTAL.get()), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }

    protected void m_6668_(DamageSource damageSource) {
        if (this.isTrueCome()) {
            super.m_6668_(damageSource);
        }
    }
}

