/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Monster.Resurrecter.ResurrecterEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EagleBowEntity
extends ResurrecterEntity
implements BossEntity,
SpellUseEntity {
    public AnimationState startAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState swordAttack1AnimationState = new AnimationState();
    public AnimationState swordAttack2AnimationState = new AnimationState();
    public AnimationState swordAttack3AnimationState = new AnimationState();
    public AnimationState swordAttack4AnimationState = new AnimationState();
    public AnimationState leadAnimationState = new AnimationState();
    public AnimationState block1AnimationState = new AnimationState();
    public AnimationState block2AnimationState = new AnimationState();
    public AnimationState block3AnimationState = new AnimationState();
    public AnimationState shieldAttackAnimationState = new AnimationState();
    public AnimationState dead1AnimationState = new AnimationState();
    public AnimationState dead2AnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(EagleBowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.BLUE, false);
    public int spellLevel = 4;
    public int startTick;
    public double leadTick;
    public int specialBlockTick;
    public int shieldAttackTick = -20;

    public EagleBowEntity(EntityType<? extends EagleBowEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.1f);
        this.f_21364_ = 300;
        this.m_21553_(true);
        this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21348_[EquipmentSlot.CHEST.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21348_[EquipmentSlot.LEGS.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21348_[EquipmentSlot.FEET.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21347_[EquipmentSlot.OFFHAND.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.SedimentLordMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.SedimentLordMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.SedimentLordArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.SedimentLordMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.SedimentLordAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.SedimentLordKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.SedimentLordMagicAttackPercentage;
        }
        return (float)OtherMainConfig.SedimentLordAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.SedimentLordDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.SedimentLordDamageCooldownTick * base;
    }

    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.canEquip(EquipmentSlot.HEAD, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.CHEST, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.LEGS, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.FEET, (Entity)this)) {
            return false;
        }
        return super.m_7243_(itemStack);
    }

    @Override
    protected boolean m_7808_(ItemStack newItem, ItemStack oldItem) {
        if (newItem.m_41720_() instanceof BowItem) {
            return false;
        }
        if (newItem.m_41720_() instanceof CrossbowItem) {
            return false;
        }
        if (newItem.m_41720_() instanceof ShieldItem) {
            return false;
        }
        return super.m_7808_(newItem, oldItem);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_HELMET.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_CHESTPLATE.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_LEGGINGS.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_BOOTS.get()), randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        this.m_8061_(equipmentSlot, itemStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 170.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22282_, 0.4);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.SEDIMENT_LORD_AMBIENT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SEDIMENT_LORD_DEATH;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.SEDIMENT_LORD_HURT;
    }

    public boolean m_21526_() {
        return false;
    }

    @Override
    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        if (!this.m_21205_().m_41619_()) {
            return aabb1.m_82377_(0.85, 0.85, 0.85);
        }
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    @Override
    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    protected float m_6121_() {
        return 5.0f;
    }

    @Override
    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.specialAction()) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.BOSS_MUSIC_1;
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    public boolean specialAction() {
        return this.leadTick > OtherMainConfig.SedimentLordLeadCooldown * 20.0 - 20.0 || this.shieldAttackTick > 0 || this.startTick > 0;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("StartTick", this.startTick);
        compoundTag.m_128347_("LeadTick", this.leadTick);
        compoundTag.m_128405_("SpecialBlockTick", this.specialBlockTick);
        compoundTag.m_128405_("ShieldAttackTick", this.shieldAttackTick);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.startTick = compoundTag.m_128451_("StartTick");
        this.leadTick = compoundTag.m_128459_("LeadTick");
        this.specialBlockTick = compoundTag.m_128451_("SpecialBlockTick");
        this.shieldAttackTick = compoundTag.m_128451_("ShieldAttackTick");
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
    }

    @Override
    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.bossEvent.update();
        if (this.specialAction()) {
            this.m_21573_().m_26573_();
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        List listLord = this.m_9236_().m_45976_(EagleBowEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listLord.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        List listResurrect = this.m_9236_().m_45976_(ResurrecterEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listResurrect.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        if (this.leadTick > 1.0) {
            this.leadTick -= 1.0;
        } else if (this.m_5448_() != null) {
            if (this.leadTick > -30.0) {
                this.leadTick -= 1.0;
            }
            if (this.leadTick <= -30.0 && listResurrect.size() < listLord.size() * 16 && this.f_19796_.m_216339_(1, 120) == 1 && this.m_20270_((Entity)this.m_5448_()) < 32.0f && this.f_20919_ == 0) {
                this.block1AnimationState.m_216973_();
                this.block2AnimationState.m_216973_();
                this.block3AnimationState.m_216973_();
                this.leadTick = OtherMainConfig.SedimentLordLeadCooldown * 20.0;
                OtherSpellFind.SedimentOrder((LivingEntity)this, this.m_5448_(), this.getSpellLevel(), this.getSpellLevel() + 2, 4, 32);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SEDIMENT_LORD_LEAD, this.m_5720_(), 10.0f, 1.0f);
                }
            }
        }
        if (this.specialBlockTick > 0) {
            --this.specialBlockTick;
        }
        if (this.shieldAttackTick > -20) {
            --this.shieldAttackTick;
        }
        if (this.shieldAttackTick == 55 || this.shieldAttackTick == 50 || this.shieldAttackTick == 45 || this.shieldAttackTick == 40 || this.shieldAttackTick == 35 || this.shieldAttackTick == 30 || this.shieldAttackTick == 25 || this.shieldAttackTick == 20 || this.shieldAttackTick == 15 || this.shieldAttackTick == 10 || this.shieldAttackTick == 5) {
            this.shieldAttack();
        }
        if (this.shieldAttackTick <= 0) {
            this.shieldAttackAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (!this.specialAction()) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            boolean bl = super.m_7327_(entity);
            if (bl) {
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 1.0f, 1.0f);
                }
                List list = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(1.5, 1.0, 1.5));
                if (this.m_20096_() && !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                    for (LivingEntity hurt : list) {
                        if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt, (Entity)entity) || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt)) continue;
                        AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
                        AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.5f, (float)0.5f, (boolean)false, (float)0.0f);
                    }
                    Main.sweepAttack((Entity)this);
                }
            }
            return bl;
        }
        return false;
    }

    public boolean shieldAttack() {
        this.m_6674_(InteractionHand.MAIN_HAND);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 10.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 2.0, 2.0));
        for (LivingEntity hurt : list) {
            if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)0.5f, (boolean)false, (float)0.0f);
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268549_)) {
            return super.m_6469_(damagesource, amount / 3.0f);
        }
        if (!this.m_21525_() && this.m_5912_() && this.isDamageSourceBlocks(damagesource) && !this.m_21205_().m_41619_() && this.isAngryTick() && this.f_20919_ == 0 && this.shieldAttackTick <= 0 && this.specialBlockTick <= 0) {
            this.leadAnimationState.m_216973_();
            this.specialBlockTick = 5;
            int attackDamage = (int)this.m_21133_(Attributes.f_22281_) * 10;
            if (attackDamage < 2) {
                attackDamage = 2;
            }
            if ((double)this.f_19796_.m_216339_(1, attackDamage) > (double)amount * 3.5) {
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SEDIMENT_LORD_BLOCK, this.m_5720_(), 10.0f, 1.0f);
                }
                if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
                    ItemStack hand = this.m_21205_();
                    hand.m_41622_((int)amount / 3, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
                }
                return false;
            }
        }
        this.shieldAttackTick = 0;
        this.shieldAttackAnimationState.m_216973_();
        this.m_9236_().m_7605_((Entity)this, (byte)14);
        if (damagesource.m_269533_(DamageTypeTags.f_268490_)) {
            return super.m_6469_(damagesource, amount / 2.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (this.shieldAttackTick <= -20) {
            this.shieldAttackTick = 60;
            this.m_9236_().m_7605_((Entity)this, (byte)13);
        }
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19620_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 4) {
            int attackRandom = this.f_19796_.m_188503_(30);
            this.block1AnimationState.m_216973_();
            this.block2AnimationState.m_216973_();
            this.block3AnimationState.m_216973_();
            if (this.m_21205_().m_41619_()) {
                if (attackRandom < 20) {
                    this.attack1AnimationState.m_216977_(this.f_19797_);
                } else {
                    this.attack2AnimationState.m_216977_(this.f_19797_);
                }
            } else if (attackRandom > 20) {
                this.swordAttack1AnimationState.m_216977_(this.f_19797_);
            } else if (attackRandom > 10) {
                this.swordAttack2AnimationState.m_216977_(this.f_19797_);
            } else if (attackRandom > 5) {
                this.swordAttack3AnimationState.m_216977_(this.f_19797_);
            } else {
                this.swordAttack4AnimationState.m_216977_(this.f_19797_);
            }
        } else if (by == 11) {
            this.leadTick = OtherMainConfig.SedimentLordLeadCooldown * 20.0;
            this.leadAnimationState.m_216977_(this.f_19797_);
        } else if (by == 12) {
            this.specialBlockTick = 5;
            int blockRandom = this.f_19796_.m_188503_(30);
            if (blockRandom > 20) {
                this.block1AnimationState.m_216977_(this.f_19797_);
            } else if (blockRandom > 10) {
                this.block2AnimationState.m_216977_(this.f_19797_);
            } else {
                this.block3AnimationState.m_216977_(this.f_19797_);
            }
        } else if (by == 13) {
            this.shieldAttackTick = 60;
            this.shieldAttackAnimationState.m_216977_(this.f_19797_);
        } else if (by == 14) {
            this.shieldAttackTick = 0;
        } else if (by == 15) {
            this.startAnimationState.m_216977_(this.f_19797_);
        } else if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        if ((double)weaponRandom > 0.65) {
            return new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_GREATSWORD.get());
        }
        if ((double)weaponRandom > 0.35) {
            return new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_BATTLE_AXE.get());
        }
        return new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_WARHAMMER.get());
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0) {
            if (this.m_21205_().m_41619_()) {
                this.dead1AnimationState.m_216977_(this.f_19797_);
            } else {
                this.dead2AnimationState.m_216977_(this.f_19797_);
            }
        }
        ++this.f_20919_;
        this.startAnimationState.m_216973_();
        this.attack1AnimationState.m_216973_();
        this.attack2AnimationState.m_216973_();
        this.swordAttack1AnimationState.m_216973_();
        this.swordAttack2AnimationState.m_216973_();
        this.swordAttack3AnimationState.m_216973_();
        this.swordAttack4AnimationState.m_216973_();
        this.leadAnimationState.m_216973_();
        this.block1AnimationState.m_216973_();
        this.block2AnimationState.m_216973_();
        this.block3AnimationState.m_216973_();
        this.idleAnimationState.m_216973_();
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

