/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesParticleTypes;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Animal.RamblerEntity;
import com.jerotes.jerotesvillage.entity.in.ToughEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ProsperousEnvoyEntity
extends RamblerEntity
implements BossEntity,
ToughEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState trampleAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOVE_ABOUT = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TOUGH_TICK = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> TOUGH_DAMAGE = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_TOUGH = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TRAMPLE_TICK = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RUSH_TICK = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(ProsperousEnvoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.GREEN, false);
    private double blockDestroyTick;
    public int start = -101;
    private float health1 = 1.0f;
    public float rushFindXRot;
    public float rushFindYRot;

    public ProsperousEnvoyEntity(EntityType entityType, Level level) {
        super((EntityType<? extends RamblerEntity>)entityType, level);
        this.m_274367_(2.1f);
        this.f_21364_ = 300;
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.ProsperousEnvoyMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.ProsperousEnvoyMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.ProsperousEnvoyArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.ProsperousEnvoyMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.ProsperousEnvoyAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.ProsperousEnvoyKnockbackResistance);
        }
        if (level.m_5776_()) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.ProsperousEnvoyMagicAttackPercentage;
        }
        return (float)OtherMainConfig.ProsperousEnvoyAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.ProsperousEnvoyDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.ProsperousEnvoyDamageCooldownTick * base;
    }

    public int m_213860_() {
        return 300;
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.start > 0) {
            this.bossEvent.m_142711_(this.health1 / this.m_21233_());
            this.health1 += (this.m_21223_() - this.health1) / 60.0f;
        } else {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 225.0);
        builder = builder.m_22268_(Attributes.f_22281_, 12.0);
        builder = builder.m_22268_(Attributes.f_22284_, 12.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.26);
        builder = builder.m_22268_(Attributes.f_22282_, 1.4);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.PROSPEROUS_ENVOY_AMBIENT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.PROSPEROUS_ENVOY_DEATH;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.PROSPEROUS_ENVOY_HURT;
    }

    @Override
    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.PROSPEROUS_ENVOY_WALK, 0.15f, 1.0f);
    }

    @Override
    protected float m_6121_() {
        return 5.0f;
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.5 && this.m_217043_().m_188503_(5) == 1 && this.getRushTick() > 0;
    }

    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.specialAction()) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.PROSPEROUS_ENVOY_MUSIC;
    }

    public boolean m_6060_() {
        if (this.isTough()) {
            return false;
        }
        return super.m_6060_();
    }

    public int m_8085_() {
        return 35;
    }

    public int m_8132_() {
        return 30;
    }

    @Override
    @Nullable
    public ProsperousEnvoyEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (ProsperousEnvoyEntity)((EntityType)JerotesVillageEntityType.PROSPEROUS_ENVOY.get()).m_20615_((Level)serverLevel);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 2.3f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public boolean m_6162_() {
        return false;
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.85, 0.85, 0.85);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    public boolean specialAction() {
        return this.getTrampleTick() > 0 || this.getRushTick() > 0;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setMoveAbout(int n) {
        this.m_20088_().m_135381_(MOVE_ABOUT, (Object)n);
    }

    public int getMoveAbout() {
        return (Integer)this.m_20088_().m_135370_(MOVE_ABOUT);
    }

    public void setTrampleTick(int n) {
        this.m_20088_().m_135381_(TRAMPLE_TICK, (Object)n);
    }

    public int getTrampleTick() {
        return (Integer)this.m_20088_().m_135370_(TRAMPLE_TICK);
    }

    public void setRushTick(int n) {
        this.m_20088_().m_135381_(RUSH_TICK, (Object)n);
    }

    public int getRushTick() {
        return (Integer)this.m_20088_().m_135370_(RUSH_TICK);
    }

    public void setToughDamage(float f) {
        this.m_20088_().m_135381_(TOUGH_DAMAGE, (Object)Float.valueOf(f));
    }

    public float getToughDamage() {
        return ((Float)this.m_20088_().m_135370_(TOUGH_DAMAGE)).floatValue();
    }

    @Override
    public boolean isTough() {
        return (Boolean)this.m_20088_().m_135370_(IS_TOUGH) != false && this.m_6084_();
    }

    public void setTough(boolean bl) {
        this.m_20088_().m_135381_(IS_TOUGH, (Object)bl);
    }

    public void setToughTick(int n) {
        this.m_20088_().m_135381_(TOUGH_TICK, (Object)n);
    }

    public int getToughTick() {
        return (Integer)this.m_20088_().m_135370_(TOUGH_TICK);
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "trample")) {
            return 4;
        }
        if (Objects.equals(animation, "dead")) {
            return 5;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.trampleAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128379_("Tough", this.isTough());
        compoundTag.m_128405_("ToughTick", this.getToughTick());
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        compoundTag.m_128405_("Start", this.start);
        compoundTag.m_128350_("Health1", this.health1);
        compoundTag.m_128350_("ToughDamage", this.getToughDamage());
        compoundTag.m_128405_("TrampleTick", this.getTrampleTick());
        compoundTag.m_128405_("RushTick", this.getRushTick());
        compoundTag.m_128405_("MoveAbout", this.getMoveAbout());
        compoundTag.m_128347_("RushFindXRot", (double)this.rushFindXRot);
        compoundTag.m_128347_("RushFindYRot", (double)this.rushFindYRot);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setTough(compoundTag.m_128471_("Tough"));
        this.setToughTick(compoundTag.m_128451_("ToughTick"));
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.start = compoundTag.m_128451_("Start");
        this.health1 = compoundTag.m_128457_("Health1");
        this.setToughDamage(compoundTag.m_128457_("ToughDamage"));
        this.bossEvent.setId(this.m_20148_());
        this.setTrampleTick(compoundTag.m_128451_("TrampleTick"));
        this.setRushTick(compoundTag.m_128451_("RushTick"));
        this.setMoveAbout(compoundTag.m_128451_("MoveAbout"));
        this.rushFindXRot = compoundTag.m_128457_("RushFindXRot");
        this.rushFindYRot = compoundTag.m_128457_("RushFindYRot");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(TRAMPLE_TICK, (Object)0);
        this.m_20088_().m_135372_(RUSH_TICK, (Object)0);
        this.m_20088_().m_135372_(TOUGH_DAMAGE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(IS_TOUGH, (Object)false);
        this.m_20088_().m_135372_(TOUGH_TICK, (Object)0);
        this.m_20088_().m_135372_(MOVE_ABOUT, (Object)0);
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.trampleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.trampleAnimationState);
                    break;
                }
                case 5: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughTick(Math.max(0, this.getToughTick() - 1));
        }
        if (this.getToughTick() > 0) {
            if (!this.isTough() && !this.m_9236_().m_5776_()) {
                this.setTough(true);
            }
        } else if (this.isTough() && !this.m_9236_().m_5776_()) {
            this.setTough(false);
        }
        if (this.isTough() && this.m_20094_() > 0) {
            this.m_20095_();
        }
    }

    @Override
    public void m_8107_() {
        Object aABB;
        ServerLevel serverLevel;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.bossEvent.update();
        if (this.m_217043_().m_188503_(240) == 1 && this.m_6084_()) {
            this.m_5634_(3.0f);
        }
        if ((double)this.f_267362_.m_267731_() >= 0.01) {
            if (!this.m_9236_().m_5776_()) {
                this.setMoveAbout(Math.min(20, this.getMoveAbout() + 1));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setMoveAbout(Math.max(-20, this.getMoveAbout() - 1));
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.start > 0) {
            --this.start;
        } else if (this.start == 0) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.PROSPEROUS_ENVOY_AMBIENT, 10.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 660, 1));
            }
            this.start = -1;
        } else if (this.start > -100) {
            --this.start;
        }
        if (this.start <= -100) {
            this.start = -101;
        }
        if (this.getAttackTick() == 5 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.getAttackTick() > 0) {
            if (this.m_5448_() != null && this.getAttackTick() > 8) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            }
            this.m_21573_().m_26573_();
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-((int)(OtherMainConfig.ProsperousEnvoyMeleeAttackCooldown * 20.0)), this.getAttackTick() - 1));
            this.setTrampleTick(Math.max(0, this.getTrampleTick() - 1));
        }
        if (this.getTrampleTick() > 0) {
            livingEntity = this.m_9236_();
            if (livingEntity instanceof ServerLevel) {
                serverLevel = (ServerLevel)livingEntity;
                for (int i = 0; i < 6; ++i) {
                    if (this.m_20075_().m_60734_() instanceof AirBlock) continue;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), this.m_20208_(1.0), this.m_20227_(0.1f), this.m_20262_(1.0), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.getTrampleTick() == 25) {
                this.TrampleAttack();
            }
        }
        if (this.getRushTick() > -((int)(OtherMainConfig.ProsperousEnvoyProsperousRushTime * 20.0 * 5.0)) && this.m_6084_()) {
            if (!this.m_9236_().m_5776_()) {
                this.setRushTick(this.getRushTick() - 1);
            }
            if (this.getRushTick() > 0) {
                if (this.getRushTick() > (int)(OtherMainConfig.ProsperousEnvoyProsperousRushTime * 20.0 - 20.0)) {
                    if (this.m_5448_() != null) {
                        this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                        this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    }
                } else if (this.getRushTick() == (int)(OtherMainConfig.ProsperousEnvoyProsperousRushTime * 20.0 - 20.0)) {
                    if (this.m_5448_() != null) {
                        this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                        this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    }
                    this.rushFindXRot = this.m_146909_();
                    this.rushFindYRot = this.m_6080_();
                } else {
                    if (this.getRushTick() > (int)(OtherMainConfig.ProsperousEnvoyProsperousRushTime * 20.0 - 25.0)) {
                        if (this.m_5448_() != null) {
                            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                        }
                        this.rushFindXRot = this.m_146909_();
                        this.rushFindYRot = this.m_6080_();
                    }
                    if (this.getRushTick() % 5 == 0 && !this.m_9236_().m_5776_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                        boolean bl = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
                        aABB = this.m_20191_().m_82400_(1.0).m_82386_(0.0, 1.0, 0.0);
                        for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)((AABB)aABB).f_82288_), (int)Mth.m_14107_((double)((AABB)aABB).f_82289_), (int)Mth.m_14107_((double)((AABB)aABB).f_82290_), (int)Mth.m_14107_((double)((AABB)aABB).f_82291_), (int)Mth.m_14107_((double)((AABB)aABB).f_82292_), (int)Mth.m_14107_((double)((AABB)aABB).f_82293_))) {
                            BlockState blockState = this.m_9236_().m_8055_(blockPos);
                            float block = blockState.m_60800_((BlockGetter)this.m_9236_(), blockPos);
                            if (block >= 5.0f || block < 0.0f || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockPos, (BlockState)blockState)) continue;
                            if ((blockState.m_204336_(BlockTags.f_278411_) || blockState.m_204336_(BlockTags.f_144274_) || blockState.m_204336_(BlockTags.f_215823_) || blockState.m_204336_(BlockTags.f_144266_)) && (double)this.m_217043_().m_188501_() > 0.05) {
                                bl = this.m_9236_().m_46953_(blockPos, false, (Entity)this) || bl;
                                continue;
                            }
                            bl = this.m_9236_().m_46953_(blockPos, true, (Entity)this) || bl;
                        }
                    }
                    this.RushAttack();
                    List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
                    for (LivingEntity shake : listShake) {
                        if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                        shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
                    }
                }
            }
        }
        if (this.getRushTick() <= -((int)(OtherMainConfig.ProsperousEnvoyProsperousRushTime * 20.0)) * 5 && this.m_5448_() != null && !this.m_21525_() && this.getRushTick() <= 0 && !this.m_292684_().m_82381_(this.m_5448_().m_20191_())) {
            if (!this.m_9236_().m_5776_()) {
                this.setRushTick((int)(OtherMainConfig.ProsperousEnvoyProsperousRushTime * 20.0));
            }
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.rushFindXRot = this.m_146909_();
            this.rushFindYRot = this.m_6080_();
            aABB = this.m_9236_();
            if (aABB instanceof ServerLevel) {
                serverLevel = (ServerLevel)aABB;
                if (!this.m_20145_()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.PROSPEROUS_RUSH_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        List listRambler = this.m_9236_().m_45976_(RamblerEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        int strength = Math.min(30, listRambler.size());
        if (this.f_19797_ % 3 == 0 && this.m_9236_().m_5776_()) {
            for (int i = 0; i < strength; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_276452_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)5.0f);
            if (blockDestroy) {
                this.blockDestroyTick = OtherMainConfig.ProsperousEnvoyBreakBlockCooldown * 20.0;
            }
            if (!this.m_9236_().m_5776_() && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        Level level;
        if (this.specialAction() || this.getAttackTick() > -((int)(OtherMainConfig.ProsperousEnvoyMeleeAttackCooldown * 20.0))) {
            return false;
        }
        if ((double)this.m_217043_().m_188501_() > OtherMainConfig.ProsperousEnvoyProsperousTrampleChance) {
            if (!this.m_9236_().m_5776_()) {
                this.setAttackTick(10);
                this.setAnimTick(10);
                int attackRandom = this.m_217043_().m_188503_(30);
                if (attackRandom > 20) {
                    this.setAnimationState("attack1");
                } else if (attackRandom < 10) {
                    this.setAnimationState("attack2");
                } else {
                    this.setAnimationState("attack3");
                }
            }
            return true;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(0);
            this.setTrampleTick(40);
            this.setAnimTick(20);
            this.setAnimationState("trample");
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.m_20145_()) {
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.PROSPEROUS_TRAMPLE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return true;
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.PROSPEROUS_ENVOY_ATTACK, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        List listRambler = this.m_9236_().m_45976_(RamblerEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        int strength = Math.min(30, listRambler.size());
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82377_(0.25, 0.25, 0.25));
        for (LivingEntity hurt : list) {
            Level level;
            RamblerEntity rambler;
            if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this) || hurt instanceof RamblerEntity && (rambler = (RamblerEntity)hurt).m_5448_() != this && this.m_5448_() != rambler) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
            if (!bl2) continue;
            if (hurt.m_21051_(Attributes.f_22278_) != null) {
                double d2 = hurt.m_21133_(Attributes.f_22278_);
                double d3 = Math.max((double)((float)strength / 60.0f), 1.0 + (double)((float)strength / 60.0f) - d2);
                if (this.m_20096_() && hurt.m_20096_() && (Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt))) {
                    hurt.m_6853_(false);
                    hurt.m_5997_(-(this.m_20185_() - hurt.m_20185_()) * 0.8 * d3, 0.1 + (double)strength * 0.01, -(this.m_20189_() - hurt.m_20189_()) * 0.8 * d3);
                }
                if (!hurt.m_9236_().f_46443_ && Math.random() < 0.28) {
                    hurt.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 1));
                    hurt.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
                }
            }
            if (hurt.m_9236_().m_5776_()) continue;
            float anesthetizedTicks = 0.0f;
            double anesthetizedAdds = this.m_21133_(Attributes.f_22281_) * 6.0 * 20.0;
            if (anesthetizedAdds != 0.0 && (level = hurt.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesParticleTypes.ANESTHETIZED_VIII.get()), hurt.m_20208_(0.5), hurt.m_20187_(), hurt.m_20262_(0.5), 3, 0.0, 0.0, 0.0, 0.0);
            }
            if (hurt.m_21023_((MobEffect)JerotesMobEffects.ANESTHETIZED.get())) {
                anesthetizedTicks = hurt.m_21124_((MobEffect)JerotesMobEffects.ANESTHETIZED.get()).m_19557_();
            }
            if (anesthetizedAdds == 0.0 && anesthetizedTicks == 0.0f || EntityFactionFind.isMachine((LivingEntity)hurt) || EntityFactionFind.isConstruct((LivingEntity)hurt)) continue;
            hurt.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.ANESTHETIZED.get(), (int)(anesthetizedAdds + (double)anesthetizedTicks), 0));
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    @Override
    public void attackAnimation() {
    }

    public boolean TrampleAttack() {
        List listRambler = this.m_9236_().m_45976_(RamblerEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        int strength = Math.min(30, listRambler.size());
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.PROSPEROUS_ENVOY_TRAMPLE, this.m_5720_(), 10.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(0.5));
        for (Object attack : list) {
            RamblerEntity rambler;
            if (AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)attack) || !this.m_142582_((Entity)attack) || attack instanceof RamblerEntity && (rambler = (RamblerEntity)((Object)attack)).m_5448_() != this && this.m_5448_() != rambler) continue;
            if (attack.m_21051_(Attributes.f_22278_) != null) {
                double d2 = attack.m_21133_(Attributes.f_22278_);
                double d3 = Math.max((double)((float)strength / 60.0f), 1.0 + (double)((float)strength / 60.0f) - d2);
                if (this.m_20096_() && attack.m_20096_() && (Main.mobSizeSmall((Entity)attack) || Main.mobSizeMedium((Entity)attack))) {
                    attack.m_6853_(false);
                    attack.m_5997_(-(this.m_20185_() - attack.m_20185_()) * 0.8 * d3, 0.15 + (double)strength * 0.01, -(this.m_20189_() - attack.m_20189_()) * 0.8 * d3);
                }
            }
            AttackFind.attackBegin((LivingEntity)this, (Entity)attack);
            boolean bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)attack, (float)((float)(3.0 + (double)strength * 0.05)), (float)2.0f, (boolean)false, (float)0.0f);
            if (bl2) {
                if (attack.m_21051_(Attributes.f_22278_) != null) {
                    double d2 = attack.m_21133_(Attributes.f_22278_);
                    double d3 = Math.max((double)((float)strength / 60.0f), 1.0 + (double)((float)strength / 60.0f) - d2);
                    if (this.m_20096_() && attack.m_20096_() && (Main.mobSizeSmall((Entity)attack) || Main.mobSizeMedium((Entity)attack))) {
                        attack.m_6853_(false);
                        attack.m_5997_(-(this.m_20185_() - attack.m_20185_()) * 0.8 * d3, 0.2 + (double)strength * 0.01, -(this.m_20189_() - attack.m_20189_()) * 0.8 * d3);
                    }
                    if (!attack.m_9236_().f_46443_ && Math.random() < 0.28) {
                        attack.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 1));
                        attack.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
                    }
                }
                if (!attack.m_9236_().m_5776_()) {
                    Level level;
                    float anesthetizedTicks = 0.0f;
                    double anesthetizedAdds = this.m_21133_(Attributes.f_22281_) * 120.0 * 20.0;
                    if (anesthetizedAdds != 0.0 && (level = attack.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesParticleTypes.ANESTHETIZED_VIII.get()), attack.m_20208_(0.5), attack.m_20187_(), attack.m_20262_(0.5), 3, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (attack.m_21023_((MobEffect)JerotesMobEffects.ANESTHETIZED.get())) {
                        anesthetizedTicks = attack.m_21124_((MobEffect)JerotesMobEffects.ANESTHETIZED.get()).m_19557_();
                    }
                    if (!(attack.m_9236_().f_46443_ || anesthetizedAdds == 0.0 && anesthetizedTicks == 0.0f || EntityFactionFind.isMachine((LivingEntity)attack) || EntityFactionFind.isConstruct((LivingEntity)attack))) {
                        attack.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.ANESTHETIZED.get(), (int)(anesthetizedAdds + (double)anesthetizedTicks), 0));
                    }
                }
            }
            if (!(attack.m_21211_().m_41720_() instanceof ShieldItem)) continue;
            if (attack instanceof Player) {
                Player player = (Player)attack;
                player.m_36384_(true);
                continue;
            }
            if (!(attack instanceof UseShieldEntity)) continue;
            UseShieldEntity useShieldEntity = (UseShieldEntity)attack;
            useShieldEntity.disableShield();
        }
        List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
        for (LivingEntity shake : listShake) {
            if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
            shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
        }
        Main.sweepAttack((Entity)this);
        AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), (double)(Main.mobWidth((Entity)this) / 2.0f + 1.0f), (double)0.0, (double)(Main.mobWidth((Entity)this) / 2.0f + 1.0f));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
        return true;
    }

    public boolean RushAttack() {
        if (!this.m_9236_().m_5776_()) {
            this.m_146926_(this.rushFindXRot);
            this.m_146922_(this.rushFindYRot);
            this.m_5618_(this.rushFindYRot);
            this.m_5616_(this.rushFindYRot);
        }
        float f = this.m_146908_();
        float f2 = this.m_146909_();
        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = 0.3f;
        float f8 = f4 *= f7 / f6 * 2.0f;
        if (!this.m_20096_()) {
            f8 = 0.0f;
        }
        this.m_5997_(f3 *= f7 / f6 * 2.0f, f8, f5 *= f7 / f6 * 2.0f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 6; ++i) {
                if (this.m_20075_().m_60734_() instanceof AirBlock) continue;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), this.m_20208_(1.0), this.m_20227_(0.1f), this.m_20262_(1.0), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.getRushTick() % 5 == 0) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.PROSPEROUS_ENVOY_RUSH, 10.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(0.5));
            for (LivingEntity attack : list) {
                RamblerEntity rambler;
                if (AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)attack) || !this.m_142582_((Entity)attack) || attack instanceof RamblerEntity && (rambler = (RamblerEntity)attack).m_5448_() != this && this.m_5448_() != rambler) continue;
                AttackFind.attackBegin((LivingEntity)this, (Entity)attack);
                boolean bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)attack, (float)1.5f, (float)2.0f, (boolean)false, (float)0.0f);
                if (bl2 && !attack.m_9236_().m_5776_()) {
                    Level level2;
                    float anesthetizedTicks = 0.0f;
                    double anesthetizedAdds = this.m_21133_(Attributes.f_22281_) * 15.0 * 20.0;
                    if (anesthetizedAdds != 0.0 && (level2 = attack.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level2;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesParticleTypes.ANESTHETIZED_VIII.get()), attack.m_20208_(0.5), attack.m_20187_(), attack.m_20262_(0.5), 3, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (attack.m_21023_((MobEffect)JerotesMobEffects.ANESTHETIZED.get())) {
                        anesthetizedTicks = attack.m_21124_((MobEffect)JerotesMobEffects.ANESTHETIZED.get()).m_19557_();
                    }
                    if (!(attack.m_9236_().f_46443_ || anesthetizedAdds == 0.0 && anesthetizedTicks == 0.0f || EntityFactionFind.isMachine((LivingEntity)attack) || EntityFactionFind.isConstruct((LivingEntity)attack))) {
                        attack.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.ANESTHETIZED.get(), (int)(anesthetizedAdds + (double)anesthetizedTicks), 0));
                    }
                }
                Main.sweepAttack((Entity)this);
            }
        }
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (this.start > -100) {
            return true;
        }
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        List listRambler = this.m_9236_().m_45976_(RamblerEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        int strength = Math.min(30, listRambler.size());
        if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && this.isTough() && (double)amount <= (double)this.getToughDamage() * OtherMainConfig.ProsperousEnvoyBreakHurtCooldownMultiple) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughDamage(amount);
        }
        double toughBase = OtherMainConfig.ProsperousEnvoyHurtCooldown * 20.0;
        float toughMultiple = 0.5f;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            toughMultiple = 1.0f;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            toughMultiple = 1.5f;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughTick((int)(toughBase * (double)toughMultiple));
        }
        return super.m_6469_(damageSource, amount * (1.0f - (float)strength * 0.01f));
    }

    public void m_7822_(byte by) {
        if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(40);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                    AABB aABB = this.m_20191_().m_82400_(4.0).m_82386_(0.0, -2.0, 0.0);
                    for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aABB.f_82288_), (int)Mth.m_14107_((double)aABB.f_82289_), (int)Mth.m_14107_((double)aABB.f_82290_), (int)Mth.m_14107_((double)aABB.f_82291_), (int)Mth.m_14107_((double)aABB.f_82292_), (int)Mth.m_14107_((double)aABB.f_82293_))) {
                        if (!BoneMealItem.m_40627_((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)serverLevel, (BlockPos)blockPos) && !BoneMealItem.m_40631_((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)serverLevel, (BlockPos)blockPos, null) || serverLevel.m_5776_()) continue;
                        serverLevel.m_46796_(1505, blockPos, 0);
                    }
                }
            }
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

