/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Monster.Resurrecter.ResurrecterEntity;
import com.jerotes.jerotesvillage.entity.Shoot.Arrow.AncientSecondRounderArrowEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SedimentLordEntity
extends ResurrecterEntity
implements BossEntity,
SpellUseEntity {
    public AnimationState startAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState swordAttack1AnimationState = new AnimationState();
    public AnimationState swordAttack2AnimationState = new AnimationState();
    public AnimationState swordAttack3AnimationState = new AnimationState();
    public AnimationState swordAttack4AnimationState = new AnimationState();
    public AnimationState leadAnimationState = new AnimationState();
    public AnimationState block1AnimationState = new AnimationState();
    public AnimationState block2AnimationState = new AnimationState();
    public AnimationState block3AnimationState = new AnimationState();
    public AnimationState shieldAttackAnimationState = new AnimationState();
    public AnimationState dead1AnimationState = new AnimationState();
    public AnimationState dead2AnimationState = new AnimationState();
    public AnimationState pushingAttackAnimationState = new AnimationState();
    public AnimationState tripAttackAnimationState = new AnimationState();
    public AnimationState precisionAttackAnimationState = new AnimationState();
    public AnimationState sweepingAttackAnimationState = new AnimationState();
    public AnimationState menacingAttackAnimationState = new AnimationState();
    public AnimationState maneuveringAttackAnimationState = new AnimationState();
    public AnimationState lungingAttackAnimationState = new AnimationState();
    public AnimationState goadingAttackAnimationState = new AnimationState();
    public AnimationState feintingAttackAnimationState = new AnimationState();
    public AnimationState disarmingAttackAnimationState = new AnimationState();
    public AnimationState distractingStrikeAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.BLUE, false);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_WALK_ANIM = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ACTION_SURGE = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECIAL_ATTACK_COOLDOWN = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECIAL_ATTACK_TICK = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECIAL_ATTACK_USE = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEAD_TICK = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEAD_USE_TICK = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHIELD_ATTACK_TICK = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECIAL_BLOCK_TICK = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(SedimentLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int spellLevel = 4;
    public int startTick;

    public SedimentLordEntity(EntityType<? extends SedimentLordEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.1f);
        this.f_21364_ = 300;
        this.m_21553_(true);
        this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21348_[EquipmentSlot.CHEST.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21348_[EquipmentSlot.LEGS.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21348_[EquipmentSlot.FEET.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        this.f_21347_[EquipmentSlot.OFFHAND.m_20749_()] = (float)OtherMainConfig.SedimentLordDropEquipmentChance;
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.SedimentLordMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.SedimentLordMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.SedimentLordArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.SedimentLordMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.SedimentLordAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.SedimentLordKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.SedimentLordMagicAttackPercentage;
        }
        return (float)OtherMainConfig.SedimentLordAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.SedimentLordDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.SedimentLordDamageCooldownTick * base;
    }

    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.canEquip(EquipmentSlot.HEAD, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.CHEST, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.LEGS, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.FEET, (Entity)this)) {
            return false;
        }
        return super.m_7243_(itemStack);
    }

    @Override
    protected boolean m_7808_(ItemStack newItem, ItemStack oldItem) {
        if (newItem.m_41720_() instanceof BowItem) {
            return false;
        }
        if (newItem.m_41720_() instanceof CrossbowItem) {
            return false;
        }
        if (newItem.m_41720_() instanceof ShieldItem) {
            return false;
        }
        return super.m_7808_(newItem, oldItem);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_HELMET.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_CHESTPLATE.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_LEGGINGS.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_BOOTS.get()), randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        this.m_8061_(equipmentSlot, itemStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 170.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22282_, 0.4);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.SEDIMENT_LORD_AMBIENT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SEDIMENT_LORD_DEATH;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.SEDIMENT_LORD_HURT;
    }

    public boolean m_21526_() {
        return false;
    }

    public boolean canUseCrossbow() {
        return false;
    }

    public boolean canUseThrow() {
        return false;
    }

    public boolean canUseRangeJavelin() {
        return false;
    }

    public boolean canUseBow() {
        return false;
    }

    @Override
    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        if (!this.m_21205_().m_41619_()) {
            return aabb1.m_82377_(0.75, 0.75, 0.75);
        }
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    @Override
    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    protected float m_6121_() {
        return 5.0f;
    }

    @Override
    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.specialAction()) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    public boolean m_21254_() {
        if (this.getSpecialBlockTick() > 4) {
            return true;
        }
        return super.m_21254_();
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.BOSS_MUSIC_1;
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    public int getActionSurge() {
        return (Integer)this.m_20088_().m_135370_(ACTION_SURGE);
    }

    public void setActionSurge(int n) {
        this.m_20088_().m_135381_(ACTION_SURGE, (Object)n);
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setSpecialAttackCooldown(int n) {
        this.m_20088_().m_135381_(SPECIAL_ATTACK_COOLDOWN, (Object)n);
    }

    public int getSpecialAttackCooldown() {
        return (Integer)this.m_20088_().m_135370_(SPECIAL_ATTACK_COOLDOWN);
    }

    public void setSpecialAttackTick(int n) {
        this.m_20088_().m_135381_(SPECIAL_ATTACK_TICK, (Object)n);
    }

    public int getSpecialAttackTick() {
        return (Integer)this.m_20088_().m_135370_(SPECIAL_ATTACK_TICK);
    }

    public void setSpecialAttackUse(int n) {
        this.m_20088_().m_135381_(SPECIAL_ATTACK_USE, (Object)n);
    }

    public int getSpecialAttackUse() {
        return (Integer)this.m_20088_().m_135370_(SPECIAL_ATTACK_USE);
    }

    public void setLeadTick(int n) {
        this.m_20088_().m_135381_(LEAD_TICK, (Object)n);
    }

    public int getLeadTick() {
        return (Integer)this.m_20088_().m_135370_(LEAD_TICK);
    }

    public void setLeadUseTick(int n) {
        this.m_20088_().m_135381_(LEAD_USE_TICK, (Object)n);
    }

    public int getLeadUseTick() {
        return (Integer)this.m_20088_().m_135370_(LEAD_USE_TICK);
    }

    public void setShieldAttackTick(int n) {
        this.m_20088_().m_135381_(SHIELD_ATTACK_TICK, (Object)n);
    }

    public int getShieldAttackTick() {
        return (Integer)this.m_20088_().m_135370_(SHIELD_ATTACK_TICK);
    }

    public void setSpecialBlockTick(int n) {
        this.m_20088_().m_135381_(SPECIAL_BLOCK_TICK, (Object)n);
    }

    public int getSpecialBlockTick() {
        return (Integer)this.m_20088_().m_135370_(SPECIAL_BLOCK_TICK);
    }

    public boolean specialAction() {
        return this.getLeadUseTick() > 0 || this.getShieldAttackTick() > 0 || this.getSpecialAttackTick() > 0 || this.startTick > 0;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setAttackWalkAnim(int n) {
        this.m_20088_().m_135381_(ATTACK_WALK_ANIM, (Object)n);
    }

    public int getAttackWalkAnim() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_WALK_ANIM);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "start")) {
            return 1;
        }
        if (Objects.equals(animation, "attack1")) {
            return 2;
        }
        if (Objects.equals(animation, "attack2")) {
            return 3;
        }
        if (Objects.equals(animation, "swordAttack1")) {
            return 4;
        }
        if (Objects.equals(animation, "swordAttack2")) {
            return 5;
        }
        if (Objects.equals(animation, "swordAttack3")) {
            return 6;
        }
        if (Objects.equals(animation, "swordAttack4")) {
            return 7;
        }
        if (Objects.equals(animation, "lead")) {
            return 8;
        }
        if (Objects.equals(animation, "block1")) {
            return 9;
        }
        if (Objects.equals(animation, "block2")) {
            return 10;
        }
        if (Objects.equals(animation, "block3")) {
            return 11;
        }
        if (Objects.equals(animation, "shieldAttack")) {
            return 12;
        }
        if (Objects.equals(animation, "dead1")) {
            return 13;
        }
        if (Objects.equals(animation, "dead2")) {
            return 14;
        }
        if (Objects.equals(animation, "pushingAttack")) {
            return 15;
        }
        if (Objects.equals(animation, "tripAttack")) {
            return 16;
        }
        if (Objects.equals(animation, "precisionAttack")) {
            return 17;
        }
        if (Objects.equals(animation, "sweepingAttack")) {
            return 18;
        }
        if (Objects.equals(animation, "menacingAttack")) {
            return 19;
        }
        if (Objects.equals(animation, "maneuveringAttack")) {
            return 20;
        }
        if (Objects.equals(animation, "lungingAttack")) {
            return 21;
        }
        if (Objects.equals(animation, "goadingAttack")) {
            return 22;
        }
        if (Objects.equals(animation, "feintingAttack")) {
            return 23;
        }
        if (Objects.equals(animation, "disarmingAttack")) {
            return 24;
        }
        if (Objects.equals(animation, "distractingStrike")) {
            return 25;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.startAnimationState);
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.swordAttack1AnimationState);
        list.add(this.swordAttack2AnimationState);
        list.add(this.swordAttack3AnimationState);
        list.add(this.swordAttack4AnimationState);
        list.add(this.leadAnimationState);
        list.add(this.block1AnimationState);
        list.add(this.block2AnimationState);
        list.add(this.block3AnimationState);
        list.add(this.shieldAttackAnimationState);
        list.add(this.dead1AnimationState);
        list.add(this.dead2AnimationState);
        list.add(this.pushingAttackAnimationState);
        list.add(this.tripAttackAnimationState);
        list.add(this.precisionAttackAnimationState);
        list.add(this.sweepingAttackAnimationState);
        list.add(this.menacingAttackAnimationState);
        list.add(this.maneuveringAttackAnimationState);
        list.add(this.lungingAttackAnimationState);
        list.add(this.goadingAttackAnimationState);
        list.add(this.feintingAttackAnimationState);
        list.add(this.disarmingAttackAnimationState);
        list.add(this.distractingStrikeAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("AttackWalkAnim", this.getAttackWalkAnim());
        compoundTag.m_128405_("ActionSurge", this.getActionSurge());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("StartTick", this.startTick);
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("SpecialAttackCooldown", this.getSpecialAttackCooldown());
        compoundTag.m_128405_("SpecialAttackTick", this.getSpecialAttackTick());
        compoundTag.m_128405_("SpecialAttackUse", this.getSpecialAttackUse());
        compoundTag.m_128405_("LeadTick", this.getLeadTick());
        compoundTag.m_128405_("LeadUseTick", this.getLeadUseTick());
        compoundTag.m_128405_("SpecialBlockTick", this.getSpecialBlockTick());
        compoundTag.m_128405_("ShieldAttackTick", this.getShieldAttackTick());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.startTick = compoundTag.m_128451_("StartTick");
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setActionSurge(compoundTag.m_128451_("ActionSurge"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setAttackWalkAnim(compoundTag.m_128451_("AttackWalkAnim"));
        this.setSpecialAttackCooldown(compoundTag.m_128451_("SpecialAttackCooldown"));
        this.setSpecialAttackTick(compoundTag.m_128451_("SpecialAttackTick"));
        this.setSpecialAttackUse(compoundTag.m_128451_("SpecialAttackUse"));
        this.setLeadTick(compoundTag.m_128451_("LeadTick"));
        this.setLeadUseTick(compoundTag.m_128451_("LeadUseTick"));
        this.setSpecialBlockTick(compoundTag.m_128451_("SpecialBlockTick"));
        this.setShieldAttackTick(compoundTag.m_128451_("ShieldAttackTick"));
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_WALK_ANIM, (Object)0);
        this.m_20088_().m_135372_(ACTION_SURGE, (Object)0);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(SPECIAL_ATTACK_COOLDOWN, (Object)0);
        this.m_20088_().m_135372_(SPECIAL_ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(SPECIAL_ATTACK_USE, (Object)0);
        this.m_20088_().m_135372_(LEAD_TICK, (Object)((int)(OtherMainConfig.SedimentLordLeadCooldown * 18.0)));
        this.m_20088_().m_135372_(LEAD_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(SPECIAL_BLOCK_TICK, (Object)0);
        this.m_20088_().m_135372_(SHIELD_ATTACK_TICK, (Object)-20);
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.startAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.startAnimationState);
                    break;
                }
                case 2: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 3: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 4: {
                    this.swordAttack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack1AnimationState);
                    break;
                }
                case 5: {
                    this.swordAttack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack2AnimationState);
                    break;
                }
                case 6: {
                    this.swordAttack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack3AnimationState);
                    break;
                }
                case 7: {
                    this.swordAttack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.swordAttack4AnimationState);
                    break;
                }
                case 8: {
                    this.leadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.leadAnimationState);
                    break;
                }
                case 9: {
                    this.block1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.block2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.block3AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.shieldAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shieldAttackAnimationState);
                    break;
                }
                case 13: {
                    this.dead1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.dead1AnimationState);
                    break;
                }
                case 14: {
                    this.dead2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.dead2AnimationState);
                    break;
                }
                case 15: {
                    this.pushingAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.pushingAttackAnimationState);
                    break;
                }
                case 16: {
                    this.tripAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.tripAttackAnimationState);
                    break;
                }
                case 17: {
                    this.precisionAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.precisionAttackAnimationState);
                    break;
                }
                case 18: {
                    this.sweepingAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.sweepingAttackAnimationState);
                    break;
                }
                case 19: {
                    this.menacingAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.menacingAttackAnimationState);
                    break;
                }
                case 20: {
                    this.maneuveringAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.maneuveringAttackAnimationState);
                    break;
                }
                case 21: {
                    this.lungingAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.lungingAttackAnimationState);
                    break;
                }
                case 22: {
                    this.goadingAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.goadingAttackAnimationState);
                    break;
                }
                case 23: {
                    this.feintingAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.feintingAttackAnimationState);
                    break;
                }
                case 24: {
                    this.disarmingAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.disarmingAttackAnimationState);
                    break;
                }
                case 25: {
                    this.distractingStrikeAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.distractingStrikeAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.update();
        if (this.specialAction()) {
            this.m_21573_().m_26573_();
        }
        if (this.startTick > 0) {
            if (this.startTick == 40) {
                this.setAnimTick(40);
                this.setAnimationState("start");
            }
            --this.startTick;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(0, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() == 15 && this.m_6084_() && this.getSpecialAttackTick() <= 0) {
            this.trueHurt();
        }
        if (this.getSpecialAttackTick() == 10 && this.m_6084_()) {
            this.trueHurtSpecial(this.getSpecialAttackUse());
        }
        if ((this.getAttackTick() > 18 || this.getSpecialAttackTick() > 15) && this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_5912_() && !this.m_21205_().m_41619_() && !this.specialAction() && this.getAttackTick() <= 0 && this.getSpecialAttackTick() <= 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setAttackWalkAnim(Math.min(this.getAttackWalkAnim() + 1, 10));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setAttackWalkAnim(Math.max(this.getAttackWalkAnim() - 1, 0));
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.m_6084_()) {
            ServerLevel serverLevel;
            Level level;
            List listLord = this.m_9236_().m_45976_(SedimentLordEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
            listLord.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
            List listResurrect = this.m_9236_().m_45976_(ResurrecterEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
            listResurrect.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
            if (this.getLeadTick() >= (int)(OtherMainConfig.SedimentLordLeadCooldown * 20.0) && this.spellNeed(2.0f, 32.0f, 1) && listResurrect.size() < listLord.size() * 8 && !this.m_9236_().m_5776_()) {
                this.setLeadUseTick(25);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                }
            }
            if (this.getLeadUseTick() == 25 && !this.m_9236_().m_5776_()) {
                this.setLeadTick(0);
                this.setAnimTick(25);
                this.setAnimationState("lead");
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                }
            }
            if (this.getLeadUseTick() == 15) {
                OtherSpellFind.SedimentOrder((LivingEntity)this, this.m_5448_(), this.getSpellLevel(), this.getSpellLevel() + 2, 4, 32);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SEDIMENT_LORD_LEAD, this.m_5720_(), 10.0f, 1.0f);
                }
            }
            if (this.getShieldAttackTick() < 60 && this.getShieldAttackTick() > 0 && this.getShieldAttackTick() % 5 == 0) {
                this.shieldAttack();
            }
            if (this.spellNeed(3.0f, 6.0f, 6) && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.getAttackTick() <= 0 && this.getActionSurge() <= 0 && this.getSpecialAttackCooldown() <= 0 && !this.m_9236_().m_5776_()) {
                this.setAttackTick(20);
                this.setSpecialAttackCooldown(120);
                this.setSpecialAttackTick(20);
                this.setAnimTick(20);
                this.setSpecialAttackUse(7);
                this.setAnimationState("lungingAttack");
                level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    if (!this.m_20145_()) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.LUNGING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.getSpecialAttackTick() == 13 && this.getSpecialAttackUse() == 7 && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
                this.m_20219_(this.m_5448_().m_20318_(0.0f));
            }
            if (this.getSpecialAttackTick() > 0 && this.getSpecialAttackUse() == 7 && (level = this.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                for (int i = 0; i < 20; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.25) - this.m_20184_().f_82479_, this.m_20187_() - 0.5 - this.m_20184_().f_82480_, this.m_20262_(0.25) - this.m_20184_().f_82481_, 0, this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_, -0.5);
                }
            }
            if (!this.m_9236_().m_5776_()) {
                this.setSpecialAttackTick(Math.max(0, this.getSpecialAttackTick() - 1));
                this.setSpecialAttackCooldown(Math.max(0, this.getSpecialAttackCooldown() - 1));
                this.setLeadTick(Math.min((int)(OtherMainConfig.SedimentLordLeadCooldown * 20.0), this.getLeadTick() + 1));
                this.setLeadUseTick(Math.max(0, this.getLeadUseTick() - 1));
                this.setSpecialBlockTick(Math.max(0, this.getSpecialBlockTick() - 1));
                this.setShieldAttackTick(Math.max(-20, this.getShieldAttackTick() - 1));
            }
        }
    }

    public boolean spellNeed(float min, float max, int time) {
        return !this.specialAction() && this.m_6084_() && !this.m_21525_() && this.getAttackTick() <= 0 && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_().m_20270_((Entity)this) > min && this.m_5448_().m_20270_((Entity)this) < max && this.m_217043_().m_188503_(time * 20) == 1;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.specialAction() || this.getAttackTick() > 0 && this.getActionSurge() <= 0 || this.getAttackTick() > 5) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            int attackRandom = Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)40);
            if (this.getActionSurge() <= 0 && this.getSpecialAttackCooldown() <= 0 && this.m_217043_().m_188501_() > 0.5f) {
                this.setSpecialAttackCooldown(120);
                this.setSpecialAttackTick(20);
                this.setAnimTick(20);
                if (attackRandom > 36) {
                    this.setSpecialAttackUse(1);
                    this.setAnimationState("pushingAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.PUSHING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 32) {
                    this.setSpecialAttackUse(2);
                    this.setAnimationState("tripAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.TRIP_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 28) {
                    this.setSpecialAttackUse(3);
                    this.setAnimationState("precisionAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.PRECISION_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 24) {
                    this.setSpecialAttackUse(4);
                    this.setAnimationState("sweepingAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.SWEEPING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 20) {
                    this.setSpecialAttackUse(5);
                    this.setAnimationState("menacingAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.MENACING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 16) {
                    this.setSpecialAttackUse(6);
                    this.setAnimationState("maneuveringAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.MANEUVERING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 12) {
                    this.setSpecialAttackTick(25);
                    this.setAnimTick(25);
                    this.setSpecialAttackUse(8);
                    this.setAnimationState("goadingAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.GOADING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 8) {
                    this.setSpecialAttackTick(25);
                    this.setAnimTick(25);
                    this.setSpecialAttackUse(9);
                    this.setAnimationState("feintingAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.FEINTING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (attackRandom > 4) {
                    this.setSpecialAttackUse(10);
                    this.setAnimationState("disarmingAttack");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.DISARMING_ATTACK_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else {
                    this.setSpecialAttackUse(11);
                    this.setAnimationState("distractingStrike");
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.DISTRACTING_STRIKE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            } else {
                float actionRandom = this.m_217043_().m_188501_();
                if (this.getActionSurge() <= 0) {
                    if (actionRandom <= 0.25f) {
                        Level level;
                        this.setActionSurge(1);
                        if (!this.m_20067_()) {
                            this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_ACTION, 5.0f, 1.0f);
                        }
                        if ((level = this.m_9236_()) instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            if (!this.m_20145_()) {
                                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.ACTION_SURGE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    } else {
                        this.setActionSurge(0);
                    }
                } else if (this.getActionSurge() == 1) {
                    if (actionRandom <= 0.75f) {
                        Level level;
                        this.setActionSurge(2);
                        if (!this.m_20067_()) {
                            this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_ACTION, 5.0f, 1.0f);
                        }
                        if ((level = this.m_9236_()) instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            if (!this.m_20145_()) {
                                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.ACTION_SURGE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    } else {
                        this.setActionSurge(0);
                    }
                } else if (this.getActionSurge() == 2) {
                    if (actionRandom <= 0.25f) {
                        Level level;
                        this.setActionSurge(3);
                        if (!this.m_20067_()) {
                            this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_ACTION, 5.0f, 1.0f);
                        }
                        if ((level = this.m_9236_()) instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            if (!this.m_20145_()) {
                                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.ACTION_SURGE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    } else {
                        this.setActionSurge(0);
                    }
                } else if (this.getActionSurge() < 10) {
                    if (actionRandom <= 0.1f) {
                        Level level;
                        this.setActionSurge(this.getActionSurge() + 1);
                        if (!this.m_20067_()) {
                            this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_ACTION, 5.0f, 1.0f);
                        }
                        if ((level = this.m_9236_()) instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            if (!this.m_20145_()) {
                                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.ACTION_SURGE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                    } else {
                        this.setActionSurge(0);
                    }
                } else {
                    this.setActionSurge(0);
                }
                if (this.m_21205_().m_41619_()) {
                    this.setAnimTick(5);
                    if (attackRandom <= 30) {
                        this.setAnimationState("attack1");
                    } else {
                        this.setAnimationState("attack2");
                    }
                } else {
                    this.setAnimTick(10);
                    if (attackRandom >= 30) {
                        this.setAnimationState("swordAttack1");
                    } else if (attackRandom >= 20) {
                        this.setAnimationState("swordAttack2");
                    } else if (attackRandom >= 10) {
                        this.setAnimationState("swordAttack3");
                    } else {
                        this.setAnimationState("swordAttack4");
                    }
                }
            }
        }
        return true;
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_ATTACK, 5.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(0.5));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        this.m_20256_(this.m_20184_().m_82520_((double)((this.m_217043_().m_188501_() - 0.5f) * 0.5f), 0.0, (double)((this.m_217043_().m_188501_() - 0.5f) * 0.5f)));
        return true;
    }

    public boolean trueHurtSpecial(int n) {
        if (!this.m_20067_()) {
            if (n == 1) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_PUSHING, 5.0f, 1.0f);
            } else if (n == 2) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_TRIP, 5.0f, 1.0f);
            } else if (n == 3) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_PRECISION, 5.0f, 1.0f);
            } else if (n == 4) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_SWEEPING, 5.0f, 1.0f);
            } else if (n == 5) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_MENACING, 5.0f, 1.0f);
            } else if (n == 6) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_MANEUVERING, 5.0f, 1.0f);
            } else if (n == 7) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_LUNGING, 5.0f, 1.0f);
            } else if (n == 8) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_GOADING, 5.0f, 1.0f);
            } else if (n == 9) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_FEINTING, 5.0f, 1.0f);
            } else if (n == 10) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_DISARMING, 5.0f, 1.0f);
            } else if (n == 11) {
                this.m_5496_(JerotesVillageSounds.SEDIMENT_LORD_DISTRACTING, 5.0f, 1.0f);
            }
        }
        int spellLevel = this.getSpellLevel() - 1;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            spellLevel = this.getSpellLevel();
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            spellLevel = this.getSpellLevel() + 1;
        }
        float damageBase = 1.25f;
        float knockbackBase = 1.25f;
        float reach = 0.75f;
        if (n == 1) {
            damageBase = 1.5f;
            knockbackBase = 2.0f;
        } else if (n == 2) {
            knockbackBase = 0.05f;
        } else if (n == 3) {
            damageBase = 2.0f;
            reach = 1.0f;
        } else if (n == 4) {
            reach = 1.5f;
        }
        boolean success = false;
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_((double)reach));
        for (LivingEntity hurt : list) {
            Mob mob;
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
            if (!bl) continue;
            success = true;
            if (n == 1 && (Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) {
                double d = 0.0;
                if (hurt.m_21051_(Attributes.f_22278_) != null) {
                    d = Math.max(hurt.m_21133_(Attributes.f_22278_), 1.0);
                }
                double d3 = Math.max(0.0, 1.0 - d) + 0.5;
                hurt.m_6853_(false);
                hurt.m_20256_(hurt.m_20184_().m_82520_(-((this.m_20185_() - hurt.m_20185_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20186_() - hurt.m_20186_()) * d3) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20189_() - hurt.m_20189_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f))));
            }
            if (n == 2 && (Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_()) && !hurt.m_9236_().m_5776_()) {
                hurt.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.ENSLAVEMENT.get(), spellLevel * 20, 0));
                hurt.m_6027_(hurt.m_20185_(), hurt.m_20186_() - 0.5, hurt.m_20189_());
            }
            if (n == 5 && !hurt.m_9236_().m_5776_()) {
                hurt.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.ABACK.get(), spellLevel * 40, spellLevel / 2));
                if (!EntityAndItemFind.isAbackAwayImmune((EntityType)hurt.m_6095_()) && hurt.m_21223_() < this.m_21223_() * 5.0f && hurt instanceof PathfinderMob) {
                    Vec3 vec3;
                    PathfinderMob mob2 = (PathfinderMob)hurt;
                    mob2.m_21573_().m_26573_();
                    if (mob2.m_21573_().m_26571_() && (vec3 = LandRandomPos.m_148521_((PathfinderMob)mob2, (int)16, (int)7, (Vec3)this.m_20182_())) != null) {
                        mob2.m_21573_().m_26536_(mob2.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0), (double)1.2f);
                    }
                }
            }
            if (n == 9 && hurt instanceof Mob && (mob = (Mob)hurt).m_5448_() != this && !hurt.m_9236_().m_5776_()) {
                hurt.m_7292_(new MobEffectInstance(MobEffects.f_19613_, spellLevel * 20, spellLevel / 2));
            }
            if (n != 10) continue;
            boolean bl2 = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean bl3 = this.m_9236_().m_46469_().m_46207_(GameRules.f_46133_);
            if (!bl2 || hurt.m_21205_().m_41720_().m_41460_(hurt.m_21205_()) == Rarity.EPIC) continue;
            if (hurt instanceof Player) {
                Player player2 = (Player)hurt;
                if (bl3 || player2.m_150110_().f_35937_) continue;
            }
            hurt.m_19983_(hurt.m_21205_());
            hurt.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_.m_5456_()));
        }
        if (success) {
            List listTeam;
            if (n == 6) {
                listTeam = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
                for (LivingEntity team : listTeam) {
                    if (team == null || !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)team) || !EntitySelector.f_20406_.test(team) || team == this) continue;
                    if (team.m_9236_().m_5776_()) break;
                    team.m_7292_(new MobEffectInstance(MobEffects.f_19596_, spellLevel * 20, spellLevel / 2));
                    break;
                }
            }
            if (n == 11) {
                listTeam = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
                for (LivingEntity team : listTeam) {
                    if (team == null || !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)team) || !EntitySelector.f_20406_.test(team) || team == this || team.m_9236_().m_5776_()) continue;
                    team.m_7292_(new MobEffectInstance(MobEffects.f_19600_, spellLevel * 20, spellLevel / 2));
                }
            }
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        this.m_20256_(this.m_20184_().m_82520_((double)((this.m_217043_().m_188501_() - 0.5f) * 0.5f), 0.0, (double)((this.m_217043_().m_188501_() - 0.5f) * 0.5f)));
        return true;
    }

    public boolean shieldAttack() {
        this.m_6674_(InteractionHand.MAIN_HAND);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12313_, this.m_5720_(), 10.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 2.0, 2.0));
        for (LivingEntity hurt : list) {
            if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)0.5f, (boolean)false, (float)0.0f);
            if (hurt.m_21211_().m_41720_() instanceof ShieldItem) {
                if (hurt instanceof Player) {
                    Player player = (Player)hurt;
                    player.m_36384_(true);
                } else if (hurt instanceof UseShieldEntity) {
                    UseShieldEntity useShieldEntity = (UseShieldEntity)hurt;
                    useShieldEntity.disableShield();
                }
            }
            double d3 = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d4 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 15; ++i) {
                double xs = this.m_20185_() + d3 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20185_() - hurt.m_20185_()) / 2.0;
                double ys = this.m_20227_(0.5) + (double)this.m_217043_().m_188501_() - 0.5 - (this.m_20186_() - hurt.m_20186_()) / 2.0;
                double zs = this.m_20189_() + d4 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20189_() - hurt.m_20189_()) / 2.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, xs, ys, zs, 0, d3, 0.0, d4, 0.0);
            }
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_7639_() instanceof AncientSecondRounderArrowEntity || damageSource.m_7640_() instanceof AncientSecondRounderArrowEntity) {
            return true;
        }
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268549_)) {
            amount /= 3.0f;
        }
        if (this.isDamageSourceBlocks(damagesource) && this.getSpecialBlockTick() > 0) {
            amount /= 2.0f;
        }
        if (!this.m_21525_() && this.m_5448_() != null && !this.m_6673_(damagesource) && this.isDamageSourceBlocks(damagesource) && !this.m_21205_().m_41619_() && !(this.m_21206_().m_41720_() instanceof ShieldItem) && this.isAngryTick() && this.m_6084_() && !this.specialAction() && this.getSpecialBlockTick() <= 0) {
            int attackDamage;
            Item item;
            ItemTwoHanded itemTwoHanded;
            Item item2;
            if (!this.specialAction() && !this.m_9236_().m_5776_()) {
                int blockRandom = this.m_217043_().m_188503_(30);
                if (blockRandom > 20) {
                    this.setAnimationState("block1");
                } else if (blockRandom > 10) {
                    this.setAnimationState("block2");
                } else {
                    this.setAnimationState("block3");
                }
            }
            if (this.m_21206_().m_41619_() && (item2 = this.m_21205_().m_41720_()) instanceof ItemTwoHanded && (itemTwoHanded = (ItemTwoHanded)item2).canBlock() && (item = this.m_21205_().m_41720_()) instanceof ItemSpecialEffect) {
                ItemSpecialEffect specialEffect = (ItemSpecialEffect)item;
                specialEffect.blockUse((Entity)this, damagesource.m_7639_(), damagesource);
            }
            if ((attackDamage = (int)this.m_21133_(Attributes.f_22281_) * 10) < 2) {
                attackDamage = 2;
            }
            if ((double)this.m_217043_().m_216339_(1, attackDamage) > (double)amount * 3.5) {
                if (!this.m_9236_().m_5776_()) {
                    this.setSpecialBlockTick(5);
                }
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SEDIMENT_LORD_BLOCK, this.m_5720_(), 10.0f, 1.0f);
                }
                if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
                    ItemStack hand = this.m_21205_();
                    hand.m_41622_((int)amount / 3, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
                }
                return false;
            }
        }
        if (this.getShieldAttackTick() > 0 && !this.m_9236_().m_5776_()) {
            this.setShieldAttackTick(0);
            this.shieldAttackAnimationState.m_216973_();
            this.stopAllAnimation();
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268490_)) {
            return super.m_6469_(damagesource, amount / 2.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (this.getShieldAttackTick() <= -20) {
            Level level;
            if (!this.m_9236_().m_5776_()) {
                this.setShieldAttackTick(60);
                this.setAnimTick(70);
                this.setAnimationState("shieldAttack");
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.m_20145_()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.SHIELD_PIERCING_COMBO_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SEDIMENT_LORD_SPECIAL, this.m_5720_(), 10.0f, 1.0f);
            }
        }
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19620_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        if ((double)weaponRandom > 0.65) {
            return new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_GREATSWORD.get());
        }
        if ((double)weaponRandom > 0.35) {
            return new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_BATTLE_AXE.get());
        }
        return new ItemStack((ItemLike)JerotesVillageItems.ANCIENT_SECOND_ROUNDER_WARHAMMER.get());
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0) {
            if (this.m_21205_().m_41619_()) {
                if (!this.m_9236_().m_5776_()) {
                    this.setAnimTick(40);
                    this.setAnimationState("dead1");
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(40);
                this.setAnimationState("dead2");
            }
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

