/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Humanoid.Serpon;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.FireAbsorptionEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Humanoid.Serpon.SerponEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class SerponFireApostleEntity
extends SerponEntity
implements FireAbsorptionEntity,
EliteEntity {
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_6, false);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SerponFireApostleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(SerponFireApostleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_ANIM = SynchedEntityData.m_135353_(SerponFireApostleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(SerponFireApostleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(SerponFireApostleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState attack4AnimationState = new AnimationState();
    public AnimationState attack5AnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();

    public SerponFireApostleEntity(EntityType<? extends SerponFireApostleEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 40;
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)JerotesVillageItems.FIRE_APOSTLE_HELMET.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)JerotesVillageItems.FIRE_APOSTLE_CHESTPLATE.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)JerotesVillageItems.FIRE_APOSTLE_LEGGINGS.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)JerotesVillageItems.FIRE_APOSTLE_BOOTS.get()), randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        this.m_8061_(equipmentSlot, itemStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22280_, 0.55);
        builder = builder.m_22268_(Attributes.f_22276_, 70.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        return builder;
    }

    public boolean m_21526_() {
        return false;
    }

    public boolean canUseCrossbow() {
        return false;
    }

    public boolean canUseThrow() {
        return false;
    }

    public boolean canUseRangeJavelin() {
        return false;
    }

    public boolean canUseBow() {
        return false;
    }

    public double FireAbsorptionPercentage() {
        return 60.0;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public void m_147240_(double d, double d2, double d3) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(0.0, 0.0, 0.0);
    }

    @Override
    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        if (!this.m_21205_().m_41619_()) {
            return aabb1.m_82377_(0.85, 0.85, 0.85);
        }
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    @Override
    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    public int getAttackAnim() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_ANIM);
    }

    public void setAttackAnim(int n) {
        this.m_20088_().m_135381_(ATTACK_ANIM, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "attack4")) {
            return 4;
        }
        if (Objects.equals(animation, "attack5")) {
            return 5;
        }
        if (Objects.equals(animation, "dead")) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.attack4AnimationState);
        list.add(this.attack5AnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("AttackAnim", this.getAttackAnim());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setAttackAnim(compoundTag.m_128451_("AttackAnim"));
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_ANIM, (Object)0);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.attack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack4AnimationState);
                    break;
                }
                case 5: {
                    this.attack5AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack5AnimationState);
                    break;
                }
                case 6: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(0, this.getAttackTick() - 1));
        }
        if (this.getAttackUse() != 5 && this.getAttackTick() == 15 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.getAttackUse() == 5 && this.m_6084_() && this.getAttackTick() == 13) {
            this.trueHurt();
        }
        if (this.getAttackTick() > 0) {
            this.m_21573_().m_26573_();
        }
        if (this.m_5448_() != null && this.getAttackTick() <= 5) {
            if (!this.m_9236_().m_5776_()) {
                this.setAttackAnim(Math.min(this.getAttackAnim() + 1, 10));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setAttackAnim(Math.max(this.getAttackAnim() - 2, 0));
        }
        if (this.getAttackTick() > 15 && this.m_5448_() != null) {
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.getAttackUse() == 2 && this.getAttackTick() <= 20 && this.getAttackTick() > 15) {
            float f = this.m_146908_();
            float f2 = this.m_146909_();
            float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
            float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
            float f7 = 0.15f;
            if (this.getAttackTick() > 18) {
                f7 = -0.05f;
            }
            float f8 = f4 *= f7 / f6 * 2.0f;
            if (!this.m_20096_()) {
                f8 = 0.0f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), (double)f8, (double)(f5 *= f7 / f6 * 2.0f)));
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() > 0) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            int attackRandom = this.m_217043_().m_188503_(100);
            if (attackRandom > 85) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(1);
                this.setAnimationState("attack1");
            } else if (attackRandom > 70) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(2);
                this.setAnimationState("attack2");
            } else if (attackRandom > 40) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(3);
                this.setAnimationState("attack3");
            } else if (attackRandom > 15) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(4);
                this.setAnimationState("attack4");
            } else {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(5);
                this.setAnimationState("attack5");
            }
        }
        this.m_21573_().m_26573_();
        this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        return true;
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.SERPON_ATTACK, 2.0f, 1.0f);
            if (this.getAttackUse() == 1) {
                this.m_5496_(SoundEvents.f_12317_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 2) {
                this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 3) {
                this.m_5496_(SoundEvents.f_12316_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 4) {
                this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 5) {
                this.m_5496_(SoundEvents.f_12313_, 2.0f, 1.0f);
            }
        }
        float damageBase = 1.0f;
        float knockbackBase = 1.0f;
        float reach = 1.35f;
        if (this.getAttackUse() == 1) {
            reach = 1.5f;
        }
        if (this.getAttackUse() == 2) {
            knockbackBase = 1.5f;
        }
        if (this.getAttackUse() == 3) {
            damageBase = 1.25f;
        }
        if (this.getAttackUse() == 4) {
            knockbackBase = 1.15f;
            reach = 1.5f;
        }
        if (this.getAttackUse() == 5) {
            damageBase = 1.25f;
            reach = 1.5f;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_((double)reach));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this) && this.getAttackUse() != 3 && this.getAttackUse() != 4 && this.getAttackUse() != 5) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
            if (!bl) continue;
            hurt.m_20254_(16);
            double d = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 15; ++i) {
                double xs = this.m_20185_() + d + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20185_() - hurt.m_20185_()) / 2.0;
                double ys = this.m_20227_(0.5) + (double)this.m_217043_().m_188501_() - 0.5 - (this.m_20186_() - hurt.m_20186_()) / 2.0;
                double zs = this.m_20189_() + d2 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20189_() - hurt.m_20189_()) / 2.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, xs, ys, zs, 0, d, 0.0, d2, 0.0);
            }
        }
        if (this.getAttackUse() == 2) {
            float f = this.m_146908_();
            float f2 = this.m_146909_();
            float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
            float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
            float f7 = 0.5f;
            float f8 = f4 *= f7 / f6 * 2.0f;
            if (!this.m_20096_()) {
                f8 = 0.0f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), (double)f8, (double)(f5 *= f7 / f6 * 2.0f)));
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @Override
    public void disableShield() {
        if ((double)this.f_19796_.m_188501_() < 0.66) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    @Override
    public void disableShieldTry() {
        if ((double)this.f_19796_.m_188501_() < 0.05) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource)) {
            return super.m_6469_(damagesource, amount / 5.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setShieldLevel(3);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.FIRE_APOSTLE_SWORD.get());
    }

    @Override
    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.SERPON_PORTAL.get()), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }
}

