/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.MagicSummoned.Bulge;

import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CelestialCoilvineEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.Bulge.BulgeEntity;
import com.jerotes.jerotesvillage.goal.BigWitchAttackGoal;
import com.jerotes.jerotesvillage.goal.BulgeFloatGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SeawaveEntity
extends BulgeEntity
implements RangedAttackMob,
SpellUseEntity {
    private static final EntityDataAccessor<Integer> IDLE_ANIM = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WIND_TICK = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BULGE_TICK = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BULGE_USE_TICK = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TRIDENT_COUNT = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TRIDENT_ADD_COOLDOWN = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> TRIDENT_HEALTH = SynchedEntityData.m_135353_(SeawaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public AnimationState idle1AnimationState = new AnimationState();
    public AnimationState idle2AnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public AnimationState windAnimationState = new AnimationState();
    public AnimationState bulgeAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    public int spellLevel = 3;

    public SeawaveEntity(EntityType<? extends SeawaveEntity> entityType, Level level) {
        super((EntityType<? extends BulgeEntity>)entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BulgeFloatGoal((Mob)this, 0.15f));
        this.f_21345_.m_25352_(1, (Goal)new BigWitchAttackGoal(this, 0.8f, 80, 20.0f));
    }

    @Override
    public void m_6504_(LivingEntity livingEntity, float f) {
        if (this.specialAction() || this.getAttackTick() > 0) {
            return;
        }
        if (this.m_20270_((Entity)livingEntity) > 8.0f || this.m_217043_().m_188501_() > 0.5f || !this.m_142582_((Entity)livingEntity)) {
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(50);
                this.setAnimationState("shoot");
                this.setShootTick(50);
                OtherSpellList.BulgeBullet(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("wind");
            this.setWindTick(30);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 80.0);
        builder = builder.m_22268_(Attributes.f_22284_, 8.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.6);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    @Override
    public SoundEvent m_7515_() {
        return JerotesVillageSounds.SEAWAVE_AMBIENT;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.SEAWAVE_HURT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SEAWAVE_DEATH;
    }

    @Override
    protected float m_6121_() {
        return 0.5f;
    }

    @Override
    public int m_8100_() {
        return 480;
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.875f;
    }

    @Override
    public void m_7023_(Vec3 dir) {
        super.m_7023_(dir);
        if (this.specialAction() || this.getAttackTick() > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.005, 1.0, 0.005));
        }
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.25, 1.25, 1.25);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "shoot")) {
            return 1;
        }
        if (Objects.equals(animation, "wind")) {
            return 2;
        }
        if (Objects.equals(animation, "bulge")) {
            return 3;
        }
        if (Objects.equals(animation, "attack1")) {
            return 4;
        }
        if (Objects.equals(animation, "attack2")) {
            return 5;
        }
        if (Objects.equals(animation, "dead")) {
            return 6;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.shootAnimationState);
        list.add(this.windAnimationState);
        list.add(this.bulgeAnimationState);
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public int getTridentCount() {
        return (Integer)this.m_20088_().m_135370_(TRIDENT_COUNT);
    }

    public void setTridentCount(int n) {
        this.m_20088_().m_135381_(TRIDENT_COUNT, (Object)n);
    }

    public int getTridentAddCooldown() {
        return (Integer)this.m_20088_().m_135370_(TRIDENT_ADD_COOLDOWN);
    }

    public void setTridentAddCooldown(int n) {
        this.m_20088_().m_135381_(TRIDENT_ADD_COOLDOWN, (Object)n);
    }

    public float getTridentHealth() {
        return ((Float)this.m_20088_().m_135370_(TRIDENT_HEALTH)).floatValue();
    }

    public void setTridentHealth(float f) {
        this.m_20088_().m_135381_(TRIDENT_HEALTH, (Object)Float.valueOf(f));
    }

    public int getIdleAnim() {
        return (Integer)this.m_20088_().m_135370_(IDLE_ANIM);
    }

    public void setIdleAnim(int n) {
        this.m_20088_().m_135381_(IDLE_ANIM, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public int getWindTick() {
        return (Integer)this.m_20088_().m_135370_(WIND_TICK);
    }

    public void setWindTick(int n) {
        this.m_20088_().m_135381_(WIND_TICK, (Object)n);
    }

    public int getBulgeTick() {
        return (Integer)this.m_20088_().m_135370_(BULGE_TICK);
    }

    public void setBulgeTick(int n) {
        this.m_20088_().m_135381_(BULGE_TICK, (Object)n);
    }

    public int getBulgeUseTick() {
        return (Integer)this.m_20088_().m_135370_(BULGE_USE_TICK);
    }

    public void setBulgeUseTick(int n) {
        this.m_20088_().m_135381_(BULGE_USE_TICK, (Object)n);
    }

    public boolean specialAction() {
        return this.getShootTick() > 0 || this.getWindTick() > 0 || this.getBulgeUseTick() > 0;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("IdleAnim", this.getIdleAnim());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128405_("ShootTick", this.getShootTick());
        compoundTag.m_128405_("WindTick", this.getWindTick());
        compoundTag.m_128405_("BulgeTick", this.getBulgeTick());
        compoundTag.m_128405_("BulgeUseTick", this.getBulgeUseTick());
        compoundTag.m_128405_("TridentCount", this.getTridentCount());
        compoundTag.m_128405_("TridentAddCooldown", this.getTridentAddCooldown());
        compoundTag.m_128350_("TridentHealth", this.getTridentHealth());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setIdleAnim(compoundTag.m_128451_("IdleAnim"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.setWindTick(compoundTag.m_128451_("WindTick"));
        this.setBulgeTick(compoundTag.m_128451_("BulgeTick"));
        this.setBulgeUseTick(compoundTag.m_128451_("BulgeUseTick"));
        this.setTridentCount(compoundTag.m_128451_("TridentCount"));
        this.setTridentAddCooldown(compoundTag.m_128451_("TridentAddCooldown"));
        this.setTridentHealth(compoundTag.m_128457_("TridentHealth"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IDLE_ANIM, (Object)0);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
        this.m_20088_().m_135372_(WIND_TICK, (Object)0);
        this.m_20088_().m_135372_(BULGE_TICK, (Object)400);
        this.m_20088_().m_135372_(BULGE_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(TRIDENT_COUNT, (Object)4);
        this.m_20088_().m_135372_(TRIDENT_ADD_COOLDOWN, (Object)0);
        this.m_20088_().m_135372_(TRIDENT_HEALTH, (Object)Float.valueOf(10.0f));
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                    break;
                }
                case 2: {
                    this.windAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.windAnimationState);
                    break;
                }
                case 3: {
                    this.bulgeAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.bulgeAnimationState);
                    break;
                }
                case 4: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 5: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 6: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.m_20095_();
        if (!this.m_5912_() && this.getShootTick() > 0) {
            this.getPersistentData().m_128347_("jerotesvillage_bulge_bullet", 0.0);
            if (!this.m_9236_().m_5776_()) {
                this.setShootTick(0);
            }
            this.shootAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            this.idle1AnimationState.m_216982_(this.f_19797_);
            this.idle2AnimationState.m_216982_(this.f_19797_);
        }
        if (this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (!this.specialAction() && this.getAttackTick() <= 0 && this.m_6084_()) {
            if (!this.m_9236_().m_5776_()) {
                this.setIdleAnim(Math.min(this.getIdleAnim() + 1, 10));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setIdleAnim(Math.max(this.getIdleAnim() - 1, 0));
        }
        if (this.m_5912_() && (this.getIdleAnim() == 9 || this.getIdleAnim() == 1)) {
            this.idle1AnimationState.m_216977_(this.f_19797_);
        }
        if (this.m_217043_().m_188503_(900) == 1 && this.m_6084_()) {
            this.m_5634_(3.0f);
        }
        if (this.m_6084_()) {
            Level i2;
            ServerLevel serverLevel;
            Level level;
            if (this.getAttackTick() <= -60 && this.m_6084_() && this.m_5448_() != null && this.m_217066_(this.m_5448_()) && this.m_292684_().m_82381_(this.m_5448_().m_20191_()) && this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.m_6674_(InteractionHand.MAIN_HAND);
                this.m_7327_((Entity)this.m_5448_());
            }
            if (this.getAttackTick() == 10 && this.m_6084_()) {
                this.trueHurt();
            }
            if ((this.m_20069_() || this.m_9236_().m_6425_(this.m_20097_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_)) && this.getAttackTick() > 5 && this.getAttackTick() <= 12 && this.getAttackUse() == 2 && this.m_6084_() && (level = this.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                for (int i2 = 0; i2 < 24; ++i2) {
                    double angle = Math.PI * 2 * (double)i2 / 24.0;
                    double radius = 3.0;
                    double offsetX = Math.cos(angle) * radius;
                    double offsetZ = Math.sin(angle) * radius;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123772_, this.m_20185_() + offsetX, this.m_20186_() - (double)0.05f, this.m_20189_() + offsetZ, 0, 0.0, 0.5, 0.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + offsetX, this.m_20186_() - (double)0.05f, this.m_20189_() + offsetZ, 0, 0.0, 0.5, 0.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123772_, this.m_20185_() + offsetX, this.m_20186_() - (double)0.05f, this.m_20189_() + offsetZ, 0, 0.0, -0.5, 0.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + offsetX, this.m_20186_() - (double)0.05f, this.m_20189_() + offsetZ, 0, 0.0, -0.5, 0.0, 1.0);
                }
            }
            if (this.m_217043_().m_188503_(900) == 1 && this.m_6084_() && !this.m_9236_().m_5776_()) {
                this.setTridentHealth(Math.min(10.0f, this.getTridentHealth() + 3.0f));
            }
            if (this.getTridentCount() < 4 && this.getTridentAddCooldown() <= 0) {
                if (!this.m_9236_().m_5776_()) {
                    this.setTridentHealth(10.0f);
                    this.setTridentCount(Math.min(4, this.getTridentCount() + 1));
                    this.setTridentAddCooldown(120);
                }
                if ((i2 = this.m_9236_()) instanceof ServerLevel) {
                    serverLevel = (ServerLevel)i2;
                    for (int i3 = 0; i3 < 20; ++i3) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.GEMSTONE_BUBBLE.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 1, 0.0, -0.25, 0.0, 0.125);
                    }
                }
                this.m_216990_(JerotesVillageSounds.SEAWAVE_REGENERAT);
            }
            if (this.getTridentCount() > 0 && this.getTridentHealth() <= 0.0f) {
                if (!this.m_9236_().m_5776_()) {
                    this.setTridentHealth(10.0f);
                    this.setTridentCount(Math.max(0, this.getTridentCount() - 1));
                    this.setTridentAddCooldown(120);
                }
                if ((i2 = this.m_9236_()) instanceof ServerLevel) {
                    serverLevel = (ServerLevel)i2;
                    for (int i4 = 0; i4 < 20; ++i4) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.GEMSTONE_BUBBLE.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 1, 0.0, -0.25, 0.0, 0.125);
                    }
                }
                this.m_216990_(JerotesVillageSounds.SEAWAVE_BREAK);
            }
            if (this.getWindTick() == 20 && this.m_5448_() != null) {
                OtherSpellList.GemstoneWaves(this.getSpellLevel(), (LivingEntity)this, (Entity)this).spellUse();
            }
            List listBulge = this.m_9236_().m_45976_(BulgeEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
            listBulge.removeIf(entity -> this.m_5448_() == entity || entity instanceof SeawaveEntity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
            List ListSeawave = this.m_9236_().m_45976_(SeawaveEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
            ListSeawave.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
            if (this.getBulgeTick() >= 600 && listBulge.size() <= ListSeawave.size() * 4 && this.m_5912_() && !this.specialAction() && this.getAttackTick() <= 0 && !this.m_9236_().m_5776_()) {
                this.setAnimTick(25);
                this.setAnimationState("bulge");
                this.setBulgeTick(0);
                this.setBulgeUseTick(25);
            }
            if (this.getBulgeUseTick() == 5) {
                OtherSpellList.ConjureBulge(this.getSpellLevel(), (LivingEntity)this, (Entity)this).spellUse();
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SEAWAVE_BULGE, this.m_5720_(), 10.0f, 1.0f);
                }
            }
            if (!this.m_9236_().m_5776_()) {
                this.setAttackTick(Math.max(-60, this.getAttackTick() - 1));
                this.setTridentAddCooldown(Math.max(0, this.getTridentAddCooldown() - 1));
                this.setShootTick(Math.max(0, this.getShootTick() - 1));
                this.setWindTick(Math.max(0, this.getWindTick() - 1));
                this.setBulgeTick(Math.min(600, this.getBulgeTick() + 1));
                this.setBulgeUseTick(Math.max(0, this.getBulgeUseTick() - 1));
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.specialAction() || this.getAttackTick() > -60) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(30);
            this.setAnimTick(30);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 15 || this.getTridentCount() <= 0) {
                this.setAnimationState("attack2");
                this.setAttackUse(2);
                if (!this.m_20067_()) {
                    this.m_5496_(JerotesVillageSounds.SEAWAVE_SHOCKWAVE, 5.0f, 1.0f);
                }
            } else {
                this.setAnimationState("attack1");
                this.setAttackUse(1);
            }
        }
        return true;
    }

    public boolean trueHurt() {
        float damageBase = 1.0f;
        float knockbackBase = 1.0f;
        float reach = 0.5f;
        if (this.getAttackUse() == 2) {
            knockbackBase = 1.5f;
            reach = 1.25f;
        }
        if (this.getAttackUse() == 1) {
            knockbackBase = 1.25f;
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.SEAWAVE_TRIDENT, 5.0f, 1.0f);
            }
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_((double)reach));
        for (Object hurt : list) {
            BulgeEntity bulgeEntity;
            if (hurt == null || this.m_20280_((Entity)hurt) > 128.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) && (this.getAttackUse() != 2 || !this.m_20069_() && !this.m_9236_().m_6425_(this.m_20097_()).m_192917_((Fluid)Fluids.f_76193_) && !this.m_9236_().m_6425_(this.m_20097_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && !this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && !this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && !this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_)) || hurt instanceof BulgeEntity && (bulgeEntity = (BulgeEntity)((Object)hurt)).m_5448_() != this && this.m_5448_() != bulgeEntity) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            if (this.getAttackUse() == 2) {
                double d3;
                double d;
                boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
                if (bl && (Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) {
                    d = 0.0;
                    if (hurt.m_21051_(Attributes.f_22278_) != null) {
                        d = Math.max(hurt.m_21133_(Attributes.f_22278_), 1.0);
                    }
                    d3 = Math.max(0.0, 1.0 - d) + (double)0.3f;
                    hurt.m_6853_(false);
                    hurt.m_20256_(hurt.m_20184_().m_82520_(-((this.m_20185_() - hurt.m_20185_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20186_() - hurt.m_20186_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20189_() - hurt.m_20189_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f))));
                    hurt.m_20256_(hurt.m_20184_().m_82520_(0.0, (double)((7.0f - this.m_20270_((Entity)hurt)) / 10.0f), 0.0));
                }
                if ((this.m_20069_() || this.m_9236_().m_6425_(this.m_20097_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_) || this.m_9236_().m_6425_(this.m_20097_().m_7495_().m_7495_().m_7495_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_)) && (Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) {
                    d = 0.0;
                    if (hurt.m_21051_(Attributes.f_22278_) != null) {
                        d = Math.max(hurt.m_21133_(Attributes.f_22278_), 1.0);
                    }
                    d3 = Math.max(0.0, 1.0 - d) + (double)0.2f;
                    hurt.m_6853_(false);
                    hurt.m_20256_(hurt.m_20184_().m_82520_(-((this.m_20185_() - hurt.m_20185_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20186_() - hurt.m_20186_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20189_() - hurt.m_20189_()) * d3 / 1.5) * (0.7 + (double)(knockbackBase / 3.0f))));
                    hurt.m_20256_(hurt.m_20184_().m_82520_(0.0, (double)((7.0f - this.m_20270_((Entity)hurt)) / 10.0f), 0.0));
                }
            }
            if (this.getAttackUse() != 1) continue;
            int count = 0;
            if (Main.canSeeAngle((Entity)this, (Vec3)hurt.m_146892_(), (double)45.0)) {
                if (this.getTridentCount() >= 4) {
                    ++count;
                }
                if (this.getTridentCount() >= 3) {
                    ++count;
                }
            }
            if (CelestialCoilvineEntity.canSeeAngleFour((Entity)this, hurt.m_146892_(), 45.0f, 80.0) && this.getTridentCount() >= 2) {
                ++count;
            }
            if (CelestialCoilvineEntity.canSeeAngleFour((Entity)this, hurt.m_146892_(), -45.0f, 80.0) && this.getTridentCount() >= 1) {
                ++count;
            }
            for (int i = 0; i < count; ++i) {
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(JerotesDamageTypes.BYPASSES_COOLDOWN_MELEE), (Entity)this);
                AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)hurt, (DamageSource)damageSource, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
            }
        }
        if (this.getAttackUse() == 2) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(12.0, 12.0, 12.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.SEAWAVE_SHOCKWAVE.get()), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            List listBoat = this.m_9236_().m_45976_(Boat.class, this.m_292684_().m_82400_((double)reach));
            for (Boat hurt : listBoat) {
                if (hurt == null || this.m_20280_((Entity)hurt) > 128.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt)) continue;
                hurt.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 30.0f);
            }
        } else {
            Main.sweepAttack((Entity)this);
        }
        return true;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && amount <= this.m_21223_() * 100.0f && this.getTridentCount() > 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setTridentHealth(this.getTridentHealth() - amount);
            }
            if (amount > 0.0f) {
                this.m_216990_(JerotesSounds.TWOHANDED_BLOCK);
            }
            amount = 0.0f;
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

