/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.MagicSummoned.VinePodBomb;

import com.jerotes.jerotes.goal.JerotesChangeFollowMobOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeFollowOwnerGoal;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CelestialCoilvineEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.MagicSummonedEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class VinePodBombEntity
extends MagicSummonedEntity {
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> IS_BOMB = SynchedEntityData.m_135353_(VinePodBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(VinePodBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(VinePodBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public VinePodBombEntity(EntityType<? extends VinePodBombEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.1f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, (double)0.2f);
        return builder;
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionBotanizeVillage(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "botanize_village";
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new JerotesChangeFollowOwnerGoal(this, 1.3, 5.0f, 1.0f, true){

            public boolean m_8036_() {
                if (VinePodBombEntity.this.isBomb()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (VinePodBombEntity.this.isBomb()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new JerotesChangeFollowMobOwnerGoal(this, 1.0){

            public boolean m_8036_() {
                if (VinePodBombEntity.this.isBomb()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (VinePodBombEntity.this.isBomb()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((VinePodBombEntity)this).m_21674_(arg_0)));
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11988_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11990_;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.4f;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public void setBomb(boolean bl) {
        this.m_20088_().m_135381_(IS_BOMB, (Object)bl);
    }

    public boolean isBomb() {
        return (Boolean)this.m_20088_().m_135370_(IS_BOMB);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsBomb", this.isBomb());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setBomb(compoundTag.m_128471_("IsBomb"));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(IS_BOMB, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_6084_() && this.isBomb() && !this.m_20096_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (this.isBomb() && this.f_19797_ > 3 && this.m_20096_()) {
            Level level;
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, false, Level.ExplosionInteraction.NONE);
            if (!this.m_9236_().m_5776_()) {
                this.setBomb(false);
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.CELESTIAL_COILVINE_ATTACK.get()), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(10);
            this.setAnimationState("attack");
        }
        return super.m_7327_(entity);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return super.m_6469_(source, amount);
        }
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof CelestialCoilvineEntity) {
            LivingEntity livingEntity2;
            AbstractArrow arrow;
            Entity entity;
            CelestialCoilvineEntity celestialCoilvineEntity = (CelestialCoilvineEntity)livingEntity;
            if (source.m_269533_(DamageTypeTags.f_268725_) || source.m_269533_(DamageTypeTags.f_268419_) || source.m_269533_(DamageTypeTags.f_268745_)) {
                amount *= 2.0f;
            }
            if (source.m_269533_(DamageTypeTags.f_268745_) || source.m_7640_() != null && (entity = source.m_7640_()) instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_6060_() || EntityAndItemFind.isMeleeDamage((DamageSource)source) && (entity = source.m_7639_()) instanceof LivingEntity && (livingEntity2 = (LivingEntity)entity).m_21205_().getEnchantmentLevel(Enchantments.f_44981_) > 0) {
                amount *= 1.5f;
            }
        } else if (source.m_269533_(DamageTypeTags.f_268725_) || source.m_269533_(DamageTypeTags.f_268419_) || source.m_269533_(DamageTypeTags.f_268745_)) {
            amount *= 1.25f;
        }
        boolean bl = super.m_6469_(source, amount);
        return bl;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }
}

