/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Elite;

import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesNoFireFleeSunGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.spell.SpellList;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantBodyRotationControl;
import com.jerotes.jerotesvillage.entity.Animal.GlowSparrowEntity;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.LampWizardEntity;
import com.jerotes.jerotesvillage.goal.DarisorderAvoidEntityGoal;
import com.jerotes.jerotesvillage.goal.DarisorderMeleeAttackGoal;
import com.jerotes.jerotesvillage.goal.DarkNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class DarisorderEntity
extends Monster
implements JerotesEntity,
BreakShieldEntity,
NeutralMob,
EliteEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState startAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState attack4AnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_12, false);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(DarisorderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(DarisorderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(DarisorderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_TICK = SynchedEntityData.m_135353_(DarisorderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> INSTABILITY = SynchedEntityData.m_135353_(DarisorderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private double blockDestroyTick;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public DarisorderEntity(EntityType<? extends DarisorderEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 100;
        this.m_274367_(2.6f);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.m_21441_(BlockPathTypes.FENCE, 0.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, GlowSparrowEntity.class, 8.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal<LampWizardEntity>((PathfinderMob)this, LampWizardEntity.class, 8.0f, 1.5, 1.5){

            public boolean m_8036_() {
                if (DarisorderEntity.this.isInstability() || DarisorderEntity.this.m_5448_() == null) {
                    return super.m_8036_();
                }
                return false;
            }

            public boolean m_8045_() {
                if (DarisorderEntity.this.isInstability() && DarisorderEntity.this.m_5448_() == null) {
                    return super.m_8045_();
                }
                return false;
            }
        });
        this.f_21345_.m_25352_(0, new DarisorderAvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new DarisorderMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesNoFireFleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new DarkNearestAttackableTargetGoal<Player>((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, new DarkNearestAttackableTargetGoal<AbstractVillager>((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, new DarkNearestAttackableTargetGoal<AbstractIllager>((Mob)this, AbstractIllager.class, true));
        this.f_21346_.m_25352_(2, new DarkNearestAttackableTargetGoal<IronGolem>((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(2, new DarkNearestAttackableTargetGoal<SecondRounderEntity>((Mob)this, SecondRounderEntity.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((DarisorderEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.33);
        builder = builder.m_22268_(Attributes.f_22276_, 230.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 20.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.9);
        return builder;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.DARISORDER_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.DARISORDER_DEATH;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean m_6785_(double d) {
        return this.isInstability();
    }

    protected boolean m_8028_() {
        return this.isInstability();
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public int getShieldBreakStrength() {
        return 100;
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level){

            protected PathFinder m_5532_(int n) {
                this.f_26508_ = new WalkNodeEvaluator();
                this.f_26508_.m_77351_(true);
                return new PathFinder(this.f_26508_, n){

                    protected float m_214208_(Node node, Node node2) {
                        return node.m_230613_(node2);
                    }
                };
            }
        };
    }

    public void m_147240_(double d, double d2, double d3) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(0.0, 0.0, 0.0);
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public boolean m_213824_() {
        return true;
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.25, 1.25, 1.25);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GiantBodyRotationControl((Mob)this);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 4.0f;
    }

    public int m_6056_() {
        return super.m_6056_() * 64;
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setSpellTick(int n) {
        this.m_20088_().m_135381_(SPELL_TICK, (Object)n);
    }

    public int getSpellTick() {
        return (Integer)this.m_20088_().m_135370_(SPELL_TICK);
    }

    public float lightLevel() {
        if (this.m_9236_().m_151577_(this.m_146903_(), this.m_146907_())) {
            return (float)this.m_9236_().m_46803_(this.m_20097_().m_7494_()) / 15.0f;
        }
        return 0.0f;
    }

    public boolean isInstability() {
        return (Boolean)this.m_20088_().m_135370_(INSTABILITY);
    }

    public void setInstability(boolean bl) {
        this.m_20088_().m_135381_(INSTABILITY, (Object)bl);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "start")) {
            return 1;
        }
        if (Objects.equals(animation, "attack1")) {
            return 2;
        }
        if (Objects.equals(animation, "attack2")) {
            return 3;
        }
        if (Objects.equals(animation, "attack3")) {
            return 4;
        }
        if (Objects.equals(animation, "attack4")) {
            return 5;
        }
        if (Objects.equals(animation, "dead")) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.startAnimationState);
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.attack4AnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception || state == this.startAnimationState) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == this.startAnimationState) continue;
            state.m_216973_();
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("SpellTick", this.getSpellTick());
        compoundTag.m_128379_("IsInstability", this.isInstability());
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setSpellTick(compoundTag.m_128451_("SpellTick"));
        this.setInstability(compoundTag.m_128471_("IsInstability"));
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.m_147285_(this.m_9236_(), compoundTag);
        this.bossEvent.setId(this.m_20148_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(SPELL_TICK, (Object)0);
        this.m_20088_().m_135372_(INSTABILITY, (Object)true);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (INSTABILITY.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.startAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.startAnimationState);
                    break;
                }
                case 2: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 3: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 4: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 5: {
                    this.attack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack4AnimationState);
                    break;
                }
                case 6: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_217043_().m_188503_((int)(900.0 * ((double)this.lightLevel() + 0.05))) == 1 && this.f_20919_ == 0) {
            this.m_5634_((float)(3.0 / ((double)this.lightLevel() + 0.25)));
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-((int)(5.0f + this.lightLevel() * 20.0f)), this.getAttackTick() - 1));
            this.setSpellTick(Math.max(0, this.getSpellTick() - 1));
        }
        if (this.getAttackTick() > -((int)(5.0f + this.lightLevel() * 20.0f)) && this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21573_().m_26573_();
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.isInstability() && (double)this.lightLevel() >= 0.4) {
            if (this.m_21223_() < 40.0f * this.lightLevel()) {
                livingEntity = this.m_9236_();
                if (livingEntity instanceof ServerLevel) {
                    serverLevel = (ServerLevel)livingEntity;
                    for (int i = 0; i < 64; ++i) {
                        double d = this.m_217043_().m_188583_() * 0.02;
                        double d2 = this.m_217043_().m_188583_() * 0.02;
                        double d3 = this.m_217043_().m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d, d2, d3, 0.0);
                        if (this.m_217043_().m_188501_() > 0.8f) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d, d2, d3, 0.0);
                        }
                        if (!(this.m_217043_().m_188501_() > 0.2f)) continue;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d, d2, d3, 0.0);
                    }
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            } else {
                this.m_6469_(this.m_269291_().m_287172_(), 40.0f * this.lightLevel());
                Level i = this.m_9236_();
                if (i instanceof ServerLevel) {
                    serverLevel = (ServerLevel)i;
                    for (int i2 = 0; i2 < 16; ++i2) {
                        double d = this.m_217043_().m_188583_() * 0.02;
                        double d2 = this.m_217043_().m_188583_() * 0.02;
                        double d3 = this.m_217043_().m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d, d2, d3, 0.0);
                        if (this.m_217043_().m_188501_() > 0.8f) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d, d2, d3, 0.0);
                        }
                        if (!(this.m_217043_().m_188501_() > 0.2f)) continue;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d, d2, d3, 0.0);
                    }
                }
            }
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)(15.0f * this.lightLevel()));
            if (blockDestroy) {
                this.blockDestroyTick = 40.0;
            }
            if (!this.m_9236_().f_46443_ && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        LivingEntity livingEntity;
        if (this.getAttackTick() > -((int)(5.0f + this.lightLevel() * 20.0f))) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(0);
            this.setAnimTick(10);
            int attackRandom = this.m_217043_().m_188503_(40);
            if (attackRandom > 30) {
                this.setAnimationState("attack1");
            } else if (attackRandom > 20) {
                this.setAnimationState("attack2");
            } else if (attackRandom > 10) {
                this.setAnimationState("attack3");
            } else {
                this.setAnimationState("attack4");
            }
        }
        float addBlind = entity instanceof LivingEntity && EntityAndItemFind.targetBlindnessTrue((LivingEntity)(livingEntity = (LivingEntity)entity)) ? 1.5f : 1.0f;
        AttackFind.attackBegin((LivingEntity)this, (Entity)entity);
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (this.m_217043_().m_188501_() > 0.8f && this.getSpellTick() <= 0 && !livingEntity.m_21023_((MobEffect)JerotesMobEffects.PHANTASMAL_KILLER.get())) {
                SpellList.PhantasmalKiller((int)4, (LivingEntity)this, (Entity)livingEntity).spellUse();
                if (!this.m_9236_().m_5776_()) {
                    this.setSpellTick(120);
                }
            }
        }
        if (bl = AttackFind.attackAfter((LivingEntity)this, (Entity)entity, (float)(1.0f + (1.0f - this.lightLevel()) * addBlind), (float)0.1f, (boolean)false, (float)0.0f)) {
            LivingEntity livingEntity2;
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.DARISORDER_ATTACK, 1.0f, 1.0f);
            }
            double d = 0.0;
            if (entity instanceof LivingEntity && (livingEntity2 = (LivingEntity)entity).m_21051_(Attributes.f_22278_) != null) {
                d = livingEntity2.m_21133_(Attributes.f_22278_);
            }
            double d3 = Math.max(0.25, 1.25 - d);
            if ((Main.mobSizeSmall((Entity)entity) || Main.mobSizeMedium((Entity)entity) || Main.mobSizeLarge((Entity)entity)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)entity.m_6095_())) {
                entity.m_6853_(false);
                entity.m_20256_(entity.m_20184_().m_82520_((this.m_20185_() - entity.m_20185_()) * 0.3 * d3, 0.0, 0.0));
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, (this.m_20186_() - entity.m_20186_()) * 0.225 * d3, 0.0));
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.0, (this.m_20189_() - entity.m_20189_()) * 0.3 * d3));
                if (entity.m_20270_((Entity)this) <= 4.0f) {
                    entity.m_20334_(0.0, 0.0, 0.0);
                }
            }
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(2.2, 1.4, 2.2));
        for (LivingEntity hurt : list) {
            DarisorderEntity darisorderEntity;
            if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt, (Entity)entity) || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof DarisorderEntity && (darisorderEntity = (DarisorderEntity)hurt).m_5448_() != this) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)((1.0f + (1.0f - this.lightLevel()) * addBlind) * 0.5f), (float)0.1f, (boolean)false, (float)0.0f);
        }
        Main.sweepAttack((Entity)this);
        if (entity instanceof LivingEntity) {
            BlockPos blockPos1;
            LivingEntity livingEntity3 = (LivingEntity)entity;
            BlockPos blockPos = this.m_20097_();
            for (int i = 0; i < 16; ++i) {
                blockPos1 = Main.findSpawnPositionNearFillOnBlock((LevelReader)this.m_9236_(), (BlockPos)entity.m_20097_(), (int)3);
                if (Main.canSee((LivingEntity)livingEntity3, (Vec3)blockPos1.m_252807_())) continue;
                blockPos = blockPos1;
            }
            if (blockPos != this.m_20097_()) {
                this.m_20035_(blockPos, this.m_146908_(), (this.m_146909_() + 180.0f) % 360.0f);
                this.m_216990_(JerotesSounds.TELEPORT);
                blockPos1 = this.m_9236_();
                if (blockPos1 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)blockPos1;
                    for (int i = 0; i < 64; ++i) {
                        double d = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        double d3 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d, d2, d3, 1.0);
                    }
                }
            }
        }
        return bl;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        float trueDamage = amount;
        if (damagesource.m_269533_(DamageTypeTags.f_268745_) || damagesource.m_269533_(DamageTypeTags.f_268419_) || damagesource.m_269533_(DamageTypeTags.f_268725_)) {
            trueDamage /= 10.0f;
        }
        if (!damagesource.m_269533_(DamageTypeTags.f_268738_)) {
            trueDamage = amount * Math.max(0.65f, 1.0f - this.lightLevel() * 0.4f);
        }
        if (trueDamage > this.m_21233_() / 10.0f && trueDamage < this.m_21233_() * 3.0f) {
            trueDamage = this.m_21233_() / 10.0f;
        }
        return super.m_6469_(damagesource, trueDamage);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ABACK.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_216964_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19610_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19615_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19619_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType == MobSpawnType.CHUNK_GENERATION) {
            this.setInstability(true);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(30);
            this.setAnimationState("start");
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        for (int i = 0; i < 16; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            double d3 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d, d2, d3);
            if (this.m_217043_().m_188501_() > 0.8f) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d, d2, d3);
            }
            if (!(this.m_217043_().m_188501_() > 0.2f)) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d, d2, d3);
        }
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

