/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Elite;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.FireAbsorptionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesAttackAvoidEntityGoal;
import com.jerotes.jerotes.goal.JerotesFireRangeAttackGoal;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.FireSecretorMoveControl;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Shoot.Magic.MagicShoot.SecreteFireOilBombEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FireSecretorEntity
extends Monster
implements RangedAttackMob,
JerotesEntity,
FireAbsorptionEntity,
SpellUseEntity,
EliteEntity {
    public AnimationState fireAnimationState = new AnimationState();
    public AnimationState smokeAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10, false);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(FireSecretorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(FireSecretorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int spellLevel = 3;
    public int fallTick;

    public FireSecretorEntity(EntityType<? extends FireSecretorEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.1f);
        this.f_21364_ = 50;
        this.f_21342_ = new FireSecretorMoveControl(this, 10, false);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new JerotesAttackAvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new JerotesFireRangeAttackGoal((RangedAttackMob)this, 1.25, 60, 20.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (FireSecretorEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        if (Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)16) > 2 || this.m_20270_((Entity)livingEntity) <= 8.0f) {
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(15);
                this.setAnimationState("fire");
            }
            OtherSpellList.SecreteFireOilBomb(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
        } else {
            int spellLevel = this.getSpellLevel();
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(15);
                this.setAnimationState("smoke");
            }
            OtherSpellList.SmokeMissile(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
        }
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public double FireAbsorptionPercentage() {
        return 80.0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 102.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22284_, 12.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.3);
        return builder;
    }

    public boolean m_6060_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.FIRE_SECRETOR_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.FIRE_SECRETOR_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.FIRE_SECRETOR_DEATH;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_6673_(DamageSource damageSource) {
        SecreteFireOilBombEntity secreteFireOilBomb;
        Entity entity;
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            return true;
        }
        if (damageSource.m_7639_() == this || damageSource.m_7639_() != null && (entity = damageSource.m_7639_()) instanceof SecreteFireOilBombEntity && (secreteFireOilBomb = (SecreteFireOilBombEntity)entity).m_19749_() == this) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        this.fallTick = 15;
        if (damagesource.m_276093_(DamageTypes.f_268565_)) {
            return super.m_6469_(damagesource, amount / 3.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19610_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        this.m_20095_();
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.fallTick > 0) {
            this.m_20242_(false);
            --this.fallTick;
        }
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.8, 1.0));
        }
        if (this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188503_(800) == 1 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, JerotesVillageSounds.FIRE_SECRETOR_BURN, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6126_() {
        return true;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "fire")) {
            return 1;
        }
        if (Objects.equals(animation, "smoke")) {
            return 2;
        }
        if (Objects.equals(animation, "dead")) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.fireAnimationState);
        list.add(this.smokeAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("FallTick", this.fallTick);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.fallTick = compoundTag.m_128451_("FallTick");
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.bossEvent.setId(this.m_20148_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.fireAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.fireAnimationState);
                    break;
                }
                case 2: {
                    this.smokeAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.smokeAnimationState);
                    break;
                }
                case 3: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack itemStack, float f) {
        if (itemStack.m_41619_()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)f, this.m_20189_(), itemStack);
        itementity.m_32060_();
        if (itementity.m_32055_().m_41720_() == JerotesVillageItems.FIRE_SECRETOR_ADHESIVE.get()) {
            itementity.m_146915_(true);
        }
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.m_9236_().m_7967_((Entity)itementity);
        }
        return itementity;
    }

    public void m_6667_(DamageSource damageSource) {
        if (this.m_5448_() != null && this.m_5448_().m_6084_() && !this.m_9236_().f_46443_) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.m_20145_()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.FUEL_EXPLOSION_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            boolean bl = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.FIRE_SECRETOR_BOMB, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)(this.getSpellLevel() * 3), bl, Level.ExplosionInteraction.MOB);
        }
        super.m_6667_(damageSource);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

