/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Elite;

import com.jerotes.jerotes.entity.BasePartLivingEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.LightningAbsorptionEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesLeapAtTargetAndLookGoal;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Shoot.Magic.MagicShoot.SecreteFireOilBombEntity;
import com.jerotes.jerotesvillage.goal.LightningWormMeleeAttackGoal;
import com.jerotes.jerotesvillage.goal.LightningWormRangedAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public class LightningWormEntity
extends Monster
implements RangedAttackMob,
JerotesEntity,
LightningAbsorptionEntity,
SpellUseEntity,
EliteEntity {
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(LightningWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIGHTNING_TICK = SynchedEntityData.m_135353_(LightningWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHARGING_TICK = SynchedEntityData.m_135353_(LightningWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(LightningWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_10, false);
    public int spellLevel = 3;

    public LightningWormEntity(EntityType<? extends LightningWormEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(2.6f);
        this.m_20242_(true);
        this.f_21364_ = 50;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public boolean isJerotesFlyingMob() {
        return true;
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LightningWormMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new LightningWormRangedAttackGoal(this, 1.25, 40, 20.0f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesLeapAtTargetAndLookGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (LightningWormEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(240);
        }
        OtherSpellList.WormThunderstorm(this.getSpellLevel(), (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22280_, 1.0);
        builder = builder.m_22268_(Attributes.f_22276_, 135.0);
        builder = builder.m_22268_(Attributes.f_22284_, 11.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.4);
        builder = builder.m_22268_(Attributes.f_22281_, 16.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.3);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.LIGHTNING_WORM_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.LIGHTNING_WORM_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.LIGHTNING_WORM_DEATH;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public double LightningAbsorptionPercentage() {
        return 80.0;
    }

    public void m_8119_() {
        Entity child;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (child = this.getChild()) == null) {
            LightningWormEntity partParent = this;
            int segments = 10;
            for (int i = 0; i < 10; ++i) {
                BasePartLivingEntity part = new BasePartLivingEntity((EntityType)JerotesVillageEntityType.LIGHTNING_WORM_PART.get(), (LivingEntity)partParent, 1.1f, 180.0f, 0.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    PlayerTeam teams = this.m_5647_();
                    if (teams != null) {
                        serverLevel.m_6188_().m_6546_(part.m_20149_(), teams);
                    }
                }
                part.setParent((Entity)partParent);
                part.setBodyIndex(i);
                if (partParent == this) {
                    this.setChildId(part.m_20148_());
                }
                part.setInitialPartPos((Entity)this);
                partParent = part;
                this.m_9236_().m_7967_((Entity)part);
            }
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        this.m_20242_(true);
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        this.m_20095_();
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(Math.max(0, this.getShootTick() - 1));
            this.setLightningTick(Math.max(0, this.getLightningTick() - 1));
            this.setChargingTick(Math.max(0, this.getChargingTick() - 1));
        }
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.m_5448_() != null) {
            if (this.m_20270_((Entity)this.m_5448_()) <= 32.0f && Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)20) == 1 && this.getLightningTick() <= 0 && this.getChargingTick() <= 0) {
                if (!this.m_9236_().m_5776_()) {
                    this.setChargingTick(40);
                }
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.LIGHTNING_WORM_CHARGING, this.m_5720_(), 15.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
                if (this.m_9236_().m_5776_()) {
                    for (int i = 0; i < 20; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_5448_().m_20208_(0.5), this.m_5448_().m_20187_(), this.m_5448_().m_20262_(0.5), 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.getChargingTick() == 5) {
                if (!this.m_9236_().m_5776_()) {
                    this.setLightningTick(120);
                }
                OtherSpellList.Discharge(this.getSpellLevel(), (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
            }
        }
        if (this.m_217043_().m_188503_(200) == 1 && this.findLightningTargetAround(this.m_20097_()) != null) {
            boolean bl = this.m_9236_().m_6106_().m_5470_().m_46207_(GameRules.f_46134_);
            LightningBolt entity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
            if (entity != null) {
                entity.m_20219_(Vec3.m_82539_((Vec3i)this.findLightningTargetAround(this.m_20097_())));
                entity.m_20874_(bl);
                this.m_9236_().m_7967_((Entity)entity);
            }
        }
    }

    private Optional<BlockPos> findLightningRod(BlockPos blockPos2) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PoiManager poiManager = serverLevel.m_8904_();
            Optional optional = poiManager.m_148658_(holder -> holder.m_203565_(PoiTypes.f_218066_), blockPos -> blockPos.m_123342_() == serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_()) - 1, blockPos2, 128, PoiManager.Occupancy.ANY);
            return optional.map(blockPos -> blockPos.m_6630_(1));
        }
        return Optional.empty();
    }

    protected BlockPos findLightningTargetAround(BlockPos blockPos) {
        ServerLevel serverLevel;
        BlockPos blockPos2;
        Optional<BlockPos> optional;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (optional = this.findLightningRod(blockPos2 = (serverLevel = (ServerLevel)level).m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos))).isPresent() && blockPos.m_203193_((Position)blockPos2.m_252807_()) < 32.0) {
            return optional.get();
        }
        return null;
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setLightningTick(int n) {
        this.m_20088_().m_135381_(LIGHTNING_TICK, (Object)n);
    }

    public int getLightningTick() {
        return (Integer)this.m_20088_().m_135370_(LIGHTNING_TICK);
    }

    public void setChargingTick(int n) {
        this.m_20088_().m_135381_(CHARGING_TICK, (Object)n);
    }

    public int getChargingTick() {
        return (Integer)this.m_20088_().m_135370_(CHARGING_TICK);
    }

    public void m_6593_(@javax.annotation.Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getChildId() != null) {
            compoundTag.m_128362_("ChildUUID", this.getChildId());
        }
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("LightningTick", this.getLightningTick());
        compoundTag.m_128405_("ChargingTick", this.getChargingTick());
        compoundTag.m_128405_("ShootTick", this.getShootTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        if (compoundTag.m_128403_("ChildUUID")) {
            this.setChildId(compoundTag.m_128342_("ChildUUID"));
        }
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setLightningTick(compoundTag.m_128451_("LightningTick"));
        this.setChargingTick(compoundTag.m_128451_("ChargingTick"));
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.bossEvent.setId(this.m_20148_());
    }

    public boolean m_6673_(DamageSource damageSource) {
        SecreteFireOilBombEntity secreteFireOilBomb;
        Entity entity;
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268725_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        if (damageSource.m_7639_() == this || damageSource.m_7639_() != null && (entity = damageSource.m_7639_()) instanceof SecreteFireOilBombEntity && (secreteFireOilBomb = (SecreteFireOilBombEntity)entity).m_19749_() == this) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    protected void m_7324_(Entity entity) {
        if (!(entity instanceof BasePartLivingEntity)) {
            super.m_7324_(entity);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CHILD_UUID, Optional.empty());
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
        this.m_20088_().m_135372_(LIGHTNING_TICK, (Object)0);
        this.m_20088_().m_135372_(CHARGING_TICK, (Object)0);
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public boolean m_7327_(Entity entity) {
        if (Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)3) == 1) {
            AttackFind.attackBegin((LivingEntity)this, (Entity)entity);
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_), (Entity)this);
            boolean bl = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)entity, (DamageSource)damageSource, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
            if (bl && !this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.LIGHTNING_WORM_ATTACK, 1.0f, 1.0f);
            }
            return bl;
        }
        boolean bl = super.m_7327_(entity);
        if (bl && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.LIGHTNING_WORM_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @javax.annotation.Nullable
    public ItemEntity m_5552_(ItemStack itemStack, float f) {
        if (itemStack.m_41619_()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)f, this.m_20189_(), itemStack);
        itementity.m_32060_();
        if (itementity.m_32055_().m_41720_() == JerotesVillageItems.LIGHTNING_WORM_CHITIN.get()) {
            itementity.m_146915_(true);
        }
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.m_9236_().m_7967_((Entity)itementity);
        }
        return itementity;
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0) {
            // empty if block
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

