/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Elite;

import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.FreezeAbsorptionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantLookControl;
import com.jerotes.jerotesvillage.control.GiantMoveControl;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CorrosiverEntity;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Shoot.Magic.MagicShoot.SecreteFireOilBombEntity;
import com.jerotes.jerotesvillage.entity.in.StopLook;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PrimordierEntity
extends Monster
implements JerotesEntity,
FreezeAbsorptionEntity,
StopLook,
SpellUseEntity,
BreakShieldEntity,
EliteEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState attack4AnimationState = new AnimationState();
    public AnimationState attack5AnimationState = new AnimationState();
    public AnimationState attack6AnimationState = new AnimationState();
    public AnimationState attack7AnimationState = new AnimationState();
    public AnimationState attack8AnimationState = new AnimationState();
    public AnimationState shockAnimationState = new AnimationState();
    public AnimationState shockToCorrosiveAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOCK_TICK = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOCK_USE_TICK = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_SHOCK = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOCK_JUMP = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_WALK = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_ANIM = SynchedEntityData.m_135353_(PrimordierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_12, false);
    public int spellLevel = 3;
    public double blockDestroyTick;
    public float rushFindXRot;
    public float rushFindYRot;

    public PrimordierEntity(EntityType<? extends PrimordierEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.1f);
        this.f_21364_ = 100;
        this.f_21342_ = new GiantMoveControl((Mob)this);
        this.f_21365_ = new GiantLookControl((Mob)this, 1);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.6, true));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CorrosiverEntity.class, 32.0f, 1.4, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Animal.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (PrimordierEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 320.0);
        builder = builder.m_22268_(Attributes.f_22284_, 8.0);
        builder = builder.m_22268_(Attributes.f_22282_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 25.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.PRIMORDIER_AMBIENT;
    }

    public int m_8100_() {
        return 400;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.PRIMORDIER_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.PRIMORDIER_DEATH;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.PRIMORDIER_RUSH, 0.15f, 1.0f);
    }

    public boolean m_213824_() {
        return true;
    }

    public int getShieldBreakStrength() {
        return 100;
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.500000277905201E-7;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public int m_21529_() {
        return 5;
    }

    public void m_21391_(Entity entity, float f, float f2) {
        if (!this.stopLookTime()) {
            super.m_21391_(entity, f, f2);
        }
    }

    public void m_146926_(float f) {
        if (!this.stopLookTime()) {
            super.m_146926_(f);
        }
    }

    public void m_146922_(float f) {
        if (!this.stopLookTime()) {
            super.m_146922_(f);
        }
    }

    public void m_5618_(float f) {
        if (!this.stopLookTime()) {
            super.m_5618_(f);
        }
    }

    @Override
    public boolean stopLookTime() {
        return this.getAttackTick() > 0;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 4.5f;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public double FreezeAbsorptionPercentage() {
        return 80.0;
    }

    public void m_7023_(Vec3 dir) {
        if (this.m_21515_() && (this.m_20069_() || this.m_20077_())) {
            this.m_19920_(this.m_6113_(), dir);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.6));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(dir);
        }
        if (this.specialAction() && !this.m_20096_() || this.getAttackTick() > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.005, 1.0, 0.005));
        }
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.5, 1.5, 1.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82377_((double)this.f_267362_.m_267731_() < 0.01 ? 0.0 : 1.0, 0.0, (double)this.f_267362_.m_267731_() < 0.01 ? 0.0 : 1.0).m_82381_(livingEntity.m_20191_());
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setShockTick(int n) {
        this.m_20088_().m_135381_(SHOCK_TICK, (Object)n);
    }

    public int getShockTick() {
        return (Integer)this.m_20088_().m_135370_(SHOCK_TICK);
    }

    public void setShockUseTick(int n) {
        this.m_20088_().m_135381_(SHOCK_USE_TICK, (Object)n);
    }

    public int getShockUseTick() {
        return (Integer)this.m_20088_().m_135370_(SHOCK_USE_TICK);
    }

    public boolean isShouldShock() {
        return (Boolean)this.m_20088_().m_135370_(SHOULD_SHOCK);
    }

    public void setShouldShock(boolean bl) {
        this.m_20088_().m_135381_(SHOULD_SHOCK, (Object)bl);
    }

    public boolean isShockJump() {
        return (Boolean)this.m_20088_().m_135370_(SHOCK_JUMP);
    }

    public void setShockJump(boolean bl) {
        this.m_20088_().m_135381_(SHOCK_JUMP, (Object)bl);
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public int getAttackWalk() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_WALK);
    }

    public void setAttackWalk(int n) {
        this.m_20088_().m_135381_(ATTACK_WALK, (Object)n);
    }

    public int getJumpAnim() {
        return (Integer)this.m_20088_().m_135370_(JUMP_ANIM);
    }

    public void setJumpAnim(int n) {
        this.m_20088_().m_135381_(JUMP_ANIM, (Object)n);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "attack4")) {
            return 4;
        }
        if (Objects.equals(animation, "attack5")) {
            return 5;
        }
        if (Objects.equals(animation, "attack6")) {
            return 6;
        }
        if (Objects.equals(animation, "attack7")) {
            return 7;
        }
        if (Objects.equals(animation, "attack8")) {
            return 8;
        }
        if (Objects.equals(animation, "shock")) {
            return 9;
        }
        if (Objects.equals(animation, "shockToCorrosive")) {
            return 10;
        }
        if (Objects.equals(animation, "dead")) {
            return 11;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.attack4AnimationState);
        list.add(this.attack5AnimationState);
        list.add(this.attack6AnimationState);
        list.add(this.attack7AnimationState);
        list.add(this.attack8AnimationState);
        list.add(this.shockAnimationState);
        list.add(this.shockToCorrosiveAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public boolean specialAction() {
        return this.getShockUseTick() > 0 || this.isShockJump();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        compoundTag.m_128405_("ShockTick", this.getShockTick());
        compoundTag.m_128405_("ShockUseTick", this.getShockUseTick());
        compoundTag.m_128379_("ShouldShock", this.isShouldShock());
        compoundTag.m_128379_("ShockJump", this.isShockJump());
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128405_("AttackWalk", this.getAttackWalk());
        compoundTag.m_128405_("JumpAnim", this.getJumpAnim());
        compoundTag.m_128347_("RushFindXRot", (double)this.rushFindXRot);
        compoundTag.m_128347_("RushFindYRot", (double)this.rushFindYRot);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.setShockTick(compoundTag.m_128451_("ShockTick"));
        this.setShockUseTick(compoundTag.m_128451_("ShockUseTick"));
        this.setShouldShock(compoundTag.m_128471_("ShouldShock"));
        this.setShockJump(compoundTag.m_128471_("ShockJump"));
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.setAttackWalk(compoundTag.m_128451_("AttackWalk"));
        this.setJumpAnim(compoundTag.m_128451_("JumpAnim"));
        this.rushFindXRot = compoundTag.m_128457_("RushFindXRot");
        this.rushFindYRot = compoundTag.m_128457_("RushFindYRot");
        this.bossEvent.setId(this.m_20148_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
        this.m_20088_().m_135372_(ATTACK_WALK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOCK_TICK, (Object)600);
        this.m_20088_().m_135372_(SHOCK_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(JUMP_ANIM, (Object)0);
        this.m_20088_().m_135372_(SHOULD_SHOCK, (Object)false);
        this.m_20088_().m_135372_(SHOCK_JUMP, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.attack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack4AnimationState);
                    break;
                }
                case 5: {
                    this.attack5AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack5AnimationState);
                    break;
                }
                case 6: {
                    this.attack6AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack6AnimationState);
                    break;
                }
                case 7: {
                    this.attack7AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack7AnimationState);
                    break;
                }
                case 8: {
                    this.attack8AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack8AnimationState);
                    break;
                }
                case 9: {
                    this.shockAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shockAnimationState);
                    break;
                }
                case 10: {
                    this.shockToCorrosiveAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shockToCorrosiveAnimationState);
                    break;
                }
                case 11: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8107_() {
        float f;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(5.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (this.f_267362_.m_267780_() && this.m_20096_() && this.m_21223_() > this.m_21233_() / 4.0f && !this.m_6162_() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        float breakLevel = 5.0f;
        double blockDestroyTickUse = 60.0;
        if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy2 = Main.BlockDestroy((Mob)this, (float)breakLevel);
            if (blockDestroy2) {
                this.blockDestroyTick = blockDestroyTickUse;
            }
            if (!this.m_9236_().f_46443_ && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-10, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() == 20 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.m_5448_() != null && this.getAttackTick() <= -10) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.getAttackTick() > 0 || this.m_5448_() != null && this.m_217066_(this.m_5448_())) {
            if (!this.m_9236_().m_5776_()) {
                this.setAttackWalk(Math.min(this.getAttackWalk() + 1, 40));
            }
            if (this.getAttackTick() > 0) {
                if (this.getAttackUse() == 4 || this.getAttackUse() == 3 || this.getAttackUse() == 1) {
                    this.m_21573_().m_26573_();
                }
                if (!this.m_9236_().m_5776_()) {
                    this.setAttackWalk(Math.min(this.getAttackWalk() + 1, 40));
                }
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setAttackWalk(Math.max(this.getAttackWalk() - 1, 0));
        }
        if (this.isShockJump() && (this.m_5448_() == null || !(this.m_5448_().m_20280_((Entity)this) <= 16.0))) {
            if (!this.m_9236_().m_5776_()) {
                this.setJumpAnim(Math.min(this.getJumpAnim() + 1, 20));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setJumpAnim(Math.max(this.getJumpAnim() - 2, 0));
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.m_6084_()) {
            CorrosiverEntity corrosiver;
            LivingEntity blockDestroy2;
            if (this.m_5912_() && this.getAttackTick() <= -10 && !this.specialAction() && this.getShockTick() >= 600 && this.isShouldShock() && this.m_5448_() != null && this.m_5448_() instanceof LivingEntity) {
                Level blockDestroy2;
                if (!this.m_9236_().m_5776_()) {
                    this.setShouldShock(false);
                    this.setShockTick(0);
                    this.setShockUseTick(120);
                    this.setAnimTick(60);
                    this.setAnimationState("shock");
                }
                if ((blockDestroy2 = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)blockDestroy2;
                    if (!this.m_20145_()) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.INTIMIDATION_STRIKE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (!(this.m_5912_() || this.m_5448_() != null || this.isShouldShock() || this.m_9236_().m_5776_())) {
                this.setShouldShock(true);
            }
            if (this.getShockUseTick() == 95 && (blockDestroy2 = this.m_5448_()) instanceof CorrosiverEntity && !(corrosiver = (CorrosiverEntity)blockDestroy2).m_9236_().m_5776_()) {
                corrosiver.setAnimTick(20);
                corrosiver.setAnimationState("wind");
            }
            if (this.getShockUseTick() == 85) {
                LivingEntity blockDestroy2 = this.m_5448_();
                if (blockDestroy2 instanceof CorrosiverEntity) {
                    CorrosiverEntity corrosiver2 = (CorrosiverEntity)blockDestroy2;
                    if (!this.m_9236_().m_5776_()) {
                        this.setShockUseTick(0);
                        this.setAnimTick(15);
                        this.setAnimationState("shockToCorrosive");
                    }
                    if (!corrosiver2.m_20067_()) {
                        corrosiver2.m_5496_(JerotesVillageSounds.CORROSIVER_AMBIENT, 5.0f, 1.0f);
                    }
                } else if (!this.m_20067_()) {
                    this.m_5496_(JerotesVillageSounds.PRIMORDIER_SHOCK, 5.0f, 1.0f);
                }
            }
            if (this.getShockUseTick() >= 75 && this.getShockUseTick() < 90) {
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                }
                float angleYaw = 1.5707964f;
                float renderYawOffset = this.f_20883_;
                Vec3 vec3 = new Vec3(this.f_19854_ + 2.25 * (double)Mth.m_14089_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw))), this.f_19855_ + (double)3.15f, this.f_19856_ + 2.25 * (double)Mth.m_14031_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw))));
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 70; ++i) {
                        double angle = Math.PI * 2 * (double)i / 70.0;
                        double offsetXAdd = Math.cos(angle);
                        double offsetZAdd = Math.sin(angle);
                        if (!Main.canSeeAngle((Entity)this, (Vec3)new Vec3(this.m_20185_() + offsetXAdd, 0.0, this.m_20189_() + offsetZAdd), (double)40.0)) continue;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, offsetXAdd * 0.5, -0.04, offsetZAdd * 0.5, 1.0);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, offsetXAdd * 1.0, -0.08, offsetZAdd * 1.0, 1.0);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, offsetXAdd * (double)0.7f, -0.12, offsetZAdd * (double)0.7f, 1.0);
                    }
                }
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(3.0));
                for (LivingEntity hurt : list) {
                    if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this) || hurt.m_146888_() >= 360) continue;
                    hurt.m_146917_(360);
                }
                List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
                for (LivingEntity shake : listShake) {
                    if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                    shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
                }
            }
            if (this.getShockUseTick() >= 75 && this.m_5448_() != null) {
                this.m_21573_().m_26517_((double)0.1f);
                this.rushFindXRot = this.m_146909_();
                this.rushFindYRot = this.m_146908_();
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            }
            if (this.getShockUseTick() == 73 && this.m_5448_() != null) {
                this.m_21573_().m_26573_();
                if (!this.m_9236_().m_5776_()) {
                    this.setShockJump(true);
                    this.setAttackUse(3);
                }
                this.trueHurt();
                this.jumpToTarget(this.m_5448_());
            }
            if (this.isShockJump() && this.getShockUseTick() < 60 && (this.m_20096_() || this.getShockUseTick() <= 0)) {
                if (this.m_20096_()) {
                    if (!this.m_9236_().m_5776_()) {
                        this.setAttackUse(3);
                    }
                    this.trueHurt();
                }
                if (!this.m_9236_().m_5776_()) {
                    this.setShockUseTick(0);
                    this.setShockJump(false);
                }
            } else if (this.isShockJump() && this.m_5448_() != null) {
                this.RushAttack();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setShockTick(Math.min(600, this.getShockTick() + 1));
            this.setShockUseTick(Math.max(0, this.getShockUseTick() - 1));
        }
    }

    public boolean jumpToTarget(LivingEntity target) {
        if (target != null) {
            float f = this.m_146908_();
            float f2 = this.m_146909_();
            float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
            float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
            float f7 = Math.min(this.m_20270_((Entity)target), 16.0f);
            this.m_6853_(false);
            this.m_20334_(f3 * (f7 / f6 * 1.35f), 1.25 + Math.min(8.0, Math.max(0.0, target.m_20186_() - this.m_20186_())) * (double)0.2f, f5 * (f7 / f6 * 1.35f));
            this.m_21573_().m_5624_((Entity)target, 1.0);
        }
        return true;
    }

    public boolean RushAttack() {
        if (!this.m_9236_().m_5776_()) {
            this.m_146926_(this.rushFindXRot);
            this.m_146922_(this.rushFindYRot);
            this.m_5618_(this.rushFindYRot);
            this.m_5616_(this.rushFindYRot);
        }
        float f = this.m_146908_();
        float f2 = this.m_146909_();
        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = 5.0f;
        this.m_6853_(false);
        this.m_20256_(this.m_20184_().m_82520_((double)(f3 * (f7 / f6 * 0.05f)), 0.0, (double)(f5 * (f7 / f6 * 0.05f))));
        return true;
    }

    public boolean m_7327_(Entity entity) {
        if (this.m_5912_() && !this.specialAction() && this.getShockTick() >= 600 && this.isShouldShock() && this.m_5448_() != null && this.m_5448_() instanceof LivingEntity) {
            return false;
        }
        if (this.getAttackTick() > -10) {
            return false;
        }
        if (this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            int attackRandom = this.m_217043_().m_188503_(40);
            if (attackRandom > 35) {
                this.setAnimTick(60);
                this.setAttackTick(50);
                this.setAnimationState("attack1");
                this.setAttackUse(1);
            } else if (attackRandom > 30) {
                this.setAnimTick(40);
                this.setAttackTick(42);
                this.setAnimationState("attack2");
                this.setAttackUse(2);
            } else if (attackRandom > 25) {
                this.setAnimTick(40);
                this.setAttackTick(42);
                this.setAnimationState("attack3");
                this.setAttackUse(2);
            } else if (attackRandom > 20) {
                this.setAnimTick(50);
                this.setAttackTick(40);
                this.setAnimationState("attack4");
                this.setAttackUse(2);
            } else if (attackRandom > 15) {
                this.setAnimTick(50);
                this.setAttackTick(40);
                this.setAnimationState("attack5");
                this.setAttackUse(2);
            } else if (attackRandom > 10) {
                this.setAnimTick(60);
                this.setAttackTick(50);
                this.setAnimationState("attack6");
                this.setAttackUse(4);
            } else if (attackRandom > 5) {
                this.setAnimTick(40);
                this.setAttackTick(40);
                this.setAnimationState("attack7");
                this.setAttackUse(3);
            } else {
                this.setAnimTick(40);
                this.setAttackTick(40);
                this.setAnimationState("attack8");
                this.setAttackUse(3);
            }
        }
        this.m_21573_().m_26573_();
        return true;
    }

    public boolean trueHurt() {
        Level renderYawOffset4;
        Level angleYaw12;
        Level vec31;
        float damageBase = 1.0f;
        float knockbackBase = 1.0f;
        float reach = 0.5f;
        if (this.getAttackUse() == 1) {
            damageBase = 1.75f;
            reach = 0.75f;
        }
        if (this.getAttackUse() == 2) {
            knockbackBase = 1.5f;
        }
        if (this.getAttackUse() == 3) {
            damageBase = 1.5f;
            knockbackBase = 1.25f;
            reach = 1.25f;
        }
        if (this.getAttackUse() == 4) {
            damageBase = 1.75f;
            knockbackBase = 1.25f;
            reach = 0.75f;
        }
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.PRIMORDIER_ATTACK, 5.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_((double)reach));
        for (Object hurt : list) {
            PrimordierEntity primordierEntity;
            if (hurt == null || this.m_20280_((Entity)hurt) > 128.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this) && this.getAttackUse() != 1 && this.getAttackUse() != 3 || hurt instanceof PrimordierEntity && (primordierEntity = (PrimordierEntity)hurt).m_5448_() != this && this.m_5448_() != primordierEntity) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
            if (!bl) continue;
            if (hurt.m_146888_() < 280) {
                hurt.m_146917_(280);
            }
            if (!hurt.m_9236_().m_5776_()) {
                hurt.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, 1), (Entity)this);
                hurt.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 120, 2), (Entity)this);
            }
            if (!Main.mobSizeSmall((Entity)hurt) && !Main.mobSizeMedium((Entity)hurt) && !Main.mobSizeLarge((Entity)hurt) || EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) continue;
            double d = 0.0;
            if (hurt.m_21051_(Attributes.f_22278_) != null) {
                d = Math.max(hurt.m_21133_(Attributes.f_22278_), 1.0);
            }
            double d3 = Math.max(0.0, 1.0 - d) + 0.4;
            hurt.m_6853_(false);
            hurt.m_20256_(hurt.m_20184_().m_82520_(-((this.m_20185_() - hurt.m_20185_()) * d3 / 2.0) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20186_() - hurt.m_20186_()) * d3 / 2.0) * (0.7 + (double)(knockbackBase / 3.0f)), -((this.m_20189_() - hurt.m_20189_()) * d3 / 2.0) * (0.7 + (double)(knockbackBase / 3.0f))));
            if (this.getAttackUse() != 2 || this.getAttackUse() != 4 || !Main.mobSizeSmall((Entity)hurt) && !Main.mobSizeMedium((Entity)hurt)) continue;
            hurt.m_20256_(hurt.m_20184_().m_82520_(0.0, (double)((7.0f - this.m_20270_((Entity)hurt)) / 8.0f), 0.0));
        }
        if (this.getAttackUse() == 1 || this.getAttackUse() == 3 || this.getAttackUse() == 4) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        if (this.getAttackUse() == 1 || this.getAttackUse() == 3) {
            Level level;
            float angleYaw = 1.5707964f;
            float renderYawOffset2 = this.f_20883_;
            Vec3 vec3 = new Vec3(this.f_19854_ + (double)(5.0f * Mth.m_14089_((float)((float)((double)renderYawOffset2 * (Math.PI / 180) + (double)angleYaw)))), this.f_19855_ + (double)0.1f, this.f_19856_ + (double)(5.0f * Mth.m_14031_((float)((float)((double)renderYawOffset2 * (Math.PI / 180) + (double)angleYaw)))));
            if (this.getAttackUse() == 3) {
                vec3 = this.m_20318_(0.1f).m_82520_(0.0, (double)0.2f, 0.0);
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 70; ++i) {
                    double angle = Math.PI * 2 * (double)i / 70.0;
                    double offsetXAdd = Math.cos(angle);
                    double offsetZAdd = Math.sin(angle);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec3.m_7096_() + offsetXAdd * (double)1.4f, vec3.m_7098_(), vec3.m_7094_() + offsetZAdd * (double)1.4f, 0, offsetXAdd * (double)1.4f, -0.04, offsetZAdd * (double)1.4f, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec3.m_7096_() + offsetXAdd * 1.0, vec3.m_7098_(), vec3.m_7094_() + offsetZAdd * 1.0, 0, offsetXAdd * 1.0, -0.04, offsetZAdd * 1.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec3.m_7096_() + offsetXAdd * (double)0.7f, vec3.m_7098_(), vec3.m_7094_() + offsetZAdd * (double)0.7f, 0, offsetXAdd * (double)0.7f, -0.04, offsetZAdd * (double)0.7f, 1.0);
                }
            }
        }
        if (this.getAttackUse() == 4) {
            float angleYaw0 = 1.7453293f;
            float angleYaw12 = 1.3962634f;
            float renderYawOffset3 = this.f_20883_;
            Vec3 vec30 = new Vec3(this.f_19854_ + (double)(4.75f * Mth.m_14089_((float)((float)((double)renderYawOffset3 * (Math.PI / 180) + (double)angleYaw0)))), this.f_19855_ + (double)0.1f, this.f_19856_ + (double)(5.0f * Mth.m_14031_((float)((float)((double)renderYawOffset3 * (Math.PI / 180) + (double)angleYaw0)))));
            vec31 = new Vec3(this.f_19854_ + (double)(4.75f * Mth.m_14089_((float)((float)((double)renderYawOffset3 * (Math.PI / 180) + (double)angleYaw12)))), this.f_19855_ + (double)0.1f, this.f_19856_ + (double)(5.0f * Mth.m_14031_((float)((float)((double)renderYawOffset3 * (Math.PI / 180) + (double)angleYaw12)))));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 70; ++i) {
                    double angle = Math.PI * 2 * (double)i / 70.0;
                    double offsetXAdd = Math.cos(angle);
                    double offsetZAdd = Math.sin(angle);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec30.m_7096_() + offsetXAdd * (double)1.4f, vec30.m_7098_(), vec30.m_7094_() + offsetZAdd * (double)1.4f, 0, offsetXAdd * (double)1.4f, -0.04, offsetZAdd * (double)1.4f, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec30.m_7096_() + offsetXAdd * 1.0, vec30.m_7098_(), vec30.m_7094_() + offsetZAdd * 1.0, 0, offsetXAdd * 1.0, -0.04, offsetZAdd * 1.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec30.m_7096_() + offsetXAdd * (double)0.7f, vec30.m_7098_(), vec30.m_7094_() + offsetZAdd * (double)0.7f, 0, offsetXAdd * (double)0.7f, -0.04, offsetZAdd * (double)0.7f, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec31.m_7096_() + offsetXAdd * (double)1.4f, vec31.m_7098_(), vec31.m_7094_() + offsetZAdd * (double)1.4f, 0, offsetXAdd * (double)1.4f, -0.04, offsetZAdd * (double)1.4f, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec31.m_7096_() + offsetXAdd * 1.0, vec31.m_7098_(), vec31.m_7094_() + offsetZAdd * 1.0, 0, offsetXAdd * 1.0, -0.04, offsetZAdd * 1.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, vec31.m_7096_() + offsetXAdd * (double)0.7f, vec31.m_7098_(), vec31.m_7094_() + offsetZAdd * (double)0.7f, 0, offsetXAdd * (double)0.7f, -0.04, offsetZAdd * (double)0.7f, 1.0);
                }
            }
        }
        Main.sweepAttack((Entity)this);
        if (this.getAttackUse() == 3 && (angleYaw12 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)angleYaw12;
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), (double)(Main.mobWidth((Entity)this) / 2.0f + 3.0f), (double)0.0, (double)(Main.mobWidth((Entity)this) / 2.0f + 3.0f));
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
        if (this.getAttackUse() == 1) {
            float angleYaw = 1.5707964f;
            float renderYawOffset4 = this.f_20883_;
            Vec3 vec3 = new Vec3(this.f_19854_ + (double)(5.0f * Mth.m_14089_((float)((float)((double)renderYawOffset4 * (Math.PI / 180) + (double)angleYaw)))), this.f_19855_ + (double)0.1f, this.f_19856_ + (double)(5.0f * Mth.m_14031_((float)((float)((double)renderYawOffset4 * (Math.PI / 180) + (double)angleYaw)))));
            if (this.getAttackUse() == 3) {
                vec3 = this.m_20318_(0.1f).m_82520_(0.0, (double)0.2f, 0.0);
            }
            if ((vec31 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)vec31;
                AABB aabb = AABB.m_165882_((Vec3)new Vec3(vec3.f_82479_, vec3.f_82480_ - 1.0, vec3.f_82481_), (double)(Main.mobWidth((Entity)this) / 2.0f + 3.0f), (double)0.0, (double)(Main.mobWidth((Entity)this) / 2.0f + 3.0f));
                for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
                }
            }
        }
        if (this.getAttackUse() == 4 && (renderYawOffset4 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)renderYawOffset4;
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), (double)(Main.mobWidth((Entity)this) / 2.0f + 12.0f), (double)0.0, (double)(Main.mobWidth((Entity)this) / 2.0f + 12.0f));
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                if (!Main.canSeeAngle((Entity)this, (Vec3)blockPos.m_252807_(), (double)120.0)) continue;
                Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
        return true;
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - 22;
    }

    public boolean m_6673_(DamageSource damageSource) {
        SecreteFireOilBombEntity secreteFireOilBomb;
        Entity entity;
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) && this.isShockJump()) {
            return true;
        }
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268419_)) {
            return true;
        }
        if (damageSource.m_7639_() == this || damageSource.m_7639_() != null && (entity = damageSource.m_7639_()) instanceof SecreteFireOilBombEntity && (secreteFireOilBomb = (SecreteFireOilBombEntity)entity).m_19749_() == this) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268745_)) {
            return super.m_6469_(damagesource, amount * 2.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19597_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19613_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

